/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

public class Filters {
    private int last_pitch;
    private float[] last_pitch_gain = new float[3];
    private float smooth_gain;
    private float[] xx = new float[1024];

    public void init() {
        this.last_pitch = 0;
        this.last_pitch_gain[2] = 0.0f;
        this.last_pitch_gain[1] = 0.0f;
        this.last_pitch_gain[0] = 0.0f;
        this.smooth_gain = 1.0f;
    }

    public static final void bw_lpc(float f, float[] fArray, float[] fArray2, int n) {
        float f2 = 1.0f;
        for (int i = 0; i < n + 1; ++i) {
            fArray2[i] = f2 * fArray[i];
            f2 *= f;
        }
    }

    public static final void filter_mem2(float[] fArray, int n, float[] fArray2, float[] fArray3, int n2, int n3, float[] fArray4, int n4) {
        for (int i = 0; i < n2; ++i) {
            float f = fArray[n + i];
            fArray[n + i] = fArray2[0] * f + fArray4[n4 + 0];
            float f2 = fArray[n + i];
            for (int j = 0; j < n3 - 1; ++j) {
                fArray4[n4 + j] = fArray4[n4 + j + 1] + fArray2[j + 1] * f - fArray3[j + 1] * f2;
            }
            fArray4[n4 + n3 - 1] = fArray2[n3] * f - fArray3[n3] * f2;
        }
    }

    public static final void filter_mem2(float[] fArray, int n, float[] fArray2, float[] fArray3, float[] fArray4, int n2, int n3, int n4, float[] fArray5, int n5) {
        for (int i = 0; i < n3; ++i) {
            float f = fArray[n + i];
            fArray4[n2 + i] = fArray2[0] * f + fArray5[0];
            float f2 = fArray4[n2 + i];
            for (int j = 0; j < n4 - 1; ++j) {
                fArray5[n5 + j] = fArray5[n5 + j + 1] + fArray2[j + 1] * f - fArray3[j + 1] * f2;
            }
            fArray5[n5 + n4 - 1] = fArray2[n4] * f - fArray3[n4] * f2;
        }
    }

    public static final void iir_mem2(float[] fArray, int n, float[] fArray2, float[] fArray3, int n2, int n3, int n4, float[] fArray4) {
        for (int i = 0; i < n3; ++i) {
            fArray3[n2 + i] = fArray[n + i] + fArray4[0];
            for (int j = 0; j < n4 - 1; ++j) {
                fArray4[j] = fArray4[j + 1] - fArray2[j + 1] * fArray3[n2 + i];
            }
            fArray4[n4 - 1] = -fArray2[n4] * fArray3[n2 + i];
        }
    }

    public static final void fir_mem2(float[] fArray, int n, float[] fArray2, float[] fArray3, int n2, int n3, int n4, float[] fArray4) {
        for (int i = 0; i < n3; ++i) {
            float f = fArray[n + i];
            fArray3[n2 + i] = fArray2[0] * f + fArray4[0];
            for (int j = 0; j < n4 - 1; ++j) {
                fArray4[j] = fArray4[j + 1] + fArray2[j + 1] * f;
            }
            fArray4[n4 - 1] = fArray2[n4] * f;
        }
    }

    public static final void syn_percep_zero(float[] fArray, int n, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, int n2, int n3) {
        float[] fArray6 = new float[n3];
        Filters.filter_mem2(fArray, n, fArray3, fArray2, fArray5, 0, n2, n3, fArray6, 0);
        for (int i = 0; i < n3; ++i) {
            fArray6[i] = 0.0f;
        }
        Filters.iir_mem2(fArray5, 0, fArray4, fArray5, 0, n2, n3, fArray6);
    }

    public static final void residue_percep_zero(float[] fArray, int n, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, int n2, int n3) {
        float[] fArray6 = new float[n3];
        Filters.filter_mem2(fArray, n, fArray2, fArray3, fArray5, 0, n2, n3, fArray6, 0);
        for (int i = 0; i < n3; ++i) {
            fArray6[i] = 0.0f;
        }
        Filters.fir_mem2(fArray5, 0, fArray4, fArray5, 0, n2, n3, fArray6);
    }

    public void fir_mem_up(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, float[] fArray4) {
        int n3;
        for (n3 = 0; n3 < n / 2; ++n3) {
            this.xx[2 * n3] = fArray[n / 2 - 1 - n3];
        }
        for (n3 = 0; n3 < n2 - 1; n3 += 2) {
            this.xx[n + n3] = fArray4[n3 + 1];
        }
        for (n3 = 0; n3 < n; n3 += 4) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = this.xx[n - 4 - n3];
            for (int i = 0; i < n2; i += 4) {
                float f6 = fArray2[i];
                float f7 = fArray2[i + 1];
                float f8 = this.xx[n - 2 + i - n3];
                f4 += f6 * f8;
                f3 += f7 * f8;
                f2 += f6 * f5;
                f += f7 * f5;
                f6 = fArray2[i + 2];
                f7 = fArray2[i + 3];
                f5 = this.xx[n + i - n3];
                f4 += f6 * f5;
                f3 += f7 * f5;
                f2 += f6 * f8;
                f += f7 * f8;
            }
            fArray3[n3] = f4;
            fArray3[n3 + 1] = f3;
            fArray3[n3 + 2] = f2;
            fArray3[n3 + 3] = f;
        }
        for (n3 = 0; n3 < n2 - 1; n3 += 2) {
            fArray4[n3 + 1] = this.xx[n3];
        }
    }

    public void comb_filter(float[] fArray, int n, float[] fArray2, int n2, int n3, int n4, float[] fArray3, float f) {
        int n5;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (n5 = n; n5 < n + n3; ++n5) {
            f2 += fArray[n5] * fArray[n5];
        }
        f4 = 0.5f * Math.abs(fArray3[0] + fArray3[1] + fArray3[2] + this.last_pitch_gain[0] + this.last_pitch_gain[1] + this.last_pitch_gain[2]);
        if (f4 > 1.3f) {
            f *= 1.3f / f4;
        }
        if (f4 < 0.5f) {
            f *= 2.0f * f4;
        }
        float f5 = 1.0f / (float)n3;
        float f6 = 0.0f;
        n5 = 0;
        int n6 = n;
        while (n5 < n3) {
            fArray2[n2 + n5] = fArray[n6] + f * (f6 += f5) * (fArray3[0] * fArray[n6 - n4 + 1] + fArray3[1] * fArray[n6 - n4] + fArray3[2] * fArray[n6 - n4 - 1]) + f * (1.0f - f6) * (this.last_pitch_gain[0] * fArray[n6 - this.last_pitch + 1] + this.last_pitch_gain[1] * fArray[n6 - this.last_pitch] + this.last_pitch_gain[2] * fArray[n6 - this.last_pitch - 1]);
            ++n5;
            ++n6;
        }
        this.last_pitch_gain[0] = fArray3[0];
        this.last_pitch_gain[1] = fArray3[1];
        this.last_pitch_gain[2] = fArray3[2];
        this.last_pitch = n4;
        for (n5 = n2; n5 < n2 + n3; ++n5) {
            f3 += fArray2[n5] * fArray2[n5];
        }
        float f7 = (float)Math.sqrt(f2 / (0.1f + f3));
        if (f7 < 0.5f) {
            f7 = 0.5f;
        }
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        n5 = n2;
        while (n5 < n2 + n3) {
            this.smooth_gain = 0.96f * this.smooth_gain + 0.04f * f7;
            int n7 = n5++;
            fArray2[n7] = fArray2[n7] * this.smooth_gain;
        }
    }

    public static final void qmf_decomp(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n, int n2, float[] fArray5) {
        int n3;
        float[] fArray6 = new float[n2];
        float[] fArray7 = new float[n + n2 - 1];
        int n4 = n2 - 1;
        int n5 = n2 >> 1;
        for (n3 = 0; n3 < n2; ++n3) {
            fArray6[n2 - n3 - 1] = fArray2[n3];
        }
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            fArray7[n3] = fArray5[n2 - n3 - 2];
        }
        for (n3 = 0; n3 < n; ++n3) {
            fArray7[n3 + n2 - 1] = fArray[n3];
        }
        n3 = 0;
        int n6 = 0;
        while (n3 < n) {
            fArray3[n6] = 0.0f;
            fArray4[n6] = 0.0f;
            for (int i = 0; i < n5; ++i) {
                int n7 = n6;
                fArray3[n7] = fArray3[n7] + fArray6[i] * (fArray7[n3 + i] + fArray7[n4 + n3 - i]);
                int n8 = n6;
                fArray4[n8] = fArray4[n8] - fArray6[i] * (fArray7[n3 + i] - fArray7[n4 + n3 - i]);
                int n9 = n6;
                fArray3[n9] = fArray3[n9] + fArray6[++i] * (fArray7[n3 + i] + fArray7[n4 + n3 - i]);
                int n10 = n6;
                fArray4[n10] = fArray4[n10] + fArray6[i] * (fArray7[n3 + i] - fArray7[n4 + n3 - i]);
            }
            n3 += 2;
            ++n6;
        }
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            fArray5[n3] = fArray[n - n3 - 1];
        }
    }
}

