/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.CRoomCatChannel;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.CreateRoomWindow;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.RoomRenderer;
import org.igoweb.igoweb.client.swing.UserList;
import org.igoweb.igoweb.shared.RoomCategories;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.APopupMenu;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SortedListModel;
import org.igoweb.util.swing.TBlock;

public class RoomListWindow
extends DFrame
implements ActionListener,
EventListener {
    private final SortedListModel<Object> list = new SortedListModel<Object>(new RoomSorter());
    private final RoomRenderer renderer = new RoomRenderer();
    private final AFrame parent;
    private final APopupMenu pop;
    private final JMenuItem joinMI;
    private final JMenuItem editMI;
    private final JMenuItem deleteMI;
    private final TBlock roomDesc = new TBlock("", 15);
    private final JLabel roomTitle = new JLabel(" ");
    private final UserList ownerList;
    private final Client client;
    private JButton joinBut;
    private JButton editBut;
    private CRoom selectedRoom;
    private final EnumSet<RoomCategories> categoryOpen = EnumSet.noneOf(RoomCategories.class);

    public RoomListWindow(Client newClient, AFrame newParent) {
        super(Defs.getString(-903340559), newParent);
        this.client = newClient;
        this.parent = newParent;
        this.pop = new APopupMenu();
        this.pop.setLabel(Defs.getString(-903340615));
        this.joinMI = new JMenuItem(Defs.getString(-903340707));
        this.pop.add(this.joinMI);
        this.joinMI.addActionListener(this);
        this.editMI = new JMenuItem(Defs.getString(-903340750));
        this.deleteMI = new JMenuItem(Defs.getString(-903340761));
        this.categoryOpen.clear();
        for (RoomCategories cat : RoomCategories.values()) {
            if (!cat.isVisible()) continue;
            this.list.add((Object)cat);
        }
        this.remenu();
        AList<Object> mainList = new AList<Object>(this.renderer, 10, event -> {
            if (event.arg instanceof RoomCategories) {
                this.categoryClick((RoomCategories)((Object)((Object)event.arg)));
            } else {
                this.roomClick((CRoom)event.arg);
            }
        }, this.list);
        JPanel lowerPanel = new JPanel(new GCLayout());
        this.roomTitle.setFont(UIManager.getFont("Label.font").deriveFont(1));
        lowerPanel.add("xSpan=2,yGrow=f,xGrow=f", this.roomTitle);
        lowerPanel.add("x=0,xSpan=1", new JLabel(Defs.getString(-903340498)));
        JScrollPane scroller = new JScrollPane(this.roomDesc, 20, 31);
        scroller.setPreferredSize(new Dimension(10, this.roomTitle.getFont().getSize() * 6));
        lowerPanel.add("ySpan=2,xGrow=t", scroller);
        this.ownerList = new UserList(newClient, null);
        this.ownerList.setEnabled(false);
        lowerPanel.add("x=0,ySpan=1,yGrow=t,xGrow=f", this.ownerList);
        this.roomDesc.setMinimumSize(new Dimension(10, 10));
        this.joinBut = this.addButton(Defs.getString(-903340537), this);
        this.joinBut.setEnabled(false);
        if (newClient.getMe().getAuthLevel() >= 4) {
            this.editBut = this.addButton(Defs.getString(-903340751), this);
            this.editBut.setEnabled(false);
        }
        this.addButton(Defs.getString(1436228510), this);
        this.getMainPanel().setLayout(new BorderLayout());
        JSplitPane splitter = new JSplitPane(0, true, mainList, lowerPanel);
        this.getMainPanel().add(splitter);
        splitter.setResizeWeight(1.0);
        this.pack();
        GuiClientUtil.addToWindowList(newClient, this);
        this.setVisible(true);
    }

    public void remenu() {
        if (this.client.getMe().getAuthLevel() >= 4) {
            if (this.pop.getComponentCount() == 1) {
                this.pop.addSeparator();
                this.pop.add(this.editMI);
                this.pop.addSeparator();
                this.pop.add(this.deleteMI);
                this.editMI.addActionListener(this);
                this.deleteMI.addActionListener(this);
            }
        } else {
            while (this.pop.getComponentCount() > 1) {
                this.pop.remove(1);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.joinMI) {
            ((CRoom)this.pop.getTarget()).sendJoinRequest();
        } else if (source == this.editMI) {
            new CreateRoomWindow(this.client, (CRoom)this.pop.getTarget(), this);
        } else if (source == this.deleteMI) {
            ((CRoom)this.pop.getTarget()).sendDeleteRequest();
        } else if (source == this.joinBut) {
            if (this.selectedRoom != null) {
                this.selectedRoom.sendJoinRequest();
            }
        } else if (source == this.editBut) {
            if (this.selectedRoom != null) {
                new CreateRoomWindow(this.client, this.selectedRoom, this.parent);
            }
        } else {
            this.dispose();
        }
    }

    @Override
    protected String getSavePositionPref() {
        return "e7q{]Q_Z";
    }

    @Override
    public void dispose() {
        for (RoomCategories cat : this.categoryOpen) {
            CRoomCatChannel catChannel = this.client.getRoomCategory(cat);
            for (CRoom cRoom : catChannel.getRooms().values()) {
                cRoom.removeListener(this);
            }
            catChannel.removeListener(this);
        }
        super.dispose();
    }

    private void categoryClick(RoomCategories category) {
        this.selectedRoom = null;
        this.joinBut.setEnabled(false);
        if (this.editBut != null) {
            this.editBut.setEnabled(false);
        }
        this.roomTitle.setEnabled(false);
        this.roomDesc.setEnabled(false);
        CRoomCatChannel cat = this.client.getRoomCategory(category);
        if (this.categoryOpen.contains((Object)category)) {
            cat.removeListener(this);
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                CRoom room;
                Object o = iter.next();
                if (!(o instanceof CRoom) || (room = (CRoom)o).getCategory() != category) continue;
                iter.remove();
                room.removeListener(this);
            }
            this.categoryOpen.remove((Object)category);
            this.renderer.setOpenCategory(category, false);
        } else {
            this.categoryOpen.add(category);
            this.renderer.setOpenCategory(category, true);
            cat.addListener(this);
        }
        this.list.sortNow();
    }

    private void roomClick(CRoom room) {
        if (this.selectedRoom == room) {
            room.sendJoinRequest();
        } else {
            this.selectedRoom = room;
            this.roomTitle.setEnabled(true);
            this.roomTitle.setText(room.getName());
            this.joinBut.setEnabled(true);
            if (this.editBut != null) {
                this.editBut.setEnabled(true);
            }
            this.updateOwnerList();
            this.roomDesc.setEnabled(true);
            this.roomDesc.setText(room.getDesc());
            this.roomDesc.setCaretPosition(0);
        }
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 19: 
            case 20: 
            case 57: 
            case 58: 
            case 59: 
            case 74: {
                this.list.add(event.source);
                this.list.scheduleSort();
                break;
            }
            case 78: {
                this.list.add(event.source);
                this.list.sortNow();
                break;
            }
            case 76: {
                this.list.remove(event.source);
                this.list.scheduleSort();
                break;
            }
            case 83: {
                CRoom room = (CRoom)event.arg;
                room.removeListener(this);
                room.addListener(this);
                this.list.add(room);
                this.list.sortNow();
                break;
            }
            case 84: {
                CRoom room = (CRoom)event.arg;
                RoomCategories newCat = room.getCategory();
                if (this.categoryOpen.contains((Object)newCat)) break;
                this.list.remove(room);
                room.removeListener(this);
                this.list.scheduleSort();
                break;
            }
            case 80: {
                if (event.source != this.selectedRoom) break;
                this.roomDesc.setText(this.selectedRoom.getDesc());
                this.roomDesc.setCaretPosition(0);
                break;
            }
            case 81: {
                if (event.source != this.selectedRoom) break;
                this.updateOwnerList();
                break;
            }
            case 82: {
                if (event.source != this.selectedRoom) break;
                this.selectedRoom.getDesc();
            }
        }
    }

    private void updateOwnerList() {
        ((SortedListModel)this.ownerList.getListModel()).clear();
        for (User user : this.selectedRoom.getOwners()) {
            this.ownerList.add(user);
        }
    }

    private static class RoomSorter
    implements Comparator<Object> {
        public static final int SORT_BY_NAME = 0;
        public static final int SORT_BY_USERS = 1;
        public static final int SORT_BY_GAMES = 2;
        public static final String PREF_KEY = "-P340;m[";
        private int sortBy;
        private Collator collator = Collator.getInstance();

        public RoomSorter() {
            this.collator.setStrength(1);
            this.sortBy = Prefs.getInt(PREF_KEY, 0);
        }

        @Override
        public int compare(Object a, Object b) {
            RoomCategories catB;
            CRoom roomB;
            RoomCategories catA;
            CRoom roomA;
            if (a instanceof RoomCategories) {
                roomA = null;
                catA = (RoomCategories)((Object)a);
            } else {
                roomA = (CRoom)a;
                catA = roomA.getCategory();
            }
            if (b instanceof RoomCategories) {
                roomB = null;
                catB = (RoomCategories)((Object)b);
            } else {
                roomB = (CRoom)b;
                catB = roomB.getCategory();
            }
            if (catA != catB) {
                return catA.compareTo(catB);
            }
            if (roomA == null) {
                return -1;
            }
            if (roomB == null) {
                return 1;
            }
            if (this.sortBy == 1 && roomA.getNumUsers() != roomB.getNumUsers()) {
                return roomB.getNumUsers() - roomA.getNumUsers();
            }
            if (this.sortBy == 2 && roomA.getNumGames() != roomB.getNumGames()) {
                return roomB.getNumGames() - roomA.getNumGames();
            }
            return this.collator.compare(roomA.getName(), roomB.getName());
        }
    }
}

