/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class AluminiumUtils {
    private static final Icon BG_IMAGE = new LazyImageIcon("aluminium/icons/background.jpg");
    private static final Icon ALTER_BG_IMAGE = new LazyImageIcon("aluminium/icons/alterBackground.jpg");
    private static Image backgroundImage = null;

    private AluminiumUtils() {
    }

    public static void fillComponent(Graphics g, Component c) {
        Graphics2D g2D = (Graphics2D)g;
        int w = c.getWidth();
        int h = c.getHeight();
        if (AbstractLookAndFeel.getTheme().isBackgroundPatternOn()) {
            int y;
            Point p = JTattooUtilities.getRelLocation(c);
            Dimension d = JTattooUtilities.getFrameSize(c);
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                int iw = BG_IMAGE.getIconWidth();
                int ih = BG_IMAGE.getIconHeight();
                for (y = -p.y; y < h; y += ih) {
                    for (int x = -p.x; x < w; x += iw) {
                        BG_IMAGE.paintIcon(c, g, x, y);
                    }
                }
                if (backgroundImage == null || backgroundImage.getWidth(null) != d.width || backgroundImage.getHeight(null) != d.height) {
                    backgroundImage = c.createImage(d.width, d.height);
                    Graphics2D ig2D = (Graphics2D)backgroundImage.getGraphics();
                    Point pt1 = new Point(0, 0);
                    Point pt2 = new Point(d.width, 0);
                    float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
                    Color c1 = new Color(220, 220, 220);
                    Color[] colors = new Color[]{c1, Color.white, c1};
                    ig2D.setPaint(new LinearGradientPaint(pt1, pt2, fractions, colors));
                    ig2D.fillRect(0, 0, d.width, d.height);
                    ig2D.dispose();
                }
                Composite savedComposite = g2D.getComposite();
                g2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                g2D.drawImage(backgroundImage, -p.x, 0, null);
                g2D.setComposite(savedComposite);
            } else {
                int iw = ALTER_BG_IMAGE.getIconWidth();
                int ih = ALTER_BG_IMAGE.getIconHeight();
                while (y < h) {
                    for (int x = -p.x; x < w; x += iw) {
                        ALTER_BG_IMAGE.paintIcon(c, g, x, y);
                    }
                    y += ih;
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, w, h);
        }
    }

    public static void fillComponent(Graphics g, Component c, int x, int y, int w, int h) {
        Graphics2D g2D = (Graphics2D)g;
        Shape savedClip = g2D.getClip();
        Area clipArea = new Area(new Rectangle2D.Double(x, y, w, h));
        clipArea.intersect(new Area(savedClip));
        g2D.setClip(clipArea);
        AluminiumUtils.fillComponent(g, c);
        g2D.setClip(savedClip);
    }
}

