/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.util;

import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private static final ILogger s_log = LoggerController.createLogger(ThreadCheckingRepaintManager.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ThreadCheckingRepaintManager.class);

    @Override
    public synchronized void addInvalidComponent(JComponent comp) {
        try {
            this.checkThread(comp);
        }
        catch (Exception ex) {
            s_log.debug(s_stringMgr.getString("ThreadCheckingRepaintManager.workinwrongthread"), ex);
        }
        super.addInvalidComponent(comp);
    }

    private void checkThread(JComponent comp) throws Exception {
        JRootPane root;
        if (!(comp.isVisible() && (root = comp.getRootPane()) != null && root.isVisible() && SwingUtilities.isEventDispatchThread())) {
            // empty if block
        }
    }

    @Override
    public synchronized void addDirtyRegion(JComponent comp, int i, int i1, int i2, int i3) {
        try {
            this.checkThread(comp);
        }
        catch (Exception ex) {
            s_log.debug(s_stringMgr.getString("ThreadCheckingRepaintManager.workinwrongthread"), ex);
        }
        super.addDirtyRegion(comp, i, i1, i2, i3);
    }
}

