/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.gui.builders.I15dPanelBuilder;

public final class DefaultFormBuilder
extends I15dPanelBuilder {
    private RowSpec lineGapSpec = FormFactory.LINE_GAP_ROWSPEC;
    private RowSpec paragraphGapSpec = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    private int leadingColumnOffset = 0;
    private boolean rowGroupingEnabled = false;

    public DefaultFormBuilder(FormLayout layout) {
        this(new JPanel(), layout);
    }

    public DefaultFormBuilder(JPanel panel, FormLayout layout) {
        this(panel, layout, null);
    }

    public DefaultFormBuilder(FormLayout layout, ResourceBundle bundle) {
        this(new JPanel(), layout, bundle);
    }

    public DefaultFormBuilder(JPanel panel, FormLayout layout, ResourceBundle bundle) {
        super(panel, layout, bundle);
    }

    public void setLineGapSize(ConstantSize lineGapSize) {
        RowSpec rowSpec;
        this.lineGapSpec = rowSpec = FormFactory.createGapRowSpec((ConstantSize)lineGapSize);
    }

    public RowSpec getLineGapSpec() {
        return this.lineGapSpec;
    }

    public void setParagraphGapSize(ConstantSize paragraphGapSize) {
        RowSpec rowSpec;
        this.paragraphGapSpec = rowSpec = FormFactory.createGapRowSpec((ConstantSize)paragraphGapSize);
    }

    public int getLeadingColumnOffset() {
        return this.leadingColumnOffset;
    }

    public void setLeadingColumnOffset(int columnOffset) {
        this.leadingColumnOffset = columnOffset;
    }

    public boolean isRowGroupingEnabled() {
        return this.rowGroupingEnabled;
    }

    public void setRowGroupingEnabled(boolean enabled) {
        this.rowGroupingEnabled = enabled;
    }

    public void append(Component component) {
        this.append(component, 1);
    }

    public void append(Component component, int columnSpan) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.lineGapSpec);
        this.ensureHasComponentLine();
        this.setColumnSpan(columnSpan);
        this.add(component);
        this.setColumnSpan(1);
        this.nextColumn(columnSpan + 1);
    }

    public void append(Component c1, Component c2) {
        this.append(c1);
        this.append(c2);
    }

    public void append(Component c1, Component c2, Component c3) {
        this.append(c1);
        this.append(c2);
        this.append(c3);
    }

    public JLabel append(String textWithMnemonic) {
        JLabel label = this.getComponentFactory().createLabel(textWithMnemonic);
        this.append(label);
        return label;
    }

    public JLabel append(String textWithMnemonic, Component component) {
        return this.append(textWithMnemonic, component, 1);
    }

    public JLabel append(String textWithMnemonic, Component c, int columnSpan) {
        JLabel label = this.append(textWithMnemonic);
        label.setLabelFor(c);
        this.append(c, columnSpan);
        return label;
    }

    public JLabel append(String textWithMnemonic, Component c1, Component c2) {
        JLabel label = this.append(textWithMnemonic, c1);
        this.append(c2);
        return label;
    }

    public void append(String textWithMnemonic, Component c1, Component c2, int colSpan) {
        this.append(textWithMnemonic, c1);
        this.append(c2, colSpan);
    }

    public JLabel append(String textWithMnemonic, Component c1, Component c2, Component c3) {
        JLabel label = this.append(textWithMnemonic, c1, c2);
        this.append(c3);
        return label;
    }

    public JLabel append(String textWithMnemonic, Component c1, Component c2, Component c3, Component c4) {
        JLabel label = this.append(textWithMnemonic, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public JLabel appendI15d(String resourceKey) {
        return this.append(this.getI15dString(resourceKey));
    }

    public JLabel appendI15d(String resourceKey, Component c, int columnSpan) {
        JLabel label = this.appendI15d(resourceKey);
        this.append(c, columnSpan);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component component) {
        return this.appendI15d(resourceKey, component, 1);
    }

    public JLabel appendI15d(String resourceKey, Component component, boolean nextLine) {
        JLabel label = this.appendI15d(resourceKey, component, 1);
        if (nextLine) {
            this.nextLine();
        }
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2) {
        JLabel label = this.appendI15d(resourceKey, c1);
        this.append(c2);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2, int colSpan) {
        JLabel label = this.appendI15d(resourceKey, c1);
        this.append(c2, colSpan);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2, Component c3) {
        JLabel label = this.appendI15d(resourceKey, c1, c2);
        this.append(c3);
        return label;
    }

    public JLabel appendI15d(String resourceKey, Component c1, Component c2, Component c3, Component c4) {
        JLabel label = this.appendI15d(resourceKey, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public JLabel appendTitle(String textWithMnemonic) {
        JLabel titleLabel = this.getComponentFactory().createTitle(textWithMnemonic);
        this.append(titleLabel);
        return titleLabel;
    }

    public JLabel appendI15dTitle(String resourceKey) {
        return this.appendTitle(this.getI15dString(resourceKey));
    }

    public JComponent appendSeparator() {
        return this.appendSeparator("");
    }

    public JComponent appendSeparator(String text) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.paragraphGapSpec);
        this.ensureHasComponentLine();
        this.setColumn(super.getLeadingColumn());
        int columnSpan = this.getColumnCount();
        this.setColumnSpan(this.getColumnCount());
        JComponent titledSeparator = this.addSeparator(text);
        this.setColumnSpan(1);
        this.nextColumn(columnSpan);
        return titledSeparator;
    }

    public void appendI15dSeparator(String resourceKey) {
        this.appendSeparator(this.getI15dString(resourceKey));
    }

    protected int getLeadingColumn() {
        int column = super.getLeadingColumn();
        return column + this.getLeadingColumnOffset() * this.getColumnIncrementSign();
    }

    private void ensureCursorColumnInGrid() {
        if (this.getColumn() > this.getColumnCount()) {
            this.nextLine();
        }
    }

    private void ensureHasGapRow(RowSpec gapRowSpec) {
        RowSpec rowSpec;
        if (this.getRow() == 1 || this.getRow() <= this.getRowCount()) {
            return;
        }
        if (this.getRow() <= this.getRowCount() && (rowSpec = this.getCursorRowSpec()) == gapRowSpec) {
            return;
        }
        this.appendRow(gapRowSpec);
        this.nextLine();
    }

    private void ensureHasComponentLine() {
        if (this.getRow() <= this.getRowCount()) {
            return;
        }
        this.appendRow(FormFactory.PREF_ROWSPEC);
        if (this.isRowGroupingEnabled()) {
            this.getLayout().addGroupedRow(this.getRow());
        }
    }

    private RowSpec getCursorRowSpec() {
        return this.getLayout().getRowSpec(this.getRow());
    }
}

