/*  Xsqlmenu
 *  Copyright (C) 1996-2000 Kees Lemmens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* K. Lemmens May 1996 */

#include <time.h>

#ifdef USE_MYSQL
#include <mysql/mysql.h>
#define sql_store_result(sock)    mysql_store_result(sock)
#define sql_num_rows(res)         mysql_num_rows(res)
#define sql_num_fields(res)       mysql_num_fields(res)
#define sql_fetch_row(res)        mysql_fetch_row(res)
#define sql_fetch_field(res)      mysql_fetch_field(res)
#define sql_free_result(res)      mysql_free_result(res)
#define sql_data_seek(res,offset) mysql_data_seek(res,offset)
#define sql_error(sock)           mysql_error(sock)
#define sql_list_dbs(sock, wild)  mysql_list_dbs(sock, wild)
#define sql_list_tables(sock, wild)  mysql_list_tables(sock, wild)
#define sql_list_fields(sock, table, wild)  mysql_list_fields(sock, table, wild)
#define sql_select_db(sock, db)   mysql_select_db(sock, db)
#define sql_connect(sock, server, user, pass) mysql_connect(sock, server, user, pass)
#define sql_query(sock, query)    mysql_query(sock, query)
#define sql_close(sock)           mysql_close(sock)
#define SQL_FIELD                 MYSQL_FIELD
#define SQL_ROW                   MYSQL_ROW
#define SQL_RES                   MYSQL_RES
#define IS_UNIQUE(x)              (x & UNIQUE_KEY_FLAG)
#else
#include <msql.h>
#define sql_store_result(sock)    msqlStoreResult()
#define sql_num_rows(res)         msqlNumRows(res)
#define sql_num_fields(res)       msqlNumFields(res)
#define sql_fetch_row(res)        msqlFetchRow(res)
#define sql_fetch_field(res)      msqlFetchField(res)
#define sql_free_result(res)      msqlFreeResult(res)
#define sql_data_seek(res,offset) msqlDataSeek(res,offset)
#define sql_error(sock)           msqlErrMsg
#define sql_list_dbs(sock, wild)  msqlListDBs(sock)
#define sql_list_tables(sock, wild)  msqlListTables(sock)
#define sql_list_fields(sock, table, wild)  msqlListFields(sock, table)
#define sql_select_db(sock, db)   msqlSelectDB(sock, db)
#define sql_connect(sock, server, user, pass) msqlConnect(server)
#define sql_query(sock, query)    msqlQuery(sock, query)
#define sql_close(sock)           msqlClose(sock)
#define SQL_FIELD                 m_field
#define SQL_ROW                   m_row
#define SQL_RES                   m_result
#endif

#include <forms.h>

/*
#define FORMS081  TRUE
*/

#define MSQL2     TRUE

#include "Xsql.h"

#define MAXSTRING 1000
#define MAXQUERY  2048
#define MAXLOGINFO  25   /* maximum number of lines in info log window */

/* browser initial fontsize : */
#define FONTSIZE  12.0

#ifdef __hpux
#define PRINTCMD "lp"
#else
#define PRINTCMD "lpr"
#endif

#define min(a,b) (a > b ? b : a )

#define debug printf

#define SELECT "SELECT * FROM %s "
#define INSERT "INSERT INTO %s VALUES ("
#define UPDATE "UPDATE %s SET "
#define DELETE "DELETE FROM %s "
#define WHERE  " WHERE "
#define EQUAL  "%s = %s"
#define LIKE   "%s LIKE %s" 
#define AND    " AND "
#define ORDER  "ORDER BY %s "

#define PASSIVE  0
#define ACTIVE   1
#define KEYFIELD 2

#define COUNT    0
#define NOCOUNT  1

/* Added JJG 8-DEC-98 , field width for ASCII display of mSQL variables */
#define JJGWIDTH 11

typedef struct {
   char     *Table;
   int      Numflds;
   int      Allflds; /* including all indexes (MSQL 2.0) */
   int      Primkey; /* number of primary key field */
   SQL_FIELD  *Fields;
   FD_Xsql  *Xsql; /* to make main form available to subfunctions */
   SQL_RES  *Res;  /* hook for Browser to hold a selection */
} Info_t;
   
/* Global variables */

#ifdef USE_MYSQL
extern MYSQL *sock;  /* selected database handle */
#else
extern int sock;  /* selected database handle */
#endif
extern int countflag;

/* function prototypes */

/* XsqlHelpers.c */

int  GetPrimaryKey(Info_t *I);
void SetNewServer(char *server,FD_Xsql *fd_Xsql);
void SetNewDatabase(char *database,FD_Xsql *fd_Xsql);
void SetNewTable(char *table,FD_Xsql *fd_Xsql);
char *TypeConvert(char *target,const char *string, int fieldtype);
int  CheckTableSelected(FD_Xsql *fd_Xsql);
Info_t *CopyInfoStruct(Info_t *Source);
void FreeInfoStruct(Info_t *Source);
int  ExecuteQuery(Info_t *I,char *query);

/* Shower functions : */

FD_Shower *BuildShowerForm(Info_t *I, char *title, int mode);
void WriteToBrowser(Info_t *I,FL_OBJECT *ob,SQL_ROW row);

/* XsqlDialog.c */
void SqlError(char *s,...);
void Message(char *s,...);
void Info(FD_Xsql *fd_Xsql,char *s,...);

/* ShowFields.c */
void SetPrimaryKey(FL_OBJECT *ob, long parent);
int GetPrimaryKey(Info_t *I);
