/* 
 * Copyright (c) 2000 Gregory D. Troxel <gdt@lexort.com>
 * Permission is granted to copy this file under the following terms,
 * subtituting Gregory D. Troxel for MIT.
 * Note that these are the same terms as the rest of the
 * xplot distribution.
 */
/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/

#ifndef _xplot_constraint_h_
#define _xplot_constraint_h_

#include "config.h"

/* Basic constraint data structure */

typedef enum { NONE, ASPECT, GEODETIC, RASTER, SCHEME } constraint_type_t;


typedef struct constraint_s {
  constraint_type_t constraint_type;
  double aspect_ratio;		/* height div width */
  double coord_per_pixel;
  char * procname;		/* later a SCM procedure */
} constraint_t;

/* Basic constraint interface */
int
xplot_constraint(constraint_t *constraint,
		 coord_type x_type, coord_type y_type,
		 coord x_left, coord y_bottom,
		 coord x_right, coord y_top,
		 coord *new_x_left, coord *new_y_bottom,
		 coord *new_x_right, coord *new_y_top,
		 int x_size, int y_size,
		 int ux_left, int uy_bottom,
		 int ux_right, int uy_top,
		 int *new_ux_left, int *new_uy_bottom,
		 int *new_ux_right, int *new_uy_top,
		 int *zoomed_x, int *zoomed_y);

#endif /* _xplot_constraint_h_ */
