/*----------------------------------------------------------------------------
--
--  Module:           xitWinInfo
--
--  Project:          Xtools
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xitWinInfo.
--
--  Filename:         xitWinInfo.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-11-29
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitWinInfo.h, Version: 1.1, Date: 95/02/18 15:10:52 */


#ifndef xitWinInfo_h
#  define xitWinInfo_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/X.h>

#include <Standard.h>
#include <LstLinked.h>


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* List all depths. */
#define  XIT_WI_ALL_DEPTHS     -1

/* Fetch this information. */
#define  XIT_WI_RES_NAME       (1<<0)
#define  XIT_WI_RES_CLASS      (1<<1)
#define  XIT_WI_WIN_NAME       (1<<2)
#define  XIT_WI_GEOMETRY       (1<<3)

/* Window flags. */
#define  XIT_WI_WITHDRAWN      (1<<0)
#define  XIT_WI_NORMAL         (1<<1)
#define  XIT_WI_ICONIC         (1<<2)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Information about one window. */
typedef struct {
  Window  window_id;
  int     level;
  char    res_class[ 100 ];
  char    res_name[ 100 ];
  char    name[ 100 ];
  int     pos_x;
  int     pos_y;
  int     width;
  int     height;
  int     width_inc;
  int     height_inc;
  UINT32  flags;
} XIT_WI_INFO;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitFetchWindowInfo( LST_DESC_TYPE  win_info_list,
                      Display        *display,
                      Window         window,
                      UINT32         flags,
                      int            current_depth,
                      int            list_depth,
                      int            max_depth );

#endif
