/*----------------------------------------------------------------------------
--
--  Module:           xitTools
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xitTools.c
--
--  Filename:         xitTools.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-01-04
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitTools.h, Version: 1.1, Date: 95/02/18 15:10:50 */


/* Only include this file once. */
#ifndef define_xitTools_h
#  define define_xitTools_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>

#include <Xm/Xm.h>

#include "System.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Short name for Motif default character set. */
#define CS    ((XmStringCharSet) XmSTRING_DEFAULT_CHARSET)

/* Menu separator indicator. */
#define XIT_SEP   "-------"


/* Flags for fil;e select. */
#define XIT_FILE_SELECT_ONLY_DIRS   (1<<0)
#define XIT_FILE_SELECT_DIRS_OK     (2<<0)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback and callback reasons from the file selection. */
typedef enum {
  XIT_FILE_SELECT_CANCEL,
  XIT_FILE_SELECT_OK
} XIT_FILE_SEL_REASON;

typedef void ( *XIT_FILE_SEL_CB ) ( XIT_FILE_SEL_REASON, char *, void * );


/* Description of one push button in the action area of a dialog. */
typedef struct {
  char     *label;
  void     (*callback)();
  void     *data;
} XIT_ACTION_AREA_ITEM;


/* Description of a arrow push button. */
typedef struct  {
  char     *name;
  Boolean  sensitive;
  int      direction;
  void     (*callback) ();
} XIT_ARROW_STRUCT;


/* A cascade item in a menu bar. */
typedef struct {
  char  *title;
  char  *mnemonic;
  char  *name;
} XIT_CASCADE_STRUCT;


/* Labels to use in the file selection window. */
typedef struct {
  char  *dir_list_label;
  char  *file_list_label;
  char  *filter_label;
  char  *selection_label;
  char  *cancel_button;
  char  *filter_button;
  char  *ok_button;
  char  *no_file_sel_msg;
  char  *cannot_read_file_msg;
} XIT_FILE_SEL_LABELS;


/* Assign a pixmap to an icon window. */
typedef struct {
  Pixmap      image;
  Boolean     report_expose_events;
  Pixel       icon_fg;
  Pixel       icon_bg;
  int         x_offset;
  int         y_offset;
  XmString    label;
  XmFontList  font_list;
  Pixel       label_fg;
} XIT_ICON_WINDOW;


/* An item in a menu pane. */
typedef struct  {
  char     *title;
  char     *mnemonic;
  void     (*callback) ();
  char     *name;
  Boolean  sensitive;
  Boolean  toggle_button;
  Boolean  selected;
} XIT_MENU_BUTTON_STRUCT;


/* Description of a label. */
typedef struct {
  char  *name;
  char  *string;
  int   alignment;
} XIT_LABEL_STRUCT;


/* Description of a push button. */
typedef struct  {
  char     *name;
  char     *title;
  char     *mnemonic;
  Boolean  sensitive;
  void     (*callback) ();
} XIT_PUSH_STRUCT;


/* Description of a text field. */
typedef struct {
  char     *name;
  void     (*callback) ();
  int      lines;
  Boolean  editable;
} XIT_TEXT_STRUCT;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void 
  xitAddTabgroup( Widget          widget, 
                  XtTranslations  translations );

Boolean
  xitAllocNamedColor( Widget  widget,
                      char    *color_string,
                      Pixel   *color );

void 
  xitAttachWidget( Widget  widget,
                   int     action_top,
                   Widget  top_widget,
                   int     action_left,
                   Widget  left_widget,
                   int     action_right,
                   Widget  right_widget,
                   int     action_bottom,
                   Widget  bottom_widget );

Boolean
  xitBusyDialogCancelled( Widget        workW,
                          XtAppContext  context );

void
  xitBusyDialogRemove( Widget  workW );

Widget 
  xitCreateArrowPushButton( Widget            parent, 
                            XIT_ARROW_STRUCT  *pb );

Widget 
  xitCreateBusyDialog( Widget parent, 
                       char   *dialog_name,
                       char   *title,
                       char   *message );

Widget 
  xitCreateCascadeButton( Widget              parent,
                          Widget              submenu,
                          XIT_CASCADE_STRUCT  *cascade );

Widget
  xitCreateDialogForm( Widget parent,
                       char   *name,
                       char   *ok_string,
                       void   (*okCB) (),
                       char   *cancel_string,
                       void   (*cancelCB) (),
                       char   *apply_string,
                       void   (*applyCB) (),
                       void   *client_data );

Widget 
  xitCreateErrorDialog( Widget  parent,
                        char   *dialog_name,
                        char   *title,
                        char   *message,
                        void   (*okCB) (),
                        void   *ok_client_data );

Widget
  xitCreateFileSelect( Widget               parent,
                       char                 *name,
                       UINT32               flags,
                       char                 *source_dir,
                       XIT_FILE_SEL_LABELS  *labels,
                       XIT_FILE_SEL_CB      actionCB,
                       void                 *user_data );

Widget
  xitCreateFormDialog( Widget                parent,
                       char                  *name,
                       int                   default_button_no,
                       int                   tightness,
                       XIT_ACTION_AREA_ITEM  *actions,
                       int                   num_actions );

Widget 
  xitCreateInformationDialog( Widget parent, 
                              char   *dialog_name,
                              char   *title,
                              char   *message,
                              void   (*okCB) (),
                              void   *ok_client_data );

Widget 
  xitCreateLabel( Widget parent,
                  char   *name,
                  char   *string,
                  int    alignment );

Widget 
  xitCreateLabelStruct( Widget            parent,
                        XIT_LABEL_STRUCT  *label_ref );

Widget 
  xitCreateLabelWidget( Widget parent,
                        char   *name,
                        char   *string,
                        int    alignment );

Widget 
  xitCreateMenuPushButton( Widget                  parent, 
                           XIT_MENU_BUTTON_STRUCT  *menu );

Widget 
  xitCreatePixmapDialog( Widget  parent, 
                         char    *dialog_name,
                         char    *title,
                         char    *message,
                         Pixmap  pixmap,
                         void    (*okCB) (),
                         void    *ok_client_data );

Widget 
  xitCreatePushButton( Widget           parent, 
                       XIT_PUSH_STRUCT  *pb );

Widget 
  xitCreatePushButtonGadget( Widget           parent, 
                             XIT_PUSH_STRUCT  *pb );

Widget 
  xitCreateQuestionDialog( Widget parent, 
                           char   *dialog_name,
                           char   *title,
                           char   *message,
                           void   (*okCB) (),
                           void   *ok_client_data,
                           void   (*cancelCB) (),
                           void   *cancel_client_data );

Widget 
  xitCreateToggleButton( Widget   parent,
                         char     *name,
                         char     *label,
                         Boolean  set );

Widget 
  xitCreateToggleButtonGadget( Widget   parent,
                               char     *name,
                               char     *label,
                               Boolean  set );

Widget 
  xitCreateText( Widget           parent, 
                 XIT_TEXT_STRUCT  *edits );

Widget 
  xitCreateTextCols( Widget           parent, 
                     XIT_TEXT_STRUCT  *edits,
                     int              init_cols );

Widget 
  xitCreateTextScrolled( Widget           parent, 
                         XIT_TEXT_STRUCT  *edits );

Widget 
  xitCreateTextScrolledCols( Widget           parent, 
                             XIT_TEXT_STRUCT  *edits,
                             int              init_cols );

Widget
  xitCreateToplevelDialog( Widget                parent,
                           char                  *name,
                           int                   default_button_no,
                           int                   tightness,
                           XIT_ACTION_AREA_ITEM  *actions,
                           int                   num_actions );

Widget 
  xitCreateWorkingDialog( Widget parent, 
                          char   *dialog_name,
                          char   *title,
                          char   *message,
                          void   (*okCB) (),
                          void   *ok_client_data,
                          void   (*cancelCB) (),
                          void   *cancel_client_data );

void 
  xitDispatchXEvents( Widget        widget,
                      XtAppContext  context );

void
  xitFileSelectDisplay( Widget  widget );

void
  xitFnGetCharMaxBounds( XmFontList  font_list,
                         char        *use_char_set,
                         Dimension   *width,
                         Dimension   *height );

Boolean
  xitGetChildren( Widget      widget,
                  Cardinal    *num_children,
                  WidgetList  *children );

Widget
  xitGetParentWidget( Widget  child,
                      char    *search_parent );

Widget
  xitGetToplevelWidget( Widget  widget );

char
  *xitGetWidgetName( Widget  widget );

void 
  xitGrabFocus( Widget  focus_toW );

void
  xitIconify( Widget  widget );

void
  xitInformationDialogTimeout( Widget widget,
                               int    secs );

Boolean
  xitIsRealized( Widget  widget );

Boolean
  xitIsTextEmpty( Widget  widget );

void
  xitManageChildren( Widget  widgets[],
                     int     number );

void 
  xitSetFocus( Widget  widget,
               Widget  focus_toW );

void 
  xitSetPositional( Widget widget, 
                    int    top, 
                    int    left, 
                    int    right, 
                    int    bottom );

void
  xitSetGeometryResources( Screen    *screen,
                           char      *geometry_str,
                           Arg       args[],
                           Cardinal  *n );

void
  xitSetIconWindow( Widget           shell,
                    XIT_ICON_WINDOW  *icon_win,
                    Window           *window,
                    GC               *gc );

void
  xitSetSizeFormDialog( Widget   toplevel,
                        Boolean  tight );

void
  xitSetSizeToplevelDialog( Widget   toplevel,
                            Boolean  tight );

void
  xitSortStringList( XmString  *list,
                     int       elements );

XmString
  xitStringConcatAndFree( XmString  to_the_string,
                          XmString  string );

char
  *xitStringGetLabel( Widget  widget );

char
  *xitStringGetString( XmString         xstr,
                       XmStringCharSet  char_set );

char
  *xitStringGetText( Widget  widget );

void
  xitStringSetLabel( Widget  widget,
                     char    *char_ref );

void
  xitStringSetTextFromFile( Widget  widget,
                            char    *file_name );

void 
  xitViewText( Widget  parent,
               char    *text,
               char    *title,
               char    *close_button );

#endif
