/*----------------------------------------------------------------------------
--
--  Module:           xitInfoSrch
--
--  Project:          xit - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file to module xitInfoSrch.
--
--  Filename:         xitInfoSrch.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitInfoSrch.h, Version: 1.1, Date: 95/02/18 15:10:39 */


/* Only include this module once. */
#ifndef define_xitInfoSrch_h
#  define define_xitInfoSrch_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XIT_IS_REASON_DESTROY,
  XIT_IS_REASON_NEW_SECTION,
  XIT_IS_REASON_POPDOWN
} XIT_IS_REASON;


/* Callback function. */
typedef void  ( *XIT_IS_ACTION_CB ) ( XIT_IS_REASON, 
                                      void *, char *, char *, char * );

/* Handle to the search window. */
typedef void  *XIT_IS_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitIsDestroy( XIT_IS_HANDLE  search_handle );

void 
  xitIsDisplaySearch( XIT_IS_HANDLE  search_handle,
                      char           *curr_book_name );

XIT_IS_HANDLE
  xitIsInitialize( Widget            parent,
                   LST_DESC_TYPE     *use_books,
                   XIT_IS_ACTION_CB  actionCB,
                   void              *user_data );

#endif
