/*----------------------------------------------------------------------------
--
--  Module:           xitColorSelect
--
--  Project:          xit   - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface for module xitColorSelect.
--
--  Filename:         xitColorSel.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-05-28
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitColorSel.h, Version: 1.1, Date: 95/02/18 15:10:22 */


/* Only include this module once. */
#ifndef define_xitColorSelect_h
#  define define_xitColorSelect_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* New resource names. */
#define COLOR_SELECT_CLASS  "ColorSelect"


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Definition of callback structure. */
typedef struct {
  int     reason;
  XEvent  *event;
  Pixel   pixel;
  XColor  color;
  char    rgb_string[ 50 ];
} xitColorSelectCallbackStruct;

/* The various child widgets you can get. */
typedef enum {
  xitCOLOR_SELECT_TEXT_FIELD,
  xitCOLOR_SELECT_BUTTON
} xitColorSelectChildren;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Widget
  xitCreateColorSelect( Widget          parent,
                        String          name,
                        ArgList         add_args,
                        Cardinal        num_args,
                        XtCallbackProc  proc,
                        XtPointer       client_data );

Widget
  xitColorSelectGetChild( Widget                  widget,
                          xitColorSelectChildren  child );

Boolean
  xitColorSelectGetColor( Widget  widget,
                          Pixel   *pixel,
                          XColor  *color,
                          char    *rgb_string );

Boolean
  xitColorSelectGetIndex( Widget  widget,
                          int     *selected_index );

Boolean
  xitColorSelectGetPixel( Widget  widget,
                          Pixel   *pixel );

void
  xitColorSelectSetColor( Widget   widget,
                          char     *new_color,
                          Boolean  call );

void
  xitColorSelectSetIndex( Widget   widget,
                          int      set_index,
                          Boolean  call );

void
  xitColorSelectSetMenu( Widget  widget,
                         char    *new_menu[],
                         int     elements );

void
  xitColorSelectSetPixel( Widget   widget,
                          Pixel    pixel,
                          Boolean  call );

#endif
