/*----------------------------------------------------------------------------
--
--  Module:           xtmMsgRead
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmMsgRead.
--
--  Filename:         xtmMsgRead.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-04-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmMsgRead.h, Version: 1.1, Date: 95/02/18 15:52:33 */


/* Include this module only once. */
#ifndef define_xtmMsgRead_h
#  define define_xtmMsgRead_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the reader. */
typedef  void  *XTM_MR_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmMrDestroy( XTM_MR_HANDLE  read_handle );

XTM_MR_HANDLE
  xtmMrInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent );

void
  xtmMrReadMessage( XTM_MR_HANDLE  read_handle,
                    UINT32         msg_id );

#endif
