%---------------------------------------------------------------------------
%  Name:     XDpsCommon.pro
%  Project:  XDiary
%
%  Description:
%   Common prolog file for PostScript output from XDiary.
%
%  Filename:         XDpsCommon.pro
%
%  Authors:          Roger Larsson, Ulrika Bornetun
%  Creation date:    1993-10-11
%
%
%  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
%      All rights reserved
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any purpose and without fee is hereby granted,
%  provided that the above copyright notice appear in all copies. Ulrika
%  Bornetun and Roger Larsson make no representations about the usability
%  of this software for any purpose. It is provided "as is" without express
%  or implied warranty.
%---------------------------------------------------------------------------
%
% SCCSID = @(#) Module: XDpsCommon.pro, Version: 1.1, Date: 95/02/18 14:15:06


%--------------------  Variables  --------------------
%
/DisplayHeader true def
/DisplayFooter true def
/Duplex false def


%--------------------  Paper size  --------------------
%

/scaleFont 1 def

% A3 paper (in mm).
PageFormat (A3) eq {
  /PageWidth    297 def % mm
  /PageHeight   420 def % mm
  /LeftMargin    10 def % mm
  /RightMargin   10 def % mm
  /TopMargin     15 def % mm
  /BottomMargin  15 def % mm
  /scaleFont 1 def
} if
  
% A4 paper (in mm).
PageFormat (A4) eq {
  /PageWidth    210 def % mm
  /PageHeight   297 def % mm
  /LeftMargin    10 def % mm
  /RightMargin   10 def % mm
  /TopMargin     15 def % mm
  /BottomMargin  15 def % mm
  /scaleFont 1 def
} if
  
% A5 paper (in mm).
PageFormat (A5) eq {
  /PageWidth    148 def % mm
  /PageHeight   210 def % mm
  /LeftMargin    10 def % mm
  /RightMargin   10 def % mm
  /TopMargin     15 def % mm
  /BottomMargin  15 def % mm
  /scaleFont 3 4 div def
} if
  
% Letter paper (in mm).
PageFormat (Letter) eq {
  /PageWidth    216 def % mm
  /PageHeight   279 def % mm
  /LeftMargin    10 def % mm
  /RightMargin   10 def % mm
  /TopMargin     15 def % mm
  /BottomMargin  15 def % mm
  /scaleFont 1 def
} if

% Legal paper (in mm).
PageFormat (Legal) eq {
  /PageWidth    216 def % mm
  /PageHeight   355 def % mm
  /LeftMargin    10 def % mm
  /RightMargin   10 def % mm
  /TopMargin     15 def % mm
  /BottomMargin  15 def % mm
  /scaleFont 1 def
} if

% IOS-8859-1 encoding.
/NLSvec [
  8#241 /exclamdown
  8#242 /cent
  8#243 /sterling
  8#250 /currency
  8#245 /yen
  8#246 /brokenbar
  8#247 /section
  8#310 /dieresis
  8#200 /copyright
  8#343 /ordfeminine
  8#253 /guillemotleft
  8#201 /logicalnot
  8#255 /hyphen
  8#202 /registered
  8#305 /macron
  8#312 /degree
  8#203 /plusminus
  8#262 /twosuperior
  8#263 /threesuperior
  8#302 /acute
  8#204 /mu
  8#266 /paragraph
  8#264 /periodcentered
  8#313 /cedilla
  8#271 /onesuperior
  8#353 /ordmasculine
  8#273 /guillemotright
  8#205 /onequarter
  8#206 /onehalf
  8#207 /threequarters
  8#277 /questiondown
  8#210 /Agrave
  8#211 /Aacute
  8#212 /Acircumflex
  8#213 /Atilde
  8#214 /Adieresis
  8#215 /Aring
  8#341 /AE
  8#216 /Ccedilla
  8#217 /Egrave
  8#220 /Eacute
  8#221 /Ecircumflex
  8#222 /Edieresis
  8#223 /Igrave
  8#224 /Iacute
  8#225 /Icircumflex
  8#226 /Idieresis
  8#227 /Eth
  8#230 /Ntilde
  8#231 /Ograve
  8#232 /Oacute
  8#233 /Ocircumflex
  8#234 /Otilde
  8#235 /Odieresis
  8#236 /multiply
  8#351 /Oslash
  8#237 /Ugrave
  8#240 /Uacute
  8#321 /Ucircumflex
  8#322 /Udieresis
  8#323 /Yacute
  8#324 /Thorn
  8#373 /germandbls
  8#325 /agrave
  8#326 /aacute
  8#327 /acircumflex
  8#330 /atilde
  8#331 /adieresis
  8#332 /aring
  8#361 /ae
  8#333 /ccedilla
  8#334 /egrave
  8#335 /eacute
  8#336 /ecircumflex
  8#337 /edieresis
  8#340 /igrave
  8#354 /iacute
  8#355 /icircumflex
  8#356 /idieresis
  8#357 /eth
  8#360 /ntilde
  8#265 /ograve
  8#276 /oacute
  8#300 /ocircumflex
  8#311 /otilde
  8#314 /odieresis
  8#342 /divide
  8#371 /oslash
  8#362 /ugrave
  8#363 /uacute
  8#364 /ucircumflex
  8#374 /udieresis
  8#375 /yacute
  8#376 /thorn
  8#377 /ydieresis
] def

%--------------------  Help procedures  --------------------
%
/mm {
  2.830 mul
} def


/inch {
  72 mul
} def


/hour {
  % Time in hh.mm format. Convert to minutes after midnight.
  %   hhMmTime

  /hhMmTime exch def

  hhMmTime truncate 60 mul
  hhMmTime hhMmTime truncate sub 100 mul add
} def


/min {
  % Minutes, no conversion.

} def


/makeTimeString {
  % Creates a HH.MM string from a float.
  %   time

  /time exch def
  /isPm false def

  /TimeB (              ) def

  /pos 0 def
  /timeHh time 60 div truncate def
  /timeMin time timeHh 60 mul sub round def

  Tf12Hour {
    timeHh 12 ge {
      timeHh 12 gt {
        /timeHh timeHh 12 sub def
      } if
      /isPm true def
    } if
  } if

  timeHh 10 lt {
    TimeB pos timeHh Buffer cvs putinterval
    /pos pos 1 add def
  } {
    TimeB pos timeHh Buffer cvs putinterval
    /pos pos 2 add def
  } ifelse

  TfSeparator length 0 gt {
    TimeB pos TfSeparator putinterval
    /pos pos 1 add def
  } if

  TimeB pos timeMin Buffer cvs putinterval
  /pos pos 1 add def

  timeMin 10 lt {
    TimeB pos (0) putinterval
  } if
  /pos pos 1 add def

  Tf12Hour {
    isPm {
      Tf12HourSuffix length 0 gt {
        TimeB pos Tf24HourSuffix putinterval
        /pos pos 1 add def
      } if
    } {
      Tf24HourSuffix length 0 gt {
        TimeB pos Tf12HourSuffix putinterval
        /pos pos 1 add def
      } if
    } ifelse
  } if

  Tf12Hour {
    TimeB 0 pos getinterval
  } {
    TimeB 0 pos getinterval
  } ifelse

} def


/centerText {
  % Center text.
  %   text leftLimit rightLimit

  /Right exch def
  /Left  exch def

  dup
  stringwidth pop
  2 div
  Right Left sub 2 div
  exch sub
  Left add
  Line moveto
  show
} def


/rightJustifyText {
  % Right justify text.
  %   text width

  /RightColumn exch def

  dup
  stringwidth pop
  RightColumn exch sub
  Line moveto
  show
} def


/reencsmalldict 12 dict def
/reEncodeSmall { 
  % Encoding as ISO-8859-1.

  reencsmalldict begin
  /newcodesandnames exch def
  /newfontname exch def
  /basefontname exch def
  /basefontdict basefontname findfont def
  /newfont basefontdict maxlength dict def
  basefontdict { 
    exch dup /FID ne {
      dup /Encoding eq { 
        exch dup length array copy
        newfont 3 1 roll put
      } {
        exch newfont 3 1 roll put
      } ifelse
    } { 
      pop pop
    } ifelse
  } forall

  newfont /FontName newfontname put
  newcodesandnames aload pop
  newcodesandnames length 2 idiv
    { newfont /Encoding get 3 1 roll put}
    repeat

  newfontname newfont definefont pop
  end
} def


