/*  window_all.h
 *
 ************************************************************
 *
 *     ̥⡼ɤѹǽ toplevel window Υ饹
 *     Gtk::Window ˤΥ饹Ѿ뤳Ȥ
 *     ɥ̥⡼ɤѹǽˤʤ롣
 *
 ************************************************************
 */
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/


#ifndef __VIDMODE_GTKMM_WINDOW_ALLSCRN_H__
#define __VIDMODE_GTKMM_WINDOW_ALLSCRN_H__

// #define HAVE_LIBXXF86VM /* 줬ƤСX Vidmode Extension Ѥ */
#ifdef HAVE_CONFIG_H
#include "config.h" // ΥޥɬפʤƤϤconfigure Ĥʤʤ餤ʤ
#endif

#include <X11/Xlib.h>
#ifdef HAVE_LIBXXF86VM
#include <X11/extensions/xf86vmode.h>
#define XF86VM_MINMAJOR 0
#define XF86VM_MINMINOR 5
#endif
/* DGA ϻȤ̣ʤΤ̵ˤ */
#ifdef HAVE_LIBXXF86DGA
#undef HAVE_LIBXXF86DGA
#endif
#ifdef HAVE_LIBXXF86DGA
#include <X11/extensions/xf86dga.h>
#define XF86DGA_MINMAJOR 1
#define XF86DGA_MINMINOR 0
#endif

#include <gtk--/window.h>

#ifndef HAVE_LIBXXF86VM
/* Ƥʤʤ顢ߡĤ */
struct XF86VidModeModeInfo {void* pointer;};
#endif

namespace Gtk {
class Window_AllScreen;
};

namespace Gtk {

class Window_AllScreen : public Window {
public: /* public methods , same as Gtk::Window */
  virtual ~Window_AllScreen();
  explicit Window_AllScreen(GtkWindowType type=GTK_WINDOW_TOPLEVEL);

private:
	int screen_bpl; // ̤ bytes per line
	int flags; // ʥե饰
	int other_window_count;
	int IsInitialized(void) { return flags & 4;}
	void SetInitialize(void) { flags |= 4; }
	int IsFinalized(void) { return flags & 8; }
	void SetFinalize(void) { flags |= 8; }
	void SetAllScreen(void) { flags |= 1;}
	void UnsetAllScreen(void) { flags &= ~1;}
	void SetUsableAllScreen(void) { flags |= 2;}
	int IsUsableAllScreen(void) { return IsInitialized() && (flags & 2); }
	void InitDGA(void);
private: // ѿ
	// ֤ݻ
	Display* dpy_restore;
	int screen_restore;
	// ӥǥ⡼ɤξ
	int vid_count;                    /* ⡼ɤο              */
	XF86VidModeModeInfo **modeinfos;  /* ⡼ɾ (0 ǽ)   */
	// ̥⡼ɤΤȤ˸ߤβ̤礭
	int all_width, all_height;
	// ̥⡼ɤλΡ˲̤ΰ֡礭
	int normal_x_pos, normal_y_pos, normal_width, normal_height;
	int dga_width;
	char* dga_buffer; /* video frame buffer for  Direct Access */

private: // private  method
	void GetAllScrnMode(void);
public:
	gint private_configure_event(GdkEventConfigure* p1);
	gint private_enter_event(GdkEventCrossing* event);

	int IsAllScreen(void) { return IsInitialized() && (flags & 1); }
	void RestoreMode(void);	// ̤򸵤ξ֤᤹
	int ToAllScreen(int width, int height); // ̤̥⡼ɤ
		// ºݤ˲̥⡼ɤ & width/height ˤʤä顢0ʳ֤
	XF86VidModeModeInfo* CheckModeLinesRes(int w, int h); // ꤵ줿 w/h Υ⡼ɤõ
	char* DGABuffer(void) { return dga_buffer; }
	int DGAWidth(void) { return dga_width; }
	/* DGA ľ衣̥⡼ɤλΤߡ 0 ֤ */
	int DGADraw(Gdk_Image* image, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
	void EnableDGA(void);
	void DisableDGA(void);

	/* ¾˥ɥ򳫤 */
	void MakeOtherWindow(void);
	void CloseOtherWindow(void);
};

};

#endif /* ! defined(__VIDMODE_GTKMM_WINDOW_ALLSCRN_H__) */
