/*-
 * @(#)gdkmm_font.cc -- Gdk--'s Gdk_Font with TrueType font
 */

#include "gdkmm_font.h"
#include<stdio.h>

Gdk_Font_FreeType::Gdk_Font_FreeType(gchar *fontname, gdouble point)
    : Gdk_Font(fontname), freetype_loaded(0), hints(NULL), info(NULL)
{
    int width, height;
    char* bitmap;
    if (!ttfont_init())
	return;
    if (!(hints = ttfont_load(fontname, point)))
	goto deinit;

    /* here set FontFaceHints's members */
    hints->resolution = 96;
    hints->ttcno = 0; 
	
    if (!(info = ttfont_open_face(hints)))
	goto unload;

    /* loaded successfully */
    freetype_loaded = 1;

    /* get font size */
    bitmap = get_bitmap(0x2422, width, height);
    delete[] bitmap;
    a_char_width = width;
    a_char_height= height;

    return;

unload:
    ttfont_unload(hints);
deinit:
    ttfont_deinit();
}

Gdk_Font_FreeType::~Gdk_Font_FreeType()
{
    if (!freetype_loaded)
	return;
    ttfont_close_face(info);
    ttfont_unload(hints);
    ttfont_deinit();
}

gchar *
Gdk_Font_FreeType::get_bitmap(gint code, gint &width, gint &height) const
{
    int font_smoothing = 1;
    char *bitmap, *bitmap_tmp;

    bitmap_tmp = ttfont_render_font(info, &width, &height,
				    code, font_smoothing);
    int bitmap_size = width * height;
    if (!(bitmap = new char[bitmap_size]))
	return NULL;

    char *src = bitmap_tmp, *dest = bitmap;
    for (int i = 0; i < bitmap_size; i++)
	*dest++ = *src++;

    /* bitmap_tmp was alloc'ed by malloc() */
    free(bitmap_tmp);

    return bitmap;
}

gint
Gdk_Font_FreeType::char_width(gint code) const
{
    return ttfont_advance(info, code);
}

gint
Gdk_Font_FreeType::char_measure(gint code) const
{
    int width, height;
    char *bitmap = get_bitmap(code, width, height);
    delete[] bitmap;
    return height;
}

/* gdkmm_font.cc ends here */
