/* gtest.cc
 *    եåطΥƥѡ
 *    ̤ΥƥȤԤ gtest() 
 */
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include "system.h"
#include "image_di.h"

void gtest(AyuSys& system);
/* obsolete... extern "C" int euc2sjis(const unsigned char* src, unsigned char* dst); */
#define euc2sjis kconv_rev

void write_number(int num) {
	FILE* f = fopen("/tmp/number","w");
	fprintf(f, "%d\n",num);
	fclose(f);
}

void textset1(AyuSys& sys) {
	sys.config->SetParam("#NVL_SYSTEM",1,1);
	sys.config->SetParam("#MESSAGE_SIZE", 2, 25,16);
	sys.config->SetParam("#MSG_MOJI_SIZE", 2, 12,24);
	sys.config->SetParam("#WINDOW_MSG_POS", 2, 30,30);
}
void textset2(AyuSys& sys) {
	sys.config->SetParam("#NVL_SYSTEM",1,0);
	sys.config->SetParam("#MESSAGE_SIZE", 2, 23,4);
	sys.config->SetParam("#MSG_MOJI_SIZE", 2, 12,29);
	sys.config->SetParam("#WINDOW_MSG_POS", 2, 22,350);
}

int textout(char* text, AyuSys& sys) {
	char buf[1024];
	euc2sjis((unsigned char*)text,(unsigned char*)buf);
	sys.DrawTextWindow();
	sys.DrawText(buf);
	sys.DrawTextEnd(1);
	sys.DrawReturnCursor(0);
	int x,y,flag = -1;
	while(flag == -1) {
		sys.CallProcessMessages();
		sys.GetMouseInfoWithClear(x,y,flag);
		if (sys.IsIntterupted()) break;
		if (sys.TextFastMode()) break;
	}
	if (sys.IsIntterupted()) return 1;
	sys.DeleteReturnCursor();
	sys.DeleteText();
	sys.DeleteTextWindow();
	return 0;
}

int textout2(char* text, AyuSys& sys) {
	char buf[1024];
	euc2sjis((unsigned char*)text,(unsigned char*)buf);
	sys.DrawTextWindow();
	sys.DrawText(buf);
	sys.DrawTextEnd(1);
	sys.DrawReturnCursor(0);
	int x,y,flag = -1;
	while(flag == -1) {
		sys.CallProcessMessages();
		sys.GetMouseInfoWithClear(x,y,flag);
		if (sys.IsIntterupted()) break;
		if (sys.TextFastMode()) break;
	}
	if (sys.IsIntterupted()) return 1;
	sys.DeleteReturnCursor();
	return 0;
}
int textout3(char* text, AyuSys& sys) {
	char buf[1024];
	euc2sjis((unsigned char*)text,(unsigned char*)buf);
	sys.DrawText(buf);
	sys.DrawTextEnd(1);
	sys.DrawReturnCursor(0);
	int x,y,flag = -1;
	while(flag == -1) {
		sys.CallProcessMessages();
		sys.GetMouseInfoWithClear(x,y,flag);
		if (sys.IsIntterupted()) break;
		if (sys.TextFastMode()) break;
	}
	if (sys.IsIntterupted()) return 1;
	return 0;
}
int textout4(char* text, AyuSys& sys) {
	char buf[1024];
	euc2sjis((unsigned char*)text,(unsigned char*)buf);
	sys.DrawText(buf);
	sys.DrawTextEnd(1);
	sys.DrawReturnCursor(0);
	int x,y,flag = -1;
	while(flag == -1) {
		sys.CallProcessMessages();
		sys.GetMouseInfoWithClear(x,y,flag);
		if (sys.IsIntterupted()) break;
		if (sys.TextFastMode()) break;
	}
	if (sys.IsIntterupted()) return 1;
	sys.DeleteReturnCursor();
	sys.DeleteText();
	sys.DeleteTextWindow();
	return 0;
}

int select(char* text,AyuSys& sys) {
	char buf[1024];
	TextAttribute sel[3];
	sprintf(buf+512, "%sԤ", text);
	sprintf(buf+768, "%sФ", text);
	euc2sjis((unsigned char*)(buf+512),(unsigned char*)buf);
	euc2sjis((unsigned char*)(buf+768),(unsigned char*)(buf+256));
	euc2sjis((unsigned char*)"̵",(unsigned char*)(buf+400));
	sel[0].SetText(buf+0);
	sel[1].SetText(buf+256);
	sel[2].SetText(buf+400);
	sys.DrawTextWindow();
	int ret = sys.SelectItem(sel, 3,1);
	if (ret == 0) return -1;
	sys.DeleteTextWindow();
	if (ret == 1) return 0;
printf("ret %d\n",ret);
	return 1;
}

void gtest(AyuSys& sys) {
	int s;
write_number(1);
	if (textout("ڣۥƥɽΥƥ",sys)) return;
	if ( (s=select("ɤĤ֤Υƥ",sys)) < 0) return;
	if (s == 0) {
write_number(2);
		if (textout("ڣ۲̤ɤĤ֤",sys)) return;
		sys.ClearPDTBuffer(1, 255, 255, 255);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(0, 255, 255, 255);
write_number(3);
		if (textout("ڣ۲̤ĤɤĤ֤",sys)) return;
		sys.ClearPDTBuffer(1, 0, 0, 255);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(4);
		if (textout("ڣ۲̤֤ɤĤ֤",sys)) return;
		sys.ClearPDTBuffer(1, 255, 0, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(5);
		if (textout("ڣ۲̤ФɤĤ֤",sys)) return;
		sys.ClearPDTBuffer(1, 0, 255, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(6);
		if (textout("ڣ۲̤򲫿ɤĤ֤",sys)) return;
		sys.ClearPDTBuffer(1, 255, 255, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(7);
		if (textout("ڣ۲̤忧ɤĤ֤",sys)) return;
		sys.ClearPDTBuffer(1, 0, 255, 255);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(8);
		if (textout("ڣ۲ͳѤ򤫤",sys)) return;
		sys.ClearPDTRect(1, 200, 200, 300, 300, 255, 255, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(9);
		if (textout("ڣ۳¦򤯤",sys)) return;
		sys.ClearPDTWithoutRect(1, 100, 100, 400, 400, 255, 255, 255);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
	}
	if ( (s=select("žΥƥ",sys)) < 0) return;
	if (s == 0) {
		sys.ClearPDTBuffer(1, 0, 255, 255);
		sys.ClearPDTRect(1, 200, 200, 300, 300, 255, 255, 0);
		sys.ClearPDTWithoutRect(1, 100, 100, 400, 400, 255, 255, 255);
write_number(10);
		if (textout("ڣĤͳѷ򤫤",sys)) return;
		sys.ClearPDTBuffer(2, 0, 0, 255);
		sys.SwapBuffer(200, 100, 300, 200, 2, 150, 150, 1);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
textset1(sys);
if (textout2("ڥƥȡʸϣ\n",sys)) return;
if (textout3("ڥƥȡʸϣ\n",sys)) return;
if (textout3("ڥƥȡʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣ\n",sys)) return;
if (textout3("ڥƥȡʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣʸϣ",sys)) return;
if (textout3("ڥƥȡʸx",sys)) return;
if (textout4("ڥƥȡʸy",sys)) return;
if (textout2("ڥƥȡʸϣ",sys)) return;
if (textout3("ڥƥȡʸϣ",sys)) return;
if (textout3("ڥƥȡʸϣ",sys)) return;
if (textout3("ڥƥȡʸϣ",sys)) return;
if (textout4("ڥƥȡʸend",sys)) return;
textset2(sys);
write_number(11);
		if (textout("ڣ۸᤹",sys)) return;
		sys.SwapBuffer(200, 100, 300, 200, 2, 150, 150, 1);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(12);
		if (textout("ڣĤǤ̤Ĥ֤",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
write_number(13);
		if (textout("ڣȾʬβ̤᤹",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 3, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 3, 100);
		sys.CopyBuffer(0, 0, 639, 479, 3, 0, 0, 0, 0);
write_number(14);
		if (textout("ڣƱ̤ΤϤ",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 3, 0);
		sys.FadePDTBuffer(3, 0, 0, 639, 479, 0, 0, 255, 100);
		sys.CopyBuffer(0, 0, 639, 479, 3, 0, 0, 0, 0);
write_number(15);
		if (textout("ڣ۽̾",sys)) return;
		sys.ClearPDTBuffer(2, 0, 0, 0);
		sys.CopyBuffer(0, 0, 639, 479, 3, 0, 0, 1, 0);
		sys.StretchBuffer(0, 0, 639, 479, 1, 100, 100, 300, 400, 2);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
write_number(16);
		if (textout("ڣ۳",sys)) return;
		sys.ClearPDTBuffer(1, 0, 0, 0);
		sys.StretchBuffer(100, 100, 300, 400, 2, 0, 0, 639, 479, 1);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
write_number(17);
		if (textout("ڣۤۤܡƱ̤ΤϤ",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 3, 0, 0, 0, 0);

	}
	if ( (s=select("̤Υƥ",sys)) < 0) return;
	if (s == 0) {
		/* sel ν */
		SEL_STRUCT sel;
		sel.x1 = sel.x3 = 0; sel.y1 = sel.y3 = 0;
		sel.x2 = 639, sel.y2 = 479;
		sel.wait_time = 32;
		/* ̤Ĥ */
		sys.ClearPDTBuffer(1, 0, 255, 255);
		sys.ClearPDTRect(1, 200, 200, 300, 300, 255, 255, 0);
		sys.ClearPDTWithoutRect(1, 100, 100, 400, 400, 255, 255, 255);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 3, 0);
		sys.FadePDTBuffer(3, 0, 0, 639, 479, 0, 0, 255, 100);
		sys.CopyBuffer(0, 0, 639, 479, 3, 0, 0, 1, 0);
		/* ɤĤ֤ */
		sys.ClearPDTBuffer(2, 255, 0, 255);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		if (textout("ڣۤޤϤβ̤顢ѥ",sys)) return;
		sel.sel_no = 5;
		sys.DrawPDTBuffer(1, &sel);
		if ( (s=select("",sys)) < 0) return;
		if (s == 0) {
write_number(19);
			if (textout("ڣۥ롧夫򤬹ߤƤ",sys)) return;
			sys.ClearPDTBuffer(2, 255, 255, 255);
			sel.sel_no = 15; sel.wait_time = 20; sel.arg4 = 1;
			sel.y2 = 199;
			sys.DrawPDTBuffer(2, &sel);
write_number(20);
			if (textout("ڣۥ롧",sys)) return;
			sel.y1 = 280; sel.y2 = 479;
			sel.sel_no = 15; sel.wait_time = 20; sel.arg4 = -1;
			sys.DrawPDTBuffer(1, &sel);
write_number(21);
			if (textout("ڣۥ롧®˾夫ߤ",sys)) return;
			sel.y1 = 0; sel.y2 = 199;
			sel.sel_no = 15; sel.wait_time = 20; sel.arg4 = 4;
			sys.DrawPDTBuffer(2, &sel);
write_number(22);
			if (textout("ڣۥ롧",sys)) return;
			sel.sel_no = 16; sel.wait_time = 20; sel.arg4 = 4;
			sel.y1 = 280; sel.y2 = 479;
			sys.DrawPDTBuffer(1, &sel);
			sel.y1 = 0; sel.y2 = 479;
			if (textout("ڣ١ۥ롧",sys)) return;
			sys.ClearPDTBuffer(2, 255, 255, 255);
			sel.sel_no = 17; sel.wait_time = 20; sel.arg4 = 1;
			sel.y2 = 199;
			sys.DrawPDTBuffer(2, &sel);
write_number(20);
			if (textout("ڣ١ۥ롧",sys)) return;
			sel.sel_no = 17; sel.wait_time = 20; sel.arg4 = -1;
			sys.DrawPDTBuffer(1, &sel);
write_number(21);
			if (textout("ڣ١ۥ롧®˺",sys)) return;
			sel.sel_no = 17; sel.wait_time = 20; sel.arg4 = 4;
			sys.DrawPDTBuffer(2, &sel);
write_number(22);
			if (textout("ڣ١ۥ롧",sys)) return;
			sel.sel_no = 18; sel.wait_time = 20; sel.arg4 = 4;
			sys.DrawPDTBuffer(1, &sel);
			sel.y1 = 0; sel.y2 = 479;
		}
		if ( (s=select("饤",sys)) < 0) return;
		if (s == 0) {
			if (textout("ڣӡۥ饤ɡ夫򤬹ߤƤ",sys)) return;
			sel.sel_no = 20; sel.wait_time = 20; sel.arg4 = 1;
			sel.y2 = 199;
			sys.DrawPDTBuffer(2, &sel);
			if (textout("ڣӡۥ饤ɡ",sys)) return;
			sel.sel_no = 21; sel.wait_time = 20; sel.arg4 = -1;
			sys.DrawPDTBuffer(1, &sel);
			sel.y2 = 479;
			if (textout("ڣӡۥ饤ɡ򤬽и",sys)) return;
			sel.x2 = 199;
			sel.sel_no = 22; sel.wait_time = 20; sel.arg4 = 1;
			sys.DrawPDTBuffer(2, &sel);
			if (textout("ڣӡۥ饤ɡ",sys)) return;
			sel.sel_no = 23; sel.wait_time = 20; sel.arg4 = -1;
			sys.DrawPDTBuffer(1, &sel);
			sel.x2 = 639;
		}
		if ( (s=select("¿ʸ",sys)) < 0) return;
		if (s == 0) {
write_number(23);
		if (textout("ڣ۾ľäƤʦ",sys)) return;
		sel.sel_no = 50; sel.wait_time = 30; sel.arg4 = 0;
		sys.DrawPDTBuffer(2, &sel);
write_number(24);
		if (textout("ڣ۾äƤ®ʦ",sys)) return;
		sel.sel_no = 50; sel.wait_time = 30; sel.arg4 = 64;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣ۾ľäƤʵٽ",sys)) return;
		sel.sel_no = 54; sel.wait_time = 30; sel.arg4 = 0;
		sys.DrawPDTBuffer(2, &sel);
write_number(24);
		if (textout("ڣ۾äƤ®ʵٽ",sys)) return;
		sel.sel_no = 54; sel.wait_time = 30; sel.arg4 = 128;
		sys.DrawPDTBuffer(1, &sel);
write_number(25);
sel.arg4=10;
		if (textout("ڣ۾夫鲼",sys)) return;
		sel.sel_no=10; sel.wait_time=5;sys.DrawPDTBuffer(2,&sel);
		if (textout("ڣ۲",sys)) return;
		sel.sel_no=11; sel.wait_time=5;sys.DrawPDTBuffer(1,&sel);
		if (textout("ڣۺ鱦",sys)) return;
		sel.sel_no=12; sel.wait_time=5;sys.DrawPDTBuffer(2,&sel);
		if (textout("ڣ۱麸",sys)) return;
		sel.sel_no=13; sel.wait_time=5;sys.DrawPDTBuffer(1,&sel);
sel.arg4=0;
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 60; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(26);
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 61; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
write_number(27);
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 62; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(28);
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 63; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
write_number(29);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 70; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(30);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 71; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
write_number(31);
		if (textout("ڣ褦衢夫",sys)) return;
		sel.sel_no = 72; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(32);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 73; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
write_number(33);
		if (textout("ڣۤΤ򹭤褦衢",sys)) return;
		sel.sel_no = 120; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(34);
		if (textout("ڣۤΤ򹭤褦衢",sys)) return;
		sel.sel_no = 121; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
write_number(35);
		if (textout("ڣۤΤ򹭤褦衢夫",sys)) return;
		sel.sel_no = 122; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(36);
		if (textout("ڣۤΤ򹭤褦衢",sys)) return;
		sel.sel_no = 123; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣۺ",sys)) return;
		sel.sel_no = 30; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
write_number(36);
		if (textout("ڣ۾岼",sys)) return;
		sel.sel_no = 31; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣۺ裲",sys)) return;
		sel.sel_no = 35; sel.wait_time = 32; sel.arg4=2;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ۾岼裲",sys)) return;
		sel.sel_no = 36; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);sel.arg4=0;
		if (textout("ڣ褦ʥդˡ",sys)) return;
		sel.sel_no = 80; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ褦ʥդˡ",sys)) return;
		sel.sel_no = 81; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣ褦ʥդˡ夫",sys)) return;
		sel.sel_no = 82; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ褦ʥդˡ",sys)) return;
		sel.sel_no = 83; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣû򹭤褦衢",sys)) return;
		sel.sel_no = 100; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣû򹭤褦衢",sys)) return;
		sel.sel_no = 101; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣû򹭤褦衢夫",sys)) return;
		sel.sel_no = 102; sel.wait_time = 32;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣû򹭤褦衢",sys)) return;
		sel.sel_no = 103; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣ۸Ť̾",sys)) return;
		sel.sel_no = 160; sel.wait_time = 100;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣۿ",sys)) return;
		sel.sel_no = 161; sel.wait_time = 100;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣ۲̾塢",sys)) return;
		sel.sel_no = 162; sel.wait_time = 100;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ۲̾塢",sys)) return;
		sel.sel_no = 163; sel.wait_time = 100;
		sys.DrawPDTBuffer(1, &sel);
		}
		if (textout("ڣ濴",sys)) return;
		sel.sel_no = 25; sel.wait_time = 5;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ۳¦",sys)) return;
		sel.sel_no = 26;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣ۳¦",sys)) return;
		sel.sel_no = 41;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ濴",sys)) return;
		sel.sel_no = 40; sel.wait_time = 5;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڣ۽",sys)) return;
		sel.sel_no = 45; sel.wait_time = 5;
		sys.DrawPDTBuffer(2, &sel);
		if (textout("ڣ۽",sys)) return;
		sel.sel_no = 45; sel.wait_time = 5;
		sys.DrawPDTBuffer(1, &sel);
	}
	if ( (s=select("̤Υƥȡʥޥդ",sys)) < 0) return;
	if (s == 0) {
		/* sel ν */
		SEL_STRUCT sel;
		sel.x1 = sel.x3 = 0; sel.y1 = sel.y3 = 0;
		sel.x2 = 639, sel.y2 = 479;
		sel.wait_time = 32;
		/* ̤Ĥ */
		sys.LoadPDTBuffer(2, "BG019Y");
		sys.LoadPDTBuffer(4, "DAYS");
		sys.CopyPDTtoBuffer(0,196,149,315, 4, 8, 8, 2,0);
		sys.CopyPDTtoBuffer(450,0,524,48, 4, 45,43, 2,0);
		sys.CopyPDTtoBuffer(348, 196, 413, 214, 4, 50, 97, 2,0);
		sys.LoadPDTBuffer(4, "CGAY26");
write_number(37);
		if (textout("ڣۤޤطʤ衣դϰ",sys)) return;
		sel.sel_no = 120; sel.wait_time = 20;
		sys.DrawPDTBuffer(2, &sel);
write_number(38);
		if (textout("ڣۤ椢桢֤",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 4; sel.wait_time = 32;
		sys.DrawPDTBuffer(1, &sel);
/*
		sel.sel_no = 50; sel.wait_time = 30; sel.arg4 = 256; sel.kasane=1;
		sys.DrawPDTBuffer(4, &sel);
*/
		sel.sel_no = 250; sel.wait_time = 50;
		if (textout("®٤˰Ū",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 260; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("夫",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 261; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 262; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("夫",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 263; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 264; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("夫",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 265; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 266; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("夫",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 267; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 270; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("濴",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 271; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("Ϥ",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 272; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("濴(ɩ)",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sys.ClearPDTBuffer(5, 255, 255, 255);
		sel.sel_no = 273; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("Ϥ(ɩ)",sys)) return;
		sys.DrawPDTBuffer(5, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 230; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("夫",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 231; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 232; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 233; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 234; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("ܤ򳫤",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 235; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("Ĥ",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 236; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("Ѳ",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 237; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("Ĥ",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.ClearPDTBuffer(5, 255, 255, 255);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 1, 0, 0, 0, 0);
		sel.sel_no = 238; sel.wait_time = 50; sel.arg4 = 32;
		if (textout("ײfadeʤ",sys)) return;
		sys.DrawPDTBuffer(5, &sel);
		sel.arg4 = 16;


write_number(28);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 210; sel.wait_time = 16; sel.arg4 = 128; sel.arg5=16;
		if (textout("(1)",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
write_number(29);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 211; sel.wait_time = 10; sel.arg4 = 128;
		if (textout("(2)",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
		sel.arg4 = 0; sel.arg5=0;

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 213; sel.wait_time = 10; sel.arg4 = 128;
		if (textout("(3)",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
		sel.arg4 = 0; sel.arg5=0;

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 222; sel.wait_time = 50; sel.arg4=21;
		if (textout("žʤfade",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
		sel.arg4 = 16;

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		// sel.sel_no = 220; sel.wait_time = 50;
		sel.sel_no = 220; sel.wait_time = 50; sel.arg4=15;
		if (textout("Ĳž",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
		sel.arg4 = 16;

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 221; sel.wait_time = 50; sel.arg4=15;
		if (textout("ž",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
		sel.arg4 = 16;

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 212; sel.wait_time = 50;sel.arg4 = 32;
		if (textout("ȥåʤ硦Ť͹碌",sys)) return;
		sys.DrawPDTBuffer(1, &sel);
		sel.arg4 = 16;

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 240; sel.wait_time = 50;
		if (textout("夫饹ȥå饤",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 241; sel.wait_time = 50;
		if (textout("饹ȥå饤",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 242; sel.wait_time = 50;
		if (textout("饹ȥå饤",sys)) return;
		sys.DrawPDTBuffer(1, &sel);

		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 243; sel.wait_time = 50;
		if (textout("饹ȥå饤",sys)) return;
		sys.DrawPDTBuffer(1, &sel);


write_number(39);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sel.sel_no = 35; sel.wait_time=50; sel.arg4 = 16; sel.arg5 = 11;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ؤˤ硼",sys)) return;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 0);
		sel.sel_no = 170; sel.wait_time = 40;
		sys.DrawPDTBuffer(1, &sel);

write_number(39);
		if (textout("ڤ֤ۡĤ͡",sys)) return;
		if (textout("ʹֿۡʤá",sys)) return;
		if (textout("ڣۡʤäơ夫ѹϤθ塢ͩ",sys)) return;
		sel.sel_no = 120; sel.wait_time = 20;
		sys.DrawPDTBuffer(2, &sel);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
		if ( (s=select("岼ɽ",sys)) < 0) return;
		if (s == 0) {
			sel.sel_no = 10; sel.wait_time = 5;
sel.kasane=1;sel.arg1=100;
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
			sys.LoadPDTBuffer(4, "CGAY15");
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 11;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 12;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 13;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 80);
sel.kasane=0;sel.arg1=0;
		}
		if ( (s=select("岼Υ饤ɽ",sys)) < 0) return;
		if (s == 0) {
			sel.sel_no = 20; sel.wait_time = 5;
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
			sys.LoadPDTBuffer(4, "CGAY15");
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 21;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 22;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 23;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 80);
		}
		if ( (s=select("岼ΤΤɽ",sys)) < 0) return;
		if (s == 0) {
			sel.sel_no = 30; sel.wait_time = 5;
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 1, 0);
			sys.LoadPDTBuffer(4, "CGAY15");
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 31;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 35; sel.wait_time=50; sel.arg4 = 16; sel.arg5 = 11;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 36;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyPDTtoBuffer(0, 0, 639, 479, 4, 0, 0, 1, 80);
			sel.arg4=0; sel.arg5=0;
		}
		if ( (s=select("濴¦ɽ",sys)) < 0) return;
		if (s == 0) {
			sel.sel_no = 25; sel.wait_time = 5;
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 26;
			sys.DrawPDTBuffer(4, &sel);
			sel.sel_no = 40; sel.wait_time = 5;
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 41;
			sys.DrawPDTBuffer(4, &sel);
			sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
			sel.sel_no = 45;
			sys.DrawPDTBuffer(4, &sel);
		}
			
		sel.sel_no = 4; sel.wait_time = 30;
		sys.DrawPDTBuffer(1, &sel);
		if (textout("ڤ֥ۡܥͩʤסʦǤȤ",sys)) return;
		sel.sel_no = 50; sel.wait_time = 30; sel.arg4 = 256; sel.kasane=1;
		sys.DrawPDTBuffer(4, &sel);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sel.sel_no = 54; sel.wait_time = 30; sel.arg4 = 128;sel.kasane=1;
		sys.DrawPDTBuffer(4, &sel);
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sel.sel_no = 54; sel.wait_time = 30; sel.arg4 = 128;sel.kasane=1; sel.arg5=1;
		sys.DrawPDTBuffer(4, &sel);sel.arg5=0;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sel.x1=100;sel.x2=400;sel.y1=100;sel.y2=400;sel.x3=0;sel.y3=0;
		sel.sel_no = 54; sel.wait_time = 30; sel.arg4 = 64;sel.kasane=1;
		sys.DrawPDTBuffer(4, &sel);
		sel.x1=0;sel.x2=639;sel.y1=0;sel.y2=479;sel.x3=0;sel.y3=0;
		sel.sel_no=4;
		sys.CopyBuffer(0, 0, 639, 479, 2, 0, 0, 0, 0);
		sys.DrawPDTBuffer(1, &sel);
write_number(40);
		if (textout("ڣ۰ʸ塢äƲ̡դѥ",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 60; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(41);
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 61; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(42);
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 62; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(43);
		if (textout("ڣۥդ衢ѥ",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 63; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(44);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 70; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(45);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 71; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(46);
		if (textout("ڣ褦衢夫",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 72; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(47);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 73; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(44);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 80; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(45);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 81; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(46);
		if (textout("ڣ褦衢夫",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 82; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(47);
		if (textout("ڣ褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 83; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(48);
		if (textout("ڣۤΤ򹭤褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 120; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(49);
		if (textout("ڣۤΤ򹭤褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 121; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(50);
		if (textout("ڣۤΤ򹭤褦衢夫",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 122; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
write_number(51);
		if (textout("ڣۤΤ򹭤褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 123; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
		if (textout("ڣû򹭤褦衢",sys)) return;
		sel.arg4=0;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 100; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
		if (textout("ڣû򹭤褦衢̤ݡȡ",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 101; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
		if (textout("ڣû򹭤褦衢夫",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 102; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
		if (textout("ڣû򹭤褦衢",sys)) return;
		sel.sel_no = 4; sel.wait_time = 30; sys.DrawPDTBuffer(1, &sel);
		sel.sel_no = 103; sel.wait_time = 32;
		sys.DrawPDTBuffer(4, &sel);
	}
write_number(99);
	if (textout("ڣ۽λ",sys)) return;
}
void AyuSys::RestoreGrp(void) {}
