// THIS FILE IS AUTOGENERATED USING go generate. DO NOT EDIT.
package iamutil

func GetEnabledResources() GeneratedResources {
	return generatedResources
}

var generatedResources = map[string]map[string]map[string]RestResource{
	"": {
		"iap": {
			"v1": RestResource{
				Name:                      "v1",
				TypeKey:                   "",
				Service:                   "iap",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iap.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iap.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "v1beta1",
				TypeKey:                   "",
				Service:                   "iap",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iap.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iap.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"b": {
		"storage": {
			"v1": RestResource{
				Name:               "buckets",
				TypeKey:            "b",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"b/o": {
		"storage": {
			"v1": RestResource{
				Name:               "objects",
				TypeKey:            "b/o",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "object"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
					"o":       "object",
					"objects": "object",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/o/{object}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/o/{object}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"billingAccounts": {
		"cloudbilling": {
			"v1": RestResource{
				Name:                      "billingAccounts",
				TypeKey:                   "billingAccounts",
				Service:                   "cloudbilling",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudbilling.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudbilling.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"buckets": {
		"storage": {
			"v1": RestResource{
				Name:               "buckets",
				TypeKey:            "buckets",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"buckets/objects": {
		"storage": {
			"v1": RestResource{
				Name:               "objects",
				TypeKey:            "buckets/objects",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "object"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
					"o":       "object",
					"objects": "object",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/o/{object}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/o/{object}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"folders": {
		"cloudresourcemanager": {
			"v2": RestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta1": RestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations": {
		"cloudresourcemanager": {
			"v1": RestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/sources": {
		"securitycenter": {
			"v1": RestResource{
				Name:                      "sources",
				TypeKey:                   "organizations/sources",
				Service:                   "securitycenter",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://securitycenter.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://securitycenter.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "sources",
				TypeKey:                   "organizations/sources",
				Service:                   "securitycenter",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://securitycenter.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://securitycenter.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1p1beta1": RestResource{
				Name:                      "sources",
				TypeKey:                   "organizations/sources",
				Service:                   "securitycenter",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://securitycenter.googleapis.com/",
					Path:       "v1p1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://securitycenter.googleapis.com/",
					Path:          "v1p1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects": {
		"cloudresourcemanager": {
			"v1": RestResource{
				Name:               "projects",
				TypeKey:            "projects",
				Service:            "cloudresourcemanager",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"projects": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1/projects/{resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1/projects/{resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:               "projects",
				TypeKey:            "projects",
				Service:            "cloudresourcemanager",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"projects": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1beta1/projects/{resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1beta1/projects/{resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/backendBuckets": {
		"compute": {
			"alpha": RestResource{
				Name:               "backendBuckets",
				TypeKey:            "projects/backendBuckets",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendBuckets": "resource",
					"projects":       "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/backendBuckets/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/backendBuckets/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/configs": {
		"runtimeconfig": {
			"v1beta1": RestResource{
				Name:                      "configs",
				TypeKey:                   "projects/configs",
				Service:                   "runtimeconfig",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://runtimeconfig.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://runtimeconfig.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/datasets": {
		"bigquery": {
			"v2": RestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/datasets",
				Service:                   "bigquery",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://bigquery.googleapis.com",
					Path:       "bigquery/v2/{+resource}",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PATCH",
					BaseURL:       "https://bigquery.googleapis.com",
					Path:          "bigquery/v2/{+resource}",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"projects/deployments": {
		"deploymentmanager": {
			"alpha": RestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/deploymentmanager/alpha/projects/",
					Path:       "{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/deploymentmanager/alpha/projects/",
					Path:          "{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": RestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/deploymentmanager/v2/projects/",
					Path:       "{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/deploymentmanager/v2/projects/",
					Path:          "{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta": RestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/deploymentmanager/v2beta/projects/",
					Path:       "{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/deploymentmanager/v2beta/projects/",
					Path:          "{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/images": {
		"compute": {
			"alpha": RestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instanceTemplates": {
		"compute": {
			"alpha": RestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/instances",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"spanner": {
			"v1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/instances",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/backups": {
		"spanner": {
			"v1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/instances/backups",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/clusters/backups": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/instances/clusters/backups",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/databases": {
		"spanner": {
			"v1": RestResource{
				Name:                      "databases",
				TypeKey:                   "projects/instances/databases",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/tables": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "tables",
				TypeKey:                   "projects/instances/tables",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/interconnects": {
		"compute": {
			"alpha": RestResource{
				Name:               "interconnects",
				TypeKey:            "projects/interconnects",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnects": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/interconnects/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/interconnects/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/licenseCodes": {
		"compute": {
			"alpha": RestResource{
				Name:               "licenseCodes",
				TypeKey:            "projects/licenseCodes",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenseCodes": "resource",
					"projects":     "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/licenseCodes/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/licenseCodes/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/licenses": {
		"compute": {
			"alpha": RestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/autoscalingPolicies": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/locations/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/locations/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/connections": {
		"bigqueryconnection": {
			"v1beta1": RestResource{
				Name:                      "connections",
				TypeKey:                   "projects/locations/connections",
				Service:                   "bigqueryconnection",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigqueryconnection.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigqueryconnection.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/connectivityTests": {
		"networkmanagement": {
			"v1beta1": RestResource{
				Name:                      "connectivityTests",
				TypeKey:                   "projects/locations/connectivityTests",
				Service:                   "networkmanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkmanagement.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkmanagement.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets": {
		"healthcare": {
			"v1beta1": RestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/locations/datasets",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/annotationStores": {
		"healthcare": {
			"v1beta1": RestResource{
				Name:                      "annotationStores",
				TypeKey:                   "projects/locations/datasets/annotationStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/dicomStores": {
		"healthcare": {
			"v1beta1": RestResource{
				Name:                      "dicomStores",
				TypeKey:                   "projects/locations/datasets/dicomStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/fhirStores": {
		"healthcare": {
			"v1beta1": RestResource{
				Name:                      "fhirStores",
				TypeKey:                   "projects/locations/datasets/fhirStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/domains": {
		"managedidentities": {
			"v1": RestResource{
				Name:                      "domains",
				TypeKey:                   "projects/locations/domains",
				Service:                   "managedidentities",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "domains",
				TypeKey:                   "projects/locations/domains",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "domains",
				TypeKey:                   "projects/locations/domains",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/entryGroups": {
		"datacatalog": {
			"v1beta1": RestResource{
				Name:                      "entryGroups",
				TypeKey:                   "projects/locations/entryGroups",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/functions": {
		"cloudfunctions": {
			"v1": RestResource{
				Name:                      "functions",
				TypeKey:                   "projects/locations/functions",
				Service:                   "cloudfunctions",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudfunctions.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudfunctions.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/instances": {
		"datafusion": {
			"v1beta1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "datafusion",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datafusion.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datafusion.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"memcache": {
			"v1beta2": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "memcache",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://memcache.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://memcache.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "keyRings",
				TypeKey:                   "projects/locations/keyRings",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings/cryptoKeys": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "cryptoKeys",
				TypeKey:                   "projects/locations/keyRings/cryptoKeys",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings/importJobs": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "importJobs",
				TypeKey:                   "projects/locations/keyRings/importJobs",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/namespaces": {
		"servicedirectory": {
			"v1beta1": RestResource{
				Name:                      "namespaces",
				TypeKey:                   "projects/locations/namespaces",
				Service:                   "servicedirectory",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/namespaces/services": {
		"servicedirectory": {
			"v1beta1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/namespaces/services",
				Service:                   "servicedirectory",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/queues": {
		"cloudtasks": {
			"v2": RestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta2": RestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta3": RestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2beta3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2beta3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/registries": {
		"cloudiot": {
			"v1": RestResource{
				Name:                      "registries",
				TypeKey:                   "projects/locations/registries",
				Service:                   "cloudiot",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudiot.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudiot.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/registries/groups": {
		"cloudiot": {
			"v1": RestResource{
				Name:                      "groups",
				TypeKey:                   "projects/locations/registries/groups",
				Service:                   "cloudiot",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudiot.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudiot.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/services": {
		"run": {
			"v1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "run",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "run",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/tagTemplates": {
		"datacatalog": {
			"v1beta1": RestResource{
				Name:                      "tagTemplates",
				TypeKey:                   "projects/locations/tagTemplates",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/taxonomies": {
		"datacatalog": {
			"v1beta1": RestResource{
				Name:                      "taxonomies",
				TypeKey:                   "projects/locations/taxonomies",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/taxonomies/policyTags": {
		"datacatalog": {
			"v1beta1": RestResource{
				Name:                      "policyTags",
				TypeKey:                   "projects/locations/taxonomies/policyTags",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workflowTemplates": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/locations/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/locations/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/machineImages": {
		"compute": {
			"alpha": RestResource{
				Name:               "machineImages",
				TypeKey:            "projects/machineImages",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"machineImages": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/machineImages/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/machineImages/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "machineImages",
				TypeKey:            "projects/machineImages",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"machineImages": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/machineImages/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/machineImages/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/notes": {
		"containeranalysis": {
			"v1alpha1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/occurrences": {
		"containeranalysis": {
			"v1alpha1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/autoscalingPolicies": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/regions/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/regions/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/clusters": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "clusters",
				TypeKey:                   "projects/regions/clusters",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "clusters",
				TypeKey:                   "projects/regions/clusters",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/disks": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/interconnectAttachments": {
		"compute": {
			"alpha": RestResource{
				Name:               "interconnectAttachments",
				TypeKey:            "projects/regions/interconnectAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectAttachments": "resource",
					"projects":                "project",
					"regions":                 "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/interconnectAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/interconnectAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/jobs": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/regions/jobs",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/regions/jobs",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/nodeTemplates": {
		"compute": {
			"alpha": RestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/operations": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "operations",
				TypeKey:                   "projects/regions/operations",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "operations",
				TypeKey:                   "projects/regions/operations",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/resourcePolicies": {
		"compute": {
			"alpha": RestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/subnetworks": {
		"compute": {
			"alpha": RestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/workflowTemplates": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/regions/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/regions/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/repos": {
		"sourcerepo": {
			"v1": RestResource{
				Name:                      "repos",
				TypeKey:                   "projects/repos",
				Service:                   "sourcerepo",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://sourcerepo.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://sourcerepo.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/secrets": {
		"secretmanager": {
			"v1": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/serviceAccounts": {
		"iam": {
			"v1": RestResource{
				Name:                      "serviceAccounts",
				TypeKey:                   "projects/serviceAccounts",
				Service:                   "iam",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iam.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iam.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/snapshots": {
		"compute": {
			"alpha": RestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"pubsub": {
			"v1": RestResource{
				Name:                      "snapshots",
				TypeKey:                   "projects/snapshots",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/subscriptions": {
		"pubsub": {
			"v1": RestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/subscriptions",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/subscriptions",
				Service:                   "pubsub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/topics": {
		"pubsub": {
			"v1": RestResource{
				Name:                      "topics",
				TypeKey:                   "projects/topics",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "topics",
				TypeKey:                   "projects/topics",
				Service:                   "pubsub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/disks": {
		"compute": {
			"alpha": RestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/instances": {
		"compute": {
			"alpha": RestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/nodeGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/reservations": {
		"compute": {
			"alpha": RestResource{
				Name:               "reservations",
				TypeKey:            "projects/zones/reservations",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"reservations": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "reservations",
				TypeKey:            "projects/zones/reservations",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"reservations": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "reservations",
				TypeKey:            "projects/zones/reservations",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"reservations": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"providers/notes": {
		"containeranalysis": {
			"v1alpha1": RestResource{
				Name:                      "notes",
				TypeKey:                   "providers/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"services": {
		"servicemanagement": {
			"v1": RestResource{
				Name:                      "services",
				TypeKey:                   "services",
				Service:                   "servicemanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicemanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicemanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"services/consumers": {
		"servicemanagement": {
			"v1": RestResource{
				Name:                      "consumers",
				TypeKey:                   "services/consumers",
				Service:                   "servicemanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicemanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicemanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
}
