#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <xosd.h>

#define FALSE 0
#define TRUE !FALSE
#define MAX 256
#define VERT_OFFSET     15
#define HORIZ_OFFSET    8

char *FONT = "-*-lucida console-medium-r-semi condensed-*-*-120-75-75-*-*-iso8859-1";
/* Valid values: XOSD_top, XOSD_middle, XOSD_bottom */
int POSITION = XOSD_top;
/* Valid values: XOSD_left, XOSD_center, XOSD_right */
int ALIGN = XOSD_left;
char *TEXT_COLOUR = "green";
char *OUTLINE_COLOUR = "grey";
int OUTLINE_SIZE = 0;
int UPDATE_INTERVAL = 6;
char *ft = "%A, %e %B %Y. %R %Z";

size_t strftime_gcc_hack(char *s, size_t max, const char *fmt, const struct tm *tm);
void make_clock(int, char*, char*);

int main (int argc, char *argv[]) {
	int index = 1;
	char *timezone = "", *city = "Local";
	char use_tzlist = FALSE;
	int i;

	for (i = 0; i < argc; i++) {
		if (strcmp(argv[i], "-tzl") == 0) {
 			use_tzlist = TRUE;
		}
		else if (strcmp(argv[i], "-i") == 0) {
			i++;
			index = atoi(argv[i]);
		}
		else if (strcmp(argv[i], "-t") == 0) {
			i++;
			timezone = argv[i];
		}
		else if (strcmp(argv[i], "-c") == 0) {
			i++;
			city = argv[i];
		}
		else if (strcmp(argv[i], "-fn") == 0) {
			i++;
			FONT = argv[i];
		}
		else if (strcmp(argv[i], "-va") == 0) {
			i++;
			if (strcmp(argv[i], "top") == 0)
				POSITION = XOSD_top;
			else if (strcmp(argv[i], "middle") == 0)
				POSITION = XOSD_middle;
			else if (strcmp(argv[i], "bottom") == 0)
				POSITION = XOSD_bottom;
		}
		else if (strcmp(argv[i], "-ha") == 0) {
			i++;
			if (strcmp(argv[i], "left") == 0)
				ALIGN = XOSD_left;
			else if (strcmp(argv[i], "center") == 0)
				ALIGN = XOSD_center;
			else if (strcmp(argv[i], "right") == 0)
				ALIGN = XOSD_right;
		}
		else if (strcmp(argv[i], "-ft") == 0) {
			i++;
			ft = argv[i];
		}
		else if (strcmp(argv[i], "-tc") == 0) {
			i++;
			TEXT_COLOUR = argv[i];
		}
		else if (strcmp(argv[i], "-oc") == 0) {
			i++;
			OUTLINE_COLOUR = argv[i];
		}
		else if (strcmp(argv[i], "-os") == 0) {
			i++;
			OUTLINE_SIZE = atoi(argv[i]);
		}
		else if (strcmp(argv[i], "-u") == 0) {
			i++;
			UPDATE_INTERVAL = atoi(argv[i]);
		}
		else if (strcmp(argv[i], "-h") == 0) {
			fputs("tzosdclock [-h | -tzl | [-c city] [-t tz] [-i index]] [-fn font] [-va vert]\n", stderr);
			fputs("		[-ha horz] [-tc colr] [-oc colr] [-os int] [-u secs] [-ft fmt]\n", stderr);
			fputs("Main Arguments:\n", stderr);
			fputs("	-h       Help\n", stderr);
			fputs("		- OR -\n", stderr);
			fputs("	-tzl     Parse .tzlist file\n", stderr);
			fputs("		- OR -\n", stderr);
			fputs("	-c city  City for this instance. def: Local\n", stderr);
			fputs("	-t tz    Timezone. def: NULL (Local)\n", stderr);
			fputs("	-i index Index. Used for vertical spacing. def: 1\n", stderr);
			fputs("Options:\n", stderr);
			fputs("	-fn font Font identifier to be used. def: lucida console\n", stderr);
			fputs("	-va vert Either top, middle, or bottom. def: top\n", stderr);
			fputs("	-ha horz Either left, center, or right. def: left\n", stderr);
			fputs("	-tc colr Color of text. def: Green\n", stderr);
			fputs("	-oc colr Color of outline. def: Grey\n", stderr);
			fputs("	-os int  Size of outline. def: 0\n", stderr);
			fputs("	-u secs  Seconds between updates. def: 6\n", stderr);
			fputs("	-ft fmt  Time format, see strftime(3). def: %A, %e %B %Y. %R %Z\n", stderr);
			exit(0);
		}
	}

	if (use_tzlist) { //parse ~/.tzlist file
		char *home = getenv("HOME");
		char c[MAX], fname[strlen(home)+9];  /* declare a char array */
		FILE *file;  /* declare a FILE pointer  */

		sprintf(fname, "%s/.tzlist", home);
		file = fopen(fname, "r"); 
		/* open a text file for reading */

		if (file==NULL) {
			fprintf(stderr, "ERROR: %s/.tzlist could not be opened!\n", home);
			fputs("\n", stderr);
			fputs("Be sure the file is created. It should follow this format:\n", stderr);
			fputs("TIME/Zone \"City Name\"\n", stderr);
			fputs("\n", stderr);
			fputs("For example, the following:\n", stderr);
			fputs("US/Mountain \"Denver, CO/US\"\n", stderr);
			fputs("Europe/London \"London/UK\"\n", stderr);
			fputs("- would produce two clocks on screen, one for MST/MDT and one for GMT/BST.\n", stderr);
			return 1;
		}
		else {
			int num = 1;
			char tz[MAX], city2[MAX];
			fprintf(stderr, "Found .tzlist file in home; Using as requested.\n");

			//fscanf is more proper than fgets/str[r]chr/str[n]cpy
			while (fscanf(file, "%s \"%[^\"]\"\n", tz, city2)!=EOF) {
/*			while (fgets(c, MAX, file)!=NULL) { 
				char *fsp = strchr(c, ' ');
				char *fqt = strchr(c, '"'), *lqt = strrchr(c, '"');
				int tzlen = strlen(c)-strlen(fsp), ctlen = strlen(fqt)-strlen(lqt)-1;
				char tz[tzlen + 2], city2[ctlen + 2];
	
				// time zone is deciphered as everything up to the first space.
				strncpy(tz, c, tzlen); //extract timezone
				strcpy(&tz[tzlen], "\0"); //null terminate the string

				// city is deciphered as everything between the first and last quotation marks.
				strncpy(city2, &fqt[1], ctlen); //extract city
				strcpy(&city2[ctlen], "\0"); //null terminate the string */

				make_clock(num, tz, city2);
				num++;
			}

			fclose(file);
			return 0;
		}
	}
	else { //not using tzlist. process as default or manual selection.
		make_clock(index, timezone, city);
	}

	exit(0);
}

size_t strftime_gcc_hack(char *s, size_t max, const char *fmt, const struct tm *tm) {
	return strftime(s, max, fmt, tm);
}

void make_clock(int index, char *timezone, char *city) {
	int pid;
	if ((pid = fork()) < 0) { //fork() is called here.
		fputs("ERROR: Could not fork().\n", stderr);
	}
	else if (pid == 0) { //child instance
		xosd *osd;
		char buffer[MAX];

		osd = xosd_create(1);
		if (osd == NULL) {
			fprintf(stderr, "ERROR: Could not create osd widget: %s", xosd_error);
			exit(1);
		}

		xosd_set_font(osd, FONT);
		xosd_set_colour(osd, TEXT_COLOUR);
		xosd_set_outline_offset(osd, OUTLINE_SIZE);
		xosd_set_outline_colour(osd, OUTLINE_COLOUR);

		xosd_set_pos(osd, POSITION);
		xosd_set_vertical_offset(osd, index*VERT_OFFSET);
		xosd_set_align(osd, ALIGN);
		xosd_set_horizontal_offset(osd, HORIZ_OFFSET);

		time_t rawtime;
		char string[MAX];

		if (strcmp(timezone, "") != 0)
			setenv("TZ", timezone, 1);
		sprintf(buffer, "%s - %s", ft, city);
		while (1) {
			time(&rawtime);
			strftime_gcc_hack(string, MAX, buffer, localtime(&rawtime));

			xosd_display(osd, 0, XOSD_string, string);
			sleep(UPDATE_INTERVAL);
		}
	
		xosd_destroy(osd);
	}
	else { //main instance
		fprintf(stderr, "tzosdclock launched for: %s\n", city);
	}
}

