/* Modules/Pro/play.c 
	vi:ts=3 sw=3:
 */

/* $Id: play.c,v 1.2 1996/05/06 07:37:04 espie Exp espie $
 * $Log: play.c,v $
 * Revision 1.2  1996/05/06 07:37:04  espie
 * *** empty log message ***
 *
 * Revision 1.1  1996/04/12 16:31:16  espie
 * Initial revision
 *
 * Revision 5.3  1996/04/09 21:14:06  espie
 * *** empty log message ***
 *
 * Revision 5.2  1996/04/02 09:33:47  espie
 * *** empty log message ***
 *
 * Revision 5.1  1995/12/24 03:13:10  espie
 * *** empty log message ***
 *
 * Revision 5.0  1995/10/21 14:57:05  espie
 * New
 *
 * Revision 4.34  1995/09/03 21:55:51  espie
 * Simplified player.
 *
 * Revision 4.32  1995/09/03 13:40:09  espie
 * Moved functions around.
 *
 * Revision 4.31  1995/08/31 13:31:25  espie
 * NO_OUTPUT option.
 *
 * Revision 4.26  1995/06/26 15:45:08  espie
 * Removed blocks, enter patterns.
 *
 * Revision 4.25  1995/06/26 10:11:17  espie
 * EVENT() abstraction.
 *
 * Revision 4.24  1995/06/23 09:35:51  espie
 * No longer pitch saved.
 *
 * Revision 4.23  1995/05/30  13:09:25  espie
 * Changed effect handling.
 *
 * Revision 4.22  1995/05/23  13:24:53  espie
 * Experimental new release.
 *
 * Revision 4.21  1995/05/15  12:20:09  espie
 * *** empty log message ***
 *
 * Revision 4.20  1995/05/11  12:30:46  espie
 * DELAY PATTERN correction.
 *
 * Revision 4.19  1995/03/11  21:41:01  espie
 * Added invert_loop.
 *
 * Revision 4.18  1995/03/04  00:16:21  espie
 * implemented vibrato wave.
 *
 * Revision 4.17  1995/03/03  14:24:21  espie
 * *** empty log message ***
 *
 * Revision 4.16  1995/03/01  15:24:51  espie
 * data width.
 *
 * Revision 4.15  1995/02/21  21:13:16  espie
 * Cleaned up source. Moved minor pieces of code around.
 *
 * Revision 4.14  1995/02/21  17:54:32  espie
 * Internal problem: buggy RCS. Fixed logs.
 *
 * Revision 4.12  1995/02/20  22:53:31  espie
 * Some display updated.
 *
 * Revision 4.11  1995/02/20  22:28:50  espie
 * 8 channels.
 *
 * Revision 4.10  1995/02/20  16:49:58  espie
 * Added funk_glissando
 *
 * Revision 4.9  1995/02/14  04:02:28  espie
 * Suppressed comment.
 *
 * Revision 4.8  1995/02/06  14:50:47  espie
 * Changed sample_info.
 *
 * Revision 4.7  1995/02/01  20:41:45  espie
 * Added color.
 *
 * Revision 4.6  1995/02/01  16:39:04  espie
 * Left/Right channels.
 *
 * Revision 4.0  1994/01/11  17:51:40  espie
 * Use the new UI calls.
 * Use the new pref settings.
 *
 * Revision 1.14  1994/01/09  23:24:37  Espie
 * Last bug fix.
 * Suppressed really outdated code.
 * New names: new_channel_tag_list, release_audio_channel.
 * Some notice to status.
 * Use new pref scheme.
 * Use get_ui
 * Use autoinit feature of display.c
 * discard_buffer forgotten...
 * Handle errors better.
 *
 * Revision 3.18  1993/12/04  16:12:50  espie
 * Lots of changes.
 * New high-level functions.
 * Amiga support.
 * Bug with delay_pattern: can't factorize the check for effect thingy.
 * Reniced verbose output display.
 * Bug fix: now use correct finetune when loading samples/starting notes.
 * Added bg/fg test.
 * General cleanup
 * Added <> operators.
 * Added update frequency on the fly.
 * Added finetune.
 * Protracker commands.
 *
 * Revision 2.19  1992/11/17  17:15:37  espie
 * Added interface using may_getchar(). Still primitive, though.
 * imask, start.
 * Added transpose feature.
 * Added possibility to get back to MONO for the sgi.
 * Added stereo capabilities to the indigo version.
 * Added two level of fault tolerancy.
 * Added some control on the number of replays,
 * and better error recovery.
 */
     
#include "defs.h"
#include "song.h"
#include "notes.h"
#include "channel.h"
#include "extern.h"
#include "tags.h"
#include "prefs.h"
#include "Modules/Pro/effects.h"
#include "p_automaton.h"
#include "automaton.h"
#include "autoinit.h"
#include "resample.h"
#include "Modules/Pro/play.h"
#include "Modules/Pro/low.h"
#include "empty.h"
     

XT short vibrato_table[3][64];

LOCAL void init_st_play(void);
LOCAL void (*INIT)(void) = init_st_play;

ID("$Id: play.c,v 1.2 1996/05/06 07:37:04 espie Exp espie $")
     

/**************
 **************
 **************/


LOCAL struct st_effect eval[NUMBER_EFFECTS];
                    		/* the effect table */

LOCAL struct channel chan[MAX_TRACKS];
                    /* every channel */

LOCAL unsigned int ntracks;		/* number of tracks of the current song */
LOCAL struct sample_info **voices;



/* init_channel(ch, dummy):
 * setup channel, with initially a dummy sample ready to play, and no note.
 */
LOCAL void init_channel(struct channel *ch, int side)
   {
	struct tag tags[2];
	tags[0].type = AUDIO_SIDE;
	tags[0].data.scalar = side;
	tags[1].type = TAG_END;
   ch->samp = empty_sample();
   ch->finetune = 0;
   ch->audio = new_channel_tag_list(tags);
   ch->volume = 0; 
   ch->pitch = 0; 
   ch->note = NO_NOTE;

      /* we don't setup arpeggio values. */
   ch->vib.offset = 0; 
   ch->vib.depth = 0;
   ch->vib.rate = 0;
	ch->vib.table = vibrato_table[0];
	ch->vib.reset = FALSE;

	ch->trem.offset = 0;
	ch->trem.depth = 0;
	ch->trem.rate = 0;
	ch->trem.table = vibrato_table[0];
	ch->trem.reset = FALSE;

   ch->slide = 0; 

   ch->pitchgoal = 0; 
   ch->pitchrate = 0;

   ch->volumerate = 0;

	
	ch->funk_glissando = FALSE;
	ch->start_offset = 0;
   ch->adjust = do_nothing;
		/* initialize loop to no loop, loop start at 0 
		 * (needed for don't you want me, for instance) */
	ch->loop_counter = -1;
	ch->loop_note_num = 0;

   ch->special = do_nothing;
	ch->invert_speed = 0;
	ch->invert_offset = 0;
	ch->invert_position = 0;
   }


LOCAL void init_channels(void)
	{
   release_audio_channels();

	init_channel(chan, LEFT_SIDE);
	init_channel(chan + 1, RIGHT_SIDE);
	init_channel(chan + 2, RIGHT_SIDE);
	init_channel(chan + 3, LEFT_SIDE);
	if (ntracks > 4)
		{
		init_channel(chan + 4, LEFT_SIDE);
		init_channel(chan + 5, RIGHT_SIDE);
		}
	if (ntracks > 6)
		{
		init_channel(chan + 6, RIGHT_SIDE);
		init_channel(chan + 7, LEFT_SIDE);
		}
	}


void init_st_play(void)
   {
   init_effects(eval);
   }


LOCAL void dump_events(struct automaton *a)
	{
		/* display the output in a reasonable order:
		 * LEFT1 LEFT2 || RIGHT1 RIGHT 2
		 */
	dump_event(chan, EVENT(a, 0));
	dump_delimiter();
	dump_event(chan+3, EVENT(a, 3));
	dump_delimiter();
	if (ntracks > 4)
		{
		dump_event(chan+4, EVENT(a, 4));
		dump_delimiter();
		}
	if (ntracks > 7)
		{
		dump_event(chan+7, EVENT(a, 7));
		dump_delimiter();
		}
	dump_delimiter();
	dump_event(chan+1, EVENT(a, 1));
	dump_delimiter();
	dump_event(chan+2, EVENT(a, 2));
	if (ntracks > 5)
		{
		dump_delimiter();
		dump_event(chan+5, EVENT(a, 5));
		}
	if (ntracks > 6)
		{
		dump_delimiter();
		dump_event(chan+6, EVENT(a, 6));
		}
	dump_event(0, 0);
	}

LOCAL void setup_effect(struct channel *ch, 
	struct automaton *a, struct event *e)
   {
   int samp, cmd;
	pitch pitch;

      /* retrieves all the parameters */
   samp = e->sample_number;

      /* load new instrument */
   if (samp)  
      {  /* note that we can change sample in the middle of a note. This 
			 * is a *feature*, not a bug (see made). Precisely: the sample 
			 * change will be taken into account for the next note, BUT the 
			 * volume change takes effect immediately.
          */
      ch->samp = voices[samp];
		ch->finetune = voices[samp]->finetune;
		if ((1L<<samp) & get_pref_scalar(PREF_IMASK))
			ch->samp = empty_sample();
		set_current_volume(ch, voices[samp]->volume);
      }

	pitch = note2pitch(e->note, ch->finetune);

   cmd = e->effect;

   if (pitch >= REAL_MAX_PITCH)
      {
      char buffer[60];

      sprintf(buffer,"Pitch out of bounds %d", pitch);
      status(buffer);
      pitch = 0;
      error = FAULT;
      }

   ch->adjust = do_nothing;

   switch(eval[cmd].type)
		{
	case NOTHING:
		if (pitch)
			{
			set_current_note(ch, e->note, pitch);
			start_note(ch);
			}
		break;
	case CH_E:
		if (pitch)
			set_current_note(ch, e->note, pitch);
		(eval[cmd].f.CH_E)(ch, e);
		if (pitch)
			start_note(ch);
		break;
	case A_E:
		if (pitch)
			set_current_note(ch, e->note, pitch);
		(eval[cmd].f.A_E)(a, e);
		if (pitch)
			start_note(ch);
		break;
	case NO_NOTE_CH_E:
		if (pitch)
			set_current_note(ch, e->note, pitch);
		(eval[cmd].f.CH_E)(ch, e);
		break;
	case PORTA_CH_PITCH_E:
		(eval[cmd].f.CH_PITCH_E)(ch, pitch, e);
		break;
	case CH_A_E:
		if (pitch)
			set_current_note(ch, e->note, pitch);
		(eval[cmd].f.CH_A_E)(ch, a, e);
		if (pitch)
			start_note(ch);
		break;
		}
   }


LOCAL void play_one_tick(struct automaton *a)
   {
   int channel;

   if (a->counter == 0)
      {	/* do new effects only if not in delay mode */
      if (a->delay_counter == 0) 
         {
         for (channel = 0; channel < ntracks; channel++)
            /* setup effects */
            setup_effect(chan + channel, a, EVENT(a, channel));
  			if (get_pref_scalar(PREF_SHOW))
     			dump_events(a);
         }
      }
   else
      for (channel = 0; channel < ntracks; channel++)
			{
         /* do the effects */
   		(chan[channel].special)(chan + channel);
         (chan[channel].adjust)(chan + channel);
			}

	update_tempo(a);
      /* actually output samples */
	if (get_pref_scalar(PREF_OUTPUT))
		resample();
   }

LOCAL struct tag pres[2];

struct tag *play_song(struct song *song, unsigned int start)
   {
   int countup;      /* keep playing the tune or not */
	int r;
	struct automaton *a;

	INIT_ONCE;

   song_title(song->title);
   pres[1].type = TAG_END;
   
	ntracks = song->ntracks;
	set_number_tracks(ntracks);

	countup = 0;

   voices = song->samples; 

   a = setup_automaton(song, start);
	set_bpm(a, get_pref_scalar(PREF_SPEED));

	init_channels();

	set_data_width(song->side_width, song->max_sample_width);

	while(1)
      {
      struct tag *result;
      
      play_one_tick(a);
		next_tick(a);
      result = get_ui();
      while( (result = get_tag(result)) )
         {
         switch(result->type)
            {  
         case UI_LOAD_SONG:
            if (!result->data.pointer)
               break;
         case UI_NEXT_SONG:
         case UI_PREVIOUS_SONG:
            discard_buffer();
            pres[0].type = result->type;
            pres[0].data = result->data;
            return pres;
         case UI_QUIT:
            discard_buffer();
            end_all(0);
            /* NOTREACHED */
         case UI_SET_BPM:
            set_bpm(a, result->data.scalar);
            break;
         case UI_RESTART:
            discard_buffer();
            a = setup_automaton(song, start);
				init_channels();
            break;
         case UI_JUMP_TO_PATTERN:
            if (result->data.scalar >= 0 && 
						result->data.scalar < a->info->length)
               {
               discard_buffer();
               a = setup_automaton(song, result->data.scalar);
               }
            break;
            /*
         case ' ':
            while (may_getchar() == EOF)
               ;
            break;
             */
         default:
            break;
            }
         result++;
         }

      switch(error)
         {
      case NONE:
         break;
      case ENDED:
			countup++;
			if ( (r = get_pref_scalar(PREF_REPEATS)) )
				{
				if (countup >= r)
					{
					pres[0].type = PLAY_ENDED;
					return pres;
					}
				}
         break;
      case SAMPLE_FAULT:
      case FAULT:
      case PREVIOUS_SONG:
      case NEXT_SONG:
      case UNRECOVERABLE:
         if ( (error == SAMPLE_FAULT && get_pref_scalar(PREF_TOLERATE))
            ||(error == FAULT && get_pref_scalar(PREF_TOLERATE) > 1) )
            break;
         pres[0].type = PLAY_ERROR;
         pres[0].data.scalar = error;
         return pres;
      default:
         break;
         }
		error = NONE;
      }
   }

