sub bencode {
	my ($item) = @_;
	return 'd'.join('', map { bencode($_).bencode(${$item}{$_}) } sort keys %{$item}).'e'
		if (ref $item eq 'HASH');
	return 'l'.join('', map { bencode($_) } @{$item}).'e' if (ref $item eq 'ARRAY');
	return 'i'.$item.'e' if ($item =~ /^(0|-?[1-9][0-9]*)$/);
	return length($item).':'.$item;
}

sub bdecode {
	my ($data) = @_;
	my @queue = ([]);
	for (my $c = 0; $c < length $data; $c++) {
		my $ch = substr($data, $c, 1);
		my ($value, $e);

		if ($ch eq 'e') {
			if (ref $queue[0] eq 'HASH') {
				die "value for key missing\n" if defined ${$queue[0]}{'KEY'};
				%{$queue[0]} = %{${$queue[0]}{'HASH'}};
			}
			shift @queue;
			next;
		} elsif ($ch eq 'i') {
			for ($e = $c+1; substr($data, $e, 1) ne 'e'; $e++) {}
			$value = substr($data, $c+1, $e-$c-1);
			$c = $e;
		} elsif ($ch ge '0' && $ch le '9') {
			for ($e = $c+1; substr($data, $e, 1) ne ':'; $e++) {}
			my $len = int(substr($data, $c, $e-$c));
			$value = substr($data, $e+1, $len);
			$c = $e + $len;
		} elsif ($ch eq 'l') {
			$value = [];
		} elsif ($ch eq 'd') {
			$value = { 'HASH'=>{}, 'KEY'=>undef };
		}

		if (ref $queue[0] eq 'ARRAY') {
			push @{$queue[0]}, $value;
		} else {
			my $key = ${$queue[0]}{'KEY'};
			if (defined $key) {
				${${$queue[0]}{'HASH'}}{$key} = $value;
				${$queue[0]}{'KEY'} = undef;
			} else {
				die "bad key type\n" if $ch lt '0' || $ch gt '9';
				${$queue[0]}{'KEY'} = $value;
			}
		}

		unshift @queue, $value if $ch eq 'l' || $ch eq 'd';
	}
	return ${$queue[0]}[0];
}
