#!/bin/sh

########################################################################
#
#  Convert an rtf document to PostScript format using 'Ted'.
#
#  Usage	rtf2ps.sh --paper paper something.rtf something.ps
#  Or		rtf2ps.sh something.rtf something.ps
#
#  Valid values for paper are a4, a5, a6, letter, legal and executive
#
#  This is an example. Refer to http://www.nllgg.nl/Ted/index.html for the
#  'Ted' documentation.
#
#  If you want 'Ted' to set configurable resources, use
#  Ted  --printToFilePaper --setProperty ... in the Ted way. E.G:
#  Ted  --setProperty usePostScriptFilters 1 \
#	--setProperty usePostScriptIndexedImages 1  \
#	--setProperty afmDirectory /usr/share/ghostscript/fonts  \
#	--setProperty fontDirectory /usr/share/ghostscript/fonts  \
#	--setProperty ghostscriptFontmap \
#				/usr/share/ghostscript/6.53/lib/Fontmap \
#	--setProperty ghostscriptFontToXmapping \
#				/usr/share/ghostscript/6.53/lib/fonts.dir \
#	--printToFilePaper .....
#  The settings can also be stored in /usr/share/Ted/Ted.properties or in 
#  $(HOME)/.Ted.properties files. Refer to the Ted documentation for 
#  more details.
#
#  This script uses the --printToFile invocation rather than the --saveTo 
#  invocation to use an explicit paper size or the default one of the machine.
#  Ted --saveTo this.rtf that.ps produces a PostScript file with the paper size 
#  of the rtf input document.
#
########################################################################

PAPER=

case $# in
    1|2)
	;;
    3|4)
	case $1 in
	    --paper)
		;;
	    *)
		echo $0: '$1='$1 'Expected --paper'
		exit 1
		;;
	esac

	case $2 in
	    a4|a5|a6|letter|legal|executive)
		PAPER=$2
		;;
	    *)
		echo $0: '$2='$2 'Expected a4|a5|a6|letter|legal|executive'
		exit 1
		;;
	esac
	shift; shift;
	;;
    *)
	echo $0: '$#='$#
	exit 1
	;;
esac

case $# in
    1)
	rtf="$1";
	ps=`basename "$1" .rtf`.ps
	;;
    2)
	rtf="$1";
	ps="$2";
	;;
    *)
	echo $0: '$#='$#
	exit 1
	;;
esac

case $PAPER in
    ?*)
	Ted --printToFilePaper "$rtf" "$ps" $PAPER
	;;
    *)
	Ted --printToFile "$rtf" "$ps"
	;;
esac

