/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"

#ifndef struct_h
#define struct_h

typedef struct {
    unsigned char m_width, m_height;
    char m_name[34];
}

mapinfo;

/* PDEAD is dead but connected.  PEMPTY is an empty slot. */
enum player_status {
    PDEAD, PALIVE, PEMPTY, POUTFIT
};

#define PFHIDDEN 1

/* One player struct for every player in the game */
typedef struct {
    int p_num;                  /* this player's # */
    char p_char;                /* The letter used for this player on the player list and in messages */
    int p_x, p_y;               /* real coords */
    unsigned char p_dir;        /* heading */
    int p_status;               /* alive, dead, empty slot, etc */
    int p_flags;                /* misc. flags (eg hidden by trees) */
    int p_speed;                /* speed */
    int p_keys, p_turnok;       /* obsolete */
    int p_expfuse;              /* When this player dies, how long to keep drawing the explosion */
    char p_name[16];            /* his name */
    char p_login[16];           /* his login */
    int p_desspeed;             /* How fast he _wants_ to be going */
    unsigned char p_desdir;     /* what direction he wants to be going */
    long p_updateplayers;       /* flags for which players need to be updated to this player */
    unsigned int p_wins, p_losses, p_kills;     /* various statistics */
    int p_team;                 /* what team he's on */
    int p_carryflag;            /* is he carrying a flag? */
    char p_host[32];            /* the FQDN of his machine */
    int p_damage;               /* how hurt is his tank? */
    int p_ammo;                 /* how many shells he has left */
    int p_fuel;                 /* how much fuel */
    int p_mines;                /* how many mines */
    int p_trees;                /* how many trees */
}

player;

enum shell_status {
    SDEAD, SALIVE, SEXPLODE
};

typedef struct {
    int s_num;                  /* this shell's number */
    int s_owner;                /* who fired it */
    int s_x, s_y;               /* real coords */
    unsigned char s_dir;        /* heading */
    int s_status;               /* active, exploding, or ready to be fired */
    int s_fuse;                 /* how much longer before it fizzles out */
}

shell;

typedef struct {
    int b_num;                  /* the base's number */
    int b_team;                 /* which team this base belongs to */
    int b_x, b_y;               /* coords */
    int b_numflags;             /* How many flags have been brought back to this base */
}

base;

typedef struct {
    int f_num;                  /* this flag's number */
    int f_team;                 /* which team owns this flag */
    int f_x, f_y;               /* coords */
    int f_carrier;              /* who is carrying this flag? */
    int f_moved;                /* has this flag moved since the last update? */
}

flag;

#define MIEMPTY 0
#define MILIVE 1
#define MIEXPLODE 2
typedef struct {
    int mi_num;                 /* this mine's number */
    int mi_status;              /* not active, live, or exploding */
    int mi_fuse;                /* how long to keep drawing the explosion */
    int mi_x, mi_y;             /* coords */
    int mi_owner;               /* who laid this mine? */
    int mi_updated;             /* who has been updated as to this mine's status/location */
}

mine;

#endif
