/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "Wlib.h"
#include "data.h"
#include "defs.h"

#define OPT_HEADER 0
#define OPT_BOOL 1
#define OPT_INT 2
#define OPT_STRING 3
#define OPT_ACTION 4

struct opt_entry {
    char *text;
    int type;
    void *var;
    W_Color *color;
};

int notdone, saveSettings=1;

char newkeymap[40];

struct opt_entry opts[] = {
    {"Options", OPT_HEADER, 0, &W_Yellow},
    {"show names on tanks", OPT_BOOL, &namesOnTanks, &W_White},
    {"use split message windows", OPT_BOOL, &splitWindows, &W_White},
    {"show build marker", OPT_BOOL, &showBuildMarker, &W_White},
    {"Add to keymap", OPT_STRING, newkeymap, &W_White},
    {"Save settings", OPT_ACTION, &saveSettings, &W_Red},
    {"Done", OPT_ACTION, &notdone, &W_Yellow},
};

#define NUM_OPTS (sizeof(opts)/sizeof(struct opt_entry))

void redraw_option_line(int i)
{
    char buf[60];
    
    switch(opts[i].type) {
      case OPT_BOOL:
	if(*((int *)opts[i].var)) {
	    strcpy(buf, opts[i].text);
	    buf[0] = toupper(buf[0]);
	} else {
	    sprintf(buf, "Don't %s", opts[i].text);
	}
	W_WriteText(optionwin, 0, i, *opts[i].color, buf, strlen(buf), W_RegularFont);
	break;
      case OPT_STRING:
	sprintf(buf, "%s:%s_", opts[i].text, ((char *)opts[i].var));
	W_WriteText(optionwin, 0, i, *opts[i].color, buf, strlen(buf), W_RegularFont);
	break;
      case OPT_HEADER:
      case OPT_ACTION:
      default:
	W_WriteText(optionwin, 0, i, *opts[i].color, opts[i].text, strlen(opts[i].text), W_RegularFont);
	break;
    }
}

void redraw_option_win()
{
    int i;

    for(i=0;i<NUM_OPTS;i++) {
	redraw_option_line(i);
    }
}

void map_option_win()
{
    if(W_IsMapped(optionwin)) {
	W_DestroyWindow(optionwin);
	optionwin = 0;
    } else {
	notdone = 1;
	newkeymap[0] = 0;
	optionwin = W_MakeMenu("option", WINWIDTH, 0, 40, NUM_OPTS, baseWin, 1);
	W_Buffer(optionwin, 0);
	redraw_option_win();
	W_MapWindow(optionwin);
    }
}

void check_variable(void *var)
{
    if(var == (void *)&splitWindows) {
	if(splitWindows) {
	    W_UnmapWindow(messwin[MW_JOINED]);
	    W_UnmapWindow(typewin);
	    W_MapWindow(messwin[MW_ALL]);
	    W_MapWindow(messwin[MW_TEAM]);
	    W_MapWindow(messwin[MW_INDIV]);
	    W_MapWindow(typewin);
	} else {
	    W_UnmapWindow(typewin);
	    W_MapWindow(messwin[MW_JOINED]);
	    W_MapWindow(typewin);
	    W_UnmapWindow(messwin[MW_INDIV]);
	    W_UnmapWindow(messwin[MW_ALL]);
	    W_UnmapWindow(messwin[MW_TEAM]);
	}
    } if(var == (void *)&saveSettings) {
	char *expname;
	if(strlen(newkeymap) > 1) {
	    add_keymap(newkeymap);
	    newkeymap[0] = 0;
	    redraw_option_win();
	}
	saveSettings = 1;
	expname = expand_filename("~/.tankedrc");
	write_defaults(expname);
    } if(var == (void *)newkeymap) {
	add_keymap(newkeymap);
	newkeymap[0] = 0;
    }
}

void option_event(W_Event *ev)
{
    if(ev->type == W_EV_BUTTON) {
	if((opts[ev->y].type == OPT_BOOL || opts[ev->y].type == OPT_ACTION) && opts[ev->y].var) {
	    *((int *)opts[ev->y].var) = !(*((int *)opts[ev->y].var));
	    check_variable(opts[ev->y].var);
	    redraw_option_line(ev->y);
	    if(!notdone) {
		if(strlen(newkeymap) > 1) {
		    add_keymap(newkeymap);
		    newkeymap[0] = 0;
		}
		if(W_IsMapped(optionwin)) {
		    W_DestroyWindow(optionwin);
		    optionwin = 0;
		}
	    }
	}
    } else if(ev->type == W_EV_KEY) {
	if(opts[ev->y].type == OPT_STRING) {
	    char *var = ((char *)opts[ev->y].var);
	    switch(ev->key) {
	      case 10:
	      case 13:
		check_variable(opts[ev->y].var);
		redraw_option_line(ev->y);
		break;
	      case 8:
	      case 127:
		if(strlen(var) > 0) {
		    var[strlen(var)-1] = 0;
		    redraw_option_line(ev->y);
		}
		break;
	      default:
		if(strlen(var) < 30) {
		    var[strlen(var)+1] = 0;
		    var[strlen(var)] = ev->key;
		    redraw_option_line(ev->y);
		}
		break;
	    }
	}
    }
}

