/* Copyright (C), 2007 by Stephen Hurd */

/* $Id: syncterm.c,v 1.261 2020/06/27 00:04:50 deuce Exp $ */

#if defined(__APPLE__) && defined(__MACH__)
 #include "DarwinWrappers.h"
#endif

#if defined(__HAIKU__)
 #include <FindDirectory.h>
 #include <fs_info.h>
#endif

#define NOCRYPT                         /* Stop windows.h from loading wincrypt.h */
/* Is windows.h REALLY necessary?!?! */
#define __WINCRYPT_H__                  /* Really REALLY stop wincrypt.h har har
                                         * This is to workaround an issue in MinGW-w64 headers where
                                         * shlobj.h (which we need to include) unconditionally
                                         * includes wincrypt.h (which we need to not be included).
                                         */
#define WIN32_LEAN_AND_MEAN
#include <sys/stat.h>
#ifdef _WIN32
 #include <shlobj.h>
 #ifndef REFKNOWNFOLDERID
typedef GUID KNOWNFOLDERID;
  #define REFKNOWNFOLDERID const KNOWNFOLDERID *

// Not shared
static const KNOWNFOLDERID FOLDERID_Downloads = {
	0x374DE290, 0x123F, 0x4565, {0x91, 0x64, 0x39, 0xC4, 0x92, 0x5E, 0x46, 0x7B}
};
static const KNOWNFOLDERID FOLDERID_RoamingAppData = {
	0x3EB685DB, 0x65F9, 0x4CF6, {0xA0, 0x3A, 0xE3, 0xEF, 0x65, 0x72, 0x9F, 0x3D}
};
static const KNOWNFOLDERID FOLDERID_InternetCache = {
	0x352481E8, 0x33BE, 0x4251, {0xBA, 0x85, 0x60, 0x07, 0xCA, 0xED, 0xCF, 0x9D}
};

// Shared
static const KNOWNFOLDERID FOLDERID_PublicDownloads = {
	0x3D644C9B, 0x1FB8, 0x4f30, {0x9B, 0x45, 0xF6, 0x70, 0x23, 0x5F, 0x79, 0xC0}
};
static const KNOWNFOLDERID FOLDERID_ProgramData = {
	0x62AB5D82, 0xFDC1, 0x4DC3, {0xA9, 0xDD, 0x07, 0x0D, 0x1D, 0x49, 0x5D, 0x97}
};
 #endif /* ifndef REFKNOWNFOLDERID */
 #ifndef KF_FLAG_CREATE
  #define KF_FLAG_CREATE 0x00008000
 #endif
 #include <xp_dl.h> /* xp_dlopen() and friends */
#endif /* ifdef _WIN32 */

#include <ciolib.h>
#include <cterm.h>
#include <dirwrap.h>
#include <filewrap.h> // STDOUT_FILENO
#include <gen_defs.h>
#include <ini_file.h>
#include <stdbool.h>
#include <stdlib.h>
#include <vidmodes.h>
#if !(defined __BORLANDC__ || defined _MSC_VER)
 #include <stdbool.h>
#else
#ifndef bool
 #define bool int
#endif
#if !(defined false && defined true)
enum {
	false,
	true
};
#endif

#endif

#include "bbslist.h"
#include "conn.h"
#ifndef WITHOUT_CRYPTLIB
#include "cryptlib.h"
#include "ssh.h"
#endif
#include "fonts.h"
#include "syncterm.h"
#include "term.h"
#include "uifcinit.h"
#include "window.h"
#include "xpbeep.h"

#if defined(__unix__) && defined(SOUNDCARD_H_IN) && (SOUNDCARD_H_IN > 0) && !defined(_WIN32)
	#if SOUNDCARD_H_IN==1
		#include <sys/soundcard.h>
	#elif SOUNDCARD_H_IN==2
		#include <soundcard.h>
	#elif SOUNDCARD_H_IN==3
		#include <linux/soundcard.h>
	#else
		#ifndef USE_ALSA_SOUND
			#warning Cannot find soundcard.h
		#endif
	#endif
#endif

const char *syncterm_version = "SyncTERM 1.6"

#define ALPHA
#ifdef _DEBUG
    " Debug ("__DATE__ ")"
#endif
;

char *usage =
    "\nusage: syncterm [options] [URL]"
    "\n\noptions:\n\n"
    "-4  =  Only resolve IPv4 addresses\n"
    "-6  =  Only resolve IPv6 addresses\n"
    "-b/path/to/list = specify user BBS list path\n"
    "-c  =  Hide the status line\n"
    "-e# =  set escape delay to #msec\n"
    "-h  =  use SSH mode if URL does not include the scheme\n"
    "-iX =  set interface mode to X (default=auto) where X is one of:\n"
    "       A = ANSI mode\n"
#ifdef __unix__
    "       C = Curses mode\n"
    "       F = Curses mode with forced IBM charset\n"
    "       I = Curses mode with forced ASCII charset\n"
    "       S[W|F] = SDL surface mode W for windowed and F for fullscreen\n"
    "       X[W|F] = X11 mode W for windowed and F for fullscreen\n"
#else
    "       G[W|F] = Win32 GDI (graphics) mode W for windowed and F for fullscreen\n"
    "       S[W|F] = SDL surface mode W for windowed and F for fullscreen\n"
    "       W = Win32 console (text) mode\n"
#endif
    "-l# =  set screen lines to # (default=auto-detect)\n"
    "-n/path/to/ini = specify a config ini path\n"
    "-q  =  Quiet mode (Hide various popups such as this during a connect)\n"
    "-r  =  use rlogin mode if URL does not include the scheme\n"
    "-s  =  enable \"Safe Mode\" which prevents writing/browsing local files\n"
    "-T  =  when the ONLY argument, dumps the terminfo entry to stdout and exits\n"
    "-t  =  use telnet mode if URL does not include the scheme\n"
    "-v  =  when the ONLY argument, dumps the version info to stdout and exits\n"
    "\n"
    "URL format is: [(rlogin|telnet|ssh|raw)://][user[:password]@]domainname[:port]\n"
    "raw:// URLs MUST include a port.\n"
    "shell:command URLs are supported on *nix.\n"
    "examples: rlogin://deuce:password@nix.synchro.net:5885\n"
    "          telnet://deuce@nix.synchro.net\n"
    "          nix.synchro.net\n"
    "          telnet://nix.synchro.net\n"
    "          raw://nix.synchro.net:23\n"
    "          shell:/usr/bin/sh\n"
;

char                    *inpath = NULL;
int                      default_font = 0;
struct syncterm_settings settings;
char                    *font_names[sizeof(conio_fontdata) / sizeof(struct conio_font_data_struct)];
struct vmem_cell        *scrollback_buf = NULL;
unsigned int             scrollback_lines = 0;
unsigned int             scrollback_mode = C80;
unsigned int             scrollback_cols = 80;
int                      safe_mode = 0;
FILE                    *log_fp;
extern ini_style_t       ini_style;
bool                     quitting = false;
int                      fake_mode = -1;
char                    *config_override;
char                    *list_override;

#ifdef _WINSOCKAPI_

static WSADATA WSAData;
 #define SOCKLIB_DESC WSAData.szDescription
static bool    WSAInitialized = false;

static bool
winsock_startup(void)
{
	int status; /* Status Code */

	if ((status = WSAStartup(MAKEWORD(1, 1), &WSAData)) == 0) {
		fprintf(stderr, "%s %s", WSAData.szDescription, WSAData.szSystemStatus);
		WSAInitialized = true;
		return true;
	}

	fprintf(stderr, "!WinSock startup ERROR %d", status);
	return false;
}

#else /* No WINSOCK */

 #define winsock_startup() (true)
 #define SOCKLIB_DESC NULL

#endif /* ifdef _WINSOCKAPI_ */

/* GIMP RGBA C-Source image dump (syncterm-icon_small.c) */

static const struct {
  unsigned int 	 width;
  unsigned int 	 height;
  unsigned int 	 bytes_per_pixel; /* 2:RGB16, 3:RGB, 4:RGBA */ 
  unsigned char	 pixel_data[64 * 64 * 4 + 1];
} syncterm_icon = {
  64, 64, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\013\000\000\000\036\000\000\000\061\000\000\000A\000\000\000N\000\000\000Y\000\000\000c\000\000\000n\000"
  "\000\000u\000\000\000w\000\000\000y\000\000\000\200\000\000\000\200\000\000\000y\000\000\000w\000\000\000u\000\000\000n\000\000\000"
  "c\000\000\000Y\000\000\000N\000\000\000A\000\000\000\060\000\000\000\036\000\000\000\013\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\000\000\000)\000\000\000D\000\000\000^\000"
  "\000\000x\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200"
  "\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000"
  "\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000"
  "\000\200\000\000\000\200\000\000\000\200\000\000\000x\000\000\000^\000\000\000C\000\000\000)\000\000\000\015\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005\000\000\000%\000\000"
  "\000H\000\000\000j\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\213\000"
  "\000\000\234\000\000\000\256\000\000\000\300\000\000\000\316\000\000\000\330\000\000\000\342\000\000\000\355\000\000"
  "\000\365\000\000\000\367\000\000\000\371\000\000\000\377\000\000\000\377\000\000\000\371\000\000\000\367\000\000\000"
  "\365\000\000\000\354\000\000\000\342\000\000\000\330\000\000\000\316\000\000\000\300\000\000\000\256\000\000\000\234"
  "\000\000\000\212\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000j\000\000\000"
  "G\000\000\000$\000\000\000\005\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\000\000\000\"\000\000\000Q\000\000\000y\000\000\000\200\000\000\000\200"
  "\000\000\000\200\000\000\000\210\000\000\000\247\000\000\000\301\000\000\000\333\000\000\000\364\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\364\000\000\000\332\000\000\000\301\000\000\000\247\000\000\000\210\000\000\000\200\000"
  "\000\000\200\000\000\000\200\000\000\000{\000\000\000U\000\000\000'\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\017\000\000\000C\000\000\000u\000\000\000\200\000\000\000\200\000\000\000\201\000\000\000"
  "\237\000\000\000\304\000\000\000\345\000\000\000\376\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\376"
  "\000\000\000\345\000\000\000\304\000\000\000\237\000\000\000\201\000\000\000\200\000\000\000\200\000\000\000u\000\000\000"
  "C\000\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\030\000\000\000V\000\000\000~\000\000\000\200\000\000\000\200\000\000\000\236\000"
  "\000\000\312\000\000\000\363\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\363\000\000\000"
  "\311\000\000\000\235\000\000\000\200\000\000\000\200\000\000\000~\000\000\000U\000\000\000\027\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\000\000M\000\000\000~\000\000\000\200\000\000\000\206"
  "\000\000\000\263\000\000\000\350\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\303\377\000\000\377\377\000"
  "\000\303\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\353\000\000\000\273"
  "\000\000\000\210\000\000\000\200\000\000\000\177\000\000\000U\000\000\000\023\000\000\000\000\000\000\000\000\000\000\000\005\000"
  "\000\000@\000\000\000}\000\000\000\200\000\000\000\206\000\000\000\273\000\000\000\367\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\003\003\003\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\303\377\000\000\377\377\000\000\303\377\000\000\000\377"
  "\000\000\304\377\000\000\375\377\000\000\356\377\000\000\323\377\000\000\253\377\000\000l\377\000\000"
  "\032\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\371\000"
  "\000\000\304\000\000\000\210\000\000\000\200\000\000\000~\000\000\000I\000\000\000\006\000\000\000o\000\000\000\200\000\000\000"
  "\203\000\000\000\275\000\000\000\370\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\011\011\011\377\070\070\070\377ccc\377"
  "\206\206\206\377\253\253\253\377\304\304\304\377'''\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000I\377\000\000\203\377\000\000\306\377\000\000\377\377\000\000\377\377\000\000\377\377\000\000\373"
  "\377\000\000\230\377\000\000\022\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\026\377\000\000"
  "\021\377\000\000\000\377\000\000\000\377\000\000\032\377\000\000\265\377\000\000\354\377\000\000\304\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\367\000\000\000\275\000\000\000\203\000\000\000\200\000\000\000o\000\000\000\200"
  "\000\000\000\241\000\000\000\353\000\000\000\377\000\000\000\377\000\000\021\377\000\000r\377\000\000L\377\000\000"
  "\005\377\000\000\000\377\010\010\010\377BBB\377zzz\377\255\255\255\377\331\331\331\377"
  "\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377nnn\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\034\377\000\000\067\377\000\000\005\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000-\377\000\000\321"
  "\377\000\000\377\377\000\000\376\377\000\000\270\377\000\000\040\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\017\377\000\000,\377\000\000\000\377\000\000\205\377\000\000\377\377"
  "\000\000\377\377\000\000\267\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\062\377\000\000[\377"
  "\000\000\213\377\000\000\262\377\000\001r\377\000\000\023\377\000\000\000\377\000\000\000\377\000\000\000\355"
  "\000\000\000\244\000\000\000\200\000\000\000\315\000\000\000\377\000\000\000\377\000\000\000\377\000\000\011\377\000"
  "\000\235\377\000\000\017\377\000\000\000\377\065\065\065\377\220\220\220\377\322\322\322"
  "\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\332\332\332\377\023\023\023\377"
  "\000\000\000\377\000\000\000\377\000\000.\377\000\000\265\377\000\000h\377\000\000\000\377\000\000\000\377\064"
  "\064\064\377mmm\377\203\203\203\377|||\377RRR\377\014\014\014\377\000\000\000\377\000"
  "\000\037\377\000\000\377\377\000\000Z\377\000\000\002\377\000\000\000\377\034\034\034\377fff\377tt"
  "t\377:::\377\000\000\000\377\000\000\004\377\000\000\000\377\000\000o\377\000\000\366\377\000\000a\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\002#\377\000\016\324\377\000\023\347\377\000\006C\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\313\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000^\377\000\000*\377\022\022"
  "\022\377\232\232\232\377\334\334\334\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334"
  "\377\334\334\334\377\334\334\334\377\271\271\271\377\000\000\000\377\000\000\004\377"
  "\000\000\216\377\000\000\373\377\000\000\323\377\000\000\000\377\006\006\006\377\232\232\232\377"
  "\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334"
  "\334\377\242\242\242\377\000\000\000\377\000\000\007\377\000\000\274\377\000\000\002\377\000\000\000"
  "\377^^^\377\327\327\327\377\334\334\334\377\334\334\334\377\334\334\334\377"
  "XXX\377\000\000\000\377\000\000\000\377\000\000;\377\000\000*\377\000\000\000\377\000\000\000\377)))\377"
  "vvv\377\234\234\234\377\227\227\227\377vvv\377\037\037\037\377\000\000\000\377\000\003"
  "\025\377\000\"\360\377\000\"\333\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000n\377\000\000\000\377ooo\377\276\276"
  "\276\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377"
  "\311\311\311\377\266\266\266\377\266\266\266\377\331\331\331\377\334\334"
  "\334\377\334\334\334\377\263\263\263\377\000\000\000\377\000\000r\377\000\000\377\377\000"
  "\000\373\377\000\000R\377\000\000\000\377OOO\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\333\333\333\377\063\063\063\377"
  "\000\000\000\377\000\000^\377\000\000\040\377\000\000\000\377[[[\377\334\334\334\377\334\334\334"
  "\377\334\334\334\377\334\334\334\377\334\334\334\377\304\304\304\377\001\001"
  "\001\377\000\000\003\377\000\000\014\377\000\000\000\377\033\033\033\377\230\230\230\377\333\333"
  "\333\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377"
  "\321\321\321\377###\377\000\000\000\377\000\035\212\377\000,\313\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000!\377\000\000\236\377\000\000\260"
  "\377\000\000\000\377\224\224\224\377\276\276\276\377\337\337\337\377\336\336\336"
  "\377\335\335\335\377\264\264\264\377GGG\377VVV\377\355\355\355\377\314\314"
  "\314\377\323\323\323\377\334\334\334\377\320\320\320\377\010\010\010\377\000\000"
  "H\377\000\000\332\377\000\000*\377\000\000\010\377\000\000\000\377ccc\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\247\247\247"
  "\377\000\000\000\377\000\000\015\377\000\000\062\377\000\000\000\377\037\037\037\377\326\326\326\377"
  "\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334"
  "\334\377\334\334\334\377\024\024\024\377\000\000\000\377\000\000\000\377BBB\377\317\317"
  "\317\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377"
  "\334\334\334\377\334\334\334\377\334\334\334\377\211\211\211\377\000\000\000\377"
  "\000\021>\377\000\035f\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\007\377\000\000\336\377\000\000\377\377\000\000\274\377\000\000\000\377\234\234\234\377\271"
  "\271\271\377\346\346\346\377\345\345\345\377\345\345\345\377\340\340\340"
  "\377SSS\377\000\000\000\377<<<\377\373\373\373\377\321\321\321\377\326\326\333"
  "\377\337\337\337\377RRR\377\000\000\000\377\000\000X\377\000\000\026\377\000\000\000\377\000\000\000"
  "\377aaa\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377"
  "\334\334\334\377___\377\000\000\000\377\000\000g\377\000\000\061\377\000\000\000\377\205\205\205"
  "\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\032\032\032\377\000\000\000\377III\377"
  "\331\331\331\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334"
  "\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377"
  "\267\267\267\377\000\000\000\377\000\007\025\377\000\001\003\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000+\377\000\000\377\377\000\000\341\377\000\000$\377\000\000\000"
  "\377\210\210\210\377\341\341\341\377\344\344\344\377\355\355\355\377\354"
  "\354\354\377\353\353\353\377\350\350\350\377ccc\377\000\000\000\377ddd\377\375"
  "\375\375\377\301\301\301\377~~~\377RRR\377\003\003\003\377\000\000\000\377\000\000\000\377"
  "\031\031\031\377\000\000\000\377___\377\340\340\340\377\340\340\340\377\337\337\337"
  "\377\336\336\336\377\335\335\335\377\035\035\035\377\000\000\000\377\000\000\231\377\000"
  "\000\025\377\000\000\000\377\271\271\271\377\334\334\334\377\334\334\334\377\334\334"
  "\334\377\334\334\334\377\334\334\334\377\334\334\334\377\326\326\326\377"
  "\005\005\005\377\"\"\"\377\323\323\323\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334"
  "\377\334\334\334\377\334\334\334\377\300\300\300\377\000\000\000\377\000\001\004\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\012\377\000"
  "\000\365\377\000\000\375\377\000\000\066\377\000\000\000\377FFF\377\377\377\377\377\311\311"
  "\311\377\352\352\352\377\363\363\363\377\362\362\362\377\362\362\362\377"
  "\361\361\361\377ttt\377\000\000\000\377!!!\377\002\002\002\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\033\033\033\377yyy\377yyy\377\000\000\000\377```\377\350\350\350\377\347"
  "\347\347\377\346\346\346\377\345\345\345\377\321\321\321\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\001\377\000\000\000\377GGG\377GGG\377\214\214\214\377\336"
  "\336\336\377\336\336\336\377\335\335\335\377\334\334\334\377\257\257\257"
  "\377\000\000\000\377\235\235\235\377\334\334\334\377\334\334\334\377\334\334\334"
  "\377\334\334\334\377\334\334\334\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377\334\334\334\377\253\253\253\377\000\000\000\377\000"
  "\014\033\377\000c\320\377\000l\337\377\000D\213\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\201\377\000\000\377\377\000\000\344\377\000\000\015\377\000\000\000\377\233\233"
  "\233\377\377\377\377\377\342\342\342\377\311\311\311\377\372\372\372\377"
  "\371\371\371\377\370\370\370\377\367\367\367\377\214\214\214\377\000\000\000\377"
  "\000\000\000\377\071\071\071\377yyy\377\264\264\264\377\357\357\357\377\362\362\362"
  "\377III\377\000\000\000\377aaa\377\357\357\357\377\356\356\356\377\355\355\355"
  "\377\355\355\355\377\307\307\307\377\235\235\235\377SSS\377\006\006\006\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\023\023\023\377\344\344\344\377\345\345"
  "\345\377\344\344\344\377\343\343\343\377\201\201\201\377\037\037\037\377\340"
  "\340\340\377\340\340\340\377\340\340\340\377\337\337\337\377\336\336\336"
  "\377\336\336\336\377\335\335\335\377\334\334\334\377\334\334\334\377\334"
  "\334\334\377\334\334\334\377xxx\377\000\000\000\377\000*P\377\000\205\364\377\000\207"
  "\364\377\000\207\364\377\000\011\021\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\007\377"
  "\000\000\303\377\000\000\377\377\000\000\315\377\000\000\022\377\000\000\000\377WWW\377\324\324"
  "\324\377\377\377\377\377\316\316\316\377\320\320\320\377\377\377\377\377"
  "\377\377\377\377\376\376\376\377###\377\000\000\000\377\234\234\234\377\373\373"
  "\373\377\372\372\372\377\372\372\372\377\371\371\371\377///\377\000\000\000\377"
  "lll\377\366\366\366\377\365\365\365\377\365\365\365\377\364\364\364\377\207"
  "\207\207\377\341\341\341\377\362\362\362\377\332\332\332\377qqq\377\010\010"
  "\010\377\000\000\000\377\000\000\000\377\000\000\000\377\313\313\313\377\354\354\354\377\353"
  "\353\353\377\353\353\353\377TTT\377PPP\377\350\350\350\377\350\350\350\377"
  "\347\347\347\377\346\346\346\377\346\346\346\377\306\306\306\377\304\304"
  "\304\377\343\343\343\377\343\343\343\377\342\342\342\377\327\327\327\377"
  "\063\063\063\377\000\000\000\377\000W\223\377\000\225\363\377\000\227\363\377\000v\276\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\064\377\000\000\340\377\000\000\344\377\000\000\376"
  "\377\000\000\377\377\000\005\356\377\000\004O\377\000\000\001\377\000\000\000\377\066\066\066\377\214"
  "\214\214\377\337\337\337\377\305\305\305\377\352\352\352\377\365\365\365"
  "\377\225\225\225\377\000\000\000\377NNN\377\372\372\372\377\373\373\373\377\374"
  "\374\374\377\375\375\375\377,,,\377\000\000\000\377xxx\377\375\375\375\377\374"
  "\374\374\377\374\374\374\377\373\373\373\377aaa\377\270\270\270\377\371\371"
  "\371\377\370\370\370\377\367\367\367\377\326\326\326\377@@@\377\000\000\000\377"
  "\000\000\000\377\240\240\240\377\363\363\363\377\362\362\362\377\362\362\362\377"
  "\071\071\071\377kkk\377\360\360\360\377\357\357\357\377\356\356\356\377\355"
  "\355\355\377\314\314\314\377\011\011\011\377ggg\377\315\315\315\377\352\352"
  "\352\377\351\351\351\377\260\260\260\377\001\001\001\377\000\002\004\377\000\223\337\377"
  "\000\244\361\377\000~\266\377\000\022\032\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\254"
  "\377\000\000\377\377\000\000\377\377\000\000\357\377\000\002X\377\000\011\207\377\000\006\067\377"
  "\000\000\003\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377===\377\236\236\236\377"
  "\352\352\352\377\323\323\323\377\000\000\000\377\016\016\016\377\361\361\361\377\360"
  "\360\360\377\361\361\361\377\362\362\362\377GGG\377\000\000\000\377|||\377\367"
  "\367\367\377\370\370\370\377\371\371\371\377\372\372\372\377===\377\234\234"
  "\234\377\375\375\375\377\376\376\376\377\377\377\377\377\376\376\376\377"
  "\372\372\372\377rrr\377\000\000\000\377\215\215\215\377\372\372\372\377\372\372"
  "\372\377\371\371\371\377\061\061\061\377]]]\377\367\367\367\377\366\366\366"
  "\377\365\365\365\377\365\365\365\377\206\206\206\377\000\000\000\377\026\026\026\377"
  "\341\341\341\377\320\320\320\377\326\326\326\377\262\262\262\377\000\000\000\377"
  "\000\003\005\377\000y\250\377\000\263\360\377\000\267\360\377\000\267\360\377\000\212\270"
  "\377\000\000\000\377\000\000\000\377\000\000\307\377\000\000\377\377\000\000\370\377\000\007\376\377"
  "\000\007\\\377\000\000\000\377\015\015\015\377III\377[[[\377CCC\377\015\015\015\377\000\000\000"
  "\377\000\000\000\377\027\027\027\377\336\336\336\377\340\340\340\377\011\011\011\377"
  "\000\000\000\377\350\350\350\377\344\344\344\377\346\346\346\377\347\347\347\377"
  "\220\220\220\377\000\000\000\377\177\177\177\377\353\353\353\377\354\354\354\377"
  "\355\355\355\377\357\357\357\377\030\030\030\377\237\237\237\377\362\362\362"
  "\377\363\363\363\377\364\364\364\377\365\365\365\377\366\366\366\377\370"
  "\370\370\377ttt\377yyy\377\373\373\373\377\374\374\374\377\375\375\375\377"
  "\063\063\063\377HHH\377\325\325\325\377\375\375\375\377\375\375\375\377\374"
  "\374\374\377\212\212\212\377\000\000\000\377\000\000\000\377\\\\\\\377\361\361\361\377"
  "\357\357\357\377\364\364\364\377^^^\377\000\000\000\377\000\002\002\377\000Sf\377\000\307"
  "\357\377\000\307\357\377\000\225\270\377\000\000\000\377\000\000\000\377\000\000\246\377\000\000"
  "\377\377\000\005\352\377\000\014\266\377\000\000\000\377;;;\377\275\275\275\377\314\314"
  "\314\377\315\315\315\377\316\316\316\377\306\306\306\377(((\377\000\000\000\377"
  "\006\006\006\377\314\314\314\377\325\325\325\377\"\"\"\377\000\000\000\377\346\346\346"
  "\377\335\335\335\377\332\332\332\377\333\333\333\377\333\333\333\377xxx\377"
  "\235\235\235\377\340\340\340\377\341\341\341\377\342\342\342\377\331\331"
  "\331\377\001\001\001\377\270\270\270\377\347\347\347\377\350\350\350\377\351\351"
  "\351\377\336\336\336\377\353\353\353\377\354\354\354\377\355\355\355\377"
  "\271\271\271\377\360\360\360\377\361\361\361\377\362\362\362\377KKK\377\016"
  "\016\016\377\305\305\305\377\366\366\366\377\367\367\367\377\371\371\371\377"
  "\314\314\314\377\002\002\002\377\000\000\000\377\000\000\000\377\022\022\022\377<<<\377\065\065"
  "\065\377\013\013\013\377%%%\377\005\005\005\377\000\000\000\377\000\232\252\377\000Wa\377\000\002"
  "\002\377\000\000\000\377\000\000\000\377\000\000]\377\000\001\377\377\000\016\375\377\000\011T\377\004"
  "\004\004\377\267\267\267\377\310\310\310\377\310\310\310\377\310\310\310\377"
  "\255\255\255\377###\377\000\000\000\377\036\036\036\377\205\205\205\377\310\310\310"
  "\377\311\311\311\377HHH\377\000\000\000\377\237\237\237\377\365\365\365\377\330"
  "\330\330\377\320\320\320\377\322\322\322\377\333\333\333\377\333\333\333"
  "\377\325\325\325\377\326\326\326\377\327\327\327\377\261\261\261\377\014\014"
  "\014\377\326\326\326\377\333\333\333\377\334\334\334\377\336\336\336\377w"
  "ww\377\242\242\242\377\336\336\336\377\342\342\342\377\343\343\343\377\344"
  "\344\344\377\345\345\345\377\347\347\347\377jjj\377\000\000\000\377\265\265\265"
  "\377\302\302\302\377\354\354\354\377\355\355\355\377\356\356\356\377bbb\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\211\211\211\377\367\367"
  "\367\377kkk\377\000\000\000\377\000tw\377\000\217\222\377\000\007\007\377\000\000\000\377\000\000\000"
  "\377\000\000\010\377\000\010\345\377\000\027\375\377\000\006&\377&&&\377\310\310\310\377"
  "\310\310\310\377\310\310\310\377\310\310\310\377\310\310\310\377\302\302"
  "\302\377\300\300\300\377\310\310\310\377\310\310\310\377\310\310\310\377"
  "\310\310\310\377\243\243\243\377\002\002\002\377\004\004\004\377\235\235\235\377\357"
  "\357\357\377\377\377\377\377\377\377\377\377\377\377\377\377\346\346\346"
  "\377\311\311\311\377\312\312\312\377\313\313\313\377\217\217\210\377III\377"
  "\317\317\317\377\320\320\320\377\321\321\321\377\322\322\322\377{{{\377\037"
  "\037\037\377\261\261\261\377\312\312\312\377\330\330\330\377\331\331\331\377"
  "\332\332\332\377\333\333\333\377\240\240\240\377\000\000\000\377CCC\377\354\354"
  "\354\377\314\314\314\377\342\342\342\377\343\343\343\377\340\340\340\377"
  "aaa\377\004\004\004\377\000\000\000\377\003\003\003\377\200\200\200\377\353\353\353\377\307"
  "\307\307\377rrr\377\000\000\000\377\000fc\377\000\364\353\377\000\260\264\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\005R\377\000\036\373\377\000\004\032\377\064\064\064\377\307\307"
  "\307\377\310\310\310\377\310\310\310\377\310\310\310\377\310\310\310\377"
  "\310\310\310\377\310\310\310\377\310\310\310\377\310\310\310\377\310\310"
  "\310\377\310\310\310\377\310\310\310\377mmm\377\004\004\004\377\000\000\000\377\000\000\000"
  "\377\035\035\035\377AAA\377^^^\377\320\320\320\377\310\310\310\377\310\310\310"
  "\377\310\310\310\377\212\213Y\377\206\206\206\377\310\310\310\377\310\310"
  "\310\377\310\310\310\377\310\310\310\377\223\223\223\377\000\000\000\377\036\036"
  "\036\377\300\300\300\377\265\265\265\377\316\316\316\377\317\317\317\377\320"
  "\320\320\377\315\315\315\377\020\020\020\377\000\000\000\377\247\247\247\377\342\342"
  "\342\377\277\277\277\377\330\330\330\377\331\331\331\377\332\332\332\377"
  "\311\311\311\377\251\251\251\377\306\306\306\377\337\337\337\377\335\335"
  "\335\377\332\332\332\377jjj\377\000\000\000\377\000xs\377\000\364\353\377\000\262\266"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\015Z\377\000\006\034\377\066\066\066"
  "\377\263\263\263\377\310\310\310\377\310\310\310\377\310\310\310\377\310"
  "\310\310\377\310\310\310\377\310\310\310\377\310\310\310\377\310\310\310"
  "\377\310\310\310\377\275\275\275\377\257\257\257\377\263\263\263\377\260"
  "\260\260\377PPP\377\015\015\015\377\000\000\000\377\000\000\000\377\065\065\065\377\310\310"
  "\310\377\310\310\310\377\310\310\310\377\310\310\306\377\230\231<\377\251"
  "\251\251\377\310\310\310\377\310\310\310\377\310\310\310\377\310\310\310"
  "\377\274\274\274\377\015\015\015\377\000\000\000\377\021\021\021\377\271\271\271\377"
  "\257\257\257\377\307\307\307\377\310\310\310\377\310\310\310\377ooo\377\000"
  "\000\000\377\022\022\022\377\321\321\321\377\363\363\363\377\261\261\261\377\312"
  "\312\312\377\317\317\317\377\320\320\320\377\321\321\321\377\322\322\322"
  "\377\323\323\323\377\266\266\266\377\373\373\373\377\040\040\040\377\000\000\000\377"
  "\000\012\013\377\000\064\066\377\000\015\016\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\013\013\013\377\373\373\373\377\303\303\303\377\256"
  "\256\256\377\257\257\257\377\256\256\256\377\256\256\256\377\262\262\262"
  "\377\275\275\275\377\315\315\315\377\353\353\353\377\377\377\377\377\347"
  "\347\347\377\271\271\271\377\211\211\211\377JJJ\377\004\004\004\377\000\002\003\377\000"
  "\000\000\377```\377\310\310\310\377\310\310\310\377\310\310\310\377\327\330\216"
  "\377\216\217G\377\335\335\335\377\264\264\264\377\310\310\310\377\310\310"
  "\310\377\310\310\310\377\304\304\304\377SSS\377\000\000\000\377\000\000\000\377\004\004\004"
  "\377\204\204\204\377\311\311\311\377\265\265\265\377\310\310\310\377\304"
  "\304\304\377'''\377\000\000\000\377\023\023\023\377\300\300\300\377\377\377\377\377"
  "\356\356\356\377\271\271\271\377\256\256\256\377\257\257\257\377\256\256"
  "\256\377\307\307\307\377\377\377\377\377\212\212\212\377\000\000\000\377\000\003\004"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\255\255\255\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\351\351\351\377\272\272\272\377\222"
  "\222\222\377hhh\377AAA\377\025\025\025\377\000\000\000\377\000\000\000\377\000\000\000\377\000\006"
  "\010\377\000\061O\377\000\007\015\377\000\000\000\377\223\223\223\377\310\310\310\377\310"
  "\310\310\377\310\310\310\377\356\361\060\377GG\070\377\325\325\325\377\377"
  "\377\377\377\312\312\312\377\262\262\262\377\261\261\261\377\363\363\363"
  "\377\274\274\274\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377???\377\322\322"
  "\322\377\304\304\304\377\265\265\265\377\315\315\315\377\021\021\021\377\000\000"
  "\000\377\001\001\001\377```\377\315\315\315\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\370\370\370\377\201\201\201\377\002\002\002\377\000"
  "\000\000\377\000\062=\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\011\011\011\377hhh\377sss\377"
  "MMM\377\033\033\033\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\016\020\377"
  "\000\034\037\377\000\034\040\377\000w\217\377\000\205\253\377\000_\205\377\000q\255\377\000"
  "\000\000\377\030\030\030\377\256\256\256\377\306\306\306\377\310\310\310\377\332"
  "\333\205\377\350\353!\377\000\000\000\377\000\000\000\377)))\377{{{\377\305\305\305\377"
  "\367\367\367\377\377\377\377\377\377\377\377\377YYY\377\000\000\000\377\000\000\006\377"
  "\000\000\005\377\000\000\000\377\003\003\003\377eee\377\337\337\337\377\377\377\377\377\311"
  "\311\311\377!!!\377\000\000\000\377\000\000\000\377\000\000\000\377!!!\377EEE\377]]]\377KK"
  "K\377\020\020\020\377\000\000\000\377\000\000\000\377\000St\377\000j\216\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\002\002\377\000"
  "<J\377\000\235\263\377\000\314\332\377\000\346\354\377\000\346\354\377\000\254\271"
  "\377\000\264\315\377\000\302\357\377\000\263\360\377\000\062J\377\000\000\000\377[[[\377"
  "\314\314\314\377\257\257\257\377\317\320\253\377\370\374\014\377\250\252\062"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\005\005\005\377\066\066\066"
  "\377WWW\377CCC\377\000\000\000\377\000\000\023\377\000\000\342\377\000\000-\377\000\000\000\377\000"
  "\000\000\377\001\001\001\377>>>\377\231\231\231\377\313\313\313\377\177\177\177\377"
  "\014\014\014\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\025$\377\000h\247\377\000\237\362\377\000n\242\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\216\272\377\000\307\357"
  "\377\000\323\352\377\000^`\377\000\062\060\377\000\325\316\377\000\346\354\377\000\315"
  "\343\377\000\307\357\377\000\236\317\377\000\001\001\377\002\002\002\377\240\240\240\377"
  "\377\377\377\377\353\354\304\377\367\373\032\377\373\377\000\377kl'\377\070\071"
  "\027\377\070\071\027\377\070\071\027\377''\020\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000<\377\000\000\372\377\000\000\376\377\000\000\031\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\002\002\002\377\000"
  "\000\000\377\000\037l\377\000\062\224\377\000\001\003\377\000\000\000\377\000\000\000\377\000C\177\377"
  "\000\211\364\377\000\220\363\377\000L|\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\012\025\377\000l\303\377\000s\272\377\000\000\000\377\000\214\270\377\000\244\305\377"
  "\000\063\071\377\000\000\000\377\000\000\000\377\000\031\030\377\000\270\275\377\000\326\355\377"
  "\000\273\340\377\000$.\377\000\000\000\377AAA\377\367\367\363\377\360\362\212\377\371"
  "\375\016\377\373\377\000\377\373\377\000\377\373\377\000\377\373\377\000\377\354\357"
  "\034\377no(\377\007\007\003\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\323\377\000\000\377\377\000\000N\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\001\004\377\000\067\340\377"
  "\000J\371\377\000\013!\377\000\000\000\377\000\000\000\377\000\003\007\377\000`\277\377\000c\273\377"
  "\000\007\014\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000]\302\377\000\205\364\377"
  "\000v\300\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\003\003\377\000(.\377\000\015\020\377\000\000\000\377\000\000\000\377]]F\377\250\252"
  "@\377\270\272\062\377\270\272\062\377\331\334*\377\373\377\001\377\373\377\000"
  "\377\322\325-\377\020\020\007\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\302\377\000\000\310\377\000"
  "\000\011\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000(\277\377\000\060\300\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000W\274\377\000g\303\377\000\014\025\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377..\023\377\366\372\015\377\373"
  "\377\000\377\314\317.\377\004\004\002\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\310\312\060\377\373\377\000\377"
  "\340\343'\377\007\007\003\377\000\000\000\377\000`\357\377\000f\377\377\000f\377\377\000f\377"
  "\377\000`\357\377\000\000\000\377\000Y\337\377\000f\377\377\000f\377\377\000f\377\377\000`"
  "\357\377\000\000\000\377\000Y\337\377\000f\377\377\000f\377\377\000c\370\377\000\063\177\377"
  "\000\000\000\377\000Y\337\377\000e\374\377\000\067\211\377\000\000\000\377\000\067\211\377\000e\374"
  "\377\000Y\337\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\063\063\025\377\372\376"
  "\003\377\362\366\025\377$$\017\377\000\000\000\377\000\000\000\377\000Y\337\377\000\000\000\377\000"
  "f\377\377\000\000\000\377\000Y\337\377\000\000\000\377\000\000\000\377\000f\377\377\000\000\000\377\000"
  "\000\000\377\000Y\337\377\000\000\000\377\000\000\000\377\000f\377\377\000\000\000\377\000\007\022\377\000"
  "c\370\377\000\000\000\377\000\000\000\377\000f\377\377\000^\354\377\000\023\060\377\000^\354\377"
  "\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\312\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\250\252\062\377"
  "\372\376\003\377XY\"\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000f\377\377\000Y\337\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000f\377\377\000\000\000\377\000\007\022\377"
  "\000c\370\377\000\000\000\377\000\000\000\377\000f\377\377\000\071\216\377\000^\354\377\000\071\216"
  "\377\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\376\000\000\000\311\000\000\000\200\000\000\000\240\000\000\000\352\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\354\357"
  "\034\377\360\363\030\377\270\272\062\377\270\272\062\377\270\272\062\377OP\037"
  "\377\000\000\000\377\000\000\000\377\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000f\377\377"
  "\000f\377\377\000f\377\377\000\064\201\377\000\000\000\377\000\000\000\377\000f\377\377\000\012\030"
  "\377\000Z\342\377\000\012\030\377\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\355\000\000\000\243\000\000\000\200\000\000\000"
  "n\000\000\000\200\000\000\000\203\000\000\000\275\000\000\000\367\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\007\007\003\377jk'\377jk'\377\361\365\026\377\373\377\000\377\270\272\062\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000f\377\377\000\000\000\377\000\000\000\377\000Y\337\377\000\000\000\377\000\000\000\377\000"
  "f\377\377\000\004\011\377\000P\307\377\000\040O\377\000\000\000\377\000\000\000\377\000f\377\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000f\377\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\367\000\000\000\274\000\000\000\203\000\000\000\200\000\000\000m\000\000\000\005"
  "\000\000\000@\000\000\000}\000\000\000\200\000\000\000\206\000\000\000\273\000\000\000\367\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377XY\"\377\373\377\000\377\270\272\062\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000Y\337\377\000f\377\377\000Y\337\377\000\000\000\377\000\000\000\377\000Y\337\377"
  "\000f\377\377\000f\377\377\000f\377\377\000`\357\377\000\000\000\377\000Y\337\377\000`\357"
  "\377\000\000\000\377\000.t\377\000Y\337\377\000\000\000\377\000Y\337\377\000`\357\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000`\357\377\000Y\337\377\000\000\000\377\000\000\000\377\000\000\000\370"
  "\000\000\000\304\000\000\000\210\000\000\000\200\000\000\000~\000\000\000I\000\000\000\006\000\000\000\000\000\000\000\000\000\000"
  "\000\020\000\000\000M\000\000\000~\000\000\000\200\000\000\000\204\000\000\000\257\000\000\000\347\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\260\262\062\377\332\335*\377\002\002\001\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\353\000\000\000\267\000\000\000\206\000\000\000\200\000\000\000\177\000\000"
  "\000U\000\000\000\023\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\026\000\000"
  "\000T\000\000\000}\000\000\000\200\000\000\000\200\000\000\000\234\000\000\000\310\000\000\000\361\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\275\277\061\377\035\035\014\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\361\000\000\000\307\000\000\000\233\000\000\000\200"
  "\000\000\000\200\000\000\000}\000\000\000S\000\000\000\026\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000B\000\000\000t\000\000\000\200"
  "\000\000\000\200\000\000\000\201\000\000\000\235\000\000\000\302\000\000\000\344\000\000\000\376\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377AB\032\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377"
  "\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\375\000\000\000\343\000\000\000\301\000\000\000\234\000\000\000\200\000\000\000"
  "\200\000\000\000\200\000\000\000t\000\000\000A\000\000\000\015\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\002\000\000\000\036\000\000\000I\000\000\000v\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\207"
  "\000\000\000\246\000\000\000\300\000\000\000\331\000\000\000\363\000\000\000\377\000\000\000\377\000\000\000\377\000"
  "\000\000\377\000\000\000\377\002\002\001\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000"
  "\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000"
  "\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\377\000\000\000\362"
  "\000\000\000\331\000\000\000\300\000\000\000\246\000\000\000\207\000\000\000\200\000\000\000\200\000\000\000\200\000"
  "\000\000x\000\000\000Q\000\000\000'\000\000\000\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\004\000\000\000#\000\000\000F\000\000\000i\000\000\000\200"
  "\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\211\000\000\000\233\000\000\000\255\000"
  "\000\000\306\000\000\000\372\000\000\000\377\000\000\000\375\000\000\000\357\000\000\000\363\000\000\000\367\000\000"
  "\000\370\000\000\000\377\000\000\000\377\000\000\000\370\000\000\000\367\000\000\000\363\000\000\000\354\000\000\000"
  "\342\000\000\000\327\000\000\000\314\000\000\000\277\000\000\000\255\000\000\000\233\000\000\000\211\000\000\000\200"
  "\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\177\000\000\000i\000\000\000F\000\000\000#\000\000\000\004\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\000\000"
  "\000(\000\000\000B\000\000\000\\\000\000\000v\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\210"
  "\000\000\000\241\000\000\000\212\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000"
  "\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000"
  "\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000\200\000\000\000v\000\000\000\\\000\000\000B\000\000"
  "\000'\000\000\000\014\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\012\000\000\000\034\000\000\000/\000\000\000A\000\000\000M\000\000\000X\000\000\000c\000\000\000m\000\000\000s\000"
  "\000\000w\000\000\000y\000\000\000\200\000\000\000\200\000\000\000y\000\000\000w\000\000\000s\000\000\000m\000\000\000c\000\000\000"
  "X\000\000\000L\000\000\000A\000\000\000/\000\000\000\034\000\000\000\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};

char *output_types[] = {
	/* coverity[missing_comma:SUPPRESS] */
	"Autodetect"
#ifdef __unix__
	" (X11, SDL, Curses, ANSI)"
#elif defined(_WIN32)
	" (GDI, SDL, Console, ANSI)"
#endif
#ifdef __unix__
	, "Curses",
	"Curses on cp437 Device",
	"Curses using US-ASCII"
#endif
	, "ANSI"
#if defined(__unix__) && !defined(NO_X)
	, "X11"
	, "X11 Fullscreen"
#endif
#ifdef _WIN32
	, "Win32 Console",
	"Win32 Console Fullscreen"
#endif
#if defined(WITH_SDL) || defined(WITH_SDL_AUDIO)
	, "SDL"
	, "SDL Fullscreen"
#endif
#if defined(WITH_GDI)
	, "GDI"
	, "GDI Fullscreen"
#endif
	, NULL
};
int   output_map[] = {
	CIOLIB_MODE_AUTO
#ifdef __unix__
	, CIOLIB_MODE_CURSES
	, CIOLIB_MODE_CURSES_IBM
	, CIOLIB_MODE_CURSES_ASCII
#endif
	, CIOLIB_MODE_ANSI
#if defined(__unix__) && !defined(NO_X)
	, CIOLIB_MODE_X
	, CIOLIB_MODE_X_FULLSCREEN
#endif
#ifdef _WIN32
	, CIOLIB_MODE_CONIO
	, CIOLIB_MODE_CONIO_FULLSCREEN
#endif
#if defined(WITH_SDL) || defined(WITH_SDL_AUDIO)
	, CIOLIB_MODE_SDL
	, CIOLIB_MODE_SDL_FULLSCREEN
#endif
#ifdef WITH_GDI
	, CIOLIB_MODE_GDI
	, CIOLIB_MODE_GDI_FULLSCREEN
#endif
	, 0
};
char *output_descrs[] = {
	"Autodetect",
	"Curses",
	"Curses on cp437 Device",
	"Curses using US-ASCII",
	"ANSI",
	"X11",
	"X11 Fullscreen",
	"Win32 Console",
	"Win32 Console Fullscreen",
	"SDL",
	"SDL Fullscreen",
	"GDI",
	"GDI Fullscreen",
	NULL
};

char *output_enum[] = {
	"Autodetect",
	"Curses",
	"Curses437",
	"CursesAscii",
	"ANSI",
	"X11",
	"X11Fullscreen",
	"WinConsole",
	"WinConsoleFullscreen",
	"SDL",
	"SDLFullscreen",
	"GDI",
	"GDIFullscreen",
	NULL
};

ini_bitdesc_t audio_output_bits[] = {
	{
		.name = "PulseAudio",
		.bit = XPBEEP_DEVICE_PULSEAUDIO
	},
	{
		.name = "PortAudio",
		.bit = XPBEEP_DEVICE_PORTAUDIO
	},
	{
		.name = "SDL",
		.bit = XPBEEP_DEVICE_SDL
	},
	{
		.name = "WaveOut",
		.bit = XPBEEP_DEVICE_WIN32
	},
	{
		.name = "ALSA",
		.bit = XPBEEP_DEVICE_ALSA
	},
	{
		.name = "OSS",
		.bit = XPBEEP_DEVICE_OSS
	},
	{
		.name = NULL,
		.bit = 0
	},
};

ini_bitdesc_t audio_output_types[] = {
#ifdef WITH_PULSEAUDIO
	{
		.name = "PulseAudio",
		.bit = XPBEEP_DEVICE_PULSEAUDIO
	},
#endif
#ifdef WITH_PORTAUDIO
	{
		.name = "PortAudio",
		.bit = XPBEEP_DEVICE_PORTAUDIO
	},
#endif
#ifdef WITH_SDL_AUDIO
	{
		.name = "SDL",
		.bit = XPBEEP_DEVICE_SDL
	},
#endif
#ifdef _WIN32
	{
		.name = "WaveOut",
		.bit = XPBEEP_DEVICE_WIN32
	},
#endif
#ifdef USE_ALSA_SOUND
	{
		.name = "ALSA",
		.bit = XPBEEP_DEVICE_ALSA
	},
#endif
#if (defined SOUNDCARD_H_IN) && (SOUNDCARD_H_IN > 0) && (defined AFMT_U8)
	{
		.name = "OSS",
		.bit = XPBEEP_DEVICE_OSS
	},
#endif
	{
		.name = NULL,
		.bit = 0
	},
};

bool
check_exit(bool force)
{
	if (force || (uifc.exit_flags & UIFC_XF_QUIT)) {
		if (!(uifc.exit_flags & UIFC_XF_QUIT) && settings.confirm_close) {
			if (!confirm("Are you sure you want to exit?", NULL))
				return false;
		}
		quitting = true;
		return true;
	}
	return false;
}

void
parse_url(char *url, struct bbslist *bbs, int dflt_conn_type, int force_defaults)
{
	char             *p1, *p2, *p3;

#define BBSLIST_SIZE ((MAX_OPTS + 1) * sizeof(struct bbslist *))
	struct  bbslist **list;
	int               listcount = 0, i;

	bbs->id = -1;
	bbs->added = time(NULL);
	bbs->calls = 0;
	bbs->type = USER_BBSLIST;
	if (force_defaults) {
		bbs->user[0] = 0;
		bbs->password[0] = 0;
		bbs->screen_mode = SCREEN_MODE_CURRENT;
		bbs->conn_type = dflt_conn_type;
		bbs->port = conn_ports[dflt_conn_type];
		bbs->xfer_loglevel = LOG_INFO;
		bbs->telnet_loglevel = LOG_INFO;
		bbs->music = CTERM_MUSIC_BANSI;
		strcpy(bbs->font, "Codepage 437 English");
	}
	p1 = url;
	if (!strnicmp("rlogin://", url, 9)) {
		bbs->conn_type = CONN_TYPE_RLOGIN;
		bbs->port = conn_ports[bbs->conn_type];
		p1 = url + 9;
	}
	else if (!strnicmp("ssh://", url, 6)) {
		bbs->conn_type = CONN_TYPE_SSH;
		bbs->port = conn_ports[bbs->conn_type];
		p1 = url + 6;
	}
	else if (!strnicmp("telnet://", url, 9)) {
		bbs->conn_type = CONN_TYPE_TELNET;
		bbs->port = conn_ports[bbs->conn_type];
		p1 = url + 9;
	}
	else if (!strnicmp("raw://", url, 6)) {
		bbs->conn_type = CONN_TYPE_TELNET;
		bbs->port = conn_ports[bbs->conn_type];
		p1 = url + 6;
	}
	else if (!strnicmp("shell:", url, 6)) {
		bbs->conn_type = CONN_TYPE_SHELL;
		bbs->port = conn_ports[bbs->conn_type];
		p1 = url + 6;
	}
	else if (!strnicmp("ghost://", url, 8)) {
		bbs->conn_type = CONN_TYPE_MBBS_GHOST;
		bbs->port = conn_ports[bbs->conn_type];
		p1 = url + 8;
	}

        /* ToDo: RFC2806 */
	p3 = strchr(p1, '@');
	if (p3 != NULL) {
		*p3 = 0;
		p2 = strchr(p1, ':');
		if (p2 != NULL) {
			*p2 = 0;
			p2++;
			SAFECOPY(bbs->password, p2);
		}
		SAFECOPY(bbs->user, p1);
		p1 = p3 + 1;
	}
	p2 = p1;
	if (*p1 == '[') {
		p2 = strchr(p1, ']');
		if (p2 != NULL) {
			p1++;
			*p2 = 0;
			p2++;
		}
		else {
			p2 = p1;
		}
	}
	if (bbs->conn_type == CONN_TYPE_MBBS_GHOST) {
		p3 = strrchr(p1, '/');
		if (p3 != NULL) {
			*p3 = 0;
			SAFECOPY(bbs->ghost_program, p3 + 1);
		}
	}
	SAFECOPY(bbs->name, p1);
	p2 = strrchr(p2, ':');
	if (p2 != NULL) {
		*p2 = 0;
		p2++;
		bbs->port = atoi(p2);
	}
	SAFECOPY(bbs->addr, p1);

        /* Find BBS listing in users phone book */
	list = calloc(1, BBSLIST_SIZE);
	read_list(settings.list_path, &list[0], NULL, &listcount, USER_BBSLIST);
	for (i = 0; i < listcount; i++) {
		if ((stricmp(bbs->addr, list[i]->addr) == 0)
		    && (bbs->port == list[i]->port)
		    && (bbs->conn_type == list[i]->conn_type)
		    && ((bbs->user[0] == 0) || (stricmp(bbs->name, list[i]->name) == 0))
		    && ((bbs->password[0] == 0) || (stricmp(bbs->password, list[i]->password) == 0))) {
			memcpy(bbs, list[i], sizeof(struct bbslist));
			break;
		}
	}
	if (i == listcount) {
		for (i = 0; i < listcount; i++) {
			if (stricmp(bbs->name, list[i]->name) == 0) {
				memcpy(bbs, list[i], sizeof(struct bbslist));
				break;
			}
		}
	}
	free_list(&list[0], listcount);
	free(list);
}

#if defined(__APPLE__) && defined(__MACH__)

#elif defined(_WIN32) /* if defined(__APPLE__) && defined(__MACH__) */

static char *
get_win_filename(char *fn, int fnlen, int type, int shared)
{
	char             *home;
	static dll_handle shell32 = NULL;
	bool              we_got_this = false;
	static HRESULT(__stdcall * GKFP) (REFKNOWNFOLDERID rfid, DWORD dwFlags, HANDLE hToken, PWSTR *ppszPath) = NULL;
	const char       *shell32dll[] = {"Shell32", NULL};

	static dll_handle ole32 = NULL;
	static int(__stdcall * CTMF) (LPVOID) = NULL;
	const char       *ole32dll[] = {"OLE32", NULL};

	home = getenv("HOME");
	if (home == NULL)
		home = getenv("USERPROFILE");
	if (home == NULL)
		home = ".";

	if (shell32 == NULL)
		shell32 = xp_dlopen(shell32dll, RTLD_LAZY, 6);
	if (ole32 == NULL)
		ole32 = xp_dlopen(ole32dll, RTLD_LAZY, 0);
	if ((shell32 != NULL) && (ole32 != NULL)) {
		if (GKFP == NULL)
			GKFP = xp_dlsym(shell32, SHGetKnownFolderPath);
		if (CTMF == NULL)
			CTMF = xp_dlsym(ole32, CoTaskMemFree);
		if (GKFP && CTMF) {
			PWSTR path;
			switch (type) {
				case SYNCTERM_PATH_INI:
				case SYNCTERM_PATH_LIST:
				case SYNCTERM_PATH_KEYS:
					if (shared) {
						if (GKFP(&FOLDERID_ProgramData, KF_FLAG_CREATE, NULL, &path) == S_OK)
							we_got_this = true;
					}
					else {
						if (GKFP(&FOLDERID_RoamingAppData, KF_FLAG_CREATE, NULL, &path) == S_OK)
							we_got_this = true;
					}
					break;
				case SYNCTERM_DEFAULT_TRANSFER_PATH:
					if (shared) {
						if (GKFP(&FOLDERID_PublicDownloads, KF_FLAG_CREATE, NULL,
						    &path) == S_OK)
							we_got_this = true;
					}
					else {
						if (GKFP(&FOLDERID_Downloads, KF_FLAG_CREATE, NULL, &path) == S_OK)
							we_got_this = true;
					}
					break;
				case SYNCTERM_PATH_CACHE:
					if (GKFP(&FOLDERID_InternetCache, KF_FLAG_CREATE, NULL, &path) == S_OK)
						we_got_this = true;
					break;
			}
			if (we_got_this) {
                                // Convert unicode to string using snprintf()
				if ((type == SYNCTERM_DEFAULT_TRANSFER_PATH) || (type == SYNCTERM_PATH_CACHE)) {
					if (snprintf(fn, fnlen, "%S", path) >= fnlen)
						we_got_this = false;
				}
				else {
					if (snprintf(fn, fnlen, "%S\\SyncTERM", path) >= fnlen)
						we_got_this = false;
				}
				CTMF(path);
			}
		}
	}
	if (!we_got_this) {
 #ifdef CSIDL_FLAG_CREATE
		if (type == SYNCTERM_DEFAULT_TRANSFER_PATH) {
			switch (SHGetFolderPathA(NULL, CSIDL_PERSONAL | CSIDL_FLAG_CREATE, NULL, SHGFP_TYPE_CURRENT,
			    fn)) {
				case E_FAIL:
				case E_INVALIDARG:
					getcwd(fn, fnlen);
					backslash(fn);
					break;
				default:
					backslash(fn);
					strncat(fn, "SyncTERM", fnlen - strlen(fn) - 1);
					break;
			}
			if (!isdir(fn))
				MKDIR(fn);
			return fn;
		}
		switch (SHGetFolderPathA(NULL, (shared ? CSIDL_COMMON_APPDATA : CSIDL_APPDATA) | CSIDL_FLAG_CREATE, NULL,
		    SHGFP_TYPE_CURRENT, fn)) {
			case E_FAIL:
			case E_INVALIDARG:
				strcpy(fn, ".");
				break;
			default:
				backslash(fn);
				strncat(fn, "SyncTERM", fnlen - strlen(fn) - 1);
				break;
		}
 #else /* ifdef CSIDL_FLAG_CREATE */
		getcwd(fn, fnlen);
		backslash(fn);
 #endif /* ifdef CSIDL_FLAG_CREATE */
	}

        /* Create if it doesn't exist */
	if (*fn && !isdir(fn)) {
		if (mkpath(fn))
			return NULL;
	}

	switch (type) {
		case SYNCTERM_PATH_INI:
			backslash(fn);
			strncat(fn, "syncterm.ini", fnlen - strlen(fn) - 1);
			break;
		case SYNCTERM_PATH_LIST:
			backslash(fn);
			strncat(fn, "syncterm.lst", fnlen - strlen(fn) - 1);
			break;
		case SYNCTERM_PATH_CACHE:
			backslash(fn);
			strncat(fn, "SyncTERM", fnlen - strlen(fn) - 1);
			backslash(fn);
			if (!isdir(fn)) {
				if (MKDIR(fn)) {
					fn[0] = 0;
					break;
				}
			}
			break;
		case SYNCTERM_PATH_KEYS:
			backslash(fn);
			strncat(fn, "syncterm.ssh", fnlen - strlen(fn) - 1);
			break;
	}

	return fn;
}

#elif defined(__HAIKU__)

static char *
get_haiku_filename(char *fn, int fnlen, int type, int shared)
{
	dev_t v = dev_for_path("/boot");
	status_t s;
	size_t sz;

	switch(type) {
		case SYNCTERM_PATH_INI:
		case SYNCTERM_PATH_LIST:
		case SYNCTERM_PATH_KEYS:
			if (shared)
				s = find_directory(B_SYSTEM_SETTINGS_DIRECTORY, v, true, fn, fnlen);
			else
				s = find_directory(B_USER_SETTINGS_DIRECTORY, v, true, fn, fnlen);
			break;
		case SYNCTERM_DEFAULT_TRANSFER_PATH:
			if (shared)
				s = B_BAD_TYPE;
			else
				s = find_directory(B_DESKTOP_DIRECTORY, v, true, fn, fnlen);
			break;
		case SYNCTERM_PATH_CACHE:
			if (shared)
				s = find_directory(B_SYSTEM_CACHE_DIRECTORY, v, true, fn, fnlen);
			else
				s = find_directory(B_USER_CACHE_DIRECTORY, v, true, fn, fnlen);
			break;
	}

	if (s != B_OK)
		return NULL;
	if (type == SYNCTERM_DEFAULT_TRANSFER_PATH)
		return fn;
	sz = strlcat(fn, "/SyncTERM", fnlen);
	if (sz >= fnlen)
		return NULL;

	/* Create if it doesn't exist */
	if (!isdir(fn) && !shared) {
		if (mkpath(fn))
			return NULL;
	}

	if (type == SYNCTERM_PATH_CACHE)
		return fn;

	switch(type) {
		case SYNCTERM_PATH_INI:
			sz = strlcat(fn, "/SyncTERM.ini", fnlen);
			break;
		case SYNCTERM_PATH_LIST:
			sz = strlcat(fn, "/SyncTERM.lst", fnlen);
			break;
		case SYNCTERM_PATH_KEYS:
			sz = strlcat(fn, "/SyncTERM.ssh", fnlen);
			break;
	}
	if (sz >= fnlen)
		return NULL;
	return fn;
}

#else
enum xdg_paths {
	XDG_DATA_HOME,
	XDG_CONFIG_HOME,
	XDG_CACHE_HOME,
	XDG_NONE, // Download dir
};
static char *
get_xdg_path(enum xdg_paths type, char *buf, size_t bufsz)
{
	char *env;

	// First, check if XDG variable is set
	switch(type) {
		case XDG_DATA_HOME:
			env = getenv("XDG_DATA_HOME");
			break;
		case XDG_CONFIG_HOME:
			env = getenv("XDG_CONFIG_HOME");
			break;
		case XDG_CACHE_HOME:
			env = getenv("XDG_CACHE_HOME");
			break;
		case XDG_NONE:
			// Always use HOME...
			env = NULL;
			break;
		default:
			fprintf(stderr, "Invalid XDG type %d\n", type);
			return NULL;
	}

	// Not set, get default
	if (env == NULL) {
		char *home;
		home = getenv("HOME"); // Standard
		if (home == NULL)
			home = ".";
		switch(type) {
			case XDG_DATA_HOME:
				snprintf(buf, bufsz, "%s/.local/share", home);
				break;
			case XDG_CONFIG_HOME:
				snprintf(buf, bufsz, "%s/.config", home);
				break;
			case XDG_CACHE_HOME:
				snprintf(buf, bufsz, "%s/.cache", home);
				break;
			case XDG_NONE:
				snprintf(buf, bufsz, "%s", home);
				break;
		}
	}
	else {
		snprintf(buf, bufsz, "%s", env);
	}

	// Add "syncterm" to the end
	if (type != XDG_NONE) {
		backslash(buf);
		strcat(buf, "syncterm");
	}

	return buf;
}

static char *
get_unix_filename(char *fn, int fnlen, int type, int shared)
{
	if (!shared) {
		switch(type) {
			case SYNCTERM_PATH_INI:
				if (get_xdg_path(XDG_CONFIG_HOME, fn, fnlen) == NULL)
					return NULL;
				break;
			case SYNCTERM_PATH_LIST:
				if (get_xdg_path(XDG_CONFIG_HOME, fn, fnlen) == NULL)
					return NULL;
				break;
			case SYNCTERM_DEFAULT_TRANSFER_PATH:
				if (get_xdg_path(XDG_NONE, fn, fnlen) == NULL)
					return NULL;
				break;
			case SYNCTERM_PATH_CACHE:
				if (get_xdg_path(XDG_CACHE_HOME, fn, fnlen) == NULL)
					return NULL;
				break;
			case SYNCTERM_PATH_KEYS:
				if (get_xdg_path(XDG_DATA_HOME, fn, fnlen) == NULL)
					return NULL;
				break;
		}
		backslash(fn);
	}
	else {
 #ifdef SYSTEM_LIST_DIR
		strcpy(fn, SYSTEM_LIST_DIR);
		backslash(fn);
 #else
		strcpy(fn, "/usr/local/etc/");
 #endif
	}

	/* Create if it doesn't exist */
	if (!isdir(fn) && !shared) {
		if (mkpath(fn))
			return NULL;
	}

	switch (type) {
		case SYNCTERM_PATH_INI:
			strncat(fn, "syncterm.ini", fnlen - strlen(fn) - 1);
			break;
		case SYNCTERM_PATH_LIST:
			strncat(fn, "syncterm.lst", fnlen - strlen(fn) - 1);
			break;
		case SYNCTERM_PATH_CACHE:
			break;
		case SYNCTERM_PATH_KEYS:
			strncat(fn, "syncterm.ssh", fnlen - strlen(fn) - 1);
			break;
	}

	return fn;
}

#endif /* if defined(__APPLE__) && defined(__MACH__) */


char *
get_syncterm_filename(char *fn, int fnlen, int type, bool shared)
{
	if ((config_override != NULL) && (type == SYNCTERM_PATH_INI) && !shared) {
		sprintf(fn, "%.*s", fnlen - 1, config_override);
		return fn;
	}
	if ((list_override != NULL) && (type == SYNCTERM_PATH_LIST) && !shared) {
		sprintf(fn, "%.*s", fnlen - 1, list_override);
		return fn;
	}

	// Get recursive for the system cache...
	if (type == SYNCTERM_PATH_SYSTEM_CACHE) {
		if (!get_syncterm_filename(fn, fnlen, SYNCTERM_PATH_CACHE, false))
			return NULL;
		backslash(fn);
		strlcat(fn, "syncterm-system-cache", fnlen);
		if (mkpath(fn) != 0)
			return NULL;
		return fn;
	}
	memset(fn, 0, fnlen);
#if defined(__APPLE__) && defined(__MACH__)
	return get_OSX_filename(fn, fnlen, type, shared);
#elif defined(_WIN32)
	return get_win_filename(fn, fnlen, type, shared);
#elif defined(__HAIKU__)
	return get_haiku_filename(fn, fnlen, type, shared);
#else
	return get_unix_filename(fn, fnlen, type, shared);
#endif
	return NULL;
}

void
check_upgrade(void)
{
	char       inipath[MAX_PATH + 1];

	if (get_syncterm_filename(inipath, sizeof(inipath), SYNCTERM_PATH_INI, false) != NULL) {
#if !(defined(_WIN32) || defined(__APPLE__) || defined(__MACH__))
		if (!fexist(inipath)) {
			const char *home = getenv("HOME");
			if (home != NULL) {
				char oldpath[MAX_PATH+1];
				snprintf(oldpath, sizeof(oldpath), "%s/.syncterm", home);
				if (isdir(oldpath)) {
					init_uifc(true, true);
					uifc.showbuf(WIN_SAV | WIN_MID | WIN_HLP, 0, 0, 76, uifc.scrn_len - 2, "Upgrade Detected",
					    "It looks like you've just upgraded SyncTERM.  Previously on POSIX\n"
					    "systems, all files were usually stored in $HOME/.syncterm.  However,\n"
					    "with SyncTERM 1.2, files are now stored in the locations defined in the\n"
					    "XDG Base Directory Specification.\n"
					    "\n"
					    "You may want to note the new locations in the File Locations menu\n"
					    "option in SyncTERM Settings menu, exit SyncTERM (this is important) and\n"
					    "manually move the files to the new locations, overwriting the newly\n"
					    "created ini file.\n", NULL, NULL);
					uifcbail();
				}
			}
		}
#endif
	}
}

void
load_settings(struct syncterm_settings *set)
{
	FILE      *inifile;
	char       inipath[MAX_PATH + 1];
	int        i = 0;
	str_list_t sortby;
	char      *order;

	get_syncterm_filename(inipath, sizeof(inipath), SYNCTERM_PATH_INI, false);
	inifile = fopen(inipath, "r");
	set->confirm_close = iniReadBool(inifile, "SyncTERM", "ConfirmClose", false);
	set->prompt_save = iniReadBool(inifile, "SyncTERM", "PromptSave", true);
	set->startup_mode = iniReadEnum(inifile, "SyncTERM", "VideoMode", screen_modes_enum, SCREEN_MODE_CURRENT);
	set->startup_mode = iniReadEnum(inifile, "SyncTERM", "ScreenMode", screen_modes_enum, set->startup_mode);
	set->output_mode = iniReadEnum(inifile, "SyncTERM", "OutputMode", output_enum, CIOLIB_MODE_AUTO);
	set->audio_output_modes = iniReadBitField(inifile, "SyncTERM", "AudioModes", audio_output_bits, XPBEEP_DEVICE_DEFAULT);
	set->backlines = iniReadInteger(inifile, "SyncTERM", "ScrollBackLines", 2000);
	set->xfer_success_keypress_timeout = iniReadInteger(inifile,
	        "SyncTERM",
	        "TransferSuccessKeypressTimeout",

                /* seconds: */ 0);
	set->xfer_failure_keypress_timeout = iniReadInteger(inifile,
	        "SyncTERM",
	        "TransferFailureKeypressTimeout",

                /* seconds: */ 60);
	set->custom_cols = iniReadInteger(inifile, "SyncTERM", "CustomCols", 80);
	set->custom_rows = iniReadInteger(inifile, "SyncTERM", "CustomRows", 25);
	set->custom_fontheight = iniReadInteger(inifile, "SyncTERM", "CustomFontHeight", 16);
	set->custom_aw = iniReadInteger(inifile, "SyncTERM", "CustomAspectWidth", 4);
	set->custom_ah = iniReadInteger(inifile, "SyncTERM", "CustomAspectHeight", 3);
	get_syncterm_filename(set->stored_list_path, sizeof(set->stored_list_path), SYNCTERM_PATH_LIST, false);
	iniReadSString(inifile, "SyncTERM", "ListPath", set->stored_list_path, set->stored_list_path, sizeof(set->stored_list_path));
	if (list_override != NULL) {
		SAFECOPY(set->list_path, list_override);
	}
	else {
		SAFECOPY(set->list_path, set->stored_list_path);
	}
	set->scaling_factor = iniReadFloat(inifile, "SyncTERM", "ScalingFactor", 0);
	set->blocky = iniReadBool(inifile, "SyncTERM", "BlockyScaling", true);
	set->extern_scale = iniReadBool(inifile, "SyncTERM", "ExternalScaling", false);
	set->invert_wheel = iniReadBool(inifile, "SyncTERM", "InvertMouseWheel", false);

        // TODO: Add this to the UI somewhere.
	set->left_just = iniReadBool(inifile, "SyncTERM", "LeftJustify", false);

        /* Modem settings */
	iniReadSString(inifile, "SyncTERM", "ModemInit", "AT&F&C1&D2", set->mdm.init_string, sizeof(set->mdm.init_string));
	iniReadSString(inifile, "SyncTERM", "ModemDial", "ATDT", set->mdm.dial_string, sizeof(set->mdm.dial_string));
	iniReadSString(inifile, "SyncTERM", "ModemDevice", DEFAULT_MODEM_DEV, set->mdm.device_name, sizeof(set->mdm.device_name));
	set->mdm.com_rate = iniReadLongInt(inifile, "SyncTERM", "ModemComRate", 0);

        /* Sort order */
	sortby = iniReadStringList(inifile, "SyncTERM", "SortOrder", ",", "5,1");
	while ((order = strListRemove(&sortby, 0)) != NULL) {
		sortorder[i++] = atoi(order);
		free(order);
	}
	strListFree(&sortby);

        /* Shell TERM settings */
	iniReadSString(inifile, "SyncTERM", "TERM", "syncterm", set->TERM, sizeof(set->TERM));

	/* Web lists */
	if (inifile) {
		iniFreeNamedStringList(set->webgets);
		set->webgets = iniReadNamedStringList(inifile, "WebLists");
	}

	if (inifile)
		fclose(inifile);
}

sem_t download_complete_sem;
void
download_thread(void *args)
{
	struct webget_request *req = args;

	iniReadHttp(req);
	sem_post(&download_complete_sem);
}

void
update_webget_progress(struct webget_request *reqs, size_t items, bool leaveup)
{
	size_t sz = items * 120;
	char *helpbuf = malloc(sz);
	if (helpbuf == NULL)
		return;
	size_t pos = 0;
	static int cur = 0;
	static int bar = 0;
	bool errors = false;

	for (size_t i = 0; i < items; i++) {
		if (sz <= pos)
			break;
		assert_pthread_mutex_lock(&reqs[i].mtx);
		if (reqs[i].msg) {
			helpbuf[pos++] = '`';
			helpbuf[pos] = 0;
			errors = true;
		}
		else if (reqs[i].cb_data & UINT64_C(0x8000000000000000)) {
			helpbuf[pos++] = '`';
			helpbuf[pos] = 0;
			errors = true;
		}
		int added = snprintf(&helpbuf[pos], sz - pos, "%-20s: %-20s ",
		    reqs[i].name, reqs[i].state ? reqs[i].state : "");
		pos += added;
		if (sz > pos) {
			if (reqs[i].msg) {
				int added = snprintf(&helpbuf[pos], sz - pos, "%s`\r\n", reqs[i].msg);
				pos += added;
			}
			else if (reqs[i].cb_data & UINT64_C(0x8000000000000000)) {
				int added = snprintf(&helpbuf[pos], sz - pos, "Thread Failed to Start`\r\n");
				pos += added;
			}
			else {
				if (reqs[i].received_size > 0 || reqs[i].remote_size > 0) {
					char received[10];
					char total[10];
					byte_estimate_to_str(reqs[i].received_size, received, sizeof(received), 0, 3);
					byte_estimate_to_str(reqs[i].remote_size, total, sizeof(total), 0, 3);
					if (reqs[i].remote_size) {
						int added = snprintf(&helpbuf[pos], sz - pos, "%9s/%-9s ", received, total);
						pos += added;
						if (sz > pos) {
							int pct = reqs[i].received_size * 100 / reqs[i].remote_size;
							int added = snprintf(&helpbuf[pos], sz - pos, "~%.*s~%.*s\r\n", pct, "", 10 - pct, "");
							pos += added;
						}
					}
					else {
						int added = snprintf(&helpbuf[pos], sz - pos, "%9s\r\n", received);
						pos += added;
					}
				}
				else {
					int added = snprintf(&helpbuf[pos], sz - pos, "\r\n");
					pos += added;
				}
			}
		}
		assert_pthread_mutex_unlock(&reqs[i].mtx);
	}
	uifc.showbuf(((leaveup && errors) ? 0 : WIN_DYN | WIN_ACT) | WIN_HLP | WIN_SAV | WIN_MID | WIN_IMM,
	    0, 0, 74, items + 4, "Web Cache Update", helpbuf, &cur, &bar);
	if (leaveup) {
		cur = 0;
		bar = 0;
	}
}

int
main(int argc, char **argv)
{
	struct bbslist   *bbs = NULL;
	bool              bbs_alloc = false;
	struct  text_info txtinfo;
	char              str[MAX_PATH + 1];
	char              drive[MAX_PATH + 1];
	char              path[MAX_PATH + 1];
	char              fname[MAX_PATH + 1];
	char              ext[MAX_PATH + 1];

        /* Command-line parsing vars */
	char              url[MAX_PATH + 1];
	int               i;
	int               ciolib_mode;
	str_list_t        inifile;
	FILE             *listfile;
	char             *inpath = NULL;
	int               conn_type = CONN_TYPE_TELNET;
	int               text_mode;
	bool              override_conn = false;
	int               addr_family = PF_UNSPEC;
	char             *last_bbs = NULL;
	char             *p, *lp;
	int               cvmode;
	double sf;
	int               default_hidepopups = -1;
	int               default_nostatus = -1;
	unsigned char     saved_red = dac_default[3].red;
	unsigned char     saved_green = dac_default[3].green;
	unsigned char     saved_blue = dac_default[3].blue;
	const char        syncterm_termcap[] = "\n# terminfo database entry for SyncTERM\n"
	    "# compile with tic -x to get the user-defined capabilities for vim (bracketed pasted)\n"
	    "syncterm|SyncTERM,\n"

            // cwin maybe?  Or just left/right and top/bottom margins?
            // smgtb=\\E[%i%p1%d;%p2%dr,
            // shift/ctrl/alt Fx as extra keys?
            // Booleans:
	    "\tam,bce,da,ndscr,\n" // sam is a printer capability
            // Numeric:
	    "\tit#8,colors#8,pairs#64,\n"

            // Strings:
	    "\tacsc=}\\234|\\330{\\322+\\020\\,\\021l\\332m\\300k\\277j\\331u\\264t\\303v\\301w\\302q\\304x\\263n\\305`^Da\\260f\\370g\\361~\\371.^Y-^Xh\\261i^U0\\333y\\363z\\362,\n"
	    "\tcbt=\\E[Z,bel=^G,cr=^M,csr=\\E[%i%p1%d;%p2%dr,tbc=\\E[3g,\n"
	    "\tmgc=\\E[69h\\E[s\\e[69l,clear=\\E[2J,csr=\\E[%i%p1%d;%p2%dr,el1=\\E[1K,\n"
	    "\tel=\\E[K,ed=\\E[J,hpa=\\E[%i%p1%dG,cup=\\E[%i%p1%d;%p2%dH,cud1=^J,home=\\E[H,\n"
	    "\tcivis=\\E[?25l,cub1=\\E[D,cnorm=\\E[?25h,cuf1=\\E[C,ll=\\E[255H,cuu1=\\E[A,\n"
	    "\tcvvis=\\E[?25h,dch1=\\E[P,dl1=\\E[M,smam=\\E[?7h,blink=\\E[5m,bold=\\E[1m,\n"
	    "\tech=\\E[%p1%dX,rmam=\\E[7l,sgr0=\\E[m,is1=\\Ec,ich1=\\E[@,il1=\\E[L,kbs=^H,\n"
	    "\tkcbt=\\E[Z,kdch1=\\177,kcud1=\\E[B,kend=\\E[K,kf1=\\E[11~,kf2=\\E[12~,\n"
	    "\tkf3=\\E[13~,kf4=\\E[14~,kf5=\\E[15~,kf6=\\E[17~,kf7=\\E[18~,kf8=\\E[19~,\n"
	    "\tkf9=\\E[20~,kf10=\\E[21~,kf11=\\E[23~,kf12=\\E[24~,kcub1=\\E[D,knp=\\E[U,\n"
	    "\tkpp=\\E[V,kcuf1=\\E[C,kcuu1=\\E[A,nel=^M^J,dch=\\E[%p1%dP,dl=\\E[%p1%dM,\n"
	    "\tcud=\\E[%p1%dB,ich=\\E[%p1%d@,indn=\\E[%p1%dS,il=\\E[%p1%dL,cub=\\E[%p1%dD,\n"
	    "\tcuf=\\E[%p1%dC,rin=\\E[%p1%dT,cuu=\\E[%p1%dA,rep=%p1%c\\E[%p2%{1}%-%db,\n"
	    "\trs1=\\E[c,rc=\\E[u,sc=\\E[s,ind=\\E[S,ri=\\E[T,\n"
	    "\tsgr=\\E[0%?%p1%p6%|%t;1%;%?%p4%|%t;5%;%?%p1%p3%|%t;7%;%?%p7%|%t;8%;m,\n"
	    "\tsmglp=\\E[69h\\E[%{1}%p1%+%d;0s\\E[69l,smgrp=\\E[69h\\E[0;%{1}%p1%+%ds\\E[69l,\n"
	    "\thts=\\E[H,ht=\t,setab=\\E[4%p1%dm,setaf=\\E[3%p1%dm,\n"
	    "\tsmglr=\\E[?69h\\E[%i%p1%d;%p2%ds\\E?69l,smso=\\E[0;1;7m,rmso=\\E[m,\n"
	    // XTerm bracketed pasted: https://invisible-island.net/xterm/xterm-paste64.html
	    /* NOTE: From terminfo source: https://invisible-island.net/ncurses/terminfo.ti.html
	     * Bracketed paste was introduced by xterm patch #203 in May 2005, as part of a
	     * larger feature for manipulating the clipboard selection.  Few terminals aside
	     * from xterm fully implement the clipboard feature, but several copy this
	     * detail.  The names for the extended capabilities here were introduced by vim
	     * in January 2017, but used internally.  In 2023, vim patch 9.0.1117 is needed
	     * to work with this change. */
	    "\tBD=\\E[?2004l,BE=\\E[?2004h,PE=\\E[201~,PS=\\E[200~,\n"
	    "syncterm-bitmap|SyncTERM in Bitmap Mode,\n"
	    "\tccc,\n"
	    "\tcolors#256,pairs#65535,\n"
	    "\tinitc=\\E]4;%p1%d;rgb\\:%p2%{255}%*%{1000}%/%2.2X/%p3%{255}%*%{1000}%/%2.2X/%p4%{255}%*%{1000}%/%2.2X\\E\\\\,\n"
	    "\tsetab=\\E[%?%p1%{8}%<%t4%p1%d%e%p1%{16}%<%t10%p1%{8}%-%d%e48;5;%p1%d%;m,\n"
	    "\tsetaf=\\E[%?%p1%{8}%<%t3%p1%d%e%p1%{16}%<%t9%p1%{8}%-%d%e38;5;%p1%d%;m,\n"
	    "\tuse=syncterm,\n"
	    "syncterm-24|SyncTERM 80x25,\n"
	    "\tlines#24,use=syncterm,\n"
	    "syncterm-25|SyncTERM No Status Line,\n"
	    "\tlines#25,use=syncterm,\n"
	    "syncterm-27|SyncTERM 80x28 With Status,\n"
	    "\tlines#27,use=syncterm,\n"
	    "syncterm-28|SyncTERM 80x28 No Status Line,\n"
	    "\tlines#28,use=syncterm,\n"
	    "syncterm-42|SyncTERM 80x23,\n"
	    "\tlines#42,use=syncterm,\n"
	    "syncterm-43|SyncTERM 80x23 No Status Line,\n"
	    "\tlines#43,use=syncterm,\n"
	    "syncterm-49|SyncTERM 80x50,\n"
	    "\tlines#49,use=syncterm,\n"
	    "syncterm-50|SyncTERM 80x50 No Status Line,\n"
	    "\tlines#50,use=syncterm,\n"
	    "syncterm-59|SyncTERM 80x60,\n"
	    "\tlines#59,use=syncterm,\n"
	    "syncterm-60|SyncTERM 80x60 No Status Line,\n"
	    "\tlines#60,use=syncterm,\n"
	    "syncterm-w|SyncTERM Wide,\n"
	    "\tcols#132,use=syncterm,\n"
	    "syncterm-25-w|SyncTERM No Status Line,\n"
	    "\tcols#132,lines#25,use=syncterm,\n"
	    "syncterm-27-w|SyncTERM 132x28 With Status,\n"
	    "\tcols#132,lines#27,use=syncterm,\n"
	    "syncterm-28-w|SyncTERM 132x28 No Status Line,\n"
	    "\tcols#132,lines#28,use=syncterm,\n"
	    "syncterm-36-w|SyncTERM 132x37,\n"
	    "\tcols#132,lines#36,use=syncterm,\n"
	    "syncterm-37-w|SyncTERM 132x37 No Status Line,\n"
	    "\tcols#132,lines#37,use=syncterm,\n"
	    "syncterm-42-w|SyncTERM 132x23,\n"
	    "\tcols#132,lines#42,use=syncterm,\n"
	    "syncterm-43-w|SyncTERM 132x23 No Status Line,\n"
	    "\tcols#132,lines#43,use=syncterm,\n"
	    "syncterm-49-w|SyncTERM 132x50,\n"
	    "\tcols#132,lines#49,use=syncterm,\n"
	    "syncterm-50-w|SyncTERM 132x50 No Status Line,\n"
	    "\tcols#132,lines#50,use=syncterm,\n"
	    "syncterm-51-w|SyncTERM 132x52,\n"
	    "\tcols#132,lines#51,use=syncterm,\n"
	    "syncterm-52-w|SyncTERM 132x52 No Status Line,\n"
	    "\tcols#132,lines#52,use=syncterm,\n"
	    "syncterm-59-w|SyncTERM 132x60,\n"
	    "\tcols#132,lines#59,use=syncterm,\n"
	    "syncterm-60-w|SyncTERM 132x60 No Status Line,\n"
	    "\tcols#132,lines#60,use=syncterm,\n"
	    "syncterm-24-bitmap|SyncTERM 80x25,\n"
	    "\tlines#24,use=syncterm-bitmap,\n"
	    "syncterm-25-bitmap|SyncTERM No Status Line,\n"
	    "\tlines#25,use=syncterm-bitmap,\n"
	    "syncterm-27-bitmap|SyncTERM 80x28 With Status,\n"
	    "\tlines#27,use=syncterm-bitmap,\n"
	    "syncterm-28-bitmap|SyncTERM 80x28 No Status Line,\n"
	    "\tlines#28,use=syncterm-bitmap,\n"
	    "syncterm-42-bitmap|SyncTERM 80x23,\n"
	    "\tlines#42,use=syncterm-bitmap,\n"
	    "syncterm-43-bitmap|SyncTERM 80x23 No Status Line,\n"
	    "\tlines#43,use=syncterm-bitmap,\n"
	    "syncterm-49-bitmap|SyncTERM 80x50,\n"
	    "\tlines#49,use=syncterm-bitmap,\n"
	    "syncterm-50-bitmap|SyncTERM 80x50 No Status Line,\n"
	    "\tlines#50,use=syncterm-bitmap,\n"
	    "syncterm-59-bitmap|SyncTERM 80x60,\n"
	    "\tlines#59,use=syncterm-bitmap,\n"
	    "syncterm-60-bitmap|SyncTERM 80x60 No Status Line,\n"
	    "\tlines#60,use=syncterm-bitmap,\n"
	    "syncterm-w-bitmap|SyncTERM Wide,\n"
	    "\tcols#132,use=syncterm-bitmap,\n"
	    "syncterm-25-w-bitmap|SyncTERM No Status Line,\n"
	    "\tcols#132,lines#25,use=syncterm-bitmap,\n"
	    "syncterm-27-w-bitmap|SyncTERM 132x28 With Status,\n"
	    "\tcols#132,lines#27,use=syncterm-bitmap,\n"
	    "syncterm-28-w-bitmap|SyncTERM 132x28 No Status Line,\n"
	    "\tcols#132,lines#28,use=syncterm-bitmap,\n"
	    "syncterm-36-w-bitmap|SyncTERM 132x37,\n"
	    "\tcols#132,lines#36,use=syncterm-bitmap,\n"
	    "syncterm-37-w-bitmap|SyncTERM 132x37 No Status Line,\n"
	    "\tcols#132,lines#37,use=syncterm-bitmap,\n"
	    "syncterm-42-w-bitmap|SyncTERM 132x23,\n"
	    "\tcols#132,lines#42,use=syncterm-bitmap,\n"
	    "syncterm-43-w-bitmap|SyncTERM 132x23 No Status Line,\n"
	    "\tcols#132,lines#43,use=syncterm-bitmap,\n"
	    "syncterm-49-w-bitmap|SyncTERM 132x50,\n"
	    "\tcols#132,lines#49,use=syncterm-bitmap,\n"
	    "syncterm-50-w-bitmap|SyncTERM 132x50 No Status Line,\n"
	    "\tcols#132,lines#50,use=syncterm-bitmap,\n"
	    "syncterm-51-w-bitmap|SyncTERM 132x52,\n"
	    "\tcols#132,lines#51,use=syncterm-bitmap,\n"
	    "syncterm-52-w-bitmap|SyncTERM 132x52 No Status Line,\n"
	    "\tcols#132,lines#52,use=syncterm-bitmap,\n"
	    "syncterm-59-w-bitmap|SyncTERM 132x60,\n"
	    "\tcols#132,lines#59,use=syncterm-bitmap,\n"
	    "syncterm-60-w-bitmap|SyncTERM 132x60 No Status Line,\n"
	    "\tcols#132,lines#60,use=syncterm-bitmap,\n";

	if ((argc == 2) && (strcmp(argv[1], "-T") == 0)) {
		return write(STDOUT_FILENO, syncterm_termcap, strlen(syncterm_termcap)) > 0 ? EXIT_SUCCESS : EXIT_FAILURE;
	}
	if ((argc == 2) && (strcmp(argv[1], "-v") == 0)) {
		fprintf(stdout, "%s\n", syncterm_version);
		return 0;
	}

#if !defined(WITHOUT_CRYPTLIB)
        /* Cryptlib initialization MUST be done before ciolib init */
        init_crypt();
#endif

        /* UIFC initialization */
	memset(&uifc, 0, sizeof(uifc));
	uifc.mode = UIFC_NOCTRL | UIFC_NHM;
	uifc.size = sizeof(uifc);
	uifc.esc_delay = 25;
	uifc.insert_mode = TRUE;
	uifc.reverse_cursor = TRUE;
	url[0] = 0;

	/*
	 * We need to parse -n and -b before we call load_settings()
	 * so that get_syncterm_filename works properly
	 */
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-'
#ifndef __unix__
		    || argv[i][0] == '/'
#endif
		    ) {
			switch (toupper(argv[i][1])) {
				case 'B':
					if (argv[i][2] == 0) {
						if ((i + 1) < argc)
							list_override = argv[++i];
						// Error handling below
					}
					else {
						list_override = &argv[i][2];
					}
					break;
				case 'N':
					if (argv[i][2] == 0) {
						if ((i + 1) < argc)
							config_override = argv[++i];
						// Error handling below
					}
					else {
						config_override = &argv[i][2];
					}
					break;
			}
		}
	}

	load_settings(&settings);
	ciolib_swap_mouse_butt45 = settings.invert_wheel;
	cvmode = find_vmode(CIOLIB_MODE_CUSTOM);
	vparams[cvmode].cols = settings.custom_cols;
	vparams[cvmode].rows = settings.custom_rows;
	vparams[cvmode].charheight = settings.custom_fontheight;
	vparams[cvmode].aspect_width = settings.custom_aw;
	vparams[cvmode].aspect_height = settings.custom_ah;
	ciolib_initial_icon = syncterm_icon.pixel_data;
	ciolib_initial_icon_width = syncterm_icon.width;
	ciolib_initial_scaling = settings.scaling_factor;
	ciolib_initial_program_name = "syncterm";
	ciolib_initial_program_class = "SyncTERM";
	ciolib_mode = settings.output_mode;
	xpbeep_sound_devices_enabled = settings.audio_output_modes;
	if (settings.startup_mode != SCREEN_MODE_CURRENT)
		text_mode = screen_to_ciolib(settings.startup_mode);
	else
		text_mode = _ORIGMODE;
	ciolib_initial_mode = text_mode;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-'
#ifndef __unix__
		    || argv[i][0] == '/'
#endif
		    ) {
			switch (toupper(argv[i][1])) {
				case '6':
					addr_family = ADDRESS_FAMILY_INET6;
					break;
				case '4':
					addr_family = ADDRESS_FAMILY_INET;
					break;
				case 'B':
					if (argv[i][2] == 0) {
						if ((i + 1) < argc) {
							// This has already been parsed above...
							//list_override = argv[++i];
						}
						else
							goto USAGE;
					}
					else {
						// This has already been parsed above...
						//list_override = &argv[i][2];
					}
					break;
				case 'N':
					if (argv[i][2] == 0) {
						if ((i + 1) < argc) {
							// This has already been parsed above...
							//config_override = argv[++i];
						}
						else
							goto USAGE;
					}
					else {
						// This has already been parsed above...
						//config_override = &argv[i][2];
					}
					break;
				case 'C':
					default_nostatus = 1;
					break;
				case 'E':
					uifc.esc_delay = atoi(argv[i] + 2);
					break;
				case 'I':
					switch (toupper(argv[i][2])) {
						case 'A':
							ciolib_mode = CIOLIB_MODE_ANSI;
							break;
						case 'C':
							ciolib_mode = CIOLIB_MODE_CURSES;
							break;
						case 'F':
							ciolib_mode = CIOLIB_MODE_CURSES_IBM;
							break;
						case 'G':
							switch (toupper(argv[i][3])) {
								case 0:
								case 'W':
									ciolib_mode = CIOLIB_MODE_GDI;
									break;
								case 'F':
									ciolib_mode = CIOLIB_MODE_GDI_FULLSCREEN;
									break;
							}
							break;
						case 'I':
							ciolib_mode = CIOLIB_MODE_CURSES_ASCII;
							break;
						case 'X':
							switch (toupper(argv[i][3])) {
								case 0:
								case 'W':
									ciolib_mode = CIOLIB_MODE_X;
									break;
								case 'F':
									ciolib_mode = CIOLIB_MODE_X_FULLSCREEN;
									break;
							}
							break;
						case 'W':
							ciolib_mode = CIOLIB_MODE_CONIO;
							break;
						case 'S':
							switch (toupper(argv[i][3])) {
								case 0:
								case 'W':
									ciolib_mode = CIOLIB_MODE_SDL;
									break;
								case 'F':
									ciolib_mode = CIOLIB_MODE_SDL_FULLSCREEN;
									break;
							}
							break;
						default:
							goto USAGE;
					}
					break;
				case 'L':
					switch (atoi(argv[i] + 2)) {
						case 14:
							text_mode = C80X14;
							break;
						case 21:
							text_mode = C80X21;
							break;
						case 25:
							text_mode = C80;
							break;
						case 28:
							text_mode = C80X28;
							break;
						case 30:
							text_mode = C80X30;
							break;
						case 43:
							text_mode = C80X43;
							break;
						case 50:
							text_mode = C80X50;
							break;
						case 60:
							text_mode = C80X60;
							break;
						default:
							text_mode = C4350;
							break;
					}
					break;
#ifdef __DARWIN__
				case 'P':
					if (strncmp("-psn_", argv[i], 5) == 0)
						break;
					goto USAGE;
#endif
				case 'R':
					conn_type = CONN_TYPE_RLOGIN;
					override_conn = true;
					break;
				case 'H':
					conn_type = CONN_TYPE_SSH;
					override_conn = true;
					break;
				case 'T':
					conn_type = CONN_TYPE_TELNET;
					override_conn = true;
					break;
				case 'S':
					safe_mode = 1;
					break;
				case 'Q':
					default_hidepopups = 1;
					break;
				default:
					goto USAGE;
			}
		}
		else {
			SAFECOPY(url, argv[i]);
		}
	}

	if (settings.blocky)
		cio_api.options |= CONIO_OPT_BLOCKY_SCALING;
	else
		cio_api.options &= ~CONIO_OPT_BLOCKY_SCALING;
	ciolib_initial_scaling_type = (settings.extern_scale ? CIOLIB_SCALING_EXTERNAL : CIOLIB_SCALING_INTERNAL);
	if (initciolib(ciolib_mode))
		return 1;
	setname("SyncTERM");
	if (settings.blocky)
		cio_api.options |= CONIO_OPT_BLOCKY_SCALING;
	else
		cio_api.options &= ~CONIO_OPT_BLOCKY_SCALING;
	ciolib_reaper = false;
	seticon(syncterm_icon.pixel_data, syncterm_icon.width);
	textmode(text_mode);
	if (settings.scaling_factor)
		setscaling(settings.scaling_factor);

	gettextinfo(&txtinfo);
	if ((txtinfo.screenwidth < 40) || (txtinfo.screenheight < 24)) {
		fputs("Window too small, must be at least 40x24\n", stderr);
		return 1;
	}

	if (inpath == NULL) {
		_splitpath(argv[0], drive, path, fname, ext);
		strcat(drive, path);
	}
	else {
		FULLPATH(path, inpath, sizeof(path));
	}
	atexit(uifcbail);

#ifdef __unix__
	umask(077);
#endif

	check_upgrade();
#if 0
 #ifdef ALPHA
	init_uifc(true, true);
	uifc.showbuf(WIN_SAV | WIN_MID | WIN_HLP, 0, 0, 76, uifc.scrn_len - 2, "WARNING: ALPHA VERSION",
	    "This is an ~`ALPHA`~ version\n"
	    "\n"
	    "It has both known and unknown issues and is not believed to be suitable\n"
	    "for use. By using it, you are agreeing to be free QA to find and report bugs.\n"
	    "\n"
	    "There are expected to be many bugs.\n"
	    "\n"
	    "Bugs should be reported at `http://sf.net/p/syncterm/tickets/`\n"
	    "when reporting bugs, please register with a valid email so I can follow\n"
	    "up with additional questions.\n"
	    "\n"
	    "This message will appear every time you start this program.  Please\n"
	    "consider running the latest release from:\n"
	    "`https://sourceforge.net/projects/syncterm/files/latest/download`\n"
	    "if you want a terminal that works.",
	    NULL, NULL);
	uifcbail();
 #endif /* ifdef ALPHA */
#endif /* if 0 */

        /* Auto-connect URL */
	if (url[0]) {
		if ((bbs = (struct bbslist *)malloc(sizeof(struct bbslist))) == NULL) {
			uifcmsg("Unable to allocate memory", "The system was unable to allocate memory.");
			return 1;
		}
		bbs_alloc = true;
		memset(bbs, 0, sizeof(struct bbslist));
		if ((listfile = fopen(settings.list_path, "r")) == NULL) {
			parse_url(url, bbs, conn_type, true);
		}
		else {
			str_list_t inilines;
			inilines = iniReadFile(listfile);
			fclose(listfile);
			read_item(inilines, bbs, NULL, 0, USER_BBSLIST);
			if (override_conn) {
				if (conn_type != bbs->conn_type)
					bbs->port = conn_ports[conn_type];
				bbs->conn_type = conn_type;
			}
			parse_url(url, bbs, conn_type, false);
			strListFree(&inilines);
		}
		if (addr_family != ADDRESS_FAMILY_UNSPEC)
			bbs->address_family = addr_family;
		if (bbs->port == 0)
			goto USAGE;
	}

	if (!winsock_startup())
		return 1;

	if (settings.webgets && !quitting) {
		// Update the web list caches...

		init_uifc(true, true);
		char cache_path[MAX_PATH + 1];
		if (get_syncterm_filename(cache_path, sizeof(cache_path), SYNCTERM_PATH_SYSTEM_CACHE, false)) {
			size_t items;
			size_t started = 0;
			COUNT_LIST_ITEMS(settings.webgets, items);
			struct webget_request *reqs = calloc(items, sizeof(struct webget_request));
			sem_init(&download_complete_sem, 0, 0);
			for (size_t i = 0; i < items; i++) {
				if (init_webget_req(&reqs[i], cache_path, settings.webgets[i]->name, settings.webgets[i]->value)) {
					reqs[i].cb_data = i;
					_beginthread(download_thread, 0, &reqs[i]);
					started++;
				}
				else {
					reqs[i].cb_data = UINT64_C(0x8000000000000000) | i;
				}
			}
			while (started > 0) {
				if (sem_trywait_block(&download_complete_sem, 200) == 0) {
					started--;
				}
				update_webget_progress(reqs, items, false);
			}
			sem_destroy(&download_complete_sem);
			update_webget_progress(reqs, items, true);
		}
		uifcbail();
	}
	load_font_files();
	while ((!quitting) && (bbs != NULL || (bbs = show_bbslist(last_bbs, false)) != NULL)) {
		if (default_hidepopups >= 0)
			bbs->hidepopups = default_hidepopups;
		if (default_nostatus >= 0)
			bbs->nostatus = default_nostatus;
		gettextinfo(&txtinfo); /* Current mode may have changed while in show_bbslist() */
		FREE_AND_NULL(last_bbs);
		uifcbail();
		if (bbs->screen_mode != SCREEN_MODE_CURRENT)
			fake_mode = screen_to_ciolib(bbs->screen_mode);
		textmode(screen_to_ciolib(bbs->screen_mode));
		if (!bbs->hidepopups)
			init_uifc(true, true);
		load_font_files();
		setfont(find_font_id(bbs->font), true, 1);
		if (conn_connect(bbs)) {
			load_font_files();
			uifcbail();
			textmode(txtinfo.currmode);
			fake_mode = -1;
			init_uifc(true, true);
			settitle("SyncTERM");
		}
		else {
                        /*
                         * ToDo: Update the entry with new lastconnected
                         * ToDo: Disallow duplicate entries
                         */
			bbs->connected = time(NULL);
			bbs->fast_connected = xp_fast_timer64();
			bbs->calls++;
			if (bbs->id != -1) {
				if (bbs->type == SYSTEM_BBSLIST) {
					bbs->type = USER_BBSLIST;
					add_bbs(settings.list_path, bbs, false);
				}
				if ((listfile = fopen(settings.list_path, "r")) != NULL) {
					inifile = iniReadFile(listfile);
					fclose(listfile);
					iniSetDateTime(&inifile,
					    bbs->name,
					    "LastConnected",
					    true,
					    bbs->connected,
					    &ini_style);
					iniSetInteger(&inifile, bbs->name, "TotalCalls", bbs->calls, &ini_style);
					if ((listfile = fopen(settings.list_path, "w")) != NULL) {
						iniWriteFile(listfile, inifile);
						fclose(listfile);
					}
					strListFree(&inifile);
				}
			}
			uifcbail();
			sprintf(str, "SyncTERM - %s", bbs->name);
			settitle(str);
			term.nostatus = bbs->nostatus;
			if (drawwin())
				return 1;
			if ((log_fp == NULL) && bbs->logfile[0])
				log_fp = fopen(bbs->logfile, bbs->append_logfile ? "a" : "w");
			if (log_fp != NULL) {
				time_t now = time(NULL);
				fprintf(log_fp, "%.15s Log opened\n", ctime(&now) + 4);
			}

			for (i = CONIO_FIRST_FREE_FONT; i < 256; i++) {
				FREE_AND_NULL(conio_fontdata[i].eight_by_sixteen);
				FREE_AND_NULL(conio_fontdata[i].eight_by_fourteen);
				FREE_AND_NULL(conio_fontdata[i].eight_by_eight);
				FREE_AND_NULL(conio_fontdata[i].twelve_by_twenty);
				FREE_AND_NULL(conio_fontdata[i].desc);
			}
			load_font_files();
			setfont(find_font_id(bbs->font), true, 1);
			if (bbs->yellow_is_yellow) {
				dac_default[3].red = dac_default[1].red;
				dac_default[3].green = dac_default[2].green;
				dac_default[3].blue = dac_default[0].blue;
			}
			if (doterm(bbs))
				quitting = true;
			dac_default[3].red = saved_red;
			dac_default[3].green = saved_green;
			dac_default[3].blue = saved_blue;
			fake_mode = -1;
			setvideoflags(0);

			if (log_fp != NULL) {
				time_t now = time(NULL);
				fprintf(log_fp, "%.15s Log closed\n", ctime(&now) + 4);
				fprintf(log_fp, "---------------\n");
				fclose(log_fp);
				log_fp = NULL;
			}
			textmode(txtinfo.currmode);
			settitle("SyncTERM");
		}
		if (quitting || url[0]) {
			if ((bbs != NULL) && (bbs->id == -1)) {
				if (!safe_mode) {
					if (settings.prompt_save) {
						char *YesNo[3] = {"Yes", "No", ""};

                                                /* Started from the command-line with a URL */
						init_uifc(true, true);
						i = 1;
						if (!bbs->hidepopups) {
							switch (uifc.list(WIN_MID | WIN_SAV, 0, 0, 0, &i, NULL,
							    "Save this directory entry?", YesNo)) {
								case 0: /* Yes */
									edit_list(NULL, bbs, settings.list_path, false);
									add_bbs(settings.list_path, bbs, false);
									last_bbs = strdup(bbs->name);
									break;
								default: /* ESC/No */
									break;
							}
						}
					}
				}
			}
			if (bbs_alloc) {
				bbs_alloc = false;
				free(bbs);
			}
			bbs = NULL;
			break;
		}
		else {
			last_bbs = strdup(bbs->name);
		}
		if (bbs_alloc) {
			bbs_alloc = false;
			free(bbs);
		}
		bbs = NULL;
	}
	for (i = CONIO_FIRST_FREE_FONT; i < 256; i++) {
		FREE_AND_NULL(conio_fontdata[i].eight_by_sixteen);
		FREE_AND_NULL(conio_fontdata[i].eight_by_fourteen);
		FREE_AND_NULL(conio_fontdata[i].eight_by_eight);
		FREE_AND_NULL(conio_fontdata[i].twelve_by_twenty);
		FREE_AND_NULL(conio_fontdata[i].desc);
	}
	if (bbs_alloc)
		free(bbs);
	if (last_bbs)
		free(last_bbs);

        // Save changed settings
	gettextinfo(&txtinfo);

        // Only save window info if we're in the startup mode...
	if ((txtinfo.currmode == screen_to_ciolib(settings.startup_mode))
	    || ((settings.startup_mode == SCREEN_MODE_CURRENT) && (txtinfo.currmode == C80))) {
		sf = getscaling();
		if (((sf > 0.0) && (sf != settings.scaling_factor))) {
			char       inipath[MAX_PATH + 1];
			FILE      *inifile;
			str_list_t inicontents;

			get_syncterm_filename(inipath, sizeof(inipath), SYNCTERM_PATH_INI, false);
			if ((inifile = fopen(inipath, "r")) != NULL) {
				inicontents = iniReadFile(inifile);
				fclose(inifile);
			}
			else {
				inicontents = strListInit();
			}
			if ((sf > 0.0) && (sf != settings.scaling_factor)) {
				iniSetFloat(&inicontents, "SyncTERM", "ScalingFactor", sf, &ini_style);
			}
			if ((inifile = fopen(inipath, "w")) != NULL) {
				iniWriteFile(inifile, inicontents);
				fclose(inifile);
			}
		}
	}

	uifcbail();
#ifdef _WINSOCKAPI_
	if (WSAInitialized && (WSACleanup() != 0))
		fprintf(stderr, "!WSACleanup ERROR %d", ERROR_VALUE);
#endif
	return 0;

USAGE:
	if (bbs_alloc)
		free(bbs);
	if (cio_api.mode == CIOLIB_MODE_AUTO && isatty(STDOUT_FILENO))
		initciolib(CIOLIB_MODE_ANSI);
	uifcbail();
	clrscr();
	gettextinfo(&txtinfo);
	p = lp = usage;
	textattr(LIGHTGRAY);
	gettextinfo(&txtinfo);
	i = 0;
	for (lp = usage; *lp; p = strchr(lp, '\n')) {
		if (p == NULL)
			p = strchr(lp, 0) - 1;
		cprintf("%.*s", p - lp + 1, lp);
		lp = p + 1;
		i++;
		if (i >= txtinfo.screenheight - 1) {
			textattr(WHITE);
			cputs("<Press A Key>");
			switch (getch()) {
				case 0:
				case 0xe0:
					getch();
			}
			textattr(LIGHTGRAY);
			gotoxy(1, txtinfo.screenheight);
			delline();
			i = 0;
		}
	}
	textattr(WHITE);
	if (cio_api.mode == CIOLIB_MODE_ANSI) {
		cprintf("\n");
	}
	else {
		cputs("<Press A Key to Exit>");
		switch (getch()) {
			case 0:
			case 0xe0:
				getch();
		}
	}
	textattr(LIGHTGRAY);
	return 0;
}

int
screen_to_ciolib(int screen)
{
	struct text_info ti;

	switch (screen) {
		case SCREEN_MODE_CURRENT:
			gettextinfo(&ti);
			return ti.currmode;
		case SCREEN_MODE_80X25:
			return C80;
		case SCREEN_MODE_LCD80X25:
			return LCD80X25;
		case SCREEN_MODE_80X28:
			return C80X28;
		case SCREEN_MODE_80X30:
			return C80X30;
		case SCREEN_MODE_80X43:
			return C80X43;
		case SCREEN_MODE_80X50:
			return C80X50;
		case SCREEN_MODE_80X60:
			return C80X60;
		case SCREEN_MODE_132X37:
			return ST132X37_16_9;
		case SCREEN_MODE_132x52:
			return ST132X52_5_4;
		case SCREEN_MODE_132X25:
			return VESA_132X25;
		case SCREEN_MODE_132X28:
			return VESA_132X28;
		case SCREEN_MODE_132X30:
			return VESA_132X30;
		case SCREEN_MODE_132X34:
			return VESA_132X34;
		case SCREEN_MODE_132X43:
			return VESA_132X43;
		case SCREEN_MODE_132X50:
			return VESA_132X50;
		case SCREEN_MODE_132X60:
			return VESA_132X60;
		case SCREEN_MODE_C64:
			return C64_40X25;
		case SCREEN_MODE_C128_40:
			return C128_40X25;
		case SCREEN_MODE_C128_80:
			return C128_80X25;
		case SCREEN_MODE_ATARI:
			return ATARI_40X24;
		case SCREEN_MODE_ATARI_XEP80:
			return ATARI_80X25;
		case SCREEN_MODE_CUSTOM:
			return CIOLIB_MODE_CUSTOM;
		case SCREEN_MODE_EGA_80X25:
			return EGA80X25;
		case SCREEN_MODE_VGA_80X25:
			return VGA80X25;
		case SCREEN_MODE_PRESTEL:
		case SCREEN_MODE_BEEB:
			return PRESTEL_40X25;
		case SCREEN_MODE_ATARIST_40X25:
			return ATARIST_40X25;
		case SCREEN_MODE_ATARIST_80X25:
			return ATARIST_80X25;
		case SCREEN_MODE_ATARIST_80X25_MONO:
			return ATARIST_80X25_MONO;
	}
	gettextinfo(&ti);
	return ti.currmode;
}

int
ciolib_to_screen(int ciolib)
{
	switch (ciolib) {
		case C80:
			return SCREEN_MODE_80X25;
		case LCD80X25:
			return SCREEN_MODE_LCD80X25;
		case C80X28:
			return SCREEN_MODE_80X28;
		case C80X30:
			return SCREEN_MODE_80X30;
		case C80X43:
			return SCREEN_MODE_80X43;
		case C80X50:
			return SCREEN_MODE_80X50;
		case C80X60:
			return SCREEN_MODE_80X60;
		case ST132X37_16_9:
			return SCREEN_MODE_132X37;
		case ST132X52_5_4:
			return SCREEN_MODE_132x52;
		case VESA_132X25:
			return SCREEN_MODE_132X25;
		case VESA_132X28:
			return SCREEN_MODE_132X28;
		case VESA_132X30:
			return SCREEN_MODE_132X30;
		case VESA_132X34:
			return SCREEN_MODE_132X34;
		case VESA_132X43:
			return SCREEN_MODE_132X43;
		case VESA_132X50:
			return SCREEN_MODE_132X50;
		case VESA_132X60:
			return SCREEN_MODE_132X60;
		case C64_40X25:
			return SCREEN_MODE_C64;
		case C128_40X25:
			return SCREEN_MODE_C128_40;
		case C128_80X25:
			return SCREEN_MODE_C128_80;
		case ATARI_40X24:
			return SCREEN_MODE_ATARI;
		case ATARI_80X25:
			return SCREEN_MODE_ATARI_XEP80;
		case CIOLIB_MODE_CUSTOM:
			return SCREEN_MODE_CUSTOM;
		case EGA80X25:
			return SCREEN_MODE_EGA_80X25;
		case VGA80X25:
			return SCREEN_MODE_VGA_80X25;
		case PRESTEL_40X25:
			return SCREEN_MODE_PRESTEL;
		case ATARIST_40X25:
			return SCREEN_MODE_ATARIST_40X25;
		case ATARIST_80X25:
			return SCREEN_MODE_ATARIST_80X25;
		case ATARIST_80X25_MONO:
			return SCREEN_MODE_ATARIST_80X25_MONO;
	}
	return SCREEN_MODE_CURRENT;
}

#if defined(_WIN32) && defined(DLLIFY)
__declspec(dllexport) int __cdecl stub_main(int argc, char *argv[], char **env)
{
	int n;
	char *bufp, *appname;

	/* Get the class name from argv[0] */
	appname = argv[0];
	if ( (bufp=strrchr(argv[0], '\\')) != NULL ) {
		appname = bufp+1;
	} else
	if ( (bufp=strrchr(argv[0], '/')) != NULL ) {
		appname = bufp+1;
	}

	if ( (bufp=strrchr(appname, '.')) == NULL )
		n = strlen(appname);
	else
		n = (bufp-appname);

	bufp = (char *)alloca(n+1);
	if ( bufp == NULL ) {
		return 1;
	}
	strncpy(bufp, appname, n);
	bufp[n] = '\0';
	ciolib_appname = bufp;

	/* Run the application main() code */
	n=CIOLIB_main(argc, argv);

	/* Exit cleanly, calling atexit() functions */
	exit(n);

	/* Hush little compiler, don't you cry... */
	return(n);
}

#endif
