#!/bin/sh
##	
##	install.sh
##
##	Last modified: 01/02/03
##
##	This script correctly positions the compiled OggVorbis.framework in 
##	the root Library directory.
##
##	Remember to use "chmod +x install.sh" before running this
##	script. 
##
##	This script is distributed as part of the FreeCraft software package
##	and is therefore subject to the GNU General Public License.

##	Correctly position the OggVorbis.framework
if  [ -e build/OggVorbis.framework ]
then

	if	[ -e build/OggVorbis.framework/Headers/ogg/Makefile.am ]
	then
		rm build/OggVorbis.framework/Headers/ogg/Makefile.am
	fi
	if	[ -e build/OggVorbis.framework/Headers/ogg/Makefile.in ]
	then
		rm build/OggVorbis.framework/Headers/ogg/Makefile.in
	fi
	if	[ -e build/OggVorbis.framework/Headers/ogg/config_types.h.in ]
	then
		rm build/OggVorbis.framework/Headers/ogg/config_types.h.in
	fi
	if	[ -e build/OggVorbis.framework/Headers/vorbis/Makefile.am ]
	then
		rm build/OggVorbis.framework/Headers/vorbis/Makefile.am
	fi
	if	[ -e build/OggVorbis.framework/Headers/vorbis/Makefile.in ]
	then
		rm build/OggVorbis.framework/Headers/vorbis/Makefile.in
	fi
	
	if  [ -e /Library/Frameworks/OggVorbis.framework ]
	then
		rm -r /Library/Frameworks/OggVorbis.framework
	fi
	cp -R build/OggVorbis.framework /Library/Frameworks/OggVorbis.framework
else
	printf "Error: OggVorbis.framework cannot be found.\n"
	exit 1
fi

##	All done
exit 0
	