#!/bin/sh
##	
##	clean.sh
##
##	Last modified: 01/02/03
##	
##	The script removes all non-essential files from the macosx directory
##	and develops a file called macosx.tgz for posting to the CVS. Running
##	it is not necessary unless you intend to contribute back changes of
##	the Mac OS X specific code to the CVS.
##
##	Remember to use "chmod +x clean.sh" before running this
##	script. 
##
##	This script is distributed as part of the FreeCraft software package 
##	and is therefore subject to the GNU General Public License.

##	Remove build directories

if [ -e build ]
then
	rm -r build
fi

if [ -e installer/build ]
then
	rm -r installer/build
fi

if [ -e wartool/build ]
then
	rm -r wartool/build
fi

if [ -e frameworks/build ]
then
	rm -r frameworks/build
fi

##	Remove *.pbxuser files

if [ -f FreeCraft.pbproj/*.pbxuser ]
then
	rm FreeCraft.pbproj/*.pbxuser
fi

if [ -f LibModPlug.pbproj/*.pbxuser ]
then
	rm LibModPlug.pbproj/*.pbxuser
fi

if [ -f wartool/WarTool.pbproj/*.pbxuser ]
then
	rm wartool/WarTool.pbproj/*.pbxuser
fi

if [ -f installer/FreeInstall.pbproj/*.pbxuser ]
then
	rm installer/FreeInstall.pbproj/*.pbxuser
fi

if [ -f frameworks/PNG.pbproj/*.pbxuser ]
then
	rm frameworks/PNG.pbproj/*.pbxuser
fi

if [ -f frameworks/OggVorbis.pbproj/*.pbxuser ]
then
	rm frameworks/OggVorbis.pbproj/*.pbxuser
fi

##	Remove Installer files

if [ -e installer/resources ]
then
	rm -r installer/resources
fi

if [ -e installer/tools ]
then
	rm -r installer/tools
fi

if [ -e installer/freecraft ]
then
	rm -r installer/freecraft
fi

##	Remove WarTool files

if [ -f wartool/wartool.m ]
then
	rm wartool/wartool.m
fi

##	Move libpng, libogg and libvorbis to /tmp

if [ -e frameworks/libpng-1.2.5 ]
then
	mv frameworks/libpng-1.2.5 /tmp/libpng-1.2.5
fi

if [ -e frameworks/libogg-1.0 ]
then
	mv frameworks/libogg-1.0 /tmp/libogg-1.0
fi

if [ -e frameworks/libvorbis-1.0 ]
then
	mv frameworks/libvorbis-1.0 /tmp/libvorbis-1.0
fi

##	Make macosx.tgz

cd ..

if [ -f macosx.tar ]
then
	rm macosx.tar
fi

if [ -f macosx.tar.gz ]
then
	rm macosx.tar.gz
fi

if [ -f macosx.tgz ]
then
	rm macosx.tgz
fi

tar -cf macosx.tar macosx
gzip macosx.tar
mv macosx.tar.gz macosx.tgz

cd macosx

##	Put libpng, libogg and libvorbis back in place

if [ -e /tmp/libpng-1.2.5 ]
then
	mv /tmp/libpng-1.2.5 frameworks/libpng-1.2.5
fi

if [ -e /tmp/libogg-1.0 ]
then
	mv /tmp/libogg-1.0 frameworks/libogg-1.0
fi

if [ -e /tmp/libvorbis-1.0 ]
then
	mv /tmp/libvorbis-1.0 frameworks/libvorbis-1.0
fi