/*	
	AutoCL.m

	AutoCL allows the user to specify a command line through a user-friendly interface
	it will then return that command line for the application until it is next changed.
	The command line is stored on disk so that it persists after exit.
	
	Licensed under the GNU General Public License
*/

extern int		gArgc;
extern char		**gArgv;

#import "AutoCL.h"

@implementation AutoCL

- (void)editCL:(id)sender
{
	NSString *defaultCLString;
	
	// Get the default command line from the preferences file
	defaultCLString = [[NSUserDefaults standardUserDefaults] stringForKey:@"defaultCL"];
	if (defaultCLString != NULL)
		[clInput setStringValue:defaultCLString];
	else
		[clInput setStringValue:kOriginalDefaultCL];
	
	// Display the editing panel and return when finished
	[NSApp runModalForWindow:clPanel];
}

- (IBAction)commitCL:(id)sender
{
	// Commit the changes
	[[NSUserDefaults standardUserDefaults] setObject:[clInput stringValue] forKey:@"defaultCL"];
	[[NSUserDefaults standardUserDefaults] synchronize];
	
	// Shut the panel
	[NSApp stopModal];
	[clPanel orderOut:NULL];
}

- (IBAction)revertCL:(id)sender
{
	// Set string back to original
	[clInput setStringValue:kOriginalDefaultCL];
}

- (void)updateArguments
{
	NSString *defaultCLString;
	const char *inputString;
	int i, i2;
	
	// Get the appropriate configuration string
	defaultCLString = [[NSUserDefaults standardUserDefaults] stringForKey:@"defaultCL"];
	if (defaultCLString != NULL)
		inputString = [defaultCLString cString];
	else
		inputString = [kOriginalDefaultCL cString];

	// Separate the string into individual pieces
	gArgc = 1;
	gArgv = malloc (sizeof(*gArgv) * (gArgc+1));
	gArgv[0] = malloc(24);
	strcpy(gArgv[0], "./dummy");
	for (i = 0; i < strlen(inputString) && gArgc < 24; i++) {
		
		// We have a quotation mark
		if (inputString[i] == '"') {
			gArgv[gArgc] = malloc(512);
			i++; i2 = i;
			while (i < strlen(inputString) && inputString[i] != '"' && i - i2 < 511) {
				gArgv[gArgc][i - i2] = inputString[i];
				i++;
			}
			gArgv[gArgc][i - i2] = 0x00;
			gArgv[gArgc] = realloc(gArgv[gArgc], i - i2 + 1);
			gArgc++;
			continue;
		}
		
		// We have an apostrophe mark
		if (inputString[i] == '\'') {
			gArgv[gArgc] = malloc(512);
			i++; i2 = i;
			while (i < strlen(inputString) && inputString[i] != '\'' && i - i2 < 511) {
				gArgv[gArgc][i - i2] = inputString[i];
				i++;
			}
			gArgv[gArgc][i - i2] = 0x00;
			gArgv[gArgc] = realloc(gArgv[gArgc], i - i2 + 1);
			gArgc++;
			continue;
		}
		
		// We have something which isn't a space
		if (inputString[i] != ' ') {
			gArgv[gArgc] = malloc(512);
			i2 = i;
			while (i < strlen(inputString) && inputString[i] != ' ' && inputString[i] != '\'' &&  inputString[i] != '"' && i - i2 < 511) {
				if (i < strlen(inputString) - 1 && inputString[i] == '\\')
					i++;
				gArgv[gArgc][i - i2] = inputString[i];
				i++;
			}
			gArgv[gArgc][i - i2] = 0x00;
			gArgv[gArgc] = realloc(gArgv[gArgc], i - i2 + 1);
			i--;
			gArgc++;
			continue;
		}
		
	}
}

@end
