/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
// This file contains code for various UNIX MDP post processor options
        
        
/*******************************************************************
 * Netscape[tm] post processor routines
 */     
        
// Some portions of this code 
// Copyright  1996 Netscape Communications Corporation, 
// all rights reserved.
        
#include <stdio.h>
#include "postProcess.h"
#include <X11/Xatom.h>
#include <X11/Xmu/WinUtil.h>	/* for XmuClientWindow() */

/* vroot.h is a header file which lets a client get along with `virtual root'
   window managers like swm, tvtwm, olvwm, etc.  If you don't have this header
   file, you can find it at "http://home.netscape.com/newsref/std/vroot.h".
   If you don't care about supporting virtual root window managers, you can
   comment this line out.
 */
#include "vroot.h"


#define MOZILLA_VERSION_PROP   "_MOZILLA_VERSION"
static Atom XA_MOZILLA_VERSION  = 0;

bool NetscapeIsRunning(Window *result)
{
    int i;
    
    Window root2, parent, *kids;
    unsigned int nkids;
    *result = 0;
    
    Display *dpy = XOpenDisplay(NULL);
    if (!dpy) 
    {
        fprintf(stderr, "mdp: XOpenDisplay() error\n");
        return false;
    }
    
    if (!XA_MOZILLA_VERSION) 
        XA_MOZILLA_VERSION = XInternAtom(dpy, MOZILLA_VERSION_PROP, False);
    
    Window root = RootWindowOfScreen(DefaultScreenOfDisplay(dpy));
    
    if (!XQueryTree (dpy, root, &root2, &parent, &kids, &nkids))
    {
        fprintf(stderr, "mdp: XQueryTree failed on display %s\n", DisplayString (dpy));
        XCloseDisplay(dpy);
        return false;
    }

    // Note: root != root2 is possible with virtual root WMs.
    if (!(kids && nkids))
    {
        fprintf(stderr, "mdp: root window has no children on display %s\n",
             DisplayString (dpy));
        XCloseDisplay(dpy);
        return false;
    }

    for (i = nkids-1; i >= 0; i--)
    {
        Atom type;
        int format;
        unsigned long nitems, bytesafter;
        unsigned char *version = 0;
        Window w = XmuClientWindow (dpy, kids[i]);
        int status = XGetWindowProperty (dpy, w, XA_MOZILLA_VERSION,
			           0, (65536 / sizeof (long)),
			           False, XA_STRING,
			           &type, &format, &nitems, &bytesafter,
			           &version);
        if (! version) continue;
        XFree (version);
        if (status == Success && type != None)
	    {
	        *result = w;
	        break;
	    }
    }
    XCloseDisplay(dpy);       
    return (*result ? true : false);
  
}  // end NetscapeIsRunning()

bool NetscapeCheckWindow(Window window)
{
    int i;   
    Window root2, parent, *kids;
    unsigned int nkids;
    
    Display *dpy = XOpenDisplay(NULL);
    if (!dpy) 
    {
        fprintf(stderr, "mdp: XOpenDisplay() error\n");
        return false;
    }
    
    if (!XA_MOZILLA_VERSION) 
        XA_MOZILLA_VERSION = XInternAtom(dpy, MOZILLA_VERSION_PROP, False);
    
    Window root = RootWindowOfScreen (DefaultScreenOfDisplay (dpy));
    
    if (!XQueryTree (dpy, root, &root2, &parent, &kids, &nkids))
    {
        fprintf(stderr, "mdp: XQueryTree failed on display %s\n", DisplayString (dpy));
        XCloseDisplay(dpy);
        return false;
    }

    // Note: root != root2 is possible with virtual root WMs.
    if (!(kids && nkids)) return false;

    for (i = nkids-1; i >= 0; i--)
    {
        Atom type;
        int format;
        unsigned long nitems, bytesafter;
        unsigned char *version = 0;
        Window w = XmuClientWindow (dpy, kids[i]);
        int status = XGetWindowProperty (dpy, w, XA_MOZILLA_VERSION,
			           0, (65536 / sizeof (long)),
			           False, XA_STRING,
			           &type, &format, &nitems, &bytesafter,
			           &version);
        if (!version) continue;
        XFree (version);
        if (status == Success && type != None)
	    {
	        if (w == window)
            {
                XCloseDisplay(dpy);
                return true;
            }
            else
            {
                continue;
            }
	    }
    }
    XCloseDisplay(dpy);
    return false;
    
}  // end NetscapeCheckWindow()
