/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
#ifndef _MDP_FILE
#define _MDP_FILE

// This is the UNIX implementation of the MdpFile class
#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/stat.h>
#include <string.h>
#include <fcntl.h>

#include "sysdefs.h"  // for bool definition, DIR_DELIMITER, PATH_MAX, etc
#include "debug.h"    // for DEBUG stuff

enum MdpFileType
{
    MDP_FILE_INVALID, 
    MDP_FILE_NORMAL, 
    MDP_FILE_DIRECTORY
};       
        
class MdpFile
{
    // Members
    private:
        int fd;
        int flags;
        off_t offset;
    
    // Methods 
    public:
        MdpFile();
        ~MdpFile();
        bool Open(char *path, int theFlags);
        bool Lock();
        void Unlock();
        bool Rename(char *old_name, char *new_name);
        bool Unlink(char *path);
        void Close();
        bool IsOpen() {return (bool) (fd >= 0);}
        int Read(char *buffer, int len)
        {
            ASSERT(IsOpen());
            return read(fd, buffer, len);
        }
        int Write(char *buffer, int len)
        {
            ASSERT(IsOpen());
            return write(fd, buffer, len);
        }
        bool Seek(unsigned long theOffset);
        unsigned long Size();
        unsigned long Offset() {return ((unsigned long) offset);}
        void SetOffset(unsigned long value) {offset = value;}
};
        
/******************************************
* The MdpDirectory and MdpDirectoryIterator classes
* are used to walk directory trees for file transmission
*/      

class MdpDirectory
{
    friend class MdpDirectoryIterator;
    
    private:
        DIR             *dptr;
        char            path[PATH_MAX];
        MdpDirectory    *parent;
    
    private:
        MdpDirectory(const char *thePath, MdpDirectory *theParent = NULL);
        void GetFullName(char *name_ptr);
        bool Open();
        void Close();
        void SetDPtr(DIR *value) {dptr = value;}
        const char *Path() {return path;}
        void RecursiveCatName(char *ptr);
};

class MdpDirectoryIterator
{
    private:
        MdpDirectory    *current;
        int             path_len;
    
    public:
        MdpDirectoryIterator();
        ~MdpDirectoryIterator();
        bool Init(const char *thePath);
        bool GetNextFile(char *file_name);
        
    private:
        void Destroy();
};

unsigned long MdpFileGetSize(const char* path);
time_t MdpFileGetUpdateTime(const char *path);
MdpFileType MdpFileGetType(const char *path);
inline bool MdpFileExists(const char *path)
    {return (0 == access(path, F_OK));}
inline bool MdpFileIsWritable(const char *path)
    {return (0 == access(path, W_OK));}
bool MdpFileIsLocked(char *path);
#endif // _MDP_FILE
