#
proc SimpleMDP {optionList} {

#Default parameters
set numClient "10"
set mdpRate "64kb"
set theDuration "120.0"
set unicastNacks "off"
set backoffWindow "3.0"

#Parse optionList for parameter
puts "Parsing options: $optionList"
set state flag
foreach option $optionList {
    switch -- $state {
        "flag" {
            switch -glob -- $option {
                "numClient" {set state "numClient"}
                "rate" {set state "rate"}
                "duration" {set state "duration"}
                "unicastNacks" {set unicastNacks "on"}
                "backoff" {set state "backoff"}
                default {error "simplemdp: Bad option argument $option"}
            }
        
        }
        "numClient" {
            set numClient $option
            set state "flag"
        }
        "rate" {
            set mdpRate $option
            set state "flag"
        }
        "duration" {
            set theDuration $option
            set state "flag"
        }
        "backoff" {
            set backoffWindow $option
            set state "flag"
        }
        default {
            error "simplemdp: Bad option parse state!"
        }
    }
}

puts "Running: num:$numClient rate:$mdpRate duration:$theDuration back:$backoffWindow"

# Create multicast enabled simulator ins__tance
set ns_ [new Simulator -multicast on]
$ns_ multicast

# Turn on full ns_/NAM tracing
set f [open out-mcast.tr w]
$ns_ trace-all $f
set nf [open out-mcast.nam w]
$ns_ namtrace-all $nf

$ns_ color 0 red
$ns_ color 2 black
$ns_ color 1 blue

# Set up color mapping for MDPv2 packet types
$ns_ color 41 yellow
$ns_ color 42 blue
$ns_ color 43 darkgreen
$ns_ color 44 purple
$ns_ color 45 orange
$ns_ color 46 red
$ns_ color 47 black

# Create nodes (1 source, 1 hub, $numClient fanout)
set maxNode [expr $numClient + 2]

puts "Creating nodes ..."
for {set i 0} {$i < $maxNode} {incr i} {
    set n($i) [$ns_ node]
}

puts "Creating links ..."
set linkRate [expr $numClient * [bw_parse $mdpRate]]
# Make sender link (Node 0 -> Node 1 link)
$ns_ duplex-link $n(0) $n(1) $linkRate 100ms DropTail
$ns_ queue-limit $n(0) $n(1) 100
$ns_ duplex-link-op $n(0) $n(1) orient right
$ns_ duplex-link-op $n(0) $n(1) queuePos 0.5

# Make fanout links
for {set i 2} {$i < $maxNode} {incr i} {
    $ns_ duplex-link $n(1) $n($i) $linkRate 100ms DropTail
    $ns_ queue-limit $n(1) $n($i) 100
	$ns_ duplex-link-op $n(1) $n($i) queuePos 0.5
}
    
### Start multicast configuration: 5 mproto options_
### CtrMcast   : centralized multicast
### DM         : static DVMRP (can't adapt to link up/down or node up/down)
### detailedDM : dens_e mode protocol that adapts to dynamics (recommended)
### dynamicDM  : dynamic DVMRP 
### pimDM      : PIM dens_e mode

### Uncomment following lines to change default
#DM set PruneTimeout 0.3               ;# default 0.5 (sec)
#dynamicDM set ReportRouteTimeout 0.5  ;# default 1 (sec)

set mproto DM
set mrthandle [$ns_ mrtproto $mproto  {}]
if {$mrthandle != ""} {
    $mrthandle set_c_rp [list $n(1)]
}
### End of multicast configuration

puts "Creating MDP agents ..."
    
#######################################  
# Create MDPv2 server and client Agents

# Server side agent (Node 0)
    set mdp_server(0) [new Agent/MDP]
    $ns_ attach-agent $n(0) $mdp_server(0)
    $mdp_server(0) ttl 32
    $mdp_server(0) txRate [bw_parse $mdpRate]
    $mdp_server(0) segmentSize 512
    $mdp_server(0) blockSize 30
    $mdp_server(0) numParity 30
    $mdp_server(0) autoParity 0
    $mdp_server(0) numRepeats -1
    $mdp_server(0) congestionControl off
    #$mdp_server(0) sendLoss 10.0
    $mdp_server(0) recvLoss 10.0
    $mdp_server(0) initialGrtt 0.422538

# Create $numClient MDP client agents
for {set i 2} {$i < $maxNode} {incr i} {
# Client side agent (Node k)
    set mdp_client($i) [new Agent/MDP]
    $ns_ attach-agent $n($i) $mdp_client($i)
    #$mdp_client($i) sendLoss 10.0
    $mdp_client($i) recvLoss 10.0
    $mdp_client($i) rxBufferSize 100000
    $mdp_client($i) unicastNacks $unicastNacks
}

# Global MDPv2 settings (These can be set via any MDP Agent)
$mdp_server(0) backoffWindow $backoffWindow
$mdp_server(0) groupSize $numClient
$mdp_server(0) debugLevel 2
#$mdp_server(0) messageTrace on
$mdp_server(0) logFile mdpLog.txt
    
# Run a single MDPv2 group over the topology

# Alloc multicast group address
set group [Node allocaddr]

puts "Starting simulation ..." 

# Start MDP server
$ns_ at 0.0 "$mdp_server(0) baseObject 1"
$ns_ at 0.0 "$mdp_server(0) start server $group 5000"
$ns_ at 0.0 "$mdp_server(0) send 65535"

# Start MDP clients
for {set i 2} {$i < $maxNode} {incr i} {
    $ns_ at 0.0 "$mdp_client($i) start client $group 5000"
    }

# Reset node colors
#for {set i 3} {$i < 10} {incr i} {
#    $ns_ at 15.0 "$n($i) color black"
#   }

$ns_ at $theDuration "finish $ns_ $f $nf"

proc finish {ns_ f nf} {
    $ns_ flush-trace
	close $f
	close $nf
    
$ns_ halt
delete $ns_

}

$ns_ run

}

# Run a set of trials with optional command-line parameters

#Usage: 
#ns simplemdp.tcl [numClient <count>][rate <bps>][duration <sec>][backoff <nGrtt>][unicastNacks]

puts "Running simplemdp: $argv"
SimpleMDP $argv

