#!/usr/bin/tclsh

source rmcc-5.tcl

#Test options#
set nam "true"
set red "true"
set ecn "false"
set mdpNum 1
set runTime 3600.0

#Setup up for random start/stop tcp
# Flows start randomly from 0 -> startSpread
set startSpread 800.0 
# TCP duration maxTime*0.1 -> maxTime if startStop is "on"
# if startStop is "off", flows last indefinitely  
set startStop "on"
set maxTime 2800.0      
                      
    #Bottleneck setup
    set bottle0(TCPCount) 1
    set bottle0(Rate) 64kb
    set bottle0(Delay) 10ms
    set bottle0(Qsize) 80
    lappend bottleList bottle0
    
    set bottle1(TCPCount) 2
    set bottle1(Rate) 64kb
    set bottle1(Delay) 10ms
    set bottle1(Qsize) 80
    lappend bottleList bottle1

    set bottle2(TCPCount) 3
    set bottle2(Rate) 64kb
    set bottle2(Delay) 10ms
    set bottle2(Qsize) 80
    lappend bottleList bottle2
    
    set bottle3(TCPCount) 0
    set bottle3(Rate) 64kb
    set bottle3(Delay) 10ms
    set bottle3(Qsize) 80
    lappend bottleList bottle3

#Run rmcc-5.tcl
RunRMCC5 $bottleList $runTime $mdpNum $red $ecn $nam $startSpread $startStop $maxTime


    

