Class ScenLib/RM

proc RunRMCC6 {bottleList duration numMdp red ecn nam startSpread startStop maxTime} {
    global prog ns fileId
    set testScen [new ScenLib/RM]
       
    # Turn on nam tracing if applicable
    if {"true" == $nam} {
	    $ns namtrace-all [open ns-$prog.nam w]
    }
    
    #Open file for ns traces
    set fileId [open ns-$prog.tr w]
    
    # Build topology (ReceiverList is added to the bottleneck links
    $testScen make_snowflake $bottleList $numMdp $red $ecn 
    
    # Setup MDP reliable multicast (rm) flows
    $testScen random_start_rm $numMdp $bottleList 0.0 0.0 
    
    # Setup Bottleneck list TCP flows
    #$testScen seq_start_tcp $numMdp $bottleList 0.0 $startSpread $startStop $maxTime      
    #$testScen random_start_tcp $numMdp $bottleList 0.0 $startSpread $startStop $maxTime   
    $testScen step_start_tcp $numMdp $bottleList 0.0 $startSpread $startStop $maxTime   
    
    $ns at $duration "finish"
    puts "Running ..."
    $ns run
}


ScenLib/RM instproc random_start_rm {numMdp bottleList start stop} {
    global ns
	for {set srcNode 0} {$srcNode < $numMdp} {incr srcNode} {
        set startTime [get_rand_time $start $stop 1]
		$self create_mcastmdp $srcNode $bottleList $startTime 
		puts "mdp flow set from $srcNode to all startTime:$startTime endTime:inf"
	}
}

ScenLib/RM instproc random_start_tcp {firstSource bottleList start stop startStop maxTime} {
	global ns 
    
    # TCP source node ids begin after MDP source node id range (0->(numMdp-1))
    set tcpSource $firstSource
    foreach link $bottleList {
        upvar #0 $link theLink
        set tcpCount $theLink(TCPCount)
        set tcpSink [lindex $theLink(ReceiverList) 0]
	    for {set i 0} {$i < $tcpCount} {incr i} {
            set startTime [get_rand_time $start $stop 1]
            set minTime [expr $maxTime * 0.1]
            set stopTime [expr $startTime + [get_rand_time $minTime $maxTime 1]]
            if {"on" == $startStop} {
                puts "tcp flow set from $tcpSource to $tcpSink startTime:$startTime endTime:$stopTime" 
            } else {
                puts "tcp flow set from $tcpSource to $tcpSink startTime:$startTime endTime:inf"
            }
            $self create_tcp $tcpSource $tcpSink $startTime $startStop $stopTime
	        incr tcpSource
            incr tcpSink
        }
    }
}

ScenLib/RM instproc seq_start_tcp {firstSource bottleList start stop startStop maxTime} {
	global ns
    
    # First make a pass over bottleList for some info
    set numTcpBottlenecks 0
    foreach link $bottleList {
        upvar #0 $link theLink
        if {0 < $theLink(TCPCount)} {
            incr numTcpBottlenecks
        }
    }    
    set duration [expr $maxTime / $numTcpBottlenecks]
    set startTime 0.0
    set stopTime $duration
    
    # TCP source node ids begin after MDP source node id range (0->(numMdp-1))
    set tcpSource $firstSource
    foreach link $bottleList {
        upvar #0 $link theLink
        if {0 < $theLink(TCPCount)} {
            set tcpCount $theLink(TCPCount)
            set tcpSink [lindex $theLink(ReceiverList) 0]
	        for {set i 0} {$i < $tcpCount} {incr i} {
                puts "tcp flow set from $tcpSource to $tcpSink startTime:$startTime endTime:$stopTime" 
                $self create_tcp $tcpSource $tcpSink $startTime "on" $stopTime
	            incr tcpSource
	            incr tcpSink
            }
            set startTime $stopTime
            set stopTime [expr $stopTime + $duration]
        }
    }
}

ScenLib/RM instproc step_start_tcp {firstSource bottleList start stop startStop maxTime} {
	global ns
    
    # First make a pass over bottleList for some info
    set numTcpBottlenecks 0
    foreach link $bottleList {
        upvar #0 $link theLink
        if {0 < $theLink(TCPCount)} {
            incr numTcpBottlenecks
        }
    }    
    set duration [expr $maxTime / $numTcpBottlenecks]
    set startTime 0.0
    set stopTime $duration
    
    # TCP source node ids begin after MDP source node id range (0->(numMdp-1))
    set tcpSource $firstSource
    foreach link $bottleList {
        upvar #0 $link theLink
        if {0 < $theLink(TCPCount)} {
            set tcpCount $theLink(TCPCount)
            set tcpSink [lindex $theLink(ReceiverList) 0]
            # Start steady-state TCP flow
            puts "tcp flow set from $tcpSource to $tcpSink startTime:0 endTime:inf" 
            $self create_tcp $tcpSource $tcpSink 0.0 "off" $stopTime
	        incr tcpSource
	        incr tcpSink
            
	        for {set i 1} {$i < $tcpCount} {incr i} {
                puts "tcp flow set from $tcpSource to $tcpSink startTime:$startTime endTime:$stopTime" 
                $self create_tcp $tcpSource $tcpSink $startTime "on" $stopTime
	            incr tcpSource
	            incr tcpSink
            }
            set startTime $stopTime
            set stopTime [expr $stopTime + $duration]
        }
    }
}


ScenLib/RM instproc create_tcp {src dst start startStop stop} {
    global ns n opts
    # Make TCP source (one TCP per "src" node id)
    set i $src
    set tcpSource($i) [new Agent/$opts(tcpType)]
    $tcpSource($i) set packetSize_ $opts(pktSize)
    $ns attach-agent $n($src) $tcpSource($i)
    # Make TCP sink and connect
    set tcpSink($i) [new Agent/$opts(sinkType)]
	$ns attach-agent $n($dst) $tcpSink($i)
    $tcpSink($i) set ecn_ 1
	$ns connect $tcpSource($i) $tcpSink($i)
    # Set up driving application
    set ftp($i) [new Application/$opts(tcpSrcType)]
    $ftp($i) attach-agent $tcpSource($i)
    $ns at $start "$ftp($i) start"
    if {"on" == $startStop} {
        $ns at $stop "$ftp($i) stop"
    }
}

# This creates an MDP session with a single sender and
# a receiver on every receiver node
ScenLib/RM instproc create_mcastmdp {srcNode bottleList startTime} {
	global ns n 
### Start multicast configuration: 5 mproto options_
### CtrMcast   : centralized multicast
### DM         : static DVMRP (can't adapt to link up/down or node up/down)
### detailedDM : dens_e mode protocol that adapts to dynamics (recommended)
### dynamicDM  : dynamic DVMRP 
### pimDM      : PIM dens_e mode

### Uncomment following lines to change default
#DM set PruneTimeout 0.3               ;# default 0.5 (sec)
#dynamicDM set ReportRouteTimeout 0.5  ;# default 1 (sec)

set mproto DM
set mrthandle [$ns mrtproto $mproto  {}]
if {$mrthandle != ""} {
    $mrthandle set_c_rp [list $n(3)]
}
### End of multicast configuration
    
	set destAddr [Node allocaddr]
    set destPort 5000
	    
	# Setup sender parameters
    # rmSimType _must_ be MDP here ... This will change
    # when other rm protocols are supported
    set src [new Agent/MDP]
    $ns attach-agent $n($srcNode) $src
    $src ttl 32
	$src txRate 500000
	$src segmentSize 512
	$src blockSize 20
	$src numParity 20
	$src numRepeats -1
	$src congestionControl on
    $src debugLevel 3
    $src messageTrace on
	$src logFile mdpLog.txt
	$ns at $startTime "$src start server $destAddr $destPort"
    $ns at $startTime "$src send 65536"
    
    # Put an MDP client agent on _every_ receiver node
	foreach link $bottleList {
        upvar #0 $link theLink
        # Uncomment this and comment "foreach" for
        # just one MDP receiver per bottleneck
        #set j [lindex $theLink(ReceiverList) 0]
        # Uncomment foreach loop and comment above for
        # MDP receivers on all receiver nodes
        foreach j $theLink(ReceiverList) {
            set rcvr($j) [new Agent/MDP]
		    $ns attach-agent $n($j) $rcvr($j)
            $rcvr($j) ecnEnable on
            $rcvr($j) unicastNacks on
		    $ns at $startTime "$rcvr($j) start client $destAddr $destPort"
        }
	}
}

ScenLib/RM instproc set_single_trace {n1 n2} {
	global ns fileId
    $ns trace-queue $n1 $n2 $fileId
}

# Make a "snowflake" topology
ScenLib/RM instproc make_snowflake {bottleList numMdp red ecn} {
    global ns n
    
    # First make a pass over bottleList for some info
    set rcvrsPerBottleneck 0
    set numBottleneck 0
    set numTcp 0
    set maxRate 0
    foreach link $bottleList {
        upvar #0 $link theLink
        if {$theLink(TCPCount) > $rcvrsPerBottleneck} {
            set rcvrsPerBottleneck $theLink(TCPCount)
        } 
        set numTcp [expr $numTcp + $theLink(TCPCount)]
        set maxRate [expr $maxRate + [bw_parse $theLink(Rate)]]
        incr numBottleneck
    }
    # Put at least 5 receivers per bottleneck
    if {$rcvrsPerBottleneck < 10} {
       set rcvrsPerBottleneck 10
    }
    puts "Building snowflake topology ..."
    puts "   numMdp: $numMdp numTcp: $numTcp"
    puts "   leaf nodes per bottleneck: $rcvrsPerBottleneck\n"
    
    # Source nodes equals 0 < n < (numMdp+numTcp)
    set i 0
    set numSrc [expr $numMdp + $numTcp]
    for {set i 0} {$i < $numSrc} {incr i} {
        set n($i) [$ns node]
    }
    # Make source convergence node
    set n($numSrc) [$ns node]
    
    set uncongestedRate [expr 10.0 * $maxRate]
    # Make source<->convergence links
    for {set i 0} {$i < $numSrc} {incr i} {
        $ns duplex-link $n($i) $n($numSrc) $uncongestedRate 1ms DropTail
    } 
    
    # Make source<->convergence node an cumulative link
    set center [expr $numSrc + 1]
    set n($center) [$ns node]
    
    $ns duplex-link $n($numSrc) $n($center) $uncongestedRate 1ms DropTail
    
    puts "Aggregate link ($numSrc, $center)\n"
    #Set trace for aggregate link in both directions
    $self set_single_trace $n($numSrc) $n($center)
    $self set_single_trace $n($center) $n($numSrc)
    
    puts "Setting up bottleneck links:"
    
    # Make bottleNeck feed and bottleNeck termination nodes and links
    set i [expr $center + 1]
    foreach link $bottleList {
        upvar #0 $link theLink
        set bitrate [bw_parse $theLink(Rate)]
        set delay $theLink(Delay)
        set Qsize $theLink(Qsize)
        set n($i) [$ns node]
        
        # This link feeds the bottleNeck
        $ns duplex-link $n($center) $n($i) $uncongestedRate 1ms DropTail
        
        #Set trace for bottleneck feed
        #$self set_single_trace $n($center) $n($i)
        
        # This is the actual bottleneck link
        set j $i
        incr i
        set n($i) [$ns node]
        # Setup RED or DropTail queue
        if {$red == "true"} {
            $ns duplex-link $n($j) $n($i) $bitrate $delay RED 
            if {$ecn == "true"} {
                [[$ns link $n($j) $n($i)] queue] set setbit_ true
            }
        } else {
            
            $ns duplex-link $n($j) $n($i) $bitrate $delay DropTail
        }
        $ns queue-limit $n($j) $n($i) $Qsize
        #colors links and orients the queues for bottlenecks
        $ns duplex-link-op $n($j) $n($i) color "red" 
        $ns duplex-link-op $n($j) $n($i) queuePos 0 
        
        #Set trace for bottleneck
        $self set_single_trace $n($j) $n($i)
        incr i
     } 
     
     # Identify cluster focus for first bottleneck
     set i [expr $numMdp + $numTcp + 3]
     # Identify first receiver
     set j [expr $i + (2 * $numBottleneck) - 1]
     foreach link $bottleList { 
        upvar #0 $link theLink
        
        # Make receiver cluster for each bottleneck  
        for {set k 0} {$k < $rcvrsPerBottleneck} {incr k} {
            set n($j) [$ns node]
            $ns duplex-link $n($i) $n($j) $uncongestedRate 1ms DropTail
            lappend theLink(ReceiverList) $j
            incr j
        }
        puts "   ([expr $i-1],$i) $theLink(Rate) $theLink(Delay) $theLink(TCPCount)tcp mdp: $theLink(ReceiverList)" 
        set i [expr $i + 2]
    }  
    puts "" 
}

ScenLib/RM instproc init {} {
    $self instvar fid_
	set fid_ 0
	global ns fileId opts
	set ns [new Simulator -multicast on] 
    $ns multicast
    
    # Simulation options
    set opts(routingProto) DM
	set opts(rmSimType) MDP
	set opts(rmSrcType) CBR
	set opts(tcpSrcType) FTP
	set opts(pktSize) 512
    set opts(runTime) 1
    set opts(tcpType) TCP/Sack1
	set opts(sinkType) TCPSink/Sack1
	set opts(window) 5 
}

proc get_rand_time {first last number} {
	set times ""
	set interval [expr $last - $first]
    set maxrval [expr pow(2,31)]
	set intrval [expr $interval/$maxrval]
    for { set i 0 } { $i < $number } { incr i } {
		set randtime [expr ([ns-random 0] * $intrval) + $first]
        # XXX include only 1 decimals (i.e. 1/10 sec)
		lappend times [format "%.1f" $randtime]
	}
    return $times
}

proc finish {} {
	global ns fileId
	puts "rmcc-6: Finishing up ..."
	$ns flush-trace
    close $fileId
	exit 0
}

global argv prog
if [string match {*.tcl} $argv0] {
    set prog [string range $argv0 0 [expr [string length $argv0] - 5]]
} else {
    set prog $argv0
}
 
