# usage : ns rmcc-5settings.tcl


source rmcc.tcl

proc RunRMCC5 {bottleList duration mdpNum red ecn nam start_spread start_stop max_time} {
    global ns recPERbn runTime
    set test_scen [new ScenLib/RM]
    #Counts total TCP flows and sets the number of receivers per bottleneck
    set tcp_counter 0
    set tcpNum 0
    set runTime $duration
    foreach link $bottleList {
        upvar #0 $link theLink
        set recPERbn $theLink(TCPCount)
        set tcp$tcp_counter $theLink(TCPCount)
        #puts "$theLink(TCPCount)"
        #puts "$tcp0"
        if {$tcp0 > $recPERbn} {
            set recPERbn $tcp0
        } else {
            set tcp0 $recPERbn
        }
        incr tcp_counter
        #Sums the number of TCP flows
        set tcpNum [expr $tcpNum + $theLink(TCPCount)]
    }
    #Sets the minimum number of recievers per bottleneck to 5
    if {$recPERbn < 5} {
        set recPERbn 5
    }
    puts "\nReceivers per bottleneck = $recPERbn"
    #Commands to determine trace file setup and to setup topology, 
    #packet coloration, RM, and TCP
    $test_scen nam_and_fileId $nam
    $test_scen make_topo3 $bottleList $mdpNum $tcpNum $red $ecn
    $test_scen color_packets
    $test_scen random_start_rm 0.0 60.0
    $test_scen random_start_tcp 0.0 $start_spread $bottleList $start_stop $max_time
    $ns at $duration "finish"
    puts "rmcc5: Running ..."
    $ns run    
}

proc get_rand_time {first last number} {
	set times ""
	set interval [expr $last - $first]
    set maxrval [expr pow(2,32) - 1]
	set intrval [expr $interval/$maxrval]
    for { set i 0 } { $i < $number } { incr i } {n
		set randtime [expr ([ns-random 0] * $intrval) + $first]
        # XXX include only 1 decimals (i.e. 1/10 sec)
		lappend times [format "%.1f" $randtime]
	}
    return $times
}

ScenLib/RM instproc color_packets {} {
    global ns multicastend unicastbegin unicastend
    $ns color 1 yellow
    $ns color 2 blue
}

ScenLib/RM instproc random_start_rm {start stop} {
	global ns n total_num mdp_num nodes opts window bottleneck_num
	#create mcast trees
	set i [expr $total_num + 2 + [expr 2 * $bottleneck_num]]
    while {$i < $nodes} {
		lappend receiverList $i
		incr i
    }
    for {set srcNode 0} {$srcNode < $mdp_num} {incr srcNode} {
        set startTime [get_rand_time $start $stop 1]
		eval $self create_mcastmdp $startTime $srcNode $receiverList
		puts "mdp flow set from $srcNode to all startTime:$startTime endTime:inf"
	}
}

ScenLib/RM instproc random_start_tcp {start stop bottleList start_stop max_time} {
	global ns bottleneck_num runTime tcp_start_stop stopTime tcp_num total_num mdp_num window nodes recPERbn
    set tcp_start_stop $start_stop
    set tcp_source $mdp_num 
    set j [expr $total_num +2 + [expr 2 * $bottleneck_num]]
    foreach link $bottleList {
        upvar #0 $link theLink
        set tcps $theLink(TCPCount)
	    for {set i 0} {$i < $tcps} {incr i} {
            if {$start_stop == "on"} {
                set startTime [get_rand_time $start $stop 1]
                set min_time [expr $max_time * 0.1]
                set stopTime [expr $startTime + [get_rand_time $min_time $max_time 1]]
                puts "tcp flow set from $tcp_source to $j startTime:$startTime endTime:$stopTime" 
            } else {
                set startTime [get_rand_time 0.0 $start 1]
                puts "tcp flow set from $tcp_source to $j at time $startTime"
            }
            $self create_tcp $tcp_source $j $startTime
	        incr tcp_source
            incr j
	    }
    set j [expr $j + [expr $recPERbn - $tcps]]
    }
}

# Make a "snowflake" topology
ScenLib/RM instproc make_topo3 {bottleList mdpNum tcpNum red ecn} {
    global ns n nodes total_num mdp_num tcp_num bottleneck_num recPERbn
    set mdp_num $mdpNum
    set tcp_num $tcpNum
    set RED $red
    set ECN $ecn
    puts "tcp flows                = $tcp_num"
    puts "mdp flows                = $mdp_num"
    set bottleneck_num [llength $bottleList]
    set total_num [expr $mdp_num + $tcp_num]
    set nodes [expr $total_num + 2 + [expr $bottleneck_num * 2] + [expr $bottleneck_num * $recPERbn]]
    puts "nodes                    = $nodes \n"
    $self make_nodes $nodes
    #Links for future TCP and RM source nodes
    for {set i 0} {$i < $total_num} {incr i} {
        $ns duplex-link $n($total_num) $n($i) 10Mb 1ms DropTail
    }
    set center [expr $total_num + 1]
    set bnnode [expr $bottleneck_num + $center + 1]
    set leaves [expr $bnnode + $bottleneck_num + $recPERbn]
    set loop $bottleneck_num
    set sum_of_bitrates 0 
    #Loop to fan out topology based on # of bottlenecks
    set i [expr $center + 1] 
    puts "Setting up bottleneck links:"
    foreach link $bottleList {
        upvar #0 $link theLink
        set bitrate [bw_parse $theLink(Rate)]
        set delay $theLink(Delay)
        set Qsize $theLink(Qsize)
        #Setting up bottleneck links and queue size
        # This link feeds the individual bottlneck
        $ns duplex-link $n($center) $n($i) 10Mb 1ms DropTail
        # This is the actual bottleneck link
        # Setup RED or DropTail queue
        if {$RED == "true"} {
            $ns duplex-link $n($i) $n($bnnode) $bitrate $delay RED 
            if {$ECN == "true"} {
                [[$ns link $n($i) $n($bnnode)] queue] set setbit_ true
            }
        } else {
            $ns duplex-link $n($i) $n($bnnode) $bitrate $delay DropTail
        }
        $ns queue-limit $n($i) $n($bnnode) $Qsize
        #colors links and orients the queues for bottlenecks
        $ns duplex-link-op $n($i) $n($bnnode) color "red" 
        $ns duplex-link-op $n($i) $n($bnnode) queuePos 0
        
        #Calculate mcast receiver set for display
        
        #calls function to set traces for bottlenecks and their feeds
        $self set_single_trace $n($i) $n($bnnode)
        #$self set_single_trace $n($center) $n($i)
        set R [list]
        for {set j [expr $bnnode + $loop]} {$j < $leaves} {incr j} {
            $ns duplex-link $n($bnnode) $n($j) 10Mb 5ms DropTail
            lappend R $j
        }
        puts "   ($i,$bnnode) $theLink(Rate) $delay clients: $R"
        set loop [expr $loop + $recPERbn-1]
        set leaves [expr $leaves + $recPERbn]
        set sum_of_bitrates [expr $sum_of_bitrates + $bitrate]
        incr bnnode
        incr i
    }
    set linkrate [expr $sum_of_bitrates * 2]
    # This is the aggregate link which feeds all of the bottlenecks
    $ns duplex-link $n($total_num) $n($center) $linkrate 5ms DropTail
    $self set_single_trace $n($total_num) $n($center)
    puts "\nAggregate link:\n   ($total_num,$center)\n"
}

global ns argv prog opts t mflag
set mflag 0
if [string match {*.tcl} $argv0] {
    set prog [string range $argv0 0 [expr [string length $argv0] - 5]]
} else {
    set prog $argv0
}

process_args $argv
set t $prog 
    

    


    

