# Copyright (c) 1997 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by the Computer Systems
#      Engineering Group at Lawrence Berkeley Laboratory.
# 4. Neither the name of the University nor of the Laboratory may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# simple-wireless.tcl
# A simple example for wireless simulation

# ======================================================================
# Define options
# ======================================================================
set val(chan)           Channel/WirelessChannel    ;# channel type
set val(prop)           Propagation/TwoRayGround   ;# radio-propagation model
set val(netif)          Phy/WirelessPhy            ;# network interface type
set val(mac)            Mac/802_11                 ;# MAC type
set val(ifq)            Queue/DropTail/PriQueue    ;# interface queue type
set val(ll)             LL                         ;# link layer type
set val(ant)            Antenna/OmniAntenna        ;# antenna model
set val(ifqlen)         50                         ;# max packet in ifq
set val(nn)             10                          ;# number of mobilenodes
set val(rp)             DSR                       ;# routing protocol
set val(x)	500
set val(y)	500

puts "this is a mobile network mdp test program"
# =====================================================================
# Main Program
# ======================================================================

#
# Initialize Global Variables
#

set ns_		[new Simulator]
set tracefd     [open simple_mdp.tr w]
$ns_ trace-all $tracefd

set namtrace [open simple_mdp.nam w]
$ns_ namtrace-all-wireless $namtrace $val(x) $val(y)

$ns_ color 0 red
$ns_ color 2 black
$ns_ color 1 blue

# Set up color mapping for MDPv2 packet types
$ns_ color 41 yellow
$ns_ color 42 blue
$ns_ color 43 darkgreen
$ns_ color 44 purple
$ns_ color 45 orange
$ns_ color 46 red
$ns_ color 47 black


# set up topography object
set topo       [new Topography]

$topo load_flatgrid 500 500

#
# Create God
#
create-god $val(nn)

#
#  Create the specified number of mobilenodes [$val(nn)] and "attach" them
#  to the channel. 
#  Here two nodes are created : node(0) and node(1)

# configure node
set chan_1_ [new $val(chan)]

        $ns_ node-config -adhocRouting $val(rp) \
			 -llType $val(ll) \
			 -macType $val(mac) \
			 -ifqType $val(ifq) \
			 -ifqLen $val(ifqlen) \
			 -antType $val(ant) \
			 -propType $val(prop) \
			 -phyType $val(netif) \
			 -channel $chan_1_ \
			 -topoInstance $topo \
			 -agentTrace ON \
			 -routerTrace ON \
			 -macTrace OFF \
			 -movementTrace ON			

	for {set i 0} {$i < $val(nn) } {incr i} {
		set node_($i) [$ns_ node]	
		$node_($i) random-motion 100
				;# disable random motion
	}
	for {set i 0} {$i < $val(nn) } {incr i} {
		$ns_ initial_node_pos $node_($i) 10		;# disable random motion
	}

#
# Provide initial (X,Y, for now Z=0) co-ordinates for mobilenodes
#
$node_(0) set X_ 5.0
$node_(0) set Y_ 2.0
$node_(1) set X_ 400.0
$node_(1) set Y_ 255.0
for {set i 2} {$i < $val(nn) } {incr i} {
		$node_($i) set X_ 250.0
		$node_($i) set Y_ 250.0
		$node_($i) set Z_ 0.0
		}
#
# Now produce some simple node movements
# Node_(1) starts to move towards node_(0)
#
$ns_ at 0.1 "$node_(1) setdest 255.0 20.0 5.0"
$ns_ at 0.1 "$node_(0) setdest 450.0 450.0 40.0"
$ns_ at 0.1 "$node_(2) setdest 10.0 10.0 10.0"
$ns_ at 0.1 "$node_(3) setdest 499.0 499.0 5.0"
$ns_ at 0.1 "$node_(4) setdest 499.0 0.1 20.0"
$ns_ at 0.1 "$node_(5) setdest 0.1 499.0 10.0"
$ns_ at 0.1 "$node_(6) setdest 300.0 100.0 20.0"
$ns_ at 0.1 "$node_(7) setdest 450.0 50.0 5.0"
$ns_ at 0.1 "$node_(8) setdest 340.0 346.0 20.0"
$ns_ at 0.1 "$node_(9) setdest 150.0 50.0 5.0"

# Node_(1) then starts to move away from node_(0)
$ns_ at 100.0 "$node_(1) setdest 49.0 48.0 5.0" 

# Setup traffic flow between nodes
# TCP connections between node_(0) and node_(1)

#set tcp [new Agent/TCP]
#$tcp set class_ 2
#set sink [new Agent/TCPSink]
#$ns_ attach-agent $node_(0) $tcp
#$ns_ attach-agent $node_(1) $sink
#$ns_ connect $tcp $sink
#set ftp [new Application/FTP]
#$ftp attach-agent $tcp
#$ns_ at 2.0 "$ftp start" 

# Setup MDP traffic flow between nodes
# 
#Option defaults
set unicastNacks "off"
# Server side agent (Node 0)
    set mdp_server(0) [new Agent/MDP]
    $ns_ attach-agent $node_(0) $mdp_server(0)
    $mdp_server(0) ttl 32
    $mdp_server(0) txRate 256000
    $mdp_server(0) segmentSize 512
    $mdp_server(0) blockSize 20
    $mdp_server(0) numParity 20
    $mdp_server(0) autoParity 0
    $mdp_server(0) numRepeats -1
    $mdp_server(0) congestionControl off
    $mdp_server(0) sendLoss 10.0
    #$mdp_server(0) recvLoss 10.0
    $mdp_server(0) initialGrtt 0.40

# Create $numClient MDP client agents
#for {set i 2} {$i < $maxNode} {incr i} {
# Client side agent (Node k)
    set mdp_client(0) [new Agent/MDP]
    $ns_ attach-agent $node_(1) $mdp_client(0)
    #$mdp_client($i) recvLoss 10.0
    $mdp_client(0) rxBufferSize 100000
    $mdp_client(0) unicastNacks $unicastNacks
#}

# Global MDPv2 settings (These can be set via any MDP Agent)
$mdp_server(0) backoffWindow 0.3
$mdp_server(0) groupSize 1
$mdp_server(0) debugLevel 2
$mdp_server(0) messageTrace on
$mdp_server(0) logFile mdpLog.txt
# For wireless operation using CMU extensions,
# MDP packets are encapsulated in PT_UDP packet type (MDP "useUdp" command)
# ("cmu-trace.cc" doesn't support all ns packet types)
$mdp_server(0) useUdp

#
$ns_ at 2.0 "$mdp_server(0) baseObject 1"
$ns_ at 2.0 "$mdp_server(0) start server [$mdp_client(0) addr] [$mdp_client(0) port]"
$ns_ at 2.0 "$mdp_server(0) send 65535"

# Start MDP clients

$ns_ at 2.0 "$mdp_client(0) start client [$mdp_server(0) addr] [$mdp_server(0) port]"

#
# Tell nodes when the simulation ends
#
for {set i 0} {$i < $val(nn) } {incr i} {
    $ns_ at 150.0 "$node_($i) reset";
}
$ns_ at 150.0 "stop"
$ns_ at 150.01 "puts \"NS EXITING...\" ; $ns_ halt"

proc stop {} {
    global ns_ tracefd namtrace
    $ns_ flush-trace
    close $tracefd
    global namtrace
    $ns_ flush-trace
    close $namtrace
}

puts "Starting Simulation..."
$ns_ run


