#

source ftpSink.tcl
source mdpTools.tcl

proc setQueueSize2 {size queue node1 node2 ns} {    
    $ns queue-limit $node1 $node2 $size
    $ns queue-limit $node2 $node1 $size
    if {$queue=="RED"} {
        set redq [[$ns link $node1 $node2] queue]
        $redq set thresh_ [expr $size/10]
        $redq set maxthresh_ [expr $size/2]
        $redq set linterm_ 10
	    #puts "queue size = $size"
	    #puts "maxthreshold = [expr $size/2]"
	    #puts "threshold = [expr $size/10]"
    }
}	

proc setQueueSize {rate queue node1 node2 ns} {
switch $rate {
puts "here i am"
    60000000 {
        $ns queue-limit $node1 $node2 1000
        $ns queue-limit $node2 $node1 1000
        if {$queue=="RED"} {
            set redq [[$ns link $node1 $node2] queue]
            $redq set thresh_ 100
            $redq set maxthresh_ 500
            $redq set linterm_ 10
        }
    }
    15000000 {
        $ns queue-limit $node1 $node2 250
        $ns queue-limit $node2 $node1 250
        if {$queue=="RED"} {
            set redq [[$ns link $node1 $node2] queue]
            $redq set thresh_ 25
            $redq set maxthresh_ 125
            $redq set linterm_ 10
        }
    }
    1500000 {
        $ns queue-limit $node1 $node2 25
        $ns queue-limit $node2 $node1 25
        if {$queue=="RED"} {
            set redq [[$ns link $node1 $node2] queue]
            $redq set thresh_ 3
            $redq set maxthresh_ 13
            $redq set linterm_ 10
        }
    }
    default {
    $ns queue-limit $node1 $node2 100
    $ns queue-limit $node2 $node1 100
    if {$queue=="RED"} {
            set redq [[$ns link $node1 $node2] queue]
            $redq set thresh_ 10
            $redq set maxthresh_ 50
            $redq set linterm_ 10
    	}
    }
  }
}


proc printall { fmon } {
    puts "aggregate per-link total_drops [$fmon set pdrops_]"
    puts "aggregate per-link total_packets [$fmon set pdepartures_]"
}

proc Usage {} {
    puts {mcc: Usage> ns mcc.tcl [<numMdp> <numTcp> <numTfrc> <bottleneckRate> <bottleneckQueueSize>}
    puts {                        <duration> <window> <outputPrefix> <optionList>]} 
    puts {   (options: nam fastStart, noRttRateBias, asymRttSmoothing, ewmaLossEstimate}
    puts {             red ecn tcpSack X11 GIF PS deleteLogs)}
}        


proc MCC {numMDP numTCP numTFRC bottleneckRate queueSize duration window fileName optionList} {

set show_tcphdr 1

# Create multicast enabled simulator instance
set ns_ [new Simulator -multicast on]
$ns_ multicast

# Generate a file name to use for logging, plots, etc
set numTotal [expr $numMDP + $numTCP + $numTFRC]
if {$numTotal} {
    if {$numMDP} {
        append fileName $numMDP "mdp"
    }
    if {$numTFRC} {
        append fileName $numTFRC "tfrc"
    }
    if {$numTCP} {
        append fileName $numTCP "tcp"
    }
} else {
    error "mcc: Error! ZERO flows (MDP, TCP, or TFRC) were specified."
}
append fileName "_" $bottleneckRate
puts $fileName
# MDP Protocol Options
set useNam 0
set fastStart "off"
set rttRateBias "on"
set asymRttSmoothing "off"
set ewmaLossEstimate "off"
set useRED 0
set useECN 0

set tcpSourceType "TCP/FullTcp"
set tcpSinkType   "TCP/FullTcp"
set sizeVar "segsize_"
set hdrSize 40

set doPlots 0
set plotType "NONE"
set deleteLogs 0

foreach option $optionList {
    if {"fastStart" == $option} {
        set fastStart "on"
    } elseif {"noRttRateBias" == $option} {
       set rttRateBias "off"
    } elseif {"asymRttSmoothing" == $option} {
       set asymRttSmoothing "on"
    } elseif {"ewmaLossEstimate" == $option} {
       set ewmaLossEstimate "on"
    } elseif {"nam" == $option} {
        set useNam 1
    } elseif {"red" == $option} {
        set useRED 1 
    } elseif {"ecn" == $option} {
        set useECN 1 
    } elseif {"tcpSack" == $option} {
        set tcpSourceType "TCP/Sack1"
        set tcpSinkType "TCPSink/Sack1"
        set sizeVar "packetSize_"
        set hdrSize 0
    } elseif {"X11" == $option} {
        set plotType "X11"
        set doPlots 1 
    } elseif {"GIF" == $option} {
        set plotType "GIF"
        set doPlots 1 
    } elseif {"PS" == $option} {
        set plotType "PS"
        set doPlots 1 
    } elseif {"deleteLogs" == $option} {
        set deleteLogs 1 
    } else {
        puts "mcc: Error! Invalid MDP protocol option: \"$option\""
        exit
    }
}

# Turn on full ns_/NAM tracing
set f [open $fileName.tr w]
#$ns_ trace-all $f

if {$useNam} {
    set nf [open $fileName.nam w]
    $ns_ namtrace-all $nf
}

$ns_ color 0 red
$ns_ color 2 black
$ns_ color 1 blue

# Set up color mapping for MDPv2 packet types
$ns_ color 41 yellow
$ns_ color 42 blue
$ns_ color 43 darkgreen
$ns_ color 44 purple
$ns_ color 45 orange
$ns_ color 46 red
$ns_ color 47 black

# Create a simple little "butterfly" topology with one bottleneck
# Create 17 nodes (7 sources, 3 for monitor/bottleneck links, 7 sinks)
for {set i 0} {$i < 17} {incr i} {
    set n($i) [$ns_ node]
	}

# Make 7 source links 
set flowCount [expr $numMDP + $numTCP + $numTFRC + 1]
set uncongestedRate [expr $flowCount * [bw_parse $bottleneckRate]]
set uncongestedRate 100Mb

set angle 1.55
for {set i 0} {$i < 7} {incr i} {
    $ns_ duplex-link $n($i) $n(7) $uncongestedRate 1ms DropTail
    $ns_ queue-limit $n($i) $n(7) 100
    $ns_ duplex-link-op $n($i) $n(7) orient $angle
    $ns_ duplex-link-op $n($i) $n(7) queuePos 0.5
    set angle [expr $angle + 0.15]
    }

#Put an uncongested link before the bottleneck for monitoring
$ns_ duplex-link $n(7) $n(8) $uncongestedRate 1ms DropTail
$ns_ queue-limit $n(7) $n(8) 80
$ns_ duplex-link-op $n(7) $n(8) orient right
$ns_ duplex-link-op $n(7) $n(8) queuePos 0.5


# Make 1 bottleneck link (Node 8 -> Node 9 link) 
#(DropTail (defautl) or RED queuing w/ option ECN)
# (TBD) add as a command-line option?
set bottleneckDelay "10ms" 
if {$useRED} {
	Queue/RED set gentle_ true
    $ns_ duplex-link $n(8) $n(9) $bottleneckRate $bottleneckDelay RED 
    if {$useECN} {
        [[$ns_ link $n(8) $n(9)] queue] set setbit_ true
	Agent/TCP set ecn_ 1
    }
} else {
    $ns_ duplex-link $n(8) $n(9) $bottleneckRate $bottleneckDelay DropTail
}

# source newqueueSize.tcl -- now included within this script
# set some variables for queueSize script

if {$useRED} {
	set queue RED 
} else {
	set queue DropTail
}

#set queuesize in setqueue script based somewhat on link rate

setQueueSize2 $queueSize $queue $n(8) $n(9) $ns_
$ns_ trace-queue $n(8) $n(9) $f

#Set of flow monitor for stats on bottleneck
set slink [$ns_ link $n(8) $n(9)]; # link to collect stats on
set fmon [$ns_ makeflowmon Fid]
$ns_ attach-fmon $slink $fmon

# (TBD) add as a command-line option?

$ns_ duplex-link-op $n(8) $n(9) orient right
$ns_ duplex-link-op $n(8) $n(9) queuePos 0.5

# Make 7 sink links (fanout)
set angle 0.45
for {set i 10} {$i < 17} {incr i} {
    $ns_ duplex-link $n(9) $n($i) $uncongestedRate 1ms DropTail
    $ns_ queue-limit $n(9) $n($i) 100
	$ns_ duplex-link-op $n(9) $n($i) orient $angle
    $ns_ duplex-link-op $n(9) $n($i) queuePos 0.5
    set angle [expr $angle - 0.15]  
    if {$angle < 0.0} {
        set angle 1.85
        }
    }
    
### Start multicast configuration: 5 mproto options_
### CtrMcast   : centralized multicast
### DM         : static DVMRP (can't adapt to link up/down or node up/down)
### detailedDM : dens_e mode protocol that adapts to dynamics (recommended)
### dynamicDM  : dynamic DVMRP 
### pimDM      : PIM dens_e mode

### Uncomment following lines to change default
#DM set PruneTimeout 0.3               ;# default 0.5 (sec)
#dynamicDM set ReportRouteTimeout 0.5  ;# default 1 (sec)

set mproto DM
set mrthandle [$ns_ mrtproto $mproto  {}]
if {$mrthandle != ""} {
    $mrthandle set_c_rp [list $n(3)]
}
### End of multicast configuration


# Create loss modules for bottleneck and sink fanout links
for {set i 9} {$i < 17} {incr i} {
	set em($i) [new ErrorModel]
	$em($i) set rate_ 0.0
	$em($i) unit pkt
	$em($i) ranvar [new RandomVariable/Uniform]
    $em($i) drop-target [new Agent/Null]
	}

# Assign loss modules to interesting links
# Bottleneck link
$ns_ lossmodel $em(9) $n(8) $n(9)
$em(9) set rate_ 0.00
# Fanout links
for {set i 10} {$i < 17} {incr i} {
    $ns_ lossmodel $em($i) $n(9) $n($i)
    $em($i) set rate_ 0.0
    }


#########################################
# Configure and create TFRC source and sink agents

Agent/TFRC set packetSize_ 1000
Agent/TFRCSink set discount_ 1
Agent/TFRC set df_ 0.95
Agent/TFRC set ca_ 1
Agent/TFRCSink set smooth_ 1
for {set i 0} {$i < $numTFRC} {incr i} {
# Which node (0-6) is this connection associated with?
    set k [expr $i%7]    
    set tfrc($i) [$ns_ create-connection TFRC $n($k) TFRCSink $n([expr $k + 10]) 0]
}


#########################################
# Create FTP/TCP source and sink agents


for {set i 0} {$i < $numTCP} {incr i} {
# Which node (0-6) is this connection associated with?
    set k [expr $i%7]
# Source
    set tcp_src($i) [new Agent/$tcpSourceType]
    $ns_ attach-agent $n($k) $tcp_src($i)
    $tcp_src($i) set window_ 10000
    $tcp_src($i) set $sizeVar [expr 1000 - $hdrSize]

# Sink
    set tcp_sink($i) [new Agent/$tcpSinkType]
    $ns_ attach-agent $n([expr $k + 10]) $tcp_sink($i)
    $tcp_sink($i) set window_ 10000
    $ns_ connect $tcp_src($i) $tcp_sink($i)
    $tcp_sink($i) listen

# FTP App
    set ftp($i) [new Application/FTP]
    $ftp($i) attach-agent $tcp_src($i)
    set ftp_sink($i) [new Application/FtpSink]
    $ftp_sink($i) attach-agent $tcp_sink($i)
}
    
#######################################  
# Create MDPv2 server and client Agents
#set numMDP 7
for {set i 0} {$i < $numMDP} {incr i} {
# Which node (0-6) is this connection associated with?
    set k [expr $i%7]
# Server side agent (Node k)
    set mdp_server($i) [new Agent/MDP]
    $ns_ attach-agent $n($k) $mdp_server($i)
    $mdp_server($i) ttl 32
    $mdp_server($i) txRate 32000
    $mdp_server($i) segmentSize 976
    $mdp_server($i) blockSize 20
    $mdp_server($i) numParity 20
    $mdp_server($i) autoParity 0
    $mdp_server($i) numRepeats -1
    $mdp_server($i) congestionControl on
    $mdp_server($i) fastStart $fastStart
    $mdp_server($i) colorPackets on
    $mdp_server($i) rttRateBias $rttRateBias
    $mdp_server($i) asymRttSmoothing $asymRttSmoothing
    $mdp_server($i) ewmaLossEstimate $ewmaLossEstimate
#    $mdp_server($i) sendLoss 0.0
    
# Client side agent (Node k)
    set mdp_client($i) [new Agent/MDP]
    $ns_ attach-agent $n([expr $k + 10]) $mdp_client($i)
    #$mdp_client($i) ecnEnable on
    $mdp_client($i) colorPackets on
}

# Global MDPv2 settings
if {$numMDP > 0} {
    $mdp_server(0) debugLevel 2
    #$mdp_server(0) messageTrace on
    $mdp_server(0) logFile $fileName-mdpLog.txt
    }
    
    
# Run MDPv2 and TCP over topology

# Start MDPv2 servers and clients
set group [Node allocaddr]
set port 5000
for {set i 0} {$i < $numMDP} {incr i} {
    set sec [expr $i/10]
    set frac [expr $i%10]
    set starttime $sec.$frac
    $ns_ at $starttime "$mdp_server($i) start server $group $port"
    $ns_ at $starttime "$mdp_server($i) send 65535"
    $ns_ at $starttime "$mdp_client($i) start client $group $port"
    set group [Node allocaddr]
    incr port
    }

#Start TFRC flows 
for {set i 0} {$i < $numTFRC} {incr i} {
    set sec [expr $i/10]
    set frac [expr $i%10]
    set starttime $sec.$frac 
    $ns_ at $starttime "[set tfrc($i)] start"
}

# Start FTP sessions_
for {set i 0} {$i < $numTCP} {incr i} {
    set sec [expr $i/10]
    set frac [expr $i%10]
    set starttime $sec.$frac
    puts "FTP src: $ftp($i) sink: $ftp_sink($i)"
    $ns_ at $starttime "$ftp($i) start"
    $ns_ at $starttime "$ftp_sink($i) listen"
}

# if {(1 == $numMDP) && (1 == $numTCP)} {
#     $ns_ at [expr $starttime + 1.0] "goodputReport $ns_ $mdp_client(0) $ftp_sink(0)"
# }

$ns_ at $duration "finish $ns_ $f $fileName.tr $numMDP $fileName-mdpLog.txt $fileName \
                          $window $doPlots $plotType $deleteLogs"

if {$useNam} {
    $ns_ at [expr $duration + 1.0] "close $nf"
}

proc goodputReport {ns_ mdp ftp} {
    set curTime [$ns_ now]
    puts "time>$curTime mdp>[$mdp goodput] tcp>[$ftp goodput]"
    $mdp resetGoodput
    $ftp resetGoodput
    $ns_ at [expr $curTime + 1.0] "goodputReport $ns_ $mdp $ftp"
}

proc finish {ns_ f traceFile numMDP mdpLog outFile window doPlots plotType deleteLogs} {
    $ns_ flush-trace
	close $f
    
$ns_ halt
delete $ns_

# GRAPH RESULTS -------------------------------------

# If we graph results, remove ns trace file & mdp log file
if {$doPlots} {
    if {$numMDP} {
        # Graph MDP log file (mdpLog.txt) data
        # "MdpCCPlot" shows all of the Congestion Control Metrics
        puts -nonewline "mcc: "
        MdpCCMetricPlot $mdpLog $outFile $plotType

        # "MdpLossIntervalPlot" shows the loss estimator interval tracking
        #puts -nonewline "mcc: "
        #MdpLossIntervalPlot $mdpLog $outFile $plotType
    }

    # Analyze ns trace file with "rateplot" (make gif with gnuplot) 
    # "link 8,9" looks at bottleneck, "link 7,8" looks at loading
    puts -nonewline "mcc: "
    RatePlot $traceFile $outFile 8 9 $window $plotType
    puts -nonewline "mcc: "
    LossPlot $traceFile $outFile 8 9 $window $plotType
}

if {$deleteLogs} {
    exec rm $traceFile 
    if {$numMDP} {
        exec rm $mdpLog
    }
}

puts "mcc: Done."

}

$ns_ run

}

# Multicast Congestion Control (MCC)
# Run a set of trials with default or given arguments and options

#Usage: ns mcc.tcl [numMdp numTcp numTfrc bottleneckRate duration window plotType [mdpOptionList]]

# (TBD) Revise command-line so that there are distinct commands & values
#  For example, change to "ns mcc.tcl mdp <numMdp> tcp <numTcp> tfrc <numTfrc> ... "

lappend mdpOptionList

if {0 == $argc} {
    puts "mcc: Using default parameters.  Use \"ns mcc.tcl help\" for usage."
    set numM 1
    set numT 1
    set numF 1
    set theRate 64kb
    set duration 360.0
    set window 5.0
    set fileName "mcc-"
    set queueSize 100
    lappend mdpOptionList "X11"
} elseif {8 <= $argc} {
    set numM [lindex $argv 0]
    set numT [lindex $argv 1]
    set numF [lindex $argv 2]
    set theRate [lindex $argv 3]
    set queueSize [lindex $argv 4]
    set duration [lindex $argv 5]
    set window [lindex $argv 6]
    set fileName [lindex $argv 7]
    for {set i 8} {$i < $argc} {incr i} {
        lappend mdpOptionList [lindex $argv $i]
    }
} elseif {"help" == [lindex $argv 0]} {
    Usage
    exit
} else {
    puts "mcc: Error! Invalid command-line syntax."
    Usage
    exit
}

puts -nonewline "mcc: Running simulation ... (numMDP:$numM numTCP:$numT "
puts            "numTFRC:$numF bottleneckRate:$theRate queuesize:$queueSize duration:$duration )"
MCC $numM $numT $numF $theRate $queueSize $duration $window $fileName $mdpOptionList

