Class Application/FtpSink -superclass Application

Application/FtpSink instproc init {} {
	$self next
}

Application/FtpSink instproc listen {} {
    $self instvar ns_ total_bytes start_time
    $self start
 	set total_bytes 0
    set ns_ [Simulator instance]
    set start_time [$ns_ now]
}

# For receiving packets (and tracing goodput)
Application/FtpSink instproc recv { nbytes } {
    $self instvar ns_ total_bytes start_time
	set total_bytes [expr $total_bytes + $nbytes]
    #set duration [expr ([$ns_ now] - $start_time)]
    #set goodput [expr (8.0 * $total_bytes) / (1000.0 * $duration)]
    #puts "TCP goodput: $goodput kbps"
}

# Returns current goodput measurement
Application/FtpSink instproc goodput { } {
    $self instvar ns_ total_bytes start_time
	set duration [expr ([$ns_ now] - $start_time)]
    set goodput [expr (8.0 * $total_bytes) / (1000.0 * $duration)]
    return $goodput
}

Application/FtpSink instproc resetGoodput { } {
    $self instvar ns_ total_bytes start_time
    set total_bytes 0
	set start_time [$ns_ now]
}

