#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX(X,Y) ((X>Y)?X:Y)
#define MIN(X,Y) ((X<Y)?X:Y)

inline double UniformRand(double max)
{
  return (max * ((double)rand() / (double)RAND_MAX));
}


inline double erand(double max, double groupSize)
{
    double lambda = log(groupSize) + 1;
    double x = UniformRand(lambda/max)+lambda/(max*(exp(lambda)-1));
    return ((max/lambda)*log(x*(exp(lambda)-1)*(max/lambda)));   
}

const unsigned int NUM_ITER = (unsigned int)1.0e+07;
const double GRTT = 0.422;
const double WINDOW = 3.0;

const unsigned int NUM_BINS = 100;

int main(int argc, char* argv[])
{
    unsigned int mhist[NUM_BINS];
    memset(mhist, 0, NUM_BINS*sizeof(unsigned int));
    unsigned int uhist[NUM_BINS];
    memset(uhist, 0, NUM_BINS*sizeof(unsigned int));
    
    double binRange = (GRTT*WINDOW) / ((double)NUM_BINS);
    for (unsigned int i = 0; i < NUM_ITER; i++)
    {
        double backoff = erand(WINDOW*GRTT, 1000.0);
        unsigned int bin = (unsigned int)(backoff / binRange);
        bin = MIN(bin, (NUM_BINS-1));
        mhist[bin]++;
        
        backoff = erand(WINDOW*GRTT, 1000.0);
        backoff -= GRTT / 2.0;
        if (backoff < 0.0) backoff *= -1.0;
        backoff += GRTT / 2.0;
        bin = (unsigned int)(backoff / binRange);
        bin = MIN(bin, (NUM_BINS-1));
        uhist[bin]++;
    }    
    
    for (unsigned int i = 0; i < NUM_BINS; i++)
    {
        fprintf(stdout, "%u, %u, %u\n", i, mhist[i], uhist[i]);   
    }
}
