# Environment variables

## SQLCCACHE

The `SQLCCACHE` environment variable dictates where `sqlc` will store cached
WASM-based plugins and modules. By default `sqlc` follows the [XDG Base
Directory
Specification](https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html).

## SQLCDEBUG

The `SQLCDEBUG` variable controls debugging variables within the runtime. It is
a comma-separated list of name=val pairs settings.

### dumpast

The `dumpast` command shows the SQL AST that was generated by the parser. Note
that this is the generic SQL AST, not the engine-specific SQL AST.

```
SQLCDEBUG=dumpast=1
```

```
([]interface {}) (len=1 cap=1) {
 (*catalog.Catalog)(0xc0004f48c0)({
  Comment: (string) "",
  DefaultSchema: (string) (len=6) "public",
  Name: (string) "",
  Schemas: ([]*catalog.Schema) (len=3 cap=4) {
   (*catalog.Schema)(0xc0004f4930)({
    Name: (string) (len=6) "public",
    Tables: ([]*catalog.Table) (len=1 cap=1) {
     (*catalog.Table)(0xc00052ff20)({
      Rel: (*ast.TableName)(0xc00052fda0)({
       Catalog: (string) "",
       Schema: (string) "",
       Name: (string) (len=7) "authors"
      }),
```

### dumpcatalog

The `dumpcatalog` command outputs the entire catalog. If you're using MySQL or
PostgreSQL, this can be a bit overwhelming. Expect this output to change in
future versions.

```
SQLCDEBUG=dumpcatalog=1
```

```
([]interface {}) (len=1 cap=1) {
 (*catalog.Catalog)(0xc00050d1f0)({
  Comment: (string) "",
  DefaultSchema: (string) (len=6) "public",
  Name: (string) "",
  Schemas: ([]*catalog.Schema) (len=3 cap=4) {
   (*catalog.Schema)(0xc00050d260)({
    Name: (string) (len=6) "public",
    Tables: ([]*catalog.Table) (len=1 cap=1) {
     (*catalog.Table)(0xc0000c0840)({
      Rel: (*ast.TableName)(0xc0000c06c0)({
       Catalog: (string) "",
       Schema: (string) "",
       Name: (string) (len=7) "authors"
      }),
```

### trace

The `trace` command is helpful for tracking down performance issues.

`SQLCDEBUG=trace=1`

By default, the trace output is written to `trace.out` in the current working
directory. You can configure a different path if needed.

`SQLCDEBUG=trace=name.out`

View the execution trace using the Go `trace` tool.

```
go tool trace trace.out
```

There's a ton of different views for the trace output, but here's an example
log showing the execution time for each package.

```
0.000043897 	 .         	1 	task sqlc (id 1, parent 0) created
0.000144923 	 .   101026 	1 	region generate started (duration: 47.619781ms)
0.001048975 	 .   904052 	1 	region package started (duration: 14.588456ms)
0.001054616 	 .     5641 	1 	name=authors dir=/Users/kyle/projects/sqlc/examples/python language=python
0.001071257 	 .    16641 	1 	region parse started (duration: 7.966549ms)
0.009043960 	 .  7972703 	1 	region codegen started (duration: 6.587086ms)
0.009171704 	 .   127744 	1 	new goroutine 35: text/template/parse.lex·dwrap·1
0.010361654 	 .  1189950 	1 	new goroutine 36: text/template/parse.lex·dwrap·1
0.015641815 	 .  5280161 	1 	region package started (duration: 10.904938ms)
0.015644943 	 .     3128 	1 	name=booktest dir=/Users/kyle/projects/sqlc/examples/python language=python
0.015647431 	 .     2488 	1 	region parse started (duration: 4.207749ms)
0.019860308 	 .  4212877 	1 	region codegen started (duration: 6.681624ms)
0.020028488 	 .   168180 	1 	new goroutine 37: text/template/parse.lex·dwrap·1
0.021020310 	 .   991822 	1 	new goroutine 8: text/template/parse.lex·dwrap·1
0.026551163 	 .  5530853 	1 	region package started (duration: 9.217294ms)
0.026554368 	 .     3205 	1 	name=jets dir=/Users/kyle/projects/sqlc/examples/python language=python
0.026556804 	 .     2436 	1 	region parse started (duration: 3.491005ms)
0.030051911 	 .  3495107 	1 	region codegen started (duration: 5.711931ms)
0.030213937 	 .   162026 	1 	new goroutine 20: text/template/parse.lex·dwrap·1
0.031099938 	 .   886001 	1 	new goroutine 38: text/template/parse.lex·dwrap·1
0.035772637 	 .  4672699 	1 	region package started (duration: 10.267039ms)
0.035775688 	 .     3051 	1 	name=ondeck dir=/Users/kyle/projects/sqlc/examples/python language=python
0.035778150 	 .     2462 	1 	region parse started (duration: 4.094518ms)
0.039877181 	 .  4099031 	1 	region codegen started (duration: 6.156341ms)
0.040010771 	 .   133590 	1 	new goroutine 39: text/template/parse.lex·dwrap·1
0.040894567 	 .   883796 	1 	new goroutine 40: text/template/parse.lex·dwrap·1
0.046042779 	 .  5148212 	1 	region writefiles started (duration: 1.718259ms)
0.047767781 	 .  1725002 	1 	task end
```

### processplugins

Setting this value to `0` disables process-based plugins. If a process-based
plugin is declared in the configuration file, running any `sqlc` command will
return an error.

`SQLCDEBUG=processplugins=0`

### dumpvetenv

The `dumpvetenv` command prints the variables available to a `sqlc vet` rule
during evaluation.

`SQLCDEBUG=dumpvetenv=1`

### dumpexplain

The `dumpexplain` command prints the JSON-formatted result from running
`EXPLAIN ...` on a query when a `sqlc vet` rule evaluation requires its output.

`SQLCDEBUG=dumpexplain=1`

## SQLCTMPDIR

If specified, use the given directory as the base for temporary folders. Only
applies when using WASM-based codegen plugins. When not specified, this
defaults to passing an empty string to
[`os.MkdirTemp`](https://pkg.go.dev/os#MkdirTemp).
