/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  mod_termio.c: Simple terminal IO library
 */

/**
 * Terminal IO module
 *
 * This module provides simple functions for controlling ANSI terminals.
 */

#define _GNU_SOURCE

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "spl.h"
#include "compat.h"

extern void SPL_ABI(spl_mod_termio_init)(struct spl_vm *vm, struct spl_module *mod, int restore);
extern void SPL_ABI(spl_mod_termio_done)(struct spl_vm *vm, struct spl_module *mod);

/**
 * This function sets the current curos position
 * The X and Y coordinates are relative to the upper left corner.
 * The upper left corner has the coordinates (1, 1).
 */
// builtin termio_setpos(x, y)
static struct spl_node *handler_termio_setpos(struct spl_task *task, void *data UNUSED)
{
	int x = spl_clib_get_int(task);
	int y = spl_clib_get_int(task);

	printf("\e[%d;%dH", y, x);
	fflush(stdout);

	return 0;
}

/**
 * This function clears the screen.
 */
// builtin termio_clear()
static struct spl_node *handler_termio_clear(struct spl_task *task UNUSED, void *data UNUSED)
{
	printf("\e[2J");
	fflush(stdout);
	return 0;
}

/**
 * This function sleeps for one second.
 */
// builting termio_sleep()
static struct spl_node *handler_termio_sleep(struct spl_task *task UNUSED, void *data UNUSED)
{
	my_sleep(1);
	return 0;
}

void SPL_ABI(spl_mod_termio_init)(struct spl_vm *vm, struct spl_module *mod UNUSED, int restore UNUSED)
{
	spl_clib_reg(vm, "termio_setpos", handler_termio_setpos, 0);
	spl_clib_reg(vm, "termio_clear",  handler_termio_clear,  0);
	spl_clib_reg(vm, "termio_sleep",  handler_termio_sleep,  0);
}

void SPL_ABI(spl_mod_termio_done)(struct spl_vm *vm UNUSED, struct spl_module *mod UNUSED)
{
	return;
}

