<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw interlink`
This API allows you to manage your InterLink services.
  
- [Connection commands](#connection-commands)
- [Link commands](#link-commands)
  - [Attach a routing policy](#attach-a-routing-policy)
  - [Attach a VPC](#attach-a-vpc)
  - [Create a link](#create-a-link)
  - [Delete a link](#delete-a-link)
  - [Detach a routing policy](#detach-a-routing-policy)
  - [Detach a VPC](#detach-a-vpc)
  - [Disable route propagation](#disable-route-propagation)
  - [Enable route propagation](#enable-route-propagation)
  - [Get a link](#get-a-link)
  - [List links](#list-links)
  - [Update a link](#update-a-link)
- [Partner commands](#partner-commands)
  - [Get a partner](#get-a-partner)
  - [List available partners](#list-available-partners)
- [PoP commands](#pop-commands)
  - [Get a PoP](#get-a-pop)
  - [List PoPs](#list-pops)
- [Routing policy commands](#routing-policy-commands)
  - [Create a routing policy](#create-a-routing-policy)
  - [Delete a routing policy](#delete-a-routing-policy)
  - [Get routing policy](#get-routing-policy)
  - [List routing policies](#list-routing-policies)
  - [Update a routing policy](#update-a-routing-policy)

  
## Connection commands

Connection commands.

Connection commands.

**Usage:**

```
scw interlink connection
```



## Link commands

Link commands.


### Attach a routing policy

Attach a routing policy to an existing link. As all routes across the link are blocked by default, you must attach a routing policy to set IP prefix filters for allowed routes, facilitating traffic flow.

**Usage:**

```
scw interlink link attach_policy <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to attach a routing policy to |
| routing-policy-id | Required | ID of the routing policy to be attached |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Attach a VPC

Attach a VPC to an existing link. This facilitates communication between the resources in your Scaleway VPC, and your on-premises infrastructure.

**Usage:**

```
scw interlink link attach_vpc <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to attach VPC to |
| vpc-id | Required | ID of the VPC to attach |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Create a link

Create a link (InterLink session / logical InterLink resource) in a given PoP, specifying its various configuration details. Links can either be hosted (facilitated by partners' shared physical connections) or self-hosted (for users who have purchased a dedicated physical connection).

**Usage:**

```
scw interlink link create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the link |
| tags.{index} |  | List of tags to apply to the link |
| pop-id | Required | PoP (location) where the link will be created |
| bandwidth-mbps | Required | Desired bandwidth for the link. Must be compatible with available link bandwidths and remaining bandwidth capacity of the connection |
| connection-id |  | If set, creates a self-hosted link using this dedicated physical connection. As the customer, specify the ID of the physical connection you already have for this link. |
| partner-id |  | If set, creates a hosted link on a partner's connection. Specify the ID of the chosen partner, who already has a shared connection with available bandwidth. |
| peer-asn |  | For self-hosted links we need the peer AS Number to establish BGP session. If not given, a default one will be assigned. |
| vlan |  | For self-hosted links only, it is possible to choose the VLAN ID. If the VLAN is not available (ie already taken or out of range), an error is returned. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a link

Delete an existing link, specified by its link ID. Note that as well as deleting the link here on the Scaleway side, it is also necessary to request deletion from the partner on their side. Only when this action has been carried out on both sides will the resource be completely deleted.

**Usage:**

```
scw interlink link delete <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Detach a routing policy

Detach a routing policy from an existing link. Without a routing policy, all routes across the link are blocked by default.

**Usage:**

```
scw interlink link detach_policy <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to detach a routing policy from |
| routing-policy-id | Required | ID of the routing policy to be detached |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Detach a VPC

Detach a VPC from an existing link.

**Usage:**

```
scw interlink link detach_vpc <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to detach the VPC from |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Disable route propagation

Prevent any prefixes from being announced in the BGP session. Traffic will not be able to flow over the InterLink until route propagation is re-enabled.

**Usage:**

```
scw interlink link disable_propagation <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link on which to disable route propagation |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable route propagation

Enable all allowed prefixes (defined in a routing policy) to be announced in the BGP session. This allows traffic to flow between the attached VPC and the on-premises infrastructure along the announced routes. Note that by default, even when route propagation is enabled, all routes are blocked. It is essential to attach a routing policy to define the ranges of routes to announce.

**Usage:**

```
scw interlink link enable_propagation <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link on which to enable route propagation |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a link

Get a link (InterLink session / logical InterLink resource) for the given link ID. The response object includes information about the link's various configuration details.

**Usage:**

```
scw interlink link get <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List links

List all your links (InterLink connections). A number of filters are available, including Project ID, name, tags and status.

**Usage:**

```
scw interlink link list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `status_asc`, `status_desc` | Order in which to return results |
| project-id |  | Project ID to filter for |
| name |  | Link name to filter for |
| tags.{index} |  | Tags to filter for |
| status | One of: `unknown_link_status`, `configuring`, `failed`, `requested`, `refused`, `expired`, `provisioning`, `active`, `limited_connectivity`, `all_down`, `deprovisioning`, `deleted`, `locked` | Link status to filter for |
| bgp-v4-status | One of: `unknown_bgp_status`, `up`, `down` | BGP IPv4 status to filter for |
| bgp-v6-status | One of: `unknown_bgp_status`, `up`, `down` | BGP IPv6 status to filter for |
| pop-id |  | Filter for links attached to this PoP (via connections) |
| bandwidth-mbps |  | Filter for link bandwidth (in Mbps) |
| partner-id |  | Filter for links hosted by this partner |
| vpc-id |  | Filter for links attached to this VPC |
| routing-policy-id |  | Filter for links using this routing policy |
| pairing-key |  | Filter for the link with this pairing_key |
| kind | One of: `hosted`, `self_hosted` | Filter for hosted or self-hosted links |
| connection-id |  | Filter for links self-hosted on this connection |
| organization-id |  | Organization ID to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a link

Update an existing link, specified by its link ID. Only its name and tags can be updated.

**Usage:**

```
scw interlink link update <link-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| link-id | Required | ID of the link to update |
| name |  | Name of the link |
| tags.{index} |  | List of tags to apply to the link |
| peer-asn |  | For self-hosted links, AS Number to establish BGP session. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Partner commands

Partner commands.


### Get a partner

Get a partner for the given partner IP. The response object includes information such as the partner's name, email address and portal URL.

**Usage:**

```
scw interlink partner get <partner-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| partner-id | Required | ID of partner to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List available partners

List all available partners. By default, the partners returned in the list are ordered by name in ascending order, though this can be modified via the `order_by` field.

**Usage:**

```
scw interlink partner list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc` | Order in which to return results |
| pop-ids.{index} |  | Filter for partners present (offering a connection) in one of these PoPs |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## PoP commands

PoP commands.


### Get a PoP

Get a PoP for the given PoP ID. The response object includes the PoP's name and information about its physical location.

**Usage:**

```
scw interlink pop get <pop-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| pop-id | Required | ID of PoP to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List PoPs

List all available PoPs (locations) for a given region. By default, the results are returned in ascending alphabetical order by name.

**Usage:**

```
scw interlink pop list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc` | Order in which to return results |
| name |  | PoP name to filter for |
| hosting-provider-name |  | Hosting provider name to filter for |
| partner-id |  | Filter for PoPs hosting an available shared connection from this partner |
| link-bandwidth-mbps |  | Filter for PoPs with a shared connection allowing this bandwidth size. Note that we cannot guarantee that PoPs returned will have available capacity. |
| dedicated-available |  | Filter for PoPs with a dedicated connection available for self-hosted links. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Routing policy commands

Routing policy commands.


### Create a routing policy

Create a routing policy. Routing policies allow you to set IP prefix filters to define the incoming route announcements to accept from the peer, and the outgoing routes to announce to the peer.

**Usage:**

```
scw interlink routing-policy create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the routing policy |
| tags.{index} |  | List of tags to apply to the routing policy |
| prefix-filter-in.{index} |  | IP prefixes to accept from the peer (ranges of route announcements to accept) |
| prefix-filter-out.{index} |  | IP prefix filters to advertise to the peer (ranges of routes to advertise) |
| is-ipv6 |  | IP prefixes version of the routing policy |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a routing policy

Delete an existing routing policy, specified by its routing policy ID.

**Usage:**

```
scw interlink routing-policy delete <routing-policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| routing-policy-id | Required | ID of the routing policy to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get routing policy

Get a routing policy for the given routing policy ID. The response object gives information including the policy's name, tags and prefix filters.

**Usage:**

```
scw interlink routing-policy get <routing-policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| routing-policy-id | Required | ID of the routing policy to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List routing policies

List all routing policies in a given region. A routing policy can be attached to one or multiple links (InterLink connections).

**Usage:**

```
scw interlink routing-policy list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Order in which to return results |
| project-id |  | Project ID to filter for |
| name |  | Routing policy name to filter for |
| tags.{index} |  | Tags to filter for |
| ipv6 |  | Filter for the routing policies based on IP prefixes version |
| organization-id |  | Organization ID to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a routing policy

Update an existing routing policy, specified by its routing policy ID. Its name, tags and incoming/outgoing prefix filters can be updated.

**Usage:**

```
scw interlink routing-policy update <routing-policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| routing-policy-id | Required | ID of the routing policy to update |
| name |  | Name of the routing policy |
| tags.{index} |  | List of tags to apply to the routing policy |
| prefix-filter-in.{index} |  | IP prefixes to accept from the peer (ranges of route announcements to accept) |
| prefix-filter-out.{index} |  | IP prefix filters for routes to advertise to the peer (ranges of routes to advertise) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



