/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.TwoColumnTablePanel;
import org.wiztools.restclient.ui.reqbody.ParameterGenerationListener;
import org.wiztools.restclient.util.Util;

public class ParameterDialog
extends EscapableDialog {
    private final List<ParameterGenerationListener> listeners = new ArrayList<ParameterGenerationListener>();
    private TwoColumnTablePanel jp_2col_center;
    private JButton jb_generate = new JButton("Generate");
    private JButton jb_cancel = new JButton("Cancel");
    private ParameterDialog me;
    private RESTUserInterface ui;

    @Inject
    public ParameterDialog(RESTUserInterface ui) {
        super((Frame)ui.getFrame(), true);
        this.setTitle("Insert Parameter");
        this.ui = ui;
        this.me = this;
    }

    public void addParameterGenerationListener(ParameterGenerationListener listener) {
        this.listeners.add(listener);
    }

    @PostConstruct
    protected void init() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp.setLayout(new BorderLayout());
        this.jp_2col_center = new TwoColumnTablePanel(new String[]{"Key", "Value"}, this.ui);
        jp.add((Component)this.jp_2col_center, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout(1));
        this.jb_generate.setMnemonic('g');
        this.getRootPane().setDefaultButton(this.jb_generate);
        this.jb_generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterDialog.this.actionGenerate(event);
            }
        });
        this.jb_cancel.setMnemonic('c');
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterDialog.this.actionCancel(event);
            }
        });
        jp_south.add(this.jb_generate);
        jp_south.add(this.jb_cancel);
        jp.add((Component)jp_south, "South");
        Dimension d = this.jp_2col_center.getPreferredSize();
        d.height += 100;
        this.jp_2col_center.setPreferredSize(d);
        this.setContentPane(jp);
        this.pack();
    }

    public void setData(MultiValueMap<String, String> data) {
        this.jp_2col_center.setData(data);
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.hideMe();
    }

    private void actionGenerate(ActionEvent e) {
        MultiValueMap<String, String> data = this.jp_2col_center.getData();
        if (this.jp_2col_center.getData().isEmpty()) {
            JOptionPane.showMessageDialog(this.me, "Please add data!", "Error: No data present!", 0);
            return;
        }
        String generatedParam = Util.parameterEncode(data);
        for (ParameterGenerationListener listener : this.listeners) {
            listener.onParameterGeneration(generatedParam);
        }
        this.setVisible(false);
    }

    private void actionCancel(ActionEvent e) {
        this.hideMe();
    }

    private void hideMe() {
        this.setVisible(false);
    }
}

