"""
Wrappers for the "SafetyKit" framework on macOS.

These wrappers don't include documentation, please check Apple's documentation
for information on how to use this framework and PyObjC's documentation
for general tips and tricks regarding the translation between Python
and (Objective-)C frameworks
"""

import os
import sys

sys.path.insert(0, os.path.dirname(__file__))


from pyobjc_setup import setup, Extension  # noqa: E402

VERSION = "11.0"

setup(
    name="pyobjc-framework-SafetyKit",
    description="Wrappers for the framework SafetyKit on macOS",
    min_os_level="13.0",
    packages=["SafetyKit"],
    ext_modules=[
        Extension(
            "SafetyKit._SafetyKit",
            ["Modules/_SafetyKit.m"],
            extra_link_args=["-framework", "SafetyKit"],
            depends=[
                os.path.join("Modules", fn)
                for fn in os.listdir("Modules")
                if fn.startswith("_SafetyKit")
            ],
        )
    ],
    version=VERSION,
    install_requires=[
        "pyobjc-core>=" + VERSION,
        "pyobjc-framework-Cocoa>=" + VERSION,
        "pyobjc-framework-Quartz>=" + VERSION,
    ],
    long_description=__doc__,
)
