import AddressBook
from PyObjCTools.TestSupport import TestCase, min_os_level, expectedFailureIf
from PyObjCTools.TestSupport import os_level_key, os_release


class TestABGlobals(TestCase):
    @min_os_level("10.12")
    def testConstants10_12(self):
        self.assertIsInstance(AddressBook.kABOrganizationPhoneticProperty, str)

    @min_os_level("10.9")
    def testConstants10_9(self):
        self.assertIsInstance(AddressBook.kABSocialProfileServiceTencentWeibo, str)

    @min_os_level("10.10")
    def testConstants10_10(self):
        self.assertIsInstance(AddressBook.kABSocialProfileServiceYelp, str)
        self.assertIsInstance(AddressBook.kABAlternateBirthdayComponentsProperty, str)

    @min_os_level("10.8")
    def testConstants10_8(self):
        self.assertIsInstance(AddressBook.kABSocialProfileServiceSinaWeibo, str)

    @min_os_level("10.7")
    def testConstants10_7(self):
        self.assertIsInstance(AddressBook.kABMobileMeLabel, str)
        self.assertIsInstance(AddressBook.kABBirthdayComponentsProperty, str)
        self.assertIsInstance(AddressBook.kABOtherDateComponentsProperty, str)
        self.assertIsInstance(AddressBook.kABInstantMessageProperty, str)
        self.assertIsInstance(AddressBook.kABInstantMessageUsernameKey, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceKey, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceAIM, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceFacebook, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceGaduGadu, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceGoogleTalk, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceICQ, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceJabber, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceMSN, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceQQ, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceSkype, str)
        self.assertIsInstance(AddressBook.kABInstantMessageServiceYahoo, str)
        self.assertIsInstance(AddressBook.kABSocialProfileProperty, str)
        self.assertIsInstance(AddressBook.kABSocialProfileURLKey, str)
        self.assertIsInstance(AddressBook.kABSocialProfileUsernameKey, str)
        self.assertIsInstance(AddressBook.kABSocialProfileUserIdentifierKey, str)
        self.assertIsInstance(AddressBook.kABSocialProfileServiceKey, str)
        self.assertIsInstance(AddressBook.kABSocialProfileServiceTwitter, str)
        self.assertIsInstance(AddressBook.kABSocialProfileServiceFacebook, str)
        self.assertIsInstance(AddressBook.kABSocialProfileServiceLinkedIn, str)
        self.assertIsInstance(AddressBook.kABSocialProfileServiceFlickr, str)
        self.assertIsInstance(AddressBook.kABSocialProfileServiceMySpace, str)

    @min_os_level("10.6")
    def testConstants10_6(self):
        self.assertIsInstance(AddressBook.kABPhoneiPhoneLabel, str)
        self.assertEqual(AddressBook.kABShowAsResource, 2)
        self.assertEqual(AddressBook.kABShowAsRoom, 3)

    @min_os_level("10.5")
    def testConstants10_5(self):
        self.assertIsInstance(AddressBook.kABCalendarURIsProperty, str)

    @expectedFailureIf(os_level_key(os_release()) < os_level_key("10.14"))
    def testConstants_10_7_broken(self):
        self.assertIsInstance(AddressBook.kABEmailMobileMeLabel, str)
        self.assertIsInstance(AddressBook.kABAIMMobileMeLabel, str)

    def testConstants(self):
        self.assertEqual(AddressBook.kABShowAsMask, 0o7)
        self.assertEqual(AddressBook.kABShowAsPerson, 0o0)
        self.assertEqual(AddressBook.kABShowAsCompany, 0o1)
        self.assertEqual(AddressBook.kABNameOrderingMask, 0o70)
        self.assertEqual(AddressBook.kABDefaultNameOrdering, 0o0)
        self.assertEqual(AddressBook.kABFirstNameFirst, 0o40)
        self.assertEqual(AddressBook.kABLastNameFirst, 0o20)

        self.assertIsInstance(AddressBook.kABUIDProperty, str)
        self.assertIsInstance(AddressBook.kABCreationDateProperty, str)
        self.assertIsInstance(AddressBook.kABModificationDateProperty, str)
        self.assertIsInstance(AddressBook.kABFirstNameProperty, str)
        self.assertIsInstance(AddressBook.kABLastNameProperty, str)
        self.assertIsInstance(AddressBook.kABFirstNamePhoneticProperty, str)
        self.assertIsInstance(AddressBook.kABLastNamePhoneticProperty, str)
        self.assertIsInstance(AddressBook.kABNicknameProperty, str)
        self.assertIsInstance(AddressBook.kABMaidenNameProperty, str)
        self.assertIsInstance(AddressBook.kABBirthdayProperty, str)

        self.assertIsInstance(AddressBook.kABOrganizationProperty, str)
        self.assertIsInstance(AddressBook.kABJobTitleProperty, str)
        self.assertIsInstance(AddressBook.kABHomePageProperty, str)
        self.assertIsInstance(AddressBook.kABURLsProperty, str)
        self.assertIsInstance(AddressBook.kABHomePageLabel, str)
        self.assertIsInstance(AddressBook.kABEmailProperty, str)
        self.assertIsInstance(AddressBook.kABEmailWorkLabel, str)
        self.assertIsInstance(AddressBook.kABEmailHomeLabel, str)
        self.assertIsInstance(AddressBook.kABAddressProperty, str)
        self.assertIsInstance(AddressBook.kABAddressStreetKey, str)
        self.assertIsInstance(AddressBook.kABAddressCityKey, str)
        self.assertIsInstance(AddressBook.kABAddressStateKey, str)
        self.assertIsInstance(AddressBook.kABAddressZIPKey, str)
        self.assertIsInstance(AddressBook.kABAddressCountryKey, str)
        self.assertIsInstance(AddressBook.kABAddressCountryCodeKey, str)
        self.assertIsInstance(AddressBook.kABAddressHomeLabel, str)
        self.assertIsInstance(AddressBook.kABAddressWorkLabel, str)
        self.assertIsInstance(AddressBook.kABOtherDatesProperty, str)
        self.assertIsInstance(AddressBook.kABAnniversaryLabel, str)
        self.assertIsInstance(AddressBook.kABRelatedNamesProperty, str)
        self.assertIsInstance(AddressBook.kABFatherLabel, str)
        self.assertIsInstance(AddressBook.kABMotherLabel, str)
        self.assertIsInstance(AddressBook.kABParentLabel, str)
        self.assertIsInstance(AddressBook.kABBrotherLabel, str)
        self.assertIsInstance(AddressBook.kABSisterLabel, str)
        self.assertIsInstance(AddressBook.kABChildLabel, str)
        self.assertIsInstance(AddressBook.kABFriendLabel, str)
        self.assertIsInstance(AddressBook.kABSpouseLabel, str)
        self.assertIsInstance(AddressBook.kABPartnerLabel, str)
        self.assertIsInstance(AddressBook.kABAssistantLabel, str)
        self.assertIsInstance(AddressBook.kABManagerLabel, str)
        self.assertIsInstance(AddressBook.kABDepartmentProperty, str)
        self.assertIsInstance(AddressBook.kABPersonFlags, str)
        self.assertIsInstance(AddressBook.kABPhoneProperty, str)
        self.assertIsInstance(AddressBook.kABPhoneWorkLabel, str)
        self.assertIsInstance(AddressBook.kABPhoneHomeLabel, str)
        self.assertIsInstance(AddressBook.kABPhoneMobileLabel, str)
        self.assertIsInstance(AddressBook.kABPhoneMainLabel, str)
        self.assertIsInstance(AddressBook.kABPhoneHomeFAXLabel, str)
        self.assertIsInstance(AddressBook.kABPhoneWorkFAXLabel, str)
        self.assertIsInstance(AddressBook.kABPhonePagerLabel, str)
        self.assertIsInstance(AddressBook.kABAIMInstantProperty, str)
        self.assertIsInstance(AddressBook.kABAIMWorkLabel, str)
        self.assertIsInstance(AddressBook.kABAIMHomeLabel, str)
        self.assertIsInstance(AddressBook.kABJabberInstantProperty, str)
        self.assertIsInstance(AddressBook.kABJabberWorkLabel, str)
        self.assertIsInstance(AddressBook.kABJabberHomeLabel, str)
        self.assertIsInstance(AddressBook.kABMSNInstantProperty, str)
        self.assertIsInstance(AddressBook.kABMSNWorkLabel, str)
        self.assertIsInstance(AddressBook.kABMSNHomeLabel, str)
        self.assertIsInstance(AddressBook.kABYahooInstantProperty, str)
        self.assertIsInstance(AddressBook.kABYahooWorkLabel, str)
        self.assertIsInstance(AddressBook.kABYahooHomeLabel, str)
        self.assertIsInstance(AddressBook.kABICQInstantProperty, str)
        self.assertIsInstance(AddressBook.kABICQWorkLabel, str)
        self.assertIsInstance(AddressBook.kABICQHomeLabel, str)
        self.assertIsInstance(AddressBook.kABNoteProperty, str)
        self.assertIsInstance(AddressBook.kABMiddleNameProperty, str)
        self.assertIsInstance(AddressBook.kABMiddleNamePhoneticProperty, str)
        self.assertIsInstance(AddressBook.kABTitleProperty, str)
        self.assertIsInstance(AddressBook.kABSuffixProperty, str)
        self.assertIsInstance(AddressBook.kABGroupNameProperty, str)
        self.assertIsInstance(AddressBook.kABWorkLabel, str)
        self.assertIsInstance(AddressBook.kABHomeLabel, str)
        self.assertIsInstance(AddressBook.kABOtherLabel, str)
        self.assertIsInstance(AddressBook.kABDatabaseChangedNotification, str)
        self.assertIsInstance(AddressBook.kABDatabaseChangedExternallyNotification, str)
        self.assertIsInstance(AddressBook.kABInsertedRecords, str)
        self.assertIsInstance(AddressBook.kABUpdatedRecords, str)
        self.assertIsInstance(AddressBook.kABDeletedRecords, str)

    def testFunctions(self):
        v = AddressBook.ABLocalizedPropertyOrLabel(AddressBook.kABAssistantLabel)
        self.assertIsInstance(v, str)
