#
# This file is generated using Tools/generate-helpers-vector.py
#
#    ** DO NOT EDIT **
#
from PyObjCTools.TestSupport import TestCase, min_os_level
import objc
from functools import partial
from objc import simd

# Tests use CGColorRef and CGColorSpaceRef. Try to import Quartz
# to get proper definitions for these types, otherwise fall back
# to minimal definitions (those aren't 100% correct, but good enough
# for these tests)
try:
    import Quartz  # noqa: F401
except ImportError:
    CGColorRef = objc.registerCFSignature("CGColorRef", b"^{CGColor=}", 0)
    CGColorSpaceRef = objc.registerCFSignature(
        "CGColorSpaceRef", b"^{CGColorSpace=}", 0
    )

from .vectorcall import OC_VectorCall, OC_VectorCallInvoke


class NoObjCClass:
    @property
    def __pyobjc_object__(self):
        raise TypeError("Cannot proxy")


class NoBool:
    def __bool__(self):
        raise TypeError("no valid in boolean context")


NoObjCValueObject = NoObjCClass()

# Register full signatures for the helper methods

objc.registerMetaDataForSelector(b"NSObject", b"v16C", {"full_signature": b"<16C>@:"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv16C", {"full_signature": b"<16C>@:"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v2d", {"full_signature": b"<2d>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"clsv2d", {"full_signature": b"<2d>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"v2dd:", {"full_signature": b"<2d>@:d"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv2dd:", {"full_signature": b"<2d>@:d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v2f", {"full_signature": b"<2f>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"clsv2f", {"full_signature": b"<2f>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"v2fQ:", {"full_signature": b"<2f>@:Q"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv2fQ:", {"full_signature": b"<2f>@:Q"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v2fd:", {"full_signature": b"<2f>@:d"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv2fd:", {"full_signature": b"<2f>@:d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v2fq:", {"full_signature": b"<2f>@:q"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv2fq:", {"full_signature": b"<2f>@:q"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v2i", {"full_signature": b"<2i>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"clsv2i", {"full_signature": b"<2i>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"v3dd:", {"full_signature": b"<3d>@:d"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3dd:", {"full_signature": b"<3d>@:d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v3f", {"full_signature": b"<3f>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"clsv3f", {"full_signature": b"<3f>@:"})
objc.registerMetaDataForSelector(
    b"NSObject", b"v3fv2i:v2i:", {"full_signature": b"<3f>@:<2i><2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3fv2i:v2i:", {"full_signature": b"<3f>@:<2i><2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"v3fv3f:", {"full_signature": b"<3f>@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3fv3f:", {"full_signature": b"<3f>@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"v3fv3f:id:", {"full_signature": b"<3f>@:<3f>@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3fv3f:id:", {"full_signature": b"<3f>@:<3f>@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"v3fv4i:", {"full_signature": b"<3f>@:<4i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3fv4i:", {"full_signature": b"<3f>@:<4i>"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v3fQ:", {"full_signature": b"<3f>@:Q"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3fQ:", {"full_signature": b"<3f>@:Q"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v3fd:", {"full_signature": b"<3f>@:d"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv3fd:", {"full_signature": b"<3f>@:d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v4dd:", {"full_signature": b"<4d>@:d"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv4dd:", {"full_signature": b"<4d>@:d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"v4f", {"full_signature": b"<4f>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"clsv4f", {"full_signature": b"<4f>@:"})
objc.registerMetaDataForSelector(b"NSObject", b"v4fd:", {"full_signature": b"<4f>@:d"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv4fd:", {"full_signature": b"<4f>@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"v4iv3f:", {"full_signature": b"<4i>@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsv4iv3f:", {"full_signature": b"<4i>@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv2d:id:", {"full_signature": b"@@:<2d>@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2d:id:", {"full_signature": b"@@:<2d>@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv2d:q:", {"full_signature": b"@@:<2d>q"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2d:q:", {"full_signature": b"@@:<2d>q"}
)
objc.registerMetaDataForSelector(b"NSObject", b"idv2f:", {"full_signature": b"@@:<2f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2f:", {"full_signature": b"@@:<2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv2f:v2I:q:id:", {"full_signature": b"@@:<2f><2I>q@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2f:v2I:q:id:", {"full_signature": b"@@:<2f><2I>q@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv2f:v2f:", {"full_signature": b"@@:<2f><2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2f:v2f:", {"full_signature": b"@@:<2f><2f>"}
)
objc.registerMetaDataForSelector(b"NSObject", b"idv2i:", {"full_signature": b"@@:<2i>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2i:", {"full_signature": b"@@:<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv2i:i:i:Z:", {"full_signature": b"@@:<2i>iiZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2i:i:i:Z:", {"full_signature": b"@@:<2i>iiZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv2i:i:i:Z:Class:", {"full_signature": b"@@:<2i>iiZ#"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv2i:i:i:Z:Class:", {"full_signature": b"@@:<2i>iiZ#"}
)
objc.registerMetaDataForSelector(b"NSObject", b"idv3f:", {"full_signature": b"@@:<3f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:", {"full_signature": b"@@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v2I:Z:Z:Z:q:id:", {"full_signature": b"@@:<3f><2I>ZZZq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v2I:Z:Z:Z:q:id:", {"full_signature": b"@@:<3f><2I>ZZZq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v2I:Z:Z:q:id:", {"full_signature": b"@@:<3f><2I>ZZq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v2I:Z:Z:q:id:", {"full_signature": b"@@:<3f><2I>ZZq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v2I:Z:q:id:", {"full_signature": b"@@:<3f><2I>Zq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v2I:Z:q:id:", {"full_signature": b"@@:<3f><2I>Zq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v2I:i:Z:q:id:", {"full_signature": b"@@:<3f><2I>iZq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v2I:i:Z:q:id:", {"full_signature": b"@@:<3f><2I>iZq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v2I:q:id:", {"full_signature": b"@@:<3f><2I>q@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v2I:q:id:", {"full_signature": b"@@:<3f><2I>q@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v3I:Z:q:id:", {"full_signature": b"@@:<3f><3I>Zq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v3I:Z:q:id:", {"full_signature": b"@@:<3f><3I>Zq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:v3I:q:Z:id:", {"full_signature": b"@@:<3f><3I>qZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:v3I:q:Z:id:", {"full_signature": b"@@:<3f><3I>qZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:Q:Q:q:Z:Z:id:", {"full_signature": b"@@:<3f>QQqZZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:Q:Q:q:Z:Z:id:", {"full_signature": b"@@:<3f>QQqZZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idv3f:Z:q:id:", {"full_signature": b"@@:<3f>Zq@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv3f:Z:q:id:", {"full_signature": b"@@:<3f>Zq@"}
)
objc.registerMetaDataForSelector(b"NSObject", b"idv4f:", {"full_signature": b"@@:<4f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidv4f:", {"full_signature": b"@@:<4f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:v2d:v2d:v2i:Z:", {"full_signature": b"@@:@<2d><2d><2i>Z"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:v2d:v2d:v2i:Z:", {"full_signature": b"@@:@<2d><2d><2i>Z"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:v2f:", {"full_signature": b"@@:@<2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:v2f:", {"full_signature": b"@@:@<2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:v3f:", {"full_signature": b"@@:@<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:v3f:", {"full_signature": b"@@:@<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:v4f:", {"full_signature": b"@@:@<4f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:v4f:", {"full_signature": b"@@:@<4f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:id:v2i:", {"full_signature": b"@@:@@<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:id:v2i:", {"full_signature": b"@@:@@<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:id:v2i:f:", {"full_signature": b"@@:@@<2i>f"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:id:v2i:f:", {"full_signature": b"@@:@@<2i>f"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:Q:v2f:", {"full_signature": b"@@:@Q<2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:Q:v2f:", {"full_signature": b"@@:@Q<2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:Q:v3f:", {"full_signature": b"@@:@Q<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:Q:v3f:", {"full_signature": b"@@:@Q<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:Q:v4f:", {"full_signature": b"@@:@Q<4f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:Q:v4f:", {"full_signature": b"@@:@Q<4f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idid:Q:simdfloat4x4:",
    {"full_signature": b"@@:@Q{simd_float4x4=[4<4f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidid:Q:simdfloat4x4:",
    {"full_signature": b"@@:@Q{simd_float4x4=[4<4f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:Z:id:v2i:q:Q:q:Z:", {"full_signature": b"@@:@Z@<2i>qQqZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:Z:id:v2i:q:Q:q:Z:", {"full_signature": b"@@:@Z@<2i>qQqZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:q:v2i:f:f:f:f:", {"full_signature": b"@@:@q<2i>ffff"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:q:v2i:f:f:f:f:", {"full_signature": b"@@:@q<2i>ffff"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:q:v2i:f:f:f:f:f:", {"full_signature": b"@@:@q<2i>fffff"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:q:v2i:f:f:f:f:f:", {"full_signature": b"@@:@q<2i>fffff"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:GKBox:", {"full_signature": b"@@:@{GKBox=<3f><3f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:GKBox:", {"full_signature": b"@@:@{GKBox=<3f><3f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:GKQuad:", {"full_signature": b"@@:@{GKQuad=<2f><2f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:GKQuad:", {"full_signature": b"@@:@{GKQuad=<2f><2f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idid:MDLAxisAlignedBoundingBox:f:",
    {"full_signature": b"@@:@{MDLAxisAlignedBoundingBox=<3f><3f>}f"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidid:MDLAxisAlignedBoundingBox:f:",
    {"full_signature": b"@@:@{MDLAxisAlignedBoundingBox=<3f><3f>}f"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idid:simdfloat2x2:",
    {"full_signature": b"@@:@{simd_float2x2=[2<2f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidid:simdfloat2x2:",
    {"full_signature": b"@@:@{simd_float2x2=[2<2f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idid:simdfloat3x3:",
    {"full_signature": b"@@:@{simd_float3x3=[3<3f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidid:simdfloat3x3:",
    {"full_signature": b"@@:@{simd_float3x3=[3<3f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idid:simdfloat4x4:",
    {"full_signature": b"@@:@{simd_float4x4=[4<4f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidid:simdfloat4x4:",
    {"full_signature": b"@@:@{simd_float4x4=[4<4f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:simdquatf:", {"full_signature": b"@@:@{simd_quatf=<4f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:simdquatf:", {"full_signature": b"@@:@{simd_quatf=<4f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idid:simdquatf:id:", {"full_signature": b"@@:@{simd_quatf=<4f>}@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidid:simdquatf:id:", {"full_signature": b"@@:@{simd_quatf=<4f>}@"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idCGColor:CGColor:id:v2i:",
    {"full_signature": b"@@:^{CGColor=}^{CGColor=}@<2i>"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidCGColor:CGColor:id:v2i:",
    {"full_signature": b"@@:^{CGColor=}^{CGColor=}@<2i>"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:v2f:v2f:", {"full_signature": b"@@:f<2f><2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:v2f:v2f:", {"full_signature": b"@@:f<2f><2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:v2f:v2f:Class:", {"full_signature": b"@@:f<2f><2f>#"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:v2f:v2f:Class:", {"full_signature": b"@@:f<2f><2f>#"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:v2f:Q:Q:Q:q:Z:id:", {"full_signature": b"@@:f<2f>QQQqZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:v2f:Q:Q:Q:q:Z:id:", {"full_signature": b"@@:f<2f>QQQqZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:v2f:Q:Q:q:Z:id:", {"full_signature": b"@@:f<2f>QQqZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:v2f:Q:Q:q:Z:id:", {"full_signature": b"@@:f<2f>QQqZ@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:id:v2i:i:q:Z:", {"full_signature": b"@@:f@<2i>iqZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:id:v2i:i:q:Z:", {"full_signature": b"@@:f@<2i>iqZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idf:id:v2i:i:q:CGColor:CGColor:",
    {"full_signature": b"@@:f@<2i>iq^{CGColor=}^{CGColor=}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidf:id:v2i:i:q:CGColor:CGColor:",
    {"full_signature": b"@@:f@<2i>iq^{CGColor=}^{CGColor=}"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:id:v2i:q:", {"full_signature": b"@@:f@<2i>q"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:id:v2i:q:", {"full_signature": b"@@:f@<2i>q"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idf:f:id:v2i:", {"full_signature": b"@@:ff@<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidf:f:id:v2i:", {"full_signature": b"@@:ff@<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idGKBox:", {"full_signature": b"@@:{GKBox=<3f><3f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidGKBox:", {"full_signature": b"@@:{GKBox=<3f><3f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idGKBox:f:", {"full_signature": b"@@:{GKBox=<3f><3f>}f"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidGKBox:f:", {"full_signature": b"@@:{GKBox=<3f><3f>}f"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idGKQuad:", {"full_signature": b"@@:{GKQuad=<2f><2f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidGKQuad:", {"full_signature": b"@@:{GKQuad=<2f><2f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idGKQuad:f:", {"full_signature": b"@@:{GKQuad=<2f><2f>}f"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsidGKQuad:f:", {"full_signature": b"@@:{GKQuad=<2f><2f>}f"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idMDLVoxelIndexExtent:",
    {"full_signature": b"@@:{MDLVoxelIndexExtent=<4i><4i>}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidMDLVoxelIndexExtent:",
    {"full_signature": b"@@:{MDLVoxelIndexExtent=<4i><4i>}"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"idsimdfloat4x4:", {"full_signature": b"@@:{simd_float4x4=[4<4f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidsimdfloat4x4:",
    {"full_signature": b"@@:{simd_float4x4=[4<4f>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"idsimdfloat4x4:Z:",
    {"full_signature": b"@@:{simd_float4x4=[4<4f>]}Z"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsidsimdfloat4x4:Z:",
    {"full_signature": b"@@:{simd_float4x4=[4<4f>]}Z"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"Zv2i:id:id:id:id:", {"full_signature": b"Z@:<2i>@@@@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsZv2i:id:id:id:id:", {"full_signature": b"Z@:<2i>@@@@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"Zv2i:q:f:id:id:id:", {"full_signature": b"Z@:<2i>qf@@@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsZv2i:q:f:id:id:id:", {"full_signature": b"Z@:<2i>qf@@@"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"Zv4i:Z:Z:Z:Z:", {"full_signature": b"Z@:<4i>ZZZZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsZv4i:Z:Z:Z:Z:", {"full_signature": b"Z@:<4i>ZZZZ"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"CGColorv3f:", {"full_signature": b"^{CGColor=}@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsCGColorv3f:", {"full_signature": b"^{CGColor=}@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"CGColorv3f:CGColorSpace:",
    {"full_signature": b"^{CGColor=}@:<3f>^{CGColorSpace=}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsCGColorv3f:CGColorSpace:",
    {"full_signature": b"^{CGColor=}@:<3f>^{CGColorSpace=}"},
)
objc.registerMetaDataForSelector(b"NSObject", b"fv2f:", {"full_signature": b"f@:<2f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsfv2f:", {"full_signature": b"f@:<2f>"}
)
objc.registerMetaDataForSelector(b"NSObject", b"fv2i:", {"full_signature": b"f@:<2i>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsfv2i:", {"full_signature": b"f@:<2i>"}
)
objc.registerMetaDataForSelector(b"NSObject", b"vv2d:", {"full_signature": b"v@:<2d>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv2d:", {"full_signature": b"v@:<2d>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv2d:d:", {"full_signature": b"v@:<2d>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv2d:d:", {"full_signature": b"v@:<2d>d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"vv2f:", {"full_signature": b"v@:<2f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv2f:", {"full_signature": b"v@:<2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv2f:d:", {"full_signature": b"v@:<2f>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv2f:d:", {"full_signature": b"v@:<2f>d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"vv3d:", {"full_signature": b"v@:<3d>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv3d:", {"full_signature": b"v@:<3d>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv3d:d:", {"full_signature": b"v@:<3d>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv3d:d:", {"full_signature": b"v@:<3d>d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"vv3f:", {"full_signature": b"v@:<3f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv3f:", {"full_signature": b"v@:<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv3f:v3f:", {"full_signature": b"v@:<3f><3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv3f:v3f:", {"full_signature": b"v@:<3f><3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv3f:v3f:v3f:", {"full_signature": b"v@:<3f><3f><3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv3f:v3f:v3f:", {"full_signature": b"v@:<3f><3f><3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv3f:d:", {"full_signature": b"v@:<3f>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv3f:d:", {"full_signature": b"v@:<3f>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv4d:d:", {"full_signature": b"v@:<4d>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv4d:d:", {"full_signature": b"v@:<4d>d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"vv4f:", {"full_signature": b"v@:<4f>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv4f:", {"full_signature": b"v@:<4f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vv4f:d:", {"full_signature": b"v@:<4f>d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv4f:d:", {"full_signature": b"v@:<4f>d"}
)
objc.registerMetaDataForSelector(b"NSObject", b"vv4i:", {"full_signature": b"v@:<4i>"})
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvv4i:", {"full_signature": b"v@:<4i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vid:v2f:v2f:", {"full_signature": b"v@:@<2f><2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvid:v2f:v2f:", {"full_signature": b"v@:@<2f><2f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vid:v2f:v2f:q:", {"full_signature": b"v@:@<2f><2f>q"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvid:v2f:v2f:q:", {"full_signature": b"v@:@<2f><2f>q"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vf:v2i:", {"full_signature": b"v@:f<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvf:v2i:", {"full_signature": b"v@:f<2i>"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"vMDLAxisAlignedBoundingBox:",
    {"full_signature": b"v@:{MDLAxisAlignedBoundingBox=<3f><3f>}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsvMDLAxisAlignedBoundingBox:",
    {"full_signature": b"v@:{MDLAxisAlignedBoundingBox=<3f><3f>}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"vMDLAxisAlignedBoundingBox:Z:",
    {"full_signature": b"v@:{MDLAxisAlignedBoundingBox=<3f><3f>}Z"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsvMDLAxisAlignedBoundingBox:Z:",
    {"full_signature": b"v@:{MDLAxisAlignedBoundingBox=<3f><3f>}Z"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimddouble4x4:", {"full_signature": b"v@:{simd_double4x4=[4<4d>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsvsimddouble4x4:",
    {"full_signature": b"v@:{simd_double4x4=[4<4d>]}"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"vsimddouble4x4:d:",
    {"full_signature": b"v@:{simd_double4x4=[4<4d>]}d"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsvsimddouble4x4:d:",
    {"full_signature": b"v@:{simd_double4x4=[4<4d>]}d"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdfloat2x2:", {"full_signature": b"v@:{simd_float2x2=[2<2f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdfloat2x2:", {"full_signature": b"v@:{simd_float2x2=[2<2f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdfloat3x3:", {"full_signature": b"v@:{simd_float3x3=[3<3f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdfloat3x3:", {"full_signature": b"v@:{simd_float3x3=[3<3f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdfloat4x4:", {"full_signature": b"v@:{simd_float4x4=[4<4f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdfloat4x4:", {"full_signature": b"v@:{simd_float4x4=[4<4f>]}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdfloat4x4:d:", {"full_signature": b"v@:{simd_float4x4=[4<4f>]}d"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsvsimdfloat4x4:d:",
    {"full_signature": b"v@:{simd_float4x4=[4<4f>]}d"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdquatd:d:", {"full_signature": b"v@:{simd_quatd=<4d>}d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdquatd:d:", {"full_signature": b"v@:{simd_quatd=<4d>}d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdquatf:", {"full_signature": b"v@:{simd_quatf=<4f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdquatf:", {"full_signature": b"v@:{simd_quatf=<4f>}"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdquatf:v3f:", {"full_signature": b"v@:{simd_quatf=<4f>}<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdquatf:v3f:", {"full_signature": b"v@:{simd_quatf=<4f>}<3f>"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"vsimdquatf:d:", {"full_signature": b"v@:{simd_quatf=<4f>}d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsvsimdquatf:d:", {"full_signature": b"v@:{simd_quatf=<4f>}d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"GKBox", {"full_signature": b"{GKBox=<3f><3f>}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsGKBox", {"full_signature": b"{GKBox=<3f><3f>}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"GKQuad", {"full_signature": b"{GKQuad=<2f><2f>}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsGKQuad", {"full_signature": b"{GKQuad=<2f><2f>}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"GKTriangleQ:", {"full_signature": b"{GKTriangle=[3<3f>]}@:Q"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clsGKTriangleQ:", {"full_signature": b"{GKTriangle=[3<3f>]}@:Q"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"MDLAxisAlignedBoundingBox",
    {"full_signature": b"{MDLAxisAlignedBoundingBox=<3f><3f>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsMDLAxisAlignedBoundingBox",
    {"full_signature": b"{MDLAxisAlignedBoundingBox=<3f><3f>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"MDLAxisAlignedBoundingBoxv4i:",
    {"full_signature": b"{MDLAxisAlignedBoundingBox=<3f><3f>}@:<4i>"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsMDLAxisAlignedBoundingBoxv4i:",
    {"full_signature": b"{MDLAxisAlignedBoundingBox=<3f><3f>}@:<4i>"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"MDLAxisAlignedBoundingBoxd:",
    {"full_signature": b"{MDLAxisAlignedBoundingBox=<3f><3f>}@:d"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsMDLAxisAlignedBoundingBoxd:",
    {"full_signature": b"{MDLAxisAlignedBoundingBox=<3f><3f>}@:d"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"MDLVoxelIndexExtent",
    {"full_signature": b"{MDLVoxelIndexExtent=<4i><4i>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsMDLVoxelIndexExtent",
    {"full_signature": b"{MDLVoxelIndexExtent=<4i><4i>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"MPSImageHistogramInfo",
    {"full_signature": b"{MPSImageHistogramInfo=QZ<4f><4f>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsMPSImageHistogramInfo",
    {"full_signature": b"{MPSImageHistogramInfo=QZ<4f><4f>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"MPSAxisAlignedBoundingBox",
    {"full_signature": b"{_MPSAxisAlignedBoundingBox=<3f><3f>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clsMPSAxisAlignedBoundingBox",
    {"full_signature": b"{_MPSAxisAlignedBoundingBox=<3f><3f>}@:"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simddouble4x4", {"full_signature": b"{simd_double4x4=[4<4d>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimddouble4x4", {"full_signature": b"{simd_double4x4=[4<4d>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simddouble4x4d:", {"full_signature": b"{simd_double4x4=[4<4d>]}@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clssimddouble4x4d:",
    {"full_signature": b"{simd_double4x4=[4<4d>]}@:d"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdfloat2x2", {"full_signature": b"{simd_float2x2=[2<2f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdfloat2x2", {"full_signature": b"{simd_float2x2=[2<2f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdfloat3x3", {"full_signature": b"{simd_float3x3=[3<3f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdfloat3x3", {"full_signature": b"{simd_float3x3=[3<3f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdfloat4x3", {"full_signature": b"{simd_float4x3=[4<3f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdfloat4x3", {"full_signature": b"{simd_float4x3=[4<3f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdfloat4x4", {"full_signature": b"{simd_float4x4=[4<4f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdfloat4x4", {"full_signature": b"{simd_float4x4=[4<4f>]}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"simdfloat4x4id:d:",
    {"full_signature": b"{simd_float4x4=[4<4f>]}@:@d"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clssimdfloat4x4id:d:",
    {"full_signature": b"{simd_float4x4=[4<4f>]}@:@d"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdfloat4x4d:", {"full_signature": b"{simd_float4x4=[4<4f>]}@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdfloat4x4d:", {"full_signature": b"{simd_float4x4=[4<4f>]}@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"simdfloat4x4simdfloat4x4:id:",
    {"full_signature": b"{simd_float4x4=[4<4f>]}@:{simd_float4x4=[4<4f>]}@"},
)
objc.registerMetaDataForSelector(
    b"NSObject",
    b"clssimdfloat4x4simdfloat4x4:id:",
    {"full_signature": b"{simd_float4x4=[4<4f>]}@:{simd_float4x4=[4<4f>]}@"},
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdquatdd:", {"full_signature": b"{simd_quatd=<4d>}@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdquatdd:", {"full_signature": b"{simd_quatd=<4d>}@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdquatf", {"full_signature": b"{simd_quatf=<4f>}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdquatf", {"full_signature": b"{simd_quatf=<4f>}@:"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"simdquatfd:", {"full_signature": b"{simd_quatf=<4f>}@:d"}
)
objc.registerMetaDataForSelector(
    b"NSObject", b"clssimdquatfd:", {"full_signature": b"{simd_quatf=<4f>}@:d"}
)


class OC_VectorCallInstance(objc.lookUpClass("NSObject")):
    def v16C(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_uchar16(
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
        )

    def v2d(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double2(0.0, 1.5)

    def v2dd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double2(0.0, 1.5)

    def v2f(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    def v2fQ_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    def v2fd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    def v2fq_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    def v2i(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_int2(0, 1)

    def v3dd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double3(0.0, 1.5, 3.0)

    def v3f(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v3fv2i_v2i_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v3fv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v3fv3f_id_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v3fv4i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v3fQ_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v3fd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    def v4dd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5)

    def v4f(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)

    def v4fd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)

    def v4iv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_int4(0, 1, 2, 3)

    def idv2d_id_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2d_q_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2f_v2I_q_id_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2f_v2f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2i_i_i_Z_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv2i_i_i_Z_Class_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v2I_Z_Z_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v2I_Z_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v2I_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v2I_i_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v2I_q_id_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v3I_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_v3I_q_Z_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_Q_Q_q_Z_Z_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv3f_Z_q_id_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idv4f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_v2d_v2d_v2i_Z_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_v2f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_v3f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_v4f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_id_v2i_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_id_v2i_f_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_Q_v2f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_Q_v3f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_Q_v4f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_Q_simdfloat4x4_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_Z_id_v2i_q_Q_q_Z_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
            arg7,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_q_v2i_f_f_f_f_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_q_v2i_f_f_f_f_f_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
            arg7,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    if objc.macos_available(10, 12):

        def idid_GKBox_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        def idid_GKQuad_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 11):

        def idid_MDLAxisAlignedBoundingBox_f_(self, arg0, arg1, arg2):
            self.argvalues = (
                arg0,
                arg1,
                arg2,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    def idid_simdfloat2x2_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_simdfloat3x3_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idid_simdfloat4x4_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    if objc.macos_available(10, 13):

        def idid_simdquatf_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 13):

        def idid_simdquatf_id_(self, arg0, arg1, arg2):
            self.argvalues = (
                arg0,
                arg1,
                arg2,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    def idCGColor_CGColor_id_v2i_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_v2f_v2f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_v2f_v2f_Class_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_v2f_Q_Q_Q_q_Z_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
            arg7,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_v2f_Q_Q_q_Z_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_id_v2i_i_q_Z_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_id_v2i_i_q_CGColor_CGColor_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_id_v2i_q_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idf_f_id_v2i_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    if objc.macos_available(10, 12):

        def idGKBox_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        def idGKBox_f_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        def idGKQuad_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        def idGKQuad_f_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 11):

        def idMDLVoxelIndexExtent_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    def idsimdfloat4x4_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def idsimdfloat4x4_Z_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    def Zv2i_id_id_id_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return False

    def Zv2i_q_f_id_id_id_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return False

    def Zv4i_Z_Z_Z_Z_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return False

    def CGColorv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "color!"

    def CGColorv3f_CGColorSpace_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "color!"

    def fv2f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return 2500000000.0

    def fv2i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return 2500000000.0

    def vv2d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv2d_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv2f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv2f_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv3d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv3d_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv3f_v3f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv3f_v3f_v3f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv3f_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv4d_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv4f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv4f_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vv4i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vid_v2f_v2f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vid_v2f_v2f_q_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vf_v2i_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    if objc.macos_available(10, 11):

        def vMDLAxisAlignedBoundingBox_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 11):

        def vMDLAxisAlignedBoundingBox_Z_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    def vsimddouble4x4_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vsimddouble4x4_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vsimdfloat2x2_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vsimdfloat3x3_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vsimdfloat4x4_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    def vsimdfloat4x4_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    if objc.macos_available(10, 13):

        def vsimdquatd_d_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 13):

        def vsimdquatf_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 13):

        def vsimdquatf_v3f_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 13):

        def vsimdquatf_d_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 12):

        def GKBox(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            )

    if objc.macos_available(10, 12):

        def GKQuad(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float2(9.0, 10.0),
                objc.simd.vector_float2(11.0, 12.0),
            )

    if objc.macos_available(10, 12):

        def GKTriangleQ_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                (
                    objc.simd.vector_float3(-18.5, -19.5, -110.5),
                    objc.simd.vector_float3(-111.5, -112.5, -113.5),
                    objc.simd.vector_float3(-17.5, 11.5, 122.5),
                ),
            )

    if objc.macos_available(10, 11):

        def MDLAxisAlignedBoundingBox(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            )

    if objc.macos_available(10, 11):

        def MDLAxisAlignedBoundingBoxv4i_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            )

    if objc.macos_available(10, 11):

        def MDLAxisAlignedBoundingBoxd_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            )

    if objc.macos_available(10, 11):

        def MDLVoxelIndexExtent(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_int4(100, 101, 102, 103),
                objc.simd.vector_int4(-20, -21, -22, -23),
            )

    if objc.macos_available(10, 13):

        def MPSImageHistogramInfo(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                4398046511104,
                True,
                objc.simd.vector_float4(1.0, 2.0, 3.0, 4.0),
                objc.simd.vector_float4(-1.0, -2.0, -3.0, -4.0),
            )

    if objc.macos_available(10, 14):

        def MPSAxisAlignedBoundingBox(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(1.5, 2.5, 3.5),
                objc.simd.vector_float3(4.5, 5.5, 6.5),
            )

    def simddouble4x4(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_double4x4(
            (
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
            )
        )

    def simddouble4x4d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_double4x4(
            (
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
            )
        )

    def simdfloat2x2(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float2x2(
            (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
        )

    def simdfloat3x3(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float3x3(
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )
        )

    def simdfloat4x3(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x3(
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )
        )

    def simdfloat4x4(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    def simdfloat4x4id_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    def simdfloat4x4d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    def simdfloat4x4simdfloat4x4_id_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    if objc.macos_available(10, 13):

        def simdquatdd_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return simd.simd_quatd(objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

    if objc.macos_available(10, 13):

        def simdquatf(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    if objc.macos_available(10, 13):

        def simdquatfd_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))


class OC_VectorCallClass(objc.lookUpClass("NSObject")):
    @classmethod
    def v16C(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_uchar16(
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
        )

    @classmethod
    def v2d(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double2(0.0, 1.5)

    @classmethod
    def v2dd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double2(0.0, 1.5)

    @classmethod
    def v2f(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    @classmethod
    def v2fQ_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    @classmethod
    def v2fd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    @classmethod
    def v2fq_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float2(0.0, 1.5)

    @classmethod
    def v2i(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_int2(0, 1)

    @classmethod
    def v3dd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double3(0.0, 1.5, 3.0)

    @classmethod
    def v3f(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v3fv2i_v2i_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v3fv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v3fv3f_id_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v3fv4i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v3fQ_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v3fd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float3(0.0, 1.5, 3.0)

    @classmethod
    def v4dd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5)

    @classmethod
    def v4f(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)

    @classmethod
    def v4fd_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)

    @classmethod
    def v4iv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return objc.simd.vector_int4(0, 1, 2, 3)

    @classmethod
    def idv2d_id_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2d_q_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2f_v2I_q_id_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2f_v2f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2i_i_i_Z_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv2i_i_i_Z_Class_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v2I_Z_Z_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v2I_Z_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v2I_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v2I_i_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v2I_q_id_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v3I_Z_q_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_v3I_q_Z_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_Q_Q_q_Z_Z_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv3f_Z_q_id_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idv4f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_v2d_v2d_v2i_Z_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_v2f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_v3f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_v4f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_id_v2i_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_id_v2i_f_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_Q_v2f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_Q_v3f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_Q_v4f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_Q_simdfloat4x4_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_Z_id_v2i_q_Q_q_Z_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
            arg7,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_q_v2i_f_f_f_f_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_q_v2i_f_f_f_f_f_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
            arg7,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    if objc.macos_available(10, 12):

        @classmethod
        def idid_GKBox_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        @classmethod
        def idid_GKQuad_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 11):

        @classmethod
        def idid_MDLAxisAlignedBoundingBox_f_(self, arg0, arg1, arg2):
            self.argvalues = (
                arg0,
                arg1,
                arg2,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    @classmethod
    def idid_simdfloat2x2_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_simdfloat3x3_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idid_simdfloat4x4_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    if objc.macos_available(10, 13):

        @classmethod
        def idid_simdquatf_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 13):

        @classmethod
        def idid_simdquatf_id_(self, arg0, arg1, arg2):
            self.argvalues = (
                arg0,
                arg1,
                arg2,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    @classmethod
    def idCGColor_CGColor_id_v2i_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_v2f_v2f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_v2f_v2f_Class_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_v2f_Q_Q_Q_q_Z_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
            arg7,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_v2f_Q_Q_q_Z_id_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_id_v2i_i_q_Z_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_id_v2i_i_q_CGColor_CGColor_(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
            arg6,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_id_v2i_q_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idf_f_id_v2i_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    if objc.macos_available(10, 12):

        @classmethod
        def idGKBox_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        @classmethod
        def idGKBox_f_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        @classmethod
        def idGKQuad_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 12):

        @classmethod
        def idGKQuad_f_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    if objc.macos_available(10, 11):

        @classmethod
        def idMDLVoxelIndexExtent_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return "hello"

    @classmethod
    def idsimdfloat4x4_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def idsimdfloat4x4_Z_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "hello"

    @classmethod
    def Zv2i_id_id_id_id_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return False

    @classmethod
    def Zv2i_q_f_id_id_id_(self, arg0, arg1, arg2, arg3, arg4, arg5):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
            arg5,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return False

    @classmethod
    def Zv4i_Z_Z_Z_Z_(self, arg0, arg1, arg2, arg3, arg4):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
            arg4,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return False

    @classmethod
    def CGColorv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "color!"

    @classmethod
    def CGColorv3f_CGColorSpace_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return "color!"

    @classmethod
    def fv2f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return 2500000000.0

    @classmethod
    def fv2i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return 2500000000.0

    @classmethod
    def vv2d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv2d_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv2f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv2f_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv3d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv3d_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv3f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv3f_v3f_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv3f_v3f_v3f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv3f_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv4d_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv4f_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv4f_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vv4i_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vid_v2f_v2f_(self, arg0, arg1, arg2):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vid_v2f_v2f_q_(self, arg0, arg1, arg2, arg3):
        self.argvalues = (
            arg0,
            arg1,
            arg2,
            arg3,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vf_v2i_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    if objc.macos_available(10, 11):

        @classmethod
        def vMDLAxisAlignedBoundingBox_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 11):

        @classmethod
        def vMDLAxisAlignedBoundingBox_Z_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    @classmethod
    def vsimddouble4x4_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vsimddouble4x4_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vsimdfloat2x2_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vsimdfloat3x3_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vsimdfloat4x4_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    @classmethod
    def vsimdfloat4x4_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()

    if objc.macos_available(10, 13):

        @classmethod
        def vsimdquatd_d_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 13):

        @classmethod
        def vsimdquatf_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 13):

        @classmethod
        def vsimdquatf_v3f_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 13):

        @classmethod
        def vsimdquatf_d_(self, arg0, arg1):
            self.argvalues = (
                arg0,
                arg1,
            )
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()

    if objc.macos_available(10, 12):

        @classmethod
        def GKBox(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            )

    if objc.macos_available(10, 12):

        @classmethod
        def GKQuad(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float2(9.0, 10.0),
                objc.simd.vector_float2(11.0, 12.0),
            )

    if objc.macos_available(10, 12):

        @classmethod
        def GKTriangleQ_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                (
                    objc.simd.vector_float3(-18.5, -19.5, -110.5),
                    objc.simd.vector_float3(-111.5, -112.5, -113.5),
                    objc.simd.vector_float3(-17.5, 11.5, 122.5),
                ),
            )

    if objc.macos_available(10, 11):

        @classmethod
        def MDLAxisAlignedBoundingBox(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            )

    if objc.macos_available(10, 11):

        @classmethod
        def MDLAxisAlignedBoundingBoxv4i_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            )

    if objc.macos_available(10, 11):

        @classmethod
        def MDLAxisAlignedBoundingBoxd_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            )

    if objc.macos_available(10, 11):

        @classmethod
        def MDLVoxelIndexExtent(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_int4(100, 101, 102, 103),
                objc.simd.vector_int4(-20, -21, -22, -23),
            )

    if objc.macos_available(10, 13):

        @classmethod
        def MPSImageHistogramInfo(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                4398046511104,
                True,
                objc.simd.vector_float4(1.0, 2.0, 3.0, 4.0),
                objc.simd.vector_float4(-1.0, -2.0, -3.0, -4.0),
            )

    if objc.macos_available(10, 14):

        @classmethod
        def MPSAxisAlignedBoundingBox(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return (
                objc.simd.vector_float3(1.5, 2.5, 3.5),
                objc.simd.vector_float3(4.5, 5.5, 6.5),
            )

    @classmethod
    def simddouble4x4(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_double4x4(
            (
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
            )
        )

    @classmethod
    def simddouble4x4d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_double4x4(
            (
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5),
            )
        )

    @classmethod
    def simdfloat2x2(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float2x2(
            (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
        )

    @classmethod
    def simdfloat3x3(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float3x3(
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )
        )

    @classmethod
    def simdfloat4x3(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x3(
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )
        )

    @classmethod
    def simdfloat4x4(self):
        self.argvalues = None
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    @classmethod
    def simdfloat4x4id_d_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    @classmethod
    def simdfloat4x4d_(self, arg0):
        self.argvalues = (arg0,)
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    @classmethod
    def simdfloat4x4simdfloat4x4_id_(self, arg0, arg1):
        self.argvalues = (
            arg0,
            arg1,
        )
        if getattr(self, "shouldRaise", False):
            raise RuntimeError("failure!")
        if getattr(self, "returnInvalid", False):
            return NoObjCClass()
        return simd.simd_float4x4(
            (
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )
        )

    if objc.macos_available(10, 13):

        @classmethod
        def simdquatdd_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return simd.simd_quatd(objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

    if objc.macos_available(10, 13):

        @classmethod
        def simdquatf(self):
            self.argvalues = None
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    if objc.macos_available(10, 13):

        @classmethod
        def simdquatfd_(self, arg0):
            self.argvalues = (arg0,)
            if getattr(self, "shouldRaise", False):
                raise RuntimeError("failure!")
            if getattr(self, "returnInvalid", False):
                return NoObjCClass()
            return simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))


class TestVectorCall(TestCase):
    def __init__(self, *args, **kwds):
        super().__init__(*args, **kwds)
        self.addTypeEqualityFunc(simd.matrix_float2x2, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.matrix_float3x3, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.matrix_float4x3, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.matrix_float4x4, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.matrix_double4x4, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_quatf, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_quatd, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_float4x4, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_float2x2, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_float3x3, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_float4x3, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_float4x4, "assertMatrixEqual")
        self.addTypeEqualityFunc(simd.simd_double4x4, "assertMatrixEqual")

    def assertMatrixEqual(self, first, second, msg=None):
        self.assertEqual(type(first), type(second))
        if hasattr(first, "vector"):
            self.assertSequenceEqual(first.vector, second.vector, msg)
        else:
            self.assertSequenceEqual(first.columns, second.columns, msg)

    def test_v16C(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v16C.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v16C)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v16C, b"<16C>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v16C

        # Valid call
        rv = caller()
        self.assertEqual(
            rv,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_clsv16C(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv16C.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv16C)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv16C, b"<16C>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv16C

        # Valid call
        rv = caller()
        self.assertEqual(
            rv,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_v16C_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v16C.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v16C)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v16C, b"<16C>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v16C")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(
            rv,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
            )

    def test_clsv16C_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv16C.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv16C)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv16C, b"<16C>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv16C")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(
            rv,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )

        # Valid call through instance
        rv = imp(
            oc_inst,
        )
        self.assertEqual(
            rv,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )

        # Valid call through meta
        rv = imp(
            type(oc),
        )
        self.assertEqual(
            rv,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
            )

    def test_imp_v16C(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v16COn_(value)
        self.assertEqual(
            result,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v16COn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v16COn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v16C_cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v16COn_(value)
        self.assertEqual(
            result,
            objc.simd.vector_uchar16(
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
            ),
        )
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v16COn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v16COn_(value)
        finally:
            del value.returnInvalid

    def test_v2d(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2d.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2d)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2d, b"<2d>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2d

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_clsv2d(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2d.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2d)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2d, b"<2d>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2d

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_v2d_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2d.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2d)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2d, b"<2d>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2d")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
            )

    def test_clsv2d_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2d.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2d)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2d, b"<2d>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2d")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        # Valid call through instance
        rv = imp(
            oc_inst,
        )
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        # Valid call through meta
        rv = imp(
            type(oc),
        )
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
            )

    def test_imp_v2d(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2dOn_(value)
        self.assertEqual(result, objc.simd.vector_double2(0.0, 1.5))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2dOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2dOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2d_cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2dOn_(value)
        self.assertEqual(result, objc.simd.vector_double2(0.0, 1.5))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2dOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2dOn_(value)
        finally:
            del value.returnInvalid

    def test_v2dd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2dd_, b"<2d>")
        self.assertArgHasType(OC_VectorCall.v2dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2dd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_clsv2dd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2dd_, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsv2dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2dd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_v2dd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2dd_, b"<2d>")
        self.assertArgHasType(OC_VectorCall.v2dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2dd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -557000000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -557000000000.0)

    def test_clsv2dd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2dd_, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsv2dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2dd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        # Valid call through instance
        rv = imp(oc_inst, -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        # Valid call through meta
        rv = imp(type(oc), -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -557000000000.0)

    def test_imp_v2dd_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2ddOn_(value)
        self.assertEqual(result, objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2ddOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2ddOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2dd__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2ddOn_(value)
        self.assertEqual(result, objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2ddOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2ddOn_(value)
        finally:
            del value.returnInvalid

    def test_v2f(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2f, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2f

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_clsv2f(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2f, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2f

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_v2f_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2f, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2f")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
            )

    def test_clsv2f_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2f, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2f")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through instance
        rv = imp(
            oc_inst,
        )
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through meta
        rv = imp(
            type(oc),
        )
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
            )

    def test_imp_v2f(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2f_cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fOn_(value)
        finally:
            del value.returnInvalid

    def test_v2fQ_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2fQ_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.v2fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2fQ_

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

    def test_clsv2fQ_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2fQ_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsv2fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2fQ_

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

    def test_v2fQ__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2fQ_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.v2fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2fQ:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, 35184372088832)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, 35184372088832)

    def test_clsv2fQ__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2fQ_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsv2fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2fQ:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through instance
        rv = imp(oc_inst, 35184372088832)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through meta
        rv = imp(type(oc), 35184372088832)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, 35184372088832)

    def test_imp_v2fQ_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fQOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(value.argvalues, (35184372088832,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fQOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fQOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2fQ__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fQOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(value.argvalues, (35184372088832,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fQOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fQOn_(value)
        finally:
            del value.returnInvalid

    def test_v2fd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2fd_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.v2fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2fd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_clsv2fd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2fd_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsv2fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2fd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_v2fd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2fd_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.v2fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2fd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -557000000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -557000000000.0)

    def test_clsv2fd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2fd_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsv2fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2fd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through instance
        rv = imp(oc_inst, -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through meta
        rv = imp(type(oc), -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -557000000000.0)

    def test_imp_v2fd_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fdOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fdOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fdOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2fd__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fdOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fdOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fdOn_(value)
        finally:
            del value.returnInvalid

    def test_v2fq_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2fq_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2fq_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2fq_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.v2fq_, 0, b"q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2fq_

        # Valid call
        rv = caller(-17592186044416)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-17592186044416)

    def test_clsv2fq_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2fq_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2fq_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2fq_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsv2fq_, 0, b"q")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2fq_

        # Valid call
        rv = caller(-17592186044416)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-17592186044416)

    def test_v2fq__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2fq_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2fq_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2fq_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.v2fq_, 0, b"q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2fq:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-17592186044416)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-17592186044416)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -17592186044416)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -17592186044416)

    def test_clsv2fq__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2fq_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2fq_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2fq_, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsv2fq_, 0, b"q")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2fq:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-17592186044416)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through instance
        rv = imp(oc_inst, -17592186044416)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        # Valid call through meta
        rv = imp(type(oc), -17592186044416)
        self.assertEqual(rv, objc.simd.vector_float2(0.0, 1.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-17592186044416)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -17592186044416)

    def test_imp_v2fq_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fqOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(value.argvalues, (-17592186044416,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fqOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fqOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2fq__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2fqOn_(value)
        self.assertEqual(result, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(value.argvalues, (-17592186044416,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2fqOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2fqOn_(value)
        finally:
            del value.returnInvalid

    def test_v2i(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2i.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2i)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2i, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v2i

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_int2(0, 1))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_clsv2i(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2i.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2i)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2i, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv2i

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_int2(0, 1))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_v2i_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v2i.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v2i)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v2i, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v2i")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_int2(0, 1))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
            )

    def test_clsv2i_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv2i.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv2i)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv2i, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv2i")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_int2(0, 1))

        # Valid call through instance
        rv = imp(
            oc_inst,
        )
        self.assertEqual(rv, objc.simd.vector_int2(0, 1))

        # Valid call through meta
        rv = imp(
            type(oc),
        )
        self.assertEqual(rv, objc.simd.vector_int2(0, 1))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
            )

    def test_imp_v2i(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2iOn_(value)
        self.assertEqual(result, objc.simd.vector_int2(0, 1))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2iOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v2i_cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v2iOn_(value)
        self.assertEqual(result, objc.simd.vector_int2(0, 1))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v2iOn_(value)
        finally:
            del value.returnInvalid

    def test_v3dd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3dd_, b"<3d>")
        self.assertArgHasType(OC_VectorCall.v3dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3dd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_clsv3dd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3dd_, b"<3d>")
        self.assertArgHasType(OC_VectorCall.clsv3dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3dd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_v3dd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3dd_, b"<3d>")
        self.assertArgHasType(OC_VectorCall.v3dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3dd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -557000000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -557000000000.0)

    def test_clsv3dd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3dd_, b"<3d>")
        self.assertArgHasType(OC_VectorCall.clsv3dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3dd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -557000000000.0)

    def test_imp_v3dd_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3ddOn_(value)
        self.assertEqual(result, objc.simd.vector_double3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3ddOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3ddOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3dd__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3ddOn_(value)
        self.assertEqual(result, objc.simd.vector_double3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3ddOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3ddOn_(value)
        finally:
            del value.returnInvalid

    def test_v3f(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3f, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3f

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_clsv3f(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3f, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3f

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_v3f_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3f, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3f")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
            )

    def test_clsv3f_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3f, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3f")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(
            oc_inst,
        )
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(
            type(oc),
        )
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
            )

    def test_imp_v3f(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3f_cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fOn_(value)
        finally:
            del value.returnInvalid

    def test_v3fv2i_v2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv2i_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv2i_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv2i_v2i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv2i_v2i_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.v3fv2i_v2i_, 1, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3fv2i_v2i_

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))

    def test_clsv3fv2i_v2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv2i_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv2i_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv2i_v2i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv2i_v2i_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsv3fv2i_v2i_, 1, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3fv2i_v2i_

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))

    def test_v3fv2i_v2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv2i_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv2i_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv2i_v2i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv2i_v2i_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.v3fv2i_v2i_, 1, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3fv2i:v2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_int2(0, 1),
                objc.simd.vector_int2(0, 1),
            )

    def test_clsv3fv2i_v2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv2i_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv2i_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv2i_v2i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv2i_v2i_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsv3fv2i_v2i_, 1, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3fv2i:v2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_int2(0, 1), objc.simd.vector_int2(0, 1))

    def test_imp_v3fv2i_v2i_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv2iv2iOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_int2(0, 1),
                objc.simd.vector_int2(0, 1),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv2iv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv2iv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3fv2i_v2i__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv2iv2iOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_int2(0, 1),
                objc.simd.vector_int2(0, 1),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv2iv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv2iv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_v3fv3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv3f_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3fv3f_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsv3fv3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv3f_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3fv3f_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_v3fv3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv3f_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3fv3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsv3fv3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv3f_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3fv3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_imp_v3fv3f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv3fOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (objc.simd.vector_float3(0.0, 1.5, 3.0),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3fv3f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv3fOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (objc.simd.vector_float3(0.0, 1.5, 3.0),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_v3fv3f_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv3f_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv3f_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv3f_id_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv3f_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv3f_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3fv3f_id_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

    def test_clsv3fv3f_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv3f_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv3f_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv3f_id_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv3f_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv3f_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3fv3f_id_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

    def test_v3fv3f_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv3f_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv3f_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv3f_id_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv3f_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv3f_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3fv3f:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

    def test_clsv3fv3f_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv3f_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv3f_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv3f_id_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv3f_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv3f_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3fv3f:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

    def test_imp_v3fv3f_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv3fidOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv3fidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv3fidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3fv3f_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv3fidOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv3fidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv3fidOn_(value)
        finally:
            del value.returnInvalid

    def test_v3fv4i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv4i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv4i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv4i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv4i_, 0, b"<4i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3fv4i_

        # Valid call
        rv = caller(objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int4(0, 1, 2, 3))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int4(0, 1, 2, 3), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int4(0, 1, 2, 3))

    def test_clsv3fv4i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv4i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv4i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv4i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv4i_, 0, b"<4i>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3fv4i_

        # Valid call
        rv = caller(objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int4(0, 1, 2, 3))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int4(0, 1, 2, 3), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int4(0, 1, 2, 3))

    def test_v3fv4i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fv4i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fv4i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fv4i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fv4i_, 0, b"<4i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3fv4i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int4(0, 1, 2, 3))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int4(0, 1, 2, 3), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int4(0, 1, 2, 3))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_int4(0, 1, 2, 3))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_int4(0, 1, 2, 3))

    def test_clsv3fv4i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fv4i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fv4i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fv4i_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fv4i_, 0, b"<4i>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3fv4i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int4(0, 1, 2, 3))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int4(0, 1, 2, 3), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int4(0, 1, 2, 3))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_int4(0, 1, 2, 3))

    def test_imp_v3fv4i_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv4iOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (objc.simd.vector_int4(0, 1, 2, 3),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv4iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv4iOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3fv4i__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fv4iOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (objc.simd.vector_int4(0, 1, 2, 3),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fv4iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fv4iOn_(value)
        finally:
            del value.returnInvalid

    def test_v3fQ_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fQ_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3fQ_

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

    def test_clsv3fQ_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fQ_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3fQ_

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

    def test_v3fQ__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fQ_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3fQ:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, 35184372088832)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, 35184372088832)

    def test_clsv3fQ__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fQ_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fQ_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fQ_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fQ_, 0, b"Q")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3fQ:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(35184372088832)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, 35184372088832)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), 35184372088832)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], 35184372088832)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(35184372088832, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(35184372088832)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, 35184372088832)

    def test_imp_v3fQ_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fQOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (35184372088832,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fQOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fQOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3fQ__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fQOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (35184372088832,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fQOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fQOn_(value)
        finally:
            del value.returnInvalid

    def test_v3fd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fd_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v3fd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_clsv3fd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fd_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv3fd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_v3fd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v3fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v3fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v3fd_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.v3fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v3fd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -557000000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -557000000000.0)

    def test_clsv3fd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv3fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv3fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv3fd_, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsv3fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv3fd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through instance
        rv = imp(oc_inst, -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Valid call through meta
        rv = imp(type(oc), -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float3(0.0, 1.5, 3.0))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -557000000000.0)

    def test_imp_v3fd_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fdOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fdOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fdOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v3fd__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v3fdOn_(value)
        self.assertEqual(result, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v3fdOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v3fdOn_(value)
        finally:
            del value.returnInvalid

    def test_v4dd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4dd_, b"<4d>")
        self.assertArgHasType(OC_VectorCall.v4dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v4dd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_clsv4dd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4dd_, b"<4d>")
        self.assertArgHasType(OC_VectorCall.clsv4dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv4dd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_v4dd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4dd_, b"<4d>")
        self.assertArgHasType(OC_VectorCall.v4dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v4dd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -557000000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -557000000000.0)

    def test_clsv4dd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4dd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4dd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4dd_, b"<4d>")
        self.assertArgHasType(OC_VectorCall.clsv4dd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv4dd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

        # Valid call through instance
        rv = imp(oc_inst, -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

        # Valid call through meta
        rv = imp(type(oc), -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -557000000000.0)

    def test_imp_v4dd_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4ddOn_(value)
        self.assertEqual(result, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4ddOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4ddOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v4dd__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4ddOn_(value)
        self.assertEqual(result, objc.simd.vector_double4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4ddOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4ddOn_(value)
        finally:
            del value.returnInvalid

    def test_v4f(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4f, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v4f

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_clsv4f(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4f, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv4f

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

    def test_v4f_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4f, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v4f")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
            )

    def test_clsv4f_imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4f.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4f)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4f, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv4f")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller()
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Valid call through instance
        rv = imp(
            oc_inst,
        )
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Valid call through meta
        rv = imp(
            type(oc),
        )
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 0)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller()

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
            )

    def test_imp_v4f(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4fOn_(value)
        self.assertEqual(result, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v4f_cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4fOn_(value)
        self.assertEqual(result, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertIs(value.argvalues, None)

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4fOn_(value)
        finally:
            del value.returnInvalid

    def test_v4fd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4fd_, b"<4f>")
        self.assertArgHasType(OC_VectorCall.v4fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v4fd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_clsv4fd_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4fd_, b"<4f>")
        self.assertArgHasType(OC_VectorCall.clsv4fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv4fd_

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

    def test_v4fd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4fd_, b"<4f>")
        self.assertArgHasType(OC_VectorCall.v4fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v4fd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, -557000000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, -557000000000.0)

    def test_clsv4fd__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4fd_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4fd_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4fd_, b"<4f>")
        self.assertArgHasType(OC_VectorCall.clsv4fd_, 0, b"d")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv4fd:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(-557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Valid call through instance
        rv = imp(oc_inst, -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Valid call through meta
        rv = imp(type(oc), -557000000000.0)
        self.assertEqual(rv, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], -557000000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(-557000000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(-557000000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, -557000000000.0)

    def test_imp_v4fd_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4fdOn_(value)
        self.assertEqual(result, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4fdOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4fdOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v4fd__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4fdOn_(value)
        self.assertEqual(result, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(value.argvalues, (-557000000000.0,))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4fdOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4fdOn_(value)
        finally:
            del value.returnInvalid

    def test_v4iv3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4iv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4iv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4iv3f_, b"<4i>")
        self.assertArgHasType(OC_VectorCall.v4iv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.v4iv3f_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_int4(0, 1, 2, 3))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsv4iv3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4iv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4iv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4iv3f_, b"<4i>")
        self.assertArgHasType(OC_VectorCall.clsv4iv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsv4iv3f_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_int4(0, 1, 2, 3))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_v4iv3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.v4iv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.v4iv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.v4iv3f_, b"<4i>")
        self.assertArgHasType(OC_VectorCall.v4iv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"v4iv3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_int4(0, 1, 2, 3))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsv4iv3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsv4iv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsv4iv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsv4iv3f_, b"<4i>")
        self.assertArgHasType(OC_VectorCall.clsv4iv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsv4iv3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_int4(0, 1, 2, 3))

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_int4(0, 1, 2, 3))

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, objc.simd.vector_int4(0, 1, 2, 3))

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_imp_v4iv3f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4iv3fOn_(value)
        self.assertEqual(result, objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(value.argvalues, (objc.simd.vector_float3(0.0, 1.5, 3.0),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4iv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4iv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_v4iv3f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.v4iv3fOn_(value)
        self.assertEqual(result, objc.simd.vector_int4(0, 1, 2, 3))
        self.assertEqual(value.argvalues, (objc.simd.vector_float3(0.0, 1.5, 3.0),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.v4iv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.v4iv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2d_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2d_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2d_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2d_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2d_id_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idv2d_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2d_id_

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), "hello")
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello")

    def test_clsidv2d_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2d_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2d_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2d_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2d_id_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidv2d_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2d_id_

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), "hello")
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello")

    def test_idv2d_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2d_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2d_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2d_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2d_id_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idv2d_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2d:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), "hello")
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello")

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_double2(0.0, 1.5), "hello")

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_double2(0.0, 1.5), "hello")

    def test_clsidv2d_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2d_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2d_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2d_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2d_id_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidv2d_id_, 1, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2d:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), "hello")
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_double2(0.0, 1.5), "hello")
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_double2(0.0, 1.5), "hello")
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello", "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), NoObjCValueObject)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), "hello")

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_double2(0.0, 1.5), "hello")

    def test_imp_idv2d_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2didOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_double2(0.0, 1.5),
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2didOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2didOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2d_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2didOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_double2(0.0, 1.5),
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2didOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2didOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2d_q_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2d_q_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2d_q_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2d_q_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2d_q_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idv2d_q_, 1, b"q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2d_q_

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -17592186044416)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)

    def test_clsidv2d_q_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2d_q_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2d_q_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2d_q_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2d_q_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidv2d_q_, 1, b"q")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2d_q_

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -17592186044416)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)

    def test_idv2d_q__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2d_q_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2d_q_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2d_q_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2d_q_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idv2d_q_, 1, b"q")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2d:q:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -17592186044416)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_double2(0.0, 1.5), -17592186044416)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_double2(0.0, 1.5), -17592186044416)

    def test_clsidv2d_q__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2d_q_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2d_q_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2d_q_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2d_q_, 0, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidv2d_q_, 1, b"q")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2d:q:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_double2(0.0, 1.5), -17592186044416)
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_double2(0.0, 1.5), -17592186044416)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[1], -17592186044416)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -17592186044416)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_double2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_double2(0.0, 1.5), -17592186044416)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_double2(0.0, 1.5), -17592186044416)

    def test_imp_idv2d_q_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2dqOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_double2(0.0, 1.5),
                -17592186044416,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2dqOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2dqOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2d_q__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2dqOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_double2(0.0, 1.5),
                -17592186044416,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2dqOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2dqOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2f_, 0, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2f_

        # Valid call
        rv = caller(objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5))

    def test_clsidv2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2f_, 0, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2f_

        # Valid call
        rv = caller(objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5))

    def test_idv2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2f_, 0, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_float2(0.0, 1.5))

    def test_clsidv2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2f_, 0, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_float2(0.0, 1.5))

    def test_imp_idv2f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(value.argvalues, (objc.simd.vector_float2(0.0, 1.5),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(value.argvalues, (objc.simd.vector_float2(0.0, 1.5),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2f_v2I_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2f_v2I_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_clsidv2f_v2I_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2f_v2I_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_idv2f_v2I_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv2f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2f:v2I:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_clsidv2f_v2I_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2f:v2I:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_imp_idv2f_v2I_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2fv2IqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2fv2IqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2fv2IqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2f_v2I_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2fv2IqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2fv2IqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2fv2IqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2f_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2f_v2f_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idv2f_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2f_v2f_

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))

    def test_clsidv2f_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2f_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2f_v2f_

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))

    def test_idv2f_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2f_v2f_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idv2f_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2f:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42, objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5)
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

    def test_clsidv2f_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2f_, 0, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidv2f_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2f:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5)
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42, objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5)
            )

    def test_imp_idv2f_v2f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2fv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2fv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2fv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2f_v2f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2fv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2fv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2fv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2i_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2i_, 0, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2i_

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1))

    def test_clsidv2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2i_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2i_, 0, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2i_

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1))

    def test_idv2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2i_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2i_, 0, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_int2(0, 1))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_int2(0, 1))

    def test_clsidv2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2i_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2i_, 0, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_int2(0, 1))

    def test_imp_idv2i_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2iOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(value.argvalues, (objc.simd.vector_int2(0, 1),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2i__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2iOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(value.argvalues, (objc.simd.vector_int2(0, 1),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2i_i_i_Z_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2i_i_i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2i_i_i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2i_i_i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 3, b"Z")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2i_i_i_Z_

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), -42, -42, False)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, None, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, NoBool())

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

    def test_clsidv2i_i_i_Z_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2i_i_i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2i_i_i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2i_i_i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 3, b"Z")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2i_i_i_Z_

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), -42, -42, False)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, None, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, NoBool())

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

    def test_idv2i_i_i_Z__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2i_i_i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2i_i_i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2i_i_i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_, 3, b"Z")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2i:i:i:Z:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), -42, -42, False)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, None, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, NoBool())

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_int2(0, 1), -42, -42, False)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_int2(0, 1), -42, -42, False)

    def test_clsidv2i_i_i_Z__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2i_i_i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2i_i_i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2i_i_i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_, 3, b"Z")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2i:i:i:Z:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_int2(0, 1), -42, -42, False)
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_int2(0, 1), -42, -42, False)
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_int2(0, 1), -42, -42, False)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), None, -42, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, None, False)

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, NoBool())

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_int2(0, 1), -42, -42, False)

    def test_imp_idv2i_i_i_Z_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2iiiZOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2iiiZOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2iiiZOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2i_i_i_Z__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2iiiZOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2iiiZOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2iiiZOn_(value)
        finally:
            del value.returnInvalid

    def test_idv2i_i_i_Z_Class_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2i_i_i_Z_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2i_i_i_Z_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2i_i_i_Z_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 4, b"#")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv2i_i_i_Z_Class_

        # Valid call
        rv = caller(
            objc.simd.vector_int2(0, 1), -42, -42, False, objc.lookUpClass("NSObject")
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False, objc.lookUpClass("NSObject"))

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                None,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                None,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                NoBool(),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, 42)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

    def test_clsidv2i_i_i_Z_Class_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2i_i_i_Z_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2i_i_i_Z_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 4, b"#")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv2i_i_i_Z_Class_

        # Valid call
        rv = caller(
            objc.simd.vector_int2(0, 1), -42, -42, False, objc.lookUpClass("NSObject")
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False, objc.lookUpClass("NSObject"))

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                None,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                None,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                NoBool(),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, 42)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

    def test_idv2i_i_i_Z_Class__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv2i_i_i_Z_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv2i_i_i_Z_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv2i_i_i_Z_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv2i_i_i_Z_Class_, 4, b"#")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv2i:i:i:Z:Class:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_int2(0, 1), -42, -42, False, objc.lookUpClass("NSObject")
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False, objc.lookUpClass("NSObject"))

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                None,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                None,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                NoBool(),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, 42)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

    def test_clsidv2i_i_i_Z_Class__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv2i_i_i_Z_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv2i_i_i_Z_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 0, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 1, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv2i_i_i_Z_Class_, 4, b"#")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv2i:i:i:Z:Class:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_int2(0, 1), -42, -42, False, objc.lookUpClass("NSObject")
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_int2(0, 1),
            -42,
            -42,
            False,
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_int2(0, 1),
            -42,
            -42,
            False,
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[1], -42)
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, -42, -42, False, objc.lookUpClass("NSObject"))

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                None,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                None,
                False,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                NoBool(),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_int2(0, 1), -42, -42, False, 42)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            )

    def test_imp_idv2i_i_i_Z_Class_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2iiiZClassOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2iiiZClassOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2iiiZClassOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv2i_i_i_Z_Class__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv2iiiZClassOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_int2(0, 1),
                -42,
                -42,
                False,
                objc.lookUpClass("NSObject"),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv2iiiZClassOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv2iiiZClassOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsidv3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_idv3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsidv3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_, 0, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_imp_idv3f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(value.argvalues, (objc.simd.vector_float3(0.0, 1.5, 3.0),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(value.argvalues, (objc.simd.vector_float3(0.0, 1.5, 3.0),))

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v2I_Z_Z_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 5, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v2I_Z_Z_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], -17592186044416)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_Z_Z_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 5, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v2I_Z_Z_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], -17592186044416)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_idv3f_v2I_Z_Z_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 5, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_Z_q_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v2I:Z:Z:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], -17592186044416)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_Z_Z_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 5, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_Z_q_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v2I:Z:Z:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], -17592186044416)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_v2I_Z_Z_Z_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IZZZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IZZZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IZZZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v2I_Z_Z_Z_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IZZZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IZZZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IZZZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v2I_Z_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v2I_Z_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_Z_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v2I_Z_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_idv3f_v2I_Z_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v2I:Z:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_Z_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v2I:Z:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_v2I_Z_Z_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IZZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IZZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IZZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v2I_Z_Z_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IZZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IZZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IZZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v2I_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v2I_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v2I_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

    def test_idv3f_v2I_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v2I:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v2I:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_v2I_Z_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v2I_Z_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v2I_i_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_i_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_i_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v2I_i_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -42,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint2(0, 1), -42, False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -42,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_i_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v2I_i_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -42,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint2(0, 1), -42, False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -42,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

    def test_idv3f_v2I_i_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_i_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_i_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_i_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v2I:i:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -42,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint2(0, 1), -42, False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -42,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_i_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 2, b"i")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_i_Z_q_id_, 5, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v2I:i:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -42,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -42,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -42,
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 6)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -42)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint2(0, 1), -42, False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -42,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_v2I_i_Z_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IiZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IiZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IiZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v2I_i_Z_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IiZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -42,
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IiZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IiZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v2I_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v2I_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), None, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v2I_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), None, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_idv3f_v2I_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v2I:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), None, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v2I_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v2I_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v2I_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v2I_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 1, b"<2I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v2I_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v2I:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint2(0, 1),
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint2(0, 1))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, objc.simd.vector_uint2(0, 1), -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), None, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_v2I_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v2I_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv2IqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint2(0, 1),
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv2IqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv2IqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v3I_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v3I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v3I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v3I_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v3I_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v3I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v3I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v3I_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

    def test_idv3f_v3I_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v3I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v3I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v3I:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_v3I_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v3I_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v3I_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 2, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_Z_q_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v3I:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], False)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), False, -17592186044416, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                None,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_v3I_Z_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv3IZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv3IZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv3IZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v3I_Z_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv3IZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv3IZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv3IZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_v3I_q_Z_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v3I_q_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v3I_q_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_v3I_q_Z_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), -17592186044416, False, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                None,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

    def test_clsidv3f_v3I_q_Z_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v3I_q_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v3I_q_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_v3I_q_Z_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), -17592186044416, False, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                None,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

    def test_idv3f_v3I_q_Z_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_v3I_q_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_v3I_q_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_v3I_q_Z_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:v3I:q:Z:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), -17592186044416, False, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                None,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

    def test_clsidv3f_v3I_q_Z_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_v3I_q_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_v3I_q_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 1, b"<3I>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 3, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_v3I_q_Z_id_, 4, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:v3I:q:Z:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            objc.simd.vector_uint3(0, 1, 2),
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], objc.simd.vector_uint3(0, 1, 2))
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], False)
        self.assertEqual(stored[4], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None, objc.simd.vector_uint3(0, 1, 2), -17592186044416, False, "hello"
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                None,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            )

    def test_imp_idv3f_v3I_q_Z_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv3IqZidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv3IqZidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv3IqZidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_v3I_q_Z_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fv3IqZidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                objc.simd.vector_uint3(0, 1, 2),
                -17592186044416,
                False,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fv3IqZidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fv3IqZidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_Q_Q_q_Z_Z_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 2, b"Q")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 5, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_Q_Q_q_Z_Z_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], 35184372088832)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], False)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                None,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                None,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                NoBool(),
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

    def test_clsidv3f_Q_Q_q_Z_Z_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 2, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 5, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_Q_Q_q_Z_Z_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], 35184372088832)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], False)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                None,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                None,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                NoBool(),
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

    def test_idv3f_Q_Q_q_Z_Z_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 2, b"Q")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 5, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_Q_Q_q_Z_Z_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:Q:Q:q:Z:Z:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], 35184372088832)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], False)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                None,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                None,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                NoBool(),
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

    def test_clsidv3f_Q_Q_q_Z_Z_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 2, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 3, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 4, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 5, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Q_Q_q_Z_Z_id_, 6, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:Q:Q:q:Z:Z:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], 35184372088832)
        self.assertEqual(stored[3], -17592186044416)
        self.assertEqual(stored[4], False)
        self.assertEqual(stored[5], False)
        self.assertEqual(stored[6], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                None,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                None,
                -17592186044416,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                None,
                False,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                NoBool(),
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            )

    def test_imp_idv3f_Q_Q_q_Z_Z_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fQQqZZidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fQQqZZidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fQQqZZidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_Q_Q_q_Z_Z_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fQQqZZidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                False,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fQQqZZidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fQQqZZidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv3f_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv3f_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
            )

    def test_clsidv3f_Z_q_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv3f_Z_q_id_

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
            )

    def test_idv3f_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv3f_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv3f_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv3f_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.idv3f_Z_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv3f:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
            )

    def test_clsidv3f_Z_q_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv3f_Z_q_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv3f_Z_q_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv3f_Z_q_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 0, b"<3f>")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 2, b"q")
        self.assertArgHasType(OC_VectorCall.clsidv3f_Z_q_id_, 3, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv3f:Z:q:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            objc.simd.vector_float3(0.0, 1.5, 3.0),
            False,
            -17592186044416,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], -17592186044416)
        self.assertEqual(stored[3], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None, False, -17592186044416, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                NoBool(),
                -17592186044416,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(objc.simd.vector_float3(0.0, 1.5, 3.0), False, None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                objc.simd.vector_float3(0.0, 1.5, 3.0), False, -17592186044416, "hello"
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
            )

    def test_imp_idv3f_Z_q_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv3f_Z_q_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv3fZqidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                objc.simd.vector_float3(0.0, 1.5, 3.0),
                False,
                -17592186044416,
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv3fZqidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv3fZqidOn_(value)
        finally:
            del value.returnInvalid

    def test_idv4f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv4f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv4f_, 0, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idv4f_

        # Valid call
        rv = caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_clsidv4f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv4f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv4f_, 0, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidv4f_

        # Valid call
        rv = caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_idv4f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idv4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idv4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idv4f_, b"@")
        self.assertArgHasType(OC_VectorCall.idv4f_, 0, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idv4f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_clsidv4f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidv4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidv4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidv4f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidv4f_, 0, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidv4f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 1)
        self.assertEqual(stored[0], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller()

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_imp_idv4f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv4fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues, (objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),)
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv4fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idv4f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idv4fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues, (objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),)
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idv4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idv4fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_v2d_v2d_v2i_Z_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v2d_v2d_v2i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v2d_v2d_v2i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 1, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 2, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 4, b"Z")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_v2d_v2d_v2i_Z_

        # Valid call
        rv = caller(
            "hello",
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_int2(0, 1),
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                None,
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

    def test_clsidid_v2d_v2d_v2i_Z_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 1, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 2, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 4, b"Z")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_v2d_v2d_v2i_Z_

        # Valid call
        rv = caller(
            "hello",
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_int2(0, 1),
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                None,
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

    def test_idid_v2d_v2d_v2i_Z__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v2d_v2d_v2i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v2d_v2d_v2i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 1, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 2, b"<2d>")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_v2d_v2d_v2i_Z_, 4, b"Z")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:v2d:v2d:v2i:Z:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_int2(0, 1),
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                None,
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

    def test_clsidid_v2d_v2d_v2i_Z__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 1, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 2, b"<2d>")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_v2d_v2d_v2i_Z_, 4, b"Z")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:v2d:v2d:v2i:Z:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_int2(0, 1),
            False,
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_int2(0, 1),
            False,
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_double2(0.0, 1.5),
            objc.simd.vector_int2(0, 1),
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 5)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_double2(0.0, 1.5))
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                None,
                objc.simd.vector_int2(0, 1),
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            )

    def test_imp_idid_v2d_v2d_v2i_Z_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv2dv2dv2iZOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv2dv2dv2iZOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv2dv2dv2iZOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_v2d_v2d_v2i_Z__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv2dv2dv2iZOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_double2(0.0, 1.5),
                objc.simd.vector_int2(0, 1),
                False,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv2dv2dv2iZOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv2dv2dv2iZOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_v2f_

        # Valid call
        rv = caller("hello", objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5))

    def test_clsidid_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_v2f_

        # Valid call
        rv = caller("hello", objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5))

    def test_idid_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, "hello", objc.simd.vector_float2(0.0, 1.5))

    def test_clsidid_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v2f_, 1, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "hello", objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "hello", objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", objc.simd.vector_float2(0.0, 1.5))

    def test_imp_idid_v2f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_v2f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_v3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v3f_, 1, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_v3f_

        # Valid call
        rv = caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsidid_v3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v3f_, 1, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_v3f_

        # Valid call
        rv = caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_idid_v3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v3f_, 1, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:v3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, "hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsidid_v3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v3f_, 1, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:v3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "hello", objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "hello", objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_imp_idid_v3f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv3fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_v3f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv3fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_v4f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v4f_, 1, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_v4f_

        # Valid call
        rv = caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_clsidid_v4f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v4f_, 1, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_v4f_

        # Valid call
        rv = caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_idid_v4f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_v4f_, 1, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:v4f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, "hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_clsidid_v4f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_v4f_, 1, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:v4f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_imp_idid_v4f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv4fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv4fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_v4f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididv4fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididv4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididv4fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_id_v2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_id_v2i_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_, 2, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_id_v2i_

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

    def test_clsidid_id_v2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_id_v2i_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_, 2, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_id_v2i_

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

    def test_idid_id_v2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_id_v2i_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_, 2, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:id:v2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(NoObjCValueObject, "hello", "hello", objc.simd.vector_int2(0, 1))

    def test_clsidid_id_v2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_id_v2i_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_, 2, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:id:v2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "hello", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "hello", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", "hello", objc.simd.vector_int2(0, 1))

    def test_imp_idid_id_v2i_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idididv2iOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                "hello",
                objc.simd.vector_int2(0, 1),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idididv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idididv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_id_v2i__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idididv2iOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                "hello",
                objc.simd.vector_int2(0, 1),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idididv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idididv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_id_v2i_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_id_v2i_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_id_v2i_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_id_v2i_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 3, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_id_v2i_f_

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello", NoObjCValueObject, objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)

    def test_clsidid_id_v2i_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_id_v2i_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_id_v2i_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_id_v2i_f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 3, b"f")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_id_v2i_f_

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello", NoObjCValueObject, objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)

    def test_idid_id_v2i_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_id_v2i_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_id_v2i_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_id_v2i_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_id_v2i_f_, 3, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:id:v2i:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello", NoObjCValueObject, objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                "hello",
                objc.simd.vector_int2(0, 1),
                2500000000.0,
            )

    def test_clsidid_id_v2i_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_id_v2i_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_id_v2i_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_id_v2i_f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 1, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_id_v2i_f_, 3, b"f")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:id:v2i:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], "hello")
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0, "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello", NoObjCValueObject, objc.simd.vector_int2(0, 1), 2500000000.0
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", "hello", objc.simd.vector_int2(0, 1), 2500000000.0)

    def test_imp_idid_id_v2i_f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idididv2ifOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                "hello",
                objc.simd.vector_int2(0, 1),
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idididv2ifOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idididv2ifOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_id_v2i_f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idididv2ifOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                "hello",
                objc.simd.vector_int2(0, 1),
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idididv2ifOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idididv2ifOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_Q_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v2f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Q_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_Q_v2f_

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))

    def test_clsidid_Q_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v2f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_Q_v2f_

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))

    def test_idid_Q_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v2f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Q_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:Q:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                35184372088832,
                objc.simd.vector_float2(0.0, 1.5),
            )

    def test_clsidid_Q_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v2f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v2f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:Q:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", 35184372088832, objc.simd.vector_float2(0.0, 1.5))

    def test_imp_idid_Q_v2f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_Q_v2f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_Q_v3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v3f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Q_v3f_, 2, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_Q_v3f_

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello"
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_clsidid_Q_v3f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v3f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v3f_, 2, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_Q_v3f_

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello"
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_idid_Q_v3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v3f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Q_v3f_, 2, b"<3f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:Q:v3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello"
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )

    def test_clsidid_Q_v3f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_v3f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_v3f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_v3f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v3f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v3f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v3f_, 2, b"<3f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:Q:v3f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst, "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0)
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc), "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0), "hello"
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float3(0.0, 1.5, 3.0))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "hello", 35184372088832, objc.simd.vector_float3(0.0, 1.5, 3.0))

    def test_imp_idid_Q_v3f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQv3fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_Q_v3f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQv3fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                objc.simd.vector_float3(0.0, 1.5, 3.0),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQv3fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQv3fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_Q_v4f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v4f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Q_v4f_, 2, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_Q_v4f_

        # Valid call
        rv = caller(
            "hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_clsidid_Q_v4f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v4f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v4f_, 2, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_Q_v4f_

        # Valid call
        rv = caller(
            "hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

    def test_idid_Q_v4f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_v4f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Q_v4f_, 2, b"<4f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:Q:v4f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42, "hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )

    def test_clsidid_Q_v4f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_v4f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_v4f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_v4f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v4f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v4f_, 1, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_v4f_, 2, b"<4f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:Q:v4f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            35184372088832,
            objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            35184372088832,
            objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(stored[2], objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42, "hello", 35184372088832, objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)
            )

    def test_imp_idid_Q_v4f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQv4fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQv4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQv4fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_Q_v4f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQv4fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQv4fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQv4fOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_Q_simdfloat4x4_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_simdfloat4x4_, 1, b"Q")
        self.assertArgHasType(
            OC_VectorCall.idid_Q_simdfloat4x4_, 2, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_Q_simdfloat4x4_

        # Valid call
        rv = caller(
            "hello",
            35184372088832,
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(
            stored[2],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_clsidid_Q_simdfloat4x4_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_simdfloat4x4_, 1, b"Q")
        self.assertArgHasType(
            OC_VectorCall.clsidid_Q_simdfloat4x4_, 2, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_Q_simdfloat4x4_

        # Valid call
        rv = caller(
            "hello",
            35184372088832,
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(
            stored[2],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_idid_Q_simdfloat4x4__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Q_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Q_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Q_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Q_simdfloat4x4_, 1, b"Q")
        self.assertArgHasType(
            OC_VectorCall.idid_Q_simdfloat4x4_, 2, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:Q:simdfloat4x4:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            35184372088832,
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(
            stored[2],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_clsidid_Q_simdfloat4x4__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Q_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Q_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Q_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Q_simdfloat4x4_, 1, b"Q")
        self.assertArgHasType(
            OC_VectorCall.clsidid_Q_simdfloat4x4_, 2, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:Q:simdfloat4x4:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            35184372088832,
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            35184372088832,
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            35184372088832,
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], 35184372088832)
        self.assertEqual(
            stored[2],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello", 35184372088832)

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", 35184372088832, None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_imp_idid_Q_simdfloat4x4_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQsimdfloat4x4On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQsimdfloat4x4On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQsimdfloat4x4On_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_Q_simdfloat4x4__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididQsimdfloat4x4On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                35184372088832,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididQsimdfloat4x4On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididQsimdfloat4x4On_(value)
        finally:
            del value.returnInvalid

    def test_idid_Z_id_v2i_q_Q_q_Z_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 5, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 6, b"q")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 7, b"Z")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_Z_id_v2i_q_Q_q_Z_

        # Valid call
        rv = caller(
            "hello",
            False,
            "hello",
            objc.simd.vector_int2(0, 1),
            -17592186044416,
            35184372088832,
            -17592186044416,
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], 35184372088832)
        self.assertEqual(stored[6], -17592186044416)
        self.assertEqual(stored[7], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                NoBool(),
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                NoObjCValueObject,
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                None,
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                None,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                None,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

    def test_clsidid_Z_id_v2i_q_Q_q_Z_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 5, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 6, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 7, b"Z")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_Z_id_v2i_q_Q_q_Z_

        # Valid call
        rv = caller(
            "hello",
            False,
            "hello",
            objc.simd.vector_int2(0, 1),
            -17592186044416,
            35184372088832,
            -17592186044416,
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], 35184372088832)
        self.assertEqual(stored[6], -17592186044416)
        self.assertEqual(stored[7], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                NoBool(),
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                NoObjCValueObject,
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                None,
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                None,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                None,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

    def test_idid_Z_id_v2i_q_Q_q_Z__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 5, b"Q")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 6, b"q")
        self.assertArgHasType(OC_VectorCall.idid_Z_id_v2i_q_Q_q_Z_, 7, b"Z")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:Z:id:v2i:q:Q:q:Z:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            False,
            "hello",
            objc.simd.vector_int2(0, 1),
            -17592186044416,
            35184372088832,
            -17592186044416,
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], 35184372088832)
        self.assertEqual(stored[6], -17592186044416)
        self.assertEqual(stored[7], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                NoBool(),
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                NoObjCValueObject,
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                None,
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                None,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                None,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

    def test_clsidid_Z_id_v2i_q_Q_q_Z__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 1, b"Z")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 3, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 4, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 5, b"Q")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 6, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_Z_id_v2i_q_Q_q_Z_, 7, b"Z")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:Z:id:v2i:q:Q:q:Z:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            False,
            "hello",
            objc.simd.vector_int2(0, 1),
            -17592186044416,
            35184372088832,
            -17592186044416,
            False,
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            False,
            "hello",
            objc.simd.vector_int2(0, 1),
            -17592186044416,
            35184372088832,
            -17592186044416,
            False,
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            False,
            "hello",
            objc.simd.vector_int2(0, 1),
            -17592186044416,
            35184372088832,
            -17592186044416,
            False,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], False)
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[4], -17592186044416)
        self.assertEqual(stored[5], 35184372088832)
        self.assertEqual(stored[6], -17592186044416)
        self.assertEqual(stored[7], False)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                NoBool(),
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                NoObjCValueObject,
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                None,
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                None,
                35184372088832,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                None,
                -17592186044416,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                None,
                False,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                NoBool(),
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            )

    def test_imp_idid_Z_id_v2i_q_Q_q_Z_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididZidv2iqQqZOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididZidv2iqQqZOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididZidv2iqQqZOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_Z_id_v2i_q_Q_q_Z__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididZidv2iqQqZOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                False,
                "hello",
                objc.simd.vector_int2(0, 1),
                -17592186044416,
                35184372088832,
                -17592186044416,
                False,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididZidv2iqQqZOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididZidv2iqQqZOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_q_v2i_f_f_f_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_q_v2i_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_q_v2i_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 6, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_q_v2i_f_f_f_f_

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_clsidid_q_v2i_f_f_f_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_q_v2i_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_q_v2i_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 6, b"f")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_q_v2i_f_f_f_f_

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_idid_q_v2i_f_f_f_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_q_v2i_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_q_v2i_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_, 6, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:q:v2i:f:f:f:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_clsidid_q_v2i_f_f_f_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_q_v2i_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_q_v2i_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_, 6, b"f")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:q:v2i:f:f:f:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 7)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_imp_idid_q_v2i_f_f_f_f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididqv2iffffOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididqv2iffffOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididqv2iffffOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_q_v2i_f_f_f_f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididqv2iffffOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididqv2iffffOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididqv2iffffOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_q_v2i_f_f_f_f_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_q_v2i_f_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_q_v2i_f_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 6, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 7, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_q_v2i_f_f_f_f_f_

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)
        self.assertEqual(stored[7], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_clsidid_q_v2i_f_f_f_f_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 6, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 7, b"f")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_q_v2i_f_f_f_f_f_

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)
        self.assertEqual(stored[7], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_idid_q_v2i_f_f_f_f_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_q_v2i_f_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_q_v2i_f_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 6, b"f")
        self.assertArgHasType(OC_VectorCall.idid_q_v2i_f_f_f_f_f_, 7, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:q:v2i:f:f:f:f:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)
        self.assertEqual(stored[7], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_clsidid_q_v2i_f_f_f_f_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 1, b"q")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 2, b"<2i>")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 3, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 4, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 5, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 6, b"f")
        self.assertArgHasType(OC_VectorCall.clsidid_q_v2i_f_f_f_f_f_, 7, b"f")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:q:v2i:f:f:f:f:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            -17592186044416,
            objc.simd.vector_int2(0, 1),
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(stored[1], -17592186044416)
        self.assertEqual(stored[2], objc.simd.vector_int2(0, 1))
        self.assertEqual(stored[3], 2500000000.0)
        self.assertEqual(stored[4], 2500000000.0)
        self.assertEqual(stored[5], 2500000000.0)
        self.assertEqual(stored[6], 2500000000.0)
        self.assertEqual(stored[7], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                None,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            )

    def test_imp_idid_q_v2i_f_f_f_f_f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididqv2ifffffOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididqv2ifffffOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididqv2ifffffOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_q_v2i_f_f_f_f_f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididqv2ifffffOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                -17592186044416,
                objc.simd.vector_int2(0, 1),
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididqv2ifffffOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididqv2ifffffOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.12")
    def test_idid_GKBox_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_GKBox_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_GKBox_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_GKBox_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKBox_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKBox_, 1, b"{GKBox=<3f><3f>}")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_GKBox_

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

    @min_os_level("10.12")
    def test_clsidid_GKBox_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_GKBox_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_GKBox_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_GKBox_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKBox_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKBox_, 1, b"{GKBox=<3f><3f>}")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_GKBox_

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

    @min_os_level("10.12")
    def test_idid_GKBox__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_GKBox_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_GKBox_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_GKBox_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKBox_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKBox_, 1, b"{GKBox=<3f><3f>}")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:GKBox:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

    @min_os_level("10.12")
    def test_clsidid_GKBox__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_GKBox_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_GKBox_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_GKBox_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKBox_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKBox_, 1, b"{GKBox=<3f><3f>}")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:GKBox:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(1.0, 2.0, 3.0),
                objc.simd.vector_float3(4.0, 5.0, 6.0),
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            )

    @min_os_level("10.12")
    def test_imp_idid_GKBox_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididGKBoxOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididGKBoxOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididGKBoxOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.12")
    def test_imp_idid_GKBox__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididGKBoxOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                (
                    objc.simd.vector_float3(1.0, 2.0, 3.0),
                    objc.simd.vector_float3(4.0, 5.0, 6.0),
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididGKBoxOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididGKBoxOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.12")
    def test_idid_GKQuad_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_GKQuad_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_GKQuad_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_GKQuad_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKQuad_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKQuad_, 1, b"{GKQuad=<2f><2f>}")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_GKQuad_

        # Valid call
        rv = caller(
            "hello",
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

    @min_os_level("10.12")
    def test_clsidid_GKQuad_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_GKQuad_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_GKQuad_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_GKQuad_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKQuad_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKQuad_, 1, b"{GKQuad=<2f><2f>}")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_GKQuad_

        # Valid call
        rv = caller(
            "hello",
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

    @min_os_level("10.12")
    def test_idid_GKQuad__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_GKQuad_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_GKQuad_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_GKQuad_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKQuad_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_GKQuad_, 1, b"{GKQuad=<2f><2f>}")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:GKQuad:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

    @min_os_level("10.12")
    def test_clsidid_GKQuad__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_GKQuad_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_GKQuad_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_GKQuad_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKQuad_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_GKQuad_, 1, b"{GKQuad=<2f><2f>}")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:GKQuad:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (objc.simd.vector_float2(9.0, 10.0), objc.simd.vector_float2(11.0, 12.0)),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            )

    @min_os_level("10.12")
    def test_imp_idid_GKQuad_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididGKQuadOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididGKQuadOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididGKQuadOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.12")
    def test_imp_idid_GKQuad__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididGKQuadOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                (
                    objc.simd.vector_float2(9.0, 10.0),
                    objc.simd.vector_float2(11.0, 12.0),
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididGKQuadOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididGKQuadOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.11")
    def test_idid_MDLAxisAlignedBoundingBox_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_,
            1,
            b"{MDLAxisAlignedBoundingBox=<3f><3f>}",
        )
        self.assertArgHasType(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_, 2, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_MDLAxisAlignedBoundingBox_f_

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
        )
        self.assertEqual(stored[2], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

    @min_os_level("10.11")
    def test_clsidid_MDLAxisAlignedBoundingBox_f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_.isClassMethod
        )
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_)
        # Check that the signature is as expected
        self.assertResultHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_, b"@"
        )
        self.assertArgHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_, 0, b"@"
        )
        self.assertArgHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_,
            1,
            b"{MDLAxisAlignedBoundingBox=<3f><3f>}",
        )
        self.assertArgHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_, 2, b"f"
        )

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_MDLAxisAlignedBoundingBox_f_

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
        )
        self.assertEqual(stored[2], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

    @min_os_level("10.11")
    def test_idid_MDLAxisAlignedBoundingBox_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_,
            1,
            b"{MDLAxisAlignedBoundingBox=<3f><3f>}",
        )
        self.assertArgHasType(OC_VectorCall.idid_MDLAxisAlignedBoundingBox_f_, 2, b"f")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:MDLAxisAlignedBoundingBox:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
        )
        self.assertEqual(stored[2], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

    @min_os_level("10.11")
    def test_clsidid_MDLAxisAlignedBoundingBox_f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_.isClassMethod
        )
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_)
        # Check that the signature is as expected
        self.assertResultHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_, b"@"
        )
        self.assertArgHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_, 0, b"@"
        )
        self.assertArgHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_,
            1,
            b"{MDLAxisAlignedBoundingBox=<3f><3f>}",
        )
        self.assertArgHasType(
            OC_VectorCall.clsidid_MDLAxisAlignedBoundingBox_f_, 2, b"f"
        )

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:MDLAxisAlignedBoundingBox:f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
            2500000000.0,
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            (
                objc.simd.vector_float3(-8.0, -9.0, -10.0),
                objc.simd.vector_float3(-11.0, -12.0, -13.0),
            ),
        )
        self.assertEqual(stored[2], 2500000000.0)

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, 2500000000.0)

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                None,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            )

    @min_os_level("10.11")
    def test_imp_idid_MDLAxisAlignedBoundingBox_f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididMDLAxisAlignedBoundingBoxfOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididMDLAxisAlignedBoundingBoxfOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididMDLAxisAlignedBoundingBoxfOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.11")
    def test_imp_idid_MDLAxisAlignedBoundingBox_f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididMDLAxisAlignedBoundingBoxfOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                (
                    objc.simd.vector_float3(-8.0, -9.0, -10.0),
                    objc.simd.vector_float3(-11.0, -12.0, -13.0),
                ),
                2500000000.0,
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididMDLAxisAlignedBoundingBoxfOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididMDLAxisAlignedBoundingBoxfOn_(value)
        finally:
            del value.returnInvalid

    def test_idid_simdfloat2x2_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdfloat2x2_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdfloat2x2_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdfloat2x2_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdfloat2x2_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_simdfloat2x2_, 1, b"{simd_float2x2=[2<2f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_simdfloat2x2_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

    def test_clsidid_simdfloat2x2_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdfloat2x2_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdfloat2x2_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdfloat2x2_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdfloat2x2_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdfloat2x2_, 1, b"{simd_float2x2=[2<2f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_simdfloat2x2_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

    def test_idid_simdfloat2x2__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdfloat2x2_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdfloat2x2_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdfloat2x2_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdfloat2x2_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_simdfloat2x2_, 1, b"{simd_float2x2=[2<2f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:simdfloat2x2:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

    def test_clsidid_simdfloat2x2__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdfloat2x2_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdfloat2x2_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdfloat2x2_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdfloat2x2_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdfloat2x2_, 1, b"{simd_float2x2=[2<2f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:simdfloat2x2:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float2x2(
                (objc.simd.vector_float2(0.0, 1.5), objc.simd.vector_float2(0.0, 1.5))
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            )

    def test_imp_idid_simdfloat2x2_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdfloat2x2On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdfloat2x2On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdfloat2x2On_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_simdfloat2x2__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdfloat2x2On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_float2x2(
                    (
                        objc.simd.vector_float2(0.0, 1.5),
                        objc.simd.vector_float2(0.0, 1.5),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdfloat2x2On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdfloat2x2On_(value)
        finally:
            del value.returnInvalid

    def test_idid_simdfloat3x3_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdfloat3x3_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdfloat3x3_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdfloat3x3_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdfloat3x3_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_simdfloat3x3_, 1, b"{simd_float3x3=[3<3f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_simdfloat3x3_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

    def test_clsidid_simdfloat3x3_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdfloat3x3_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdfloat3x3_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdfloat3x3_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdfloat3x3_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdfloat3x3_, 1, b"{simd_float3x3=[3<3f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_simdfloat3x3_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

    def test_idid_simdfloat3x3__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdfloat3x3_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdfloat3x3_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdfloat3x3_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdfloat3x3_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_simdfloat3x3_, 1, b"{simd_float3x3=[3<3f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:simdfloat3x3:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

    def test_clsidid_simdfloat3x3__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdfloat3x3_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdfloat3x3_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdfloat3x3_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdfloat3x3_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdfloat3x3_, 1, b"{simd_float3x3=[3<3f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:simdfloat3x3:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float3x3(
                (
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                    objc.simd.vector_float3(0.0, 1.5, 3.0),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            )

    def test_imp_idid_simdfloat3x3_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdfloat3x3On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdfloat3x3On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdfloat3x3On_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_simdfloat3x3__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdfloat3x3On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_float3x3(
                    (
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                        objc.simd.vector_float3(0.0, 1.5, 3.0),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdfloat3x3On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdfloat3x3On_(value)
        finally:
            del value.returnInvalid

    def test_idid_simdfloat4x4_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_simdfloat4x4_, 1, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_simdfloat4x4_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_clsidid_simdfloat4x4_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdfloat4x4_, 1, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_simdfloat4x4_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_idid_simdfloat4x4__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.idid_simdfloat4x4_, 1, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:simdfloat4x4:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_clsidid_simdfloat4x4__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdfloat4x4_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdfloat4x4_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdfloat4x4_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdfloat4x4_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdfloat4x4_, 1, b"{simd_float4x4=[4<4f>]}"
        )

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:simdfloat4x4:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1],
            simd.simd_float4x4(
                (
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                )
            ),
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            )

    def test_imp_idid_simdfloat4x4_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdfloat4x4On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdfloat4x4On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdfloat4x4On_(value)
        finally:
            del value.returnInvalid

    def test_imp_idid_simdfloat4x4__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdfloat4x4On_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_float4x4(
                    (
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                        objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5),
                    )
                ),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdfloat4x4On_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdfloat4x4On_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.13")
    def test_idid_simdquatf_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdquatf_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdquatf_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdquatf_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_, 1, b"{simd_quatf=<4f>}")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_simdquatf_

        # Valid call
        rv = caller(
            "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

    @min_os_level("10.13")
    def test_clsidid_simdquatf_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdquatf_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdquatf_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdquatf_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_, 1, b"{simd_quatf=<4f>}")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_simdquatf_

        # Valid call
        rv = caller(
            "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

    @min_os_level("10.13")
    def test_idid_simdquatf__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdquatf_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdquatf_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdquatf_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_, 1, b"{simd_quatf=<4f>}")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:simdquatf:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

    @min_os_level("10.13")
    def test_clsidid_simdquatf__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdquatf_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdquatf_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdquatf_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_, 1, b"{simd_quatf=<4f>}")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:simdquatf:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 2)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            )

    @min_os_level("10.13")
    def test_imp_idid_simdquatf_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdquatfOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdquatfOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdquatfOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.13")
    def test_imp_idid_simdquatf__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdquatfOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdquatfOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdquatfOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.13")
    def test_idid_simdquatf_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdquatf_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdquatf_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdquatf_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_id_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_id_, 1, b"{simd_quatf=<4f>}")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_id_, 2, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idid_simdquatf_id_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(stored[2], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

    @min_os_level("10.13")
    def test_clsidid_simdquatf_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdquatf_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdquatf_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdquatf_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_id_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdquatf_id_, 1, b"{simd_quatf=<4f>}"
        )
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_id_, 2, b"@")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidid_simdquatf_id_

        # Valid call
        rv = caller(
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(stored[2], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

    @min_os_level("10.13")
    def test_idid_simdquatf_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idid_simdquatf_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idid_simdquatf_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idid_simdquatf_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_id_, 0, b"@")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_id_, 1, b"{simd_quatf=<4f>}")
        self.assertArgHasType(OC_VectorCall.idid_simdquatf_id_, 2, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idid:simdquatf:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(stored[2], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

    @min_os_level("10.13")
    def test_clsidid_simdquatf_id__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidid_simdquatf_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidid_simdquatf_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidid_simdquatf_id_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_id_, 0, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidid_simdquatf_id_, 1, b"{simd_quatf=<4f>}"
        )
        self.assertArgHasType(OC_VectorCall.clsidid_simdquatf_id_, 2, b"@")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidid:simdquatf:id:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            "hello",
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            "hello",
            simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], "hello")
        self.assertEqual(
            stored[1], simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
        )
        self.assertEqual(stored[2], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello", simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5))
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                NoObjCValueObject,
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller("hello", None, "hello")

        with self.assertRaises((TypeError, ValueError)):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            )

    @min_os_level("10.13")
    def test_imp_idid_simdquatf_id_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdquatfidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdquatfidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdquatfidOn_(value)
        finally:
            del value.returnInvalid

    @min_os_level("10.13")
    def test_imp_idid_simdquatf_id__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.ididsimdquatfidOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "hello",
                simd.simd_quatf(objc.simd.vector_float4(0.0, 1.5, 3.0, 4.5)),
                "hello",
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.ididsimdquatfidOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.ididsimdquatfidOn_(value)
        finally:
            del value.returnInvalid

    def test_idCGColor_CGColor_id_v2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idCGColor_CGColor_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idCGColor_CGColor_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idCGColor_CGColor_id_v2i_, b"@")
        self.assertArgHasType(
            OC_VectorCall.idCGColor_CGColor_id_v2i_, 0, b"^{CGColor=}"
        )
        self.assertArgHasType(
            OC_VectorCall.idCGColor_CGColor_id_v2i_, 1, b"^{CGColor=}"
        )
        self.assertArgHasType(OC_VectorCall.idCGColor_CGColor_id_v2i_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.idCGColor_CGColor_id_v2i_, 3, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idCGColor_CGColor_id_v2i_

        # Valid call
        rv = caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "color!")
        self.assertEqual(stored[1], "color!")
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "color!", "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))

    def test_clsidCGColor_CGColor_id_v2i_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidCGColor_CGColor_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidCGColor_CGColor_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidCGColor_CGColor_id_v2i_, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 0, b"^{CGColor=}"
        )
        self.assertArgHasType(
            OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 1, b"^{CGColor=}"
        )
        self.assertArgHasType(OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 3, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidCGColor_CGColor_id_v2i_

        # Valid call
        rv = caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "color!")
        self.assertEqual(stored[1], "color!")
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "color!", "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))

    def test_idCGColor_CGColor_id_v2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idCGColor_CGColor_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idCGColor_CGColor_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idCGColor_CGColor_id_v2i_, b"@")
        self.assertArgHasType(
            OC_VectorCall.idCGColor_CGColor_id_v2i_, 0, b"^{CGColor=}"
        )
        self.assertArgHasType(
            OC_VectorCall.idCGColor_CGColor_id_v2i_, 1, b"^{CGColor=}"
        )
        self.assertArgHasType(OC_VectorCall.idCGColor_CGColor_id_v2i_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.idCGColor_CGColor_id_v2i_, 3, b"<2i>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idCGColor:CGColor:id:v2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "color!")
        self.assertEqual(stored[1], "color!")
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "color!", "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(42, "color!", "color!", "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                "color!",
                "color!",
                "hello",
                objc.simd.vector_int2(0, 1),
            )

    def test_clsidCGColor_CGColor_id_v2i__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidCGColor_CGColor_id_v2i_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidCGColor_CGColor_id_v2i_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidCGColor_CGColor_id_v2i_, b"@")
        self.assertArgHasType(
            OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 0, b"^{CGColor=}"
        )
        self.assertArgHasType(
            OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 1, b"^{CGColor=}"
        )
        self.assertArgHasType(OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 2, b"@")
        self.assertArgHasType(OC_VectorCall.clsidCGColor_CGColor_id_v2i_, 3, b"<2i>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidCGColor:CGColor:id:v2i:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(oc_inst, "color!", "color!", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(type(oc), "color!", "color!", "hello", objc.simd.vector_int2(0, 1))
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], "color!")
        self.assertEqual(stored[1], "color!")
        self.assertEqual(stored[2], "hello")
        self.assertEqual(stored[3], objc.simd.vector_int2(0, 1))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello")

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1), "hello")

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(NoObjCValueObject, "color!", "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", NoObjCValueObject, "hello", objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", NoObjCValueObject, objc.simd.vector_int2(0, 1))

        with self.assertRaises((TypeError, ValueError)):
            caller("color!", "color!", "hello", None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller("color!", "color!", "hello", objc.simd.vector_int2(0, 1))

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(42, "color!", "color!", "hello", objc.simd.vector_int2(0, 1))

    def test_imp_idCGColor_CGColor_id_v2i_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idCGColorCGColoridv2iOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "color!",
                "color!",
                "hello",
                objc.simd.vector_int2(0, 1),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idCGColorCGColoridv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idCGColorCGColoridv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idCGColor_CGColor_id_v2i__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idCGColorCGColoridv2iOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                "color!",
                "color!",
                "hello",
                objc.simd.vector_int2(0, 1),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idCGColorCGColoridv2iOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idCGColorCGColoridv2iOn_(value)
        finally:
            del value.returnInvalid

    def test_idf_v2f_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idf_v2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idf_v2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idf_v2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idf_v2f_v2f_

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

    def test_clsidf_v2f_v2f_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidf_v2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidf_v2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidf_v2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidf_v2f_v2f_

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

    def test_idf_v2f_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idf_v2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idf_v2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idf_v2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idf:v2f:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

    def test_clsidf_v2f_v2f__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidf_v2f_v2f_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidf_v2f_v2f_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidf_v2f_v2f_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_, 2, b"<2f>")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidf:v2f:v2f:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 3)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5))

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, None, objc.simd.vector_float2(0.0, 1.5))

        with self.assertRaises((TypeError, ValueError)):
            caller(2500000000.0, objc.simd.vector_float2(0.0, 1.5), None)

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

    def test_imp_idf_v2f_v2f_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idfv2fv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idfv2fv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idfv2fv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idf_v2f_v2f__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idfv2fv2fOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idfv2fv2fOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idfv2fv2fOn_(value)
        finally:
            del value.returnInvalid

    def test_idf_v2f_v2f_Class_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idf_v2f_v2f_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idf_v2f_v2f_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idf_v2f_v2f_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 2, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 3, b"#")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idf_v2f_v2f_Class_

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[3], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                None,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                42,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

    def test_clsidf_v2f_v2f_Class_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidf_v2f_v2f_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidf_v2f_v2f_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 2, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 3, b"#")

        # Create test object
        oc = OC_VectorCall
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.clsidf_v2f_v2f_Class_

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[3], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                None,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                42,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

    def test_idf_v2f_v2f_Class__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idf_v2f_v2f_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idf_v2f_v2f_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idf_v2f_v2f_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 2, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_v2f_Class_, 3, b"#")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"idf:v2f:v2f:Class:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[3], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                None,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                42,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(ValueError, "unrecognized selector"):
            imp(
                42,
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaisesRegex(TypeError, "Cannot proxy"):
            imp(
                NoObjCValueObject,
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

    def test_clsidf_v2f_v2f_Class__imp(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertTrue(OC_VectorCall.clsidf_v2f_v2f_Class_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.clsidf_v2f_v2f_Class_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, b"@")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 2, b"<2f>")
        self.assertArgHasType(OC_VectorCall.clsidf_v2f_v2f_Class_, 3, b"#")

        # Create test object
        oc = OC_VectorCall
        oc_inst = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        imp = oc.methodForSelector_(b"clsidf:v2f:v2f:Class:")
        self.assertIsInstance(imp, objc.IMP)
        caller = partial(imp, oc)

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        # Valid call through instance
        rv = imp(
            oc_inst,
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        # Valid call through meta
        rv = imp(
            type(oc),
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            objc.simd.vector_float2(0.0, 1.5),
            objc.lookUpClass("NSObject"),
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 4)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[3], objc.lookUpClass("NSObject"))

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                None,
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                None,
                objc.lookUpClass("NSObject"),
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                42,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

        # Call with invalid type for self
        with self.assertRaisesRegex(
            TypeError, "Need Objective-C object or class as self"
        ):
            imp(
                42,
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            )

    def test_imp_idf_v2f_v2f_Class_(self):
        value = OC_VectorCallInstance.alloc().init()
        value.argvalues = 1
        result = OC_VectorCallInvoke.idfv2fv2fClassOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idfv2fv2fClassOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idfv2fv2fClassOn_(value)
        finally:
            del value.returnInvalid

    def test_imp_idf_v2f_v2f_Class__cls(self):
        value = OC_VectorCallClass
        value.argvalues = 1
        result = OC_VectorCallInvoke.idfv2fv2fClassOn_(value)
        self.assertEqual(result, "hello")
        self.assertEqual(
            value.argvalues,
            (
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                objc.simd.vector_float2(0.0, 1.5),
                objc.lookUpClass("NSObject"),
            ),
        )

        # Test raising an exception
        value.shouldRaise = True
        try:
            with self.assertRaisesRegex(RuntimeError, "failure"):
                OC_VectorCallInvoke.idfv2fv2fClassOn_(value)
        finally:
            del value.shouldRaise

        value.returnInvalid = True
        try:
            with self.assertRaises((ValueError, TypeError)):
                OC_VectorCallInvoke.idfv2fv2fClassOn_(value)
        finally:
            del value.returnInvalid

    def test_idf_v2f_Q_Q_Q_q_Z_id_(self):
        OC_VectorCall.clearRaise()
        # Verify method type
        self.assertFalse(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_.isClassMethod)
        # Verify that method is not an initializer
        self.assertIsNotInitializer(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_)
        # Check that the signature is as expected
        self.assertResultHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, b"@")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 0, b"f")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 1, b"<2f>")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 2, b"Q")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 3, b"Q")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 4, b"Q")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 5, b"q")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 6, b"Z")
        self.assertArgHasType(OC_VectorCall.idf_v2f_Q_Q_Q_q_Z_id_, 7, b"@")

        # Create test object
        oc = OC_VectorCall.alloc().init()
        self.assertIsNot(oc, None)

        # Set caller to the selector/IMP to call (With bound self)
        caller = oc.idf_v2f_Q_Q_Q_q_Z_id_

        # Valid call
        rv = caller(
            2500000000.0,
            objc.simd.vector_float2(0.0, 1.5),
            35184372088832,
            35184372088832,
            35184372088832,
            -17592186044416,
            False,
            "hello",
        )
        self.assertEqual(rv, "hello")

        stored = oc.storedvalue()
        self.assertIsInstance(stored, (list, tuple))
        self.assertEqual(len(stored), 8)
        self.assertEqual(stored[0], 2500000000.0)
        self.assertEqual(stored[1], objc.simd.vector_float2(0.0, 1.5))
        self.assertEqual(stored[2], 35184372088832)
        self.assertEqual(stored[3], 35184372088832)
        self.assertEqual(stored[4], 35184372088832)
        self.assertEqual(stored[5], -17592186044416)
        self.assertEqual(stored[6], False)
        self.assertEqual(stored[7], "hello")

        # Too few arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
            )

        # Too many arguments call
        with self.assertRaisesRegex(TypeError, "expected.*arguments.*got"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                "hello",
                "hello",
            )

        # Bad value for arguments
        with self.assertRaises((TypeError, ValueError)):
            caller(
                None,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                None,
                35184372088832,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                None,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                None,
                35184372088832,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                None,
                -17592186044416,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                35184372088832,
                None,
                False,
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                35184372088832,
                -17592186044416,
                NoBool(),
                "hello",
            )

        with self.assertRaises((TypeError, ValueError)):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
                35184372088832,
                -17592186044416,
                False,
                NoObjCValueObject,
            )

        # Exception handling
        OC_VectorCall.setRaise()
        with self.assertRaisesRegex(objc.error, "SimpleException"):
            caller(
                2500000000.0,
                objc.simd.vector_float2(0.0, 1.5),
                35184372088832,
                35184372088832,
  