/*
   Copyright (C) 2004 Manuel Bouyer
   Copyright (C) 1998,1999,2000,2001 T. Scott Dattalo

This file is part of gpsim.

gpsim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpsim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpsim; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef __USART_MODULE_H__
#define __USART_MODULE_H__

/* IN_MODULE should be defined for modules */
#define IN_MODULE

#include <gpsim/modules.h>
#include <gpsim/packages.h>
#include <gpsim/stimuli.h>
#include <gpsim/symbol.h>
#include <gpsim/trace.h>
#include <gpsim/ioports.h>
#include <gpsim/bitlog.h> // for BoolEventLogger
#include <gpsim/interface.h> // for verbose
#include <gpsim/gpsim_time.h> // for cycles
#include <gpsim/processor.h> // for get_active_cpu

class ptyUSART_IOPORT;
class ptyUSARTModule;

class ptyTXREG;
class ptyRCREG;

class ptyUSART_external;

class ptyUSART_CORE
{
 public:

  /* */
  ptyUSART_IOPORT *port;

  /*  receiver stuff **/
  ptyRCREG *rcreg;

  /* Transmitter stuff **/
  ptyTXREG *txreg;

  /* external interraction (pty) stuff */
  ptyUSART_external *external_io;

  ptyUSARTModule *um;

  virtual void new_rx_edge(bool);
  void initialize(ptyUSART_IOPORT *new_iop=NULL);

  void new_serial_parameters(int rx_baud, int tx_baud, int data_bits, bool use_parity, bool parity, int stop);

  ptyUSART_CORE(ptyUSART_IOPORT *new_iop);
};

class ptyUSARTModule : public Module
{
 public:

  ptyUSART_IOPORT *port;
  ptyUSART_CORE   *usart;

  // Inheritances from the Package class
  virtual void create_iopin_map(void);

  ptyUSARTModule(const char *new_name = NULL);
  ~ptyUSARTModule();

  static Module *ptyUSART_construct(const char *new_name=NULL);

};

class ptyUSART_external
{
 public:
    ptyUSART_external(ptyUSART_CORE *_usart);
    ~ptyUSART_external();
    void put_char(const unsigned char c);
    int poll();
 private:
    int master;
    int slave; // file descriptors for the pty
    ptyUSART_CORE *usart; //for termios callbacks
    unsigned char rbuf[BUFSIZ]; // the read buffer
    int bufsize; // current size of the buffer
    unsigned char *curchar; // current character in buffer;
};
#endif //  __USART_MODULE_H__
