/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.util;

import com.sshtools.daemon.util.StringExaminer;
import com.sshtools.daemon.util.StringUtil;
import java.io.Serializable;

public class StringPattern
implements Serializable {
    protected static final String MULTI_WILDCARD = "*";
    protected static final char MULTICHAR_WILDCARD = '*';
    protected static final char SINGLECHAR_WILDCARD = '?';
    private boolean ignoreCase = false;
    private String pattern = null;
    private Character digitWildcard = null;

    public StringPattern(String pattern, boolean ignoreCase) {
        this.setPattern(pattern);
        this.setIgnoreCase(ignoreCase);
    }

    public StringPattern(String pattern) {
        this(pattern, false);
    }

    public StringPattern(String pattern, char digitWildcard) {
        this(pattern, false, digitWildcard);
    }

    public StringPattern(String pattern, boolean ignoreCase, char digitWildcard) {
        this.setPattern(pattern);
        this.setIgnoreCase(ignoreCase);
        this.setDigitWildcardChar(digitWildcard);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String newValue) {
        this.pattern = newValue;
    }

    protected Character digitWildcard() {
        return this.digitWildcard;
    }

    protected void digitWildcard(Character newValue) {
        this.digitWildcard = newValue;
    }

    public static boolean match(String probe, String pattern) {
        StringPattern stringPattern = new StringPattern(pattern, false);
        return stringPattern.matches(probe);
    }

    public static boolean matchIgnoreCase(String probe, String pattern) {
        StringPattern stringPattern = new StringPattern(pattern, true);
        return stringPattern.matches(probe);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String probe) {
        StringExaminer patternIterator = null;
        StringExaminer probeIterator = null;
        char patternCh = '-';
        char probeCh = '-';
        String newPattern = null;
        String subPattern = null;
        int charIndex = 0;
        if (probe == null) {
            return false;
        }
        if (probe.length() == 0) {
            return false;
        }
        patternIterator = this.newExaminer(this.getPattern());
        probeIterator = this.newExaminer(probe);
        probeCh = probeIterator.nextChar();
        patternCh = this.getPatternChar(patternIterator, probeCh);
        while (this.endNotReached(patternCh) && this.endNotReached(probeCh)) {
            if (patternCh == '*') {
                patternCh = this.skipWildcards(patternIterator);
                if (this.endReached(patternCh)) {
                    return true;
                }
                patternIterator.skip(-1);
                newPattern = this.upToEnd(patternIterator);
                charIndex = newPattern.indexOf(42);
                if (charIndex >= 0) {
                    subPattern = newPattern.substring(0, charIndex);
                    if (!this.skipAfter(probeIterator, subPattern)) return false;
                    patternIterator = this.newExaminer(newPattern.substring(charIndex));
                    patternCh = probeCh;
                } else {
                    probeIterator.skip(-1);
                    return this.matchReverse(newPattern, probeIterator);
                }
            }
            if (this.charsAreEqual(probeCh, patternCh)) {
                if (!this.endNotReached(patternCh)) continue;
                probeCh = probeIterator.nextChar();
                patternCh = this.getPatternChar(patternIterator, probeCh);
                continue;
            }
            if (patternCh == 42) continue;
            return false;
        }
        return this.endReached(patternCh) && this.endReached(probeCh);
    }

    public String toString() {
        if (this.getPattern() == null) {
            return super.toString();
        }
        return this.getPattern();
    }

    public boolean hasWildcard() {
        if (this.getPattern() == null) {
            return false;
        }
        if (this.hasDigitWildcard() && this.getPattern().indexOf(this.digitWildcardChar()) >= 0) {
            return true;
        }
        return this.getPattern().indexOf(MULTI_WILDCARD) >= 0 || this.getPattern().indexOf(63) >= 0;
    }

    public void setDigitWildcardChar(char digitWildcard) {
        if (digitWildcard <= '\u0000') {
            this.digitWildcard(null);
        } else {
            this.digitWildcard(new Character(digitWildcard));
        }
    }

    protected boolean hasDigitWildcard() {
        return this.digitWildcard() != null;
    }

    protected char digitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.digitWildcard().charValue();
        }
        return '\u0000';
    }

    protected char skipWildcards(StringExaminer iterator) {
        char result = '-';
        while ((result = (char)iterator.nextChar()) == '*' || result == '?') {
        }
        return result;
    }

    protected boolean skipAfter(StringExaminer examiner, String matchString) {
        char ch = '-';
        char matchChar = ' ';
        boolean found = false;
        int index = 0;
        if (matchString == null || matchString.length() == 0) {
            return false;
        }
        ch = examiner.nextChar();
        while (examiner.endNotReached(ch) && !found) {
            matchChar = matchString.charAt(index);
            if (this.charsAreEqual(ch, matchChar)) {
                if (++index >= matchString.length()) {
                    found = true;
                    continue;
                }
                ch = examiner.nextChar();
                continue;
            }
            if (index == 0) {
                ch = examiner.nextChar();
                continue;
            }
            index = 0;
        }
        return found;
    }

    protected String upToEnd(StringExaminer iterator) {
        return iterator.upToEnd();
    }

    protected boolean matchReverse(String pattern, StringExaminer probeIterator) {
        String newPattern = MULTI_WILDCARD + pattern;
        String newProbe = this.upToEnd(probeIterator);
        newPattern = this.strUtil().reverse(newPattern);
        newProbe = this.strUtil().reverse(newProbe);
        StringPattern newMatcher = new StringPattern(newPattern, this.getIgnoreCase());
        if (this.hasDigitWildcard()) {
            newMatcher.setDigitWildcardChar(this.digitWildcardChar());
        }
        return newMatcher.matches(newProbe);
    }

    protected boolean charsAreEqual(char probeChar, char patternChar) {
        if (this.hasDigitWildcard() && patternChar == this.digitWildcardChar()) {
            return Character.isDigit(probeChar);
        }
        if (this.getIgnoreCase()) {
            return Character.toUpperCase(probeChar) == Character.toUpperCase(patternChar);
        }
        return probeChar == patternChar;
    }

    protected boolean endReached(char character) {
        return character == '\uffff';
    }

    protected boolean endNotReached(char character) {
        return !this.endReached(character);
    }

    protected char getPatternChar(StringExaminer patternIterator, char probeCh) {
        char patternCh = patternIterator.nextChar();
        return patternCh == '?' ? probeCh : patternCh;
    }

    protected StringExaminer newExaminer(String str) {
        return new StringExaminer(str, this.getIgnoreCase());
    }

    protected StringUtil strUtil() {
        return StringUtil.current();
    }
}

