//
// Sound2.h
//

#pragma once

typedef struct
{
	uint16_t	effectNum;
	float	volumeAdjust;
	uint32_t	leftVolume, rightVolume;
}ChannelInfoType;



#define		FULL_CHANNEL_VOLUME		kFullVolume
#define		NORMAL_CHANNEL_RATE		0x10000



enum
{
	SONG_THEME,
	SONG_FARM,
	SONG_SLIME,
	SONG_SLIMEBOSS,
	SONG_APOCALYPSE,
	SONG_CLOUD,
	SONG_JUNGLE,
	SONG_JUNGLEBOSS,
	SONG_FIREICE,
	SONG_SAUCER,
	SONG_BONUS,
	SONG_HIGHSCORE,
	SONG_BRAINBOSS,
	SONG_LOSESONG,
	SONG_WIN,
	NUM_SONGS
};


/***************** EFFECTS *************************/
// This table must match gEffectsTable
//

enum
{
		/* DEFAULT */
		
	EFFECT_BADSELECT = 0,
	EFFECT_SAUCER,
	EFFECT_STUNGUN,
	EFFECT_ZAP,
	EFFECT_ROCKET,
	EFFECT_ROCKETLANDED,
	EFFECT_JUMPJET,
	EFFECT_SHATTER,
	EFFECT_WEAPONCLICK,
	EFFECT_WEAPONWHIR,
	EFFECT_NEWLIFE,
	EFFECT_FREEZEGUN,
	EFFECT_PUNCHHIT,
	EFFECT_PLAYERCRASH,
	EFFECT_NOJUMPJET,
	EFFECT_PLAYERCRUSH,
	EFFECT_HEADSWOOSH,
	EFFECT_HEADTHUD,
	EFFECT_POWPODHIT,
	EFFECT_METALLAND,
	EFFECT_SERVO,
	EFFECT_LEFTFOOT,
	EFFECT_RIGHTFOOT,
	EFFECT_NOVACHARGE,
	EFFECT_TELEPORTHUMAN,
	EFFECT_CHECKPOINTHIT,
	EFFECT_CHECKPOINTLOOP,
	EFFECT_FLARESHOOT,
	EFFECT_FLAREEXPLODE,
	EFFECT_DARTWOOSH,
	EFFECT_ATOMCHIME,
	EFFECT_PLAYERCLANG,
	EFFECT_THROWNSWOOSH,
	EFFECT_BEAMHUM,
	EFFECT_JUMP,
	EFFECT_HEALTHWARNING,
	EFFECT_HATCH,
	EFFECT_BRAINWAVE,
	EFFECT_WEAPONDEPOSIT,
	EFFECT_BRAINDIE,
	EFFECT_LASERHIT,
	EFFECT_FLAREUP,
	EFFECT_FREEZEPOOF,
	EFFECT_CHANGEWEAPON,
	EFFECT_GIANTFOOTSTEP,
	
	
		/* MENU */
			
	EFFECT_MENUCHANGE,
	EFFECT_LOGOAMBIENCE,
	EFFECT_ACCENTDRONE1,
	EFFECT_ACCENTDRONE2,
	
		/* BONUS */
		
	EFFECT_BONUSTELEPORT,
	EFFECT_POINTBEEP,
	EFFECT_BONUSTRACTORBEAM,
	EFFECT_BONUSROCKET,
	
	
		/* FARM */
		
	EFFECT_POPCORN,
	EFFECT_SHOOTCORN,
	EFFECT_METALGATEHIT,
	EFFECT_METALGATECRASH,
	EFFECT_TRACTOR,
	EFFECT_ONIONSWOOSH,
	EFFECT_WOODGATECRASH,
	EFFECT_TOMATOJUMP,
	EFFECT_TOMATOSPLAT,
	EFFECT_WOODDOORHIT,
	EFFECT_ONIONSPLAT,
	EFFECT_CORNCRUNCH,
	
	
		/* SLIME */
		
	EFFECT_BUBBLEPOP,
	EFFECT_BLOBMOVE,
	EFFECT_SLIMEBOAT,
	EFFECT_CRYSTALCRACK,
	EFFECT_SLIMEPIPES,
	EFFECT_CRYSTALCRASH,
	EFFECT_BUMPERBUBBLE,
	EFFECT_SLIMEBOSSOPEN,
	EFFECT_BLOBSHOOT,
	EFFECT_BLOBBEAMHUM,
	EFFECT_SLIMEBOUNCE,
	EFFECT_SLIMEBOOM,
	EFFECT_BLOBBOSSBOOM,
	EFFECT_AIRPUMP,
	
		/* APOC */
		
	EFFECT_PODBUZZ,
	EFFECT_PODCRASH,
	EFFECT_MANHOLEBLAST,
	EFFECT_PODWORM,
	EFFECT_MANHOLEROLL,
	EFFECT_DOORCLANKOPEN,
	EFFECT_DOORCLANKCLOSE,
	EFFECT_MINEEXPLODE,
	EFFECT_MUTANTROBOTSHOOT,
	EFFECT_MUTANTGROWL,
	EFFECT_PLAYERTELEPORT,
	EFFECT_TELEPORTERDRONE,
	EFFECT_DEBRISSMASH,
	
		/* CLOUD */
		
	EFFECT_CANNONFIRE,
	EFFECT_BUMPERHIT,
	EFFECT_BUMPERHUM,
	EFFECT_BUMPERPOLETAP,
	EFFECT_BUMPERPOLEHUM,
	EFFECT_BUMPERPOLEOFF,
	EFFECT_CLOWNBUBBLEPOP,
	EFFECT_INFLATE,
	EFFECT_BOMBDROP,
	EFFECT_BUMPERPOLEBREAK,
	EFFECT_ROCKETSLED,
	EFFECT_TRAPDOOR,
	EFFECT_BALLOONPOP,
	EFFECT_FALLYAA,
	EFFECT_BIRDBOMBBOOM,
	EFFECT_CONFETTIBOOM,
	EFFECT_FISHBOOM,
	
	
		/* JUNGLE */
		
	EFFECT_ACIDSIZZLE,
	EFFECT_LIZARDROAR,
	EFFECT_FIREBREATH,
	EFFECT_LIZARDINHALE,
	EFFECT_MANTISSPIT,
	EFFECT_BIGDOORSMASH,
	EFFECT_TRACTORBEAM,
	EFFECT_PITCHERPAIN,
	EFFECT_PITCHERPUKE,
	EFFECT_FLYTRAP,
	EFFECT_PITCHERBOOM,
	EFFECT_PODSHOOT,
	EFFECT_PODBOOM,
	
	
		/* FIRE & ICE */
		
	EFFECT_VOLCANOBLOW,
	EFFECT_METALHIT,
	EFFECT_SWINGERDRONE,
	EFFECT_METALHIT2,
	EFFECT_SAUCERHATCH,
	EFFECT_ICECRACK,
	EFFECT_ROBOTEXPLODE,
	EFFECT_HAMMERSQUEAK,
	EFFECT_DRILLBOTWHINE,
	EFFECT_DRILLBOTWHINEHI,
	EFFECT_PILLARCRUNCH,
	EFFECT_ROCKETSLED2,
	EFFECT_SPLATHIT,
	EFFECT_SQUOOSHYSHOOT,
	EFFECT_SLEDEXPLODE,
	
	
		/* SAUCER */
		
	EFFECT_SAUCERKABOOM,
	EFFECT_SAUCERHIT,
	
	
		/* BRAIN BOSS */
		
	EFFECT_BRAINSTATIC,
	EFFECT_BRAINBOSSSHOOT,
	EFFECT_BRAINBOSSDIE,
	EFFECT_PORTALBOOM,
	EFFECT_BRAINPAIN,
	
	
		/* LOSE */
		
	EFFECT_CONVEYORBELT,
	EFFECT_TRANSFORM,
		
	NUM_EFFECTS
};


enum
{
	SOUNDBANK_MAIN,
	SOUNDBANK_MENU,
	SOUNDBANK_BONUS,
	SOUNDBANK_FARM,
	SOUNDBANK_SLIME,
	SOUNDBANK_APOC,
	SOUNDBANK_CLOUD,
	SOUNDBANK_JUNGLE,
	SOUNDBANK_FIREICE,
	SOUNDBANK_SAUCER,
	SOUNDBANK_BRAIN,
	SOUNDBANK_LOSE,
	NUM_SOUNDBANKS
};


enum
{
	kPlaySong_PlayOnceFlag = 1 << 1,	// don't loop the song
	kPlaySong_PreloadFlag = 2 << 1,		// pause the song immediately for later playback
};




//===================== PROTOTYPES ===================================


extern void	InitSoundTools(void);
void ShutdownSound(void);

void StopAChannel(short *channelNum);
extern	void StopAllEffectChannels(void);
void PlaySong(short songNum, int flags);
void KillSong(void);
extern	short PlayEffect(short effectNum);
short PlayEffect_Parms3D(short effectNum, OGLPoint3D *where, uint32_t rateMultiplier, float volumeAdjust);
void EnforceMusicPausePref(void);
extern void	DoSoundMaintenance(void);
void LoadSoundEffect(int effectNum);
void DisposeSoundEffect(int effectNum);
void LoadSoundBank(int bankNum);
void DisposeSoundBank(int bankNum);
short PlayEffect_Parms(int effectNum, uint32_t leftVolume, uint32_t rightVolume, unsigned long rateMultiplier);
void PauseAllChannels(Boolean pause);
void ChangeChannelVolume(short channel, uint32_t leftVol, uint32_t rightVol);
short PlayEffect3D(short effectNum, OGLPoint3D *where);
Boolean Update3DSoundChannel(short effectNum, short *channel, OGLPoint3D *where);
Boolean IsEffectChannelPlaying(short chanNum);
void UpdateListenerLocation(void);
void ChangeChannelRate(short channel, long rateMult);
void StopAChannelIfEffectNum(short *channelNum, short effectNum);
