#pragma once

typedef enum GameLanguageID
{
	LANGUAGE_ILLEGAL = -1,
	LANGUAGE_ENGLISH = 0,
	LANGUAGE_FRENCH,
	LANGUAGE_GERMAN,
	LANGUAGE_SPANISH,
	LANGUAGE_ITALIAN,
	LANGUAGE_SWEDISH,
	MAX_LANGUAGES
} GameLanguageID;

typedef enum LocStrID
{
	STR_LANGUAGE_NAME			= 0,
	STR_NEW_GAME,
	STR_LOAD_GAME,
	STR_HELP,
	STR_QUIT,
	STR_CREDITS,
	STR_HIGH_SCORES,
	STR_SETTINGS,
	STR_RESUME_GAME,
	STR_RETIRE_GAME,
	STR_QUIT_APPLICATION,
	STR_SAVE_GAME,
	STR_CONTINUE_WITHOUT_SAVING,
	STR_LEVEL,
	STR_SCORE,
	STR_EMPTY_SLOT,
	STR_JANUARY,
	STR_FEBRUARY,
	STR_MARCH,
	STR_APRIL,
	STR_MAY,
	STR_JUNE,
	STR_JULY,
	STR_AUGUST,
	STR_SEPTEMBER,
	STR_OCTOBER,
	STR_NOVEMBER,
	STR_DECEMBER,
	STR_LEVEL_CHEAT,
	STR_LEVEL_1,
	STR_LEVEL_2,
	STR_LEVEL_3,
	STR_LEVEL_4,
	STR_LEVEL_5,
	STR_LEVEL_6,
	STR_LEVEL_7,
	STR_LEVEL_8,
	STR_LEVEL_9,
	STR_LEVEL_10,
	STR_WARP_TO_ITEM,
	STR_IN_GAME_HELP_0,
	STR_IN_GAME_HELP_1,
	STR_IN_GAME_HELP_2,
	STR_IN_GAME_HELP_3,
	STR_IN_GAME_HELP_4,
	STR_IN_GAME_HELP_5,
	STR_IN_GAME_HELP_6,
	STR_IN_GAME_HELP_7,
	STR_IN_GAME_HELP_8,
	STR_IN_GAME_HELP_9,
	STR_IN_GAME_HELP_10,
	STR_IN_GAME_HELP_11,
	STR_IN_GAME_HELP_12,
	STR_IN_GAME_HELP_13,
	STR_IN_GAME_HELP_14,
	STR_IN_GAME_HELP_15,
	STR_IN_GAME_HELP_16,
	STR_IN_GAME_HELP_17,
	STR_IN_GAME_HELP_18,
	STR_IN_GAME_HELP_19,
	STR_IN_GAME_HELP_20,
	STR_IN_GAME_HELP_21,
	STR_LANGUAGE,
	STR_VIDEO_SETTINGS,
	STR_FULLSCREEN,
	STR_VSYNC,
	STR_UI_CENTERING,
	STR_UI_SCALE,
	STR_AUTO_ALIGN_CAMERA,
	STR_ANTIALIASING,
	STR_MSAA_2X,
	STR_MSAA_4X,
	STR_MSAA_8X,
	STR_PREFERRED_DISPLAY,
	STR_DISPLAY,
	STR_ANTIALIASING_CHANGE_WARNING_1,
	STR_ANTIALIASING_CHANGE_WARNING_2,
	STR_ANAGLYPH,
	STR_PLAYER_RELATIVE_CONTROLS,
	STR_MUSIC,
	STR_CONFIGURE_KEYBOARD,
	STR_CONFIGURE_GAMEPAD,
	STR_CONFIGURE_MOUSE,
	STR_CONFIGURE_KEYBOARD_HELP,
	STR_CONFIGURE_GAMEPAD_HELP,
	STR_CONFIGURE_KEYBOARD_HELP_CANCEL,
	STR_CONFIGURE_GAMEPAD_HELP_CANCEL,
	STR_NO_GAMEPAD_DETECTED,
	STR_GAMEPAD_RUMBLE,
	STR_MOUSE_SENSITIVITY,
	STR_MOUSE_SENSITIVITY_1,
	STR_MOUSE_SENSITIVITY_2,
	STR_MOUSE_SENSITIVITY_3,
	STR_MOUSE_SENSITIVITY_4,
	STR_MOUSE_SENSITIVITY_5,
	STR_MOUSE_SENSITIVITY_6,
	STR_MOUSE_SENSITIVITY_7,
	STR_MOUSE_SENSITIVITY_8,
	STR_MOUSE_CONTROL_TYPE,
	STR_MOUSE_CONTROLS_CAMERA,
	STR_MOUSE_CONTROLS_OTTO,
	STR_OK,
	STR_BACK,
	STR_ON,
	STR_OFF,
	STR_ON_MONOCHROME,
	STR_ON_COLOR,
	STR_ANAGLYPH_TOGGLE_WARNING_1,
	STR_ANAGLYPH_TOGGLE_WARNING_2,
	STR_ANAGLYPH_TOGGLE_WARNING_3,
	STR_PRESS,
	STR_CLICK,
	STR_RESET_KEYBINDINGS,
	STR_MOUSE_BUTTON_LEFT,
	STR_MOUSE_BUTTON_MIDDLE,
	STR_MOUSE_BUTTON_RIGHT,
	STR_BUTTON,
	STR_MOUSE_WHEEL_UP,
	STR_MOUSE_WHEEL_DOWN,
	STR_UNBOUND_PLACEHOLDER,
	STR_KEYBINDING_DESCRIPTION_0,
	STR_KEYBINDING_DESCRIPTION_1,
	STR_KEYBINDING_DESCRIPTION_2,
	STR_KEYBINDING_DESCRIPTION_3,
	STR_KEYBINDING_DESCRIPTION_4,
	STR_KEYBINDING_DESCRIPTION_5,
	STR_KEYBINDING_DESCRIPTION_6,
	STR_KEYBINDING_DESCRIPTION_7,
	STR_KEYBINDING_DESCRIPTION_8,
	STR_KEYBINDING_DESCRIPTION_9,
	STR_KEYBINDING_DESCRIPTION_10,
	STR_KEYBINDING_DESCRIPTION_11,
	STR_CREDITS_GAME_DESIGN,
	STR_CREDITS_PROGRAMMING,
	STR_CREDITS_ARTWORK,
	STR_CREDITS_MUSIC,
	STR_CREDITS_ADDITIONAL_PROGRAMMING,
	STR_ALL_HUMANS_RESCUED,
	STR_N_HUMANS_MISSING,
	STR_1_HUMAN_MISSING,
} LocStrID;

void LoadLocalizedStrings(GameLanguageID languageID);

const char* Localize(LocStrID stringID);

GameLanguageID GetBestLanguageIDFromSystemLocale(void);
