/* smhd.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "funcprotos.h"
#include "openquicktime.h"




void quicktime_smhd_init(quicktime_smhd_t *smhd)
{
	smhd->version = 0;
	smhd->flags = 0;
	smhd->balance = 0;
	smhd->reserved = 0;
}

void quicktime_smhd_delete(quicktime_smhd_t *smhd)
{
}

void quicktime_smhd_dump(quicktime_smhd_t *smhd)
{
	printf("    sound media header\n");
	printf("     version %d\n", smhd->version);
	printf("     flags %ld\n", smhd->flags);
	printf("     balance %d\n", smhd->balance);
	printf("     reserved %d\n", smhd->reserved);
}

void quicktime_read_smhd(quicktime_t *file, quicktime_smhd_t *smhd)
{
	smhd->version = quicktime_read_char(file);
	smhd->flags = quicktime_read_int24(file);
	smhd->balance = quicktime_read_int16(file);
	smhd->reserved = quicktime_read_int16(file);
}

void quicktime_write_smhd(quicktime_t *file, quicktime_smhd_t *smhd)
{
	quicktime_atom_t atom;
	quicktime_atom_write_header(file, &atom, "smhd");

	quicktime_write_char(file, smhd->version);
	quicktime_write_int24(file, smhd->flags);
	quicktime_write_int16(file, smhd->balance);
	quicktime_write_int16(file, smhd->reserved);

	quicktime_atom_write_footer(file, &atom);
}
