/* ctab.c
 * Copyright (C) 2001 QT4Linux and OpenQuicktime Teams
 *
 * This file is part of OpenQuicktime, a free QuickTime library.
 *
 * Based on QT4Linux by Adam Williams.
 *
 * OpenQuicktime is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * OpenQuicktime is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include "funcprotos.h"
#include "openquicktime.h"

int quicktime_ctab_init(quicktime_ctab_t *ctab)
{
	ctab->seed = 0;
	ctab->flags = 0;
	ctab->size = 0;
	ctab->alpha = 0;
	ctab->red = 0;
	ctab->green = 0;
	ctab->blue = 0;
	return 0;
}

int quicktime_ctab_delete(quicktime_ctab_t *ctab)
{
	if(ctab->alpha) free(ctab->alpha);
	if(ctab->red) free(ctab->red);
	if(ctab->green) free(ctab->green);
	if(ctab->blue) free(ctab->blue);
	return 0;
}

void quicktime_ctab_dump(quicktime_ctab_t *ctab)
{
	long i;
	printf(" color table\n");
	printf("  seed %ld\n", ctab->seed);
	printf("  flags %ld\n", ctab->flags);
	printf("  size %ld\n", ctab->size);
	printf("  colors ");
	for(i = 0; i < ctab->size; i++)
	{
		printf("[%d %d %d %d]", (int)ctab->red[i], (int)ctab->green[i], (int)ctab->blue[i], (int)ctab->alpha[i]);
	}
	printf("\n");
}

int quicktime_read_ctab(quicktime_t *file, quicktime_ctab_t *ctab)
{
	long i;
	
	ctab->seed = quicktime_read_int32(file);
	ctab->flags = quicktime_read_int16(file);
	ctab->size = quicktime_read_int16(file) + 1;
	ctab->alpha = malloc(sizeof(int16_t) * ctab->size);
	ctab->red = malloc(sizeof(int16_t) * ctab->size);
	ctab->green = malloc(sizeof(int16_t) * ctab->size);
	ctab->blue = malloc(sizeof(int16_t) * ctab->size);
	
	for(i = 0; i < ctab->size; i++)
	{
		ctab->alpha[i] = quicktime_read_int16(file);
		ctab->red[i] = quicktime_read_int16(file);
		ctab->green[i] = quicktime_read_int16(file);
		ctab->blue[i] = quicktime_read_int16(file);
	}

	return 0;
}
